/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.rmi.UnknownHostException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.musicbrainz.search.servlet.RateLimiterChecker;

/*
 * Exception performing whole class analysis ignored.
 */
public class RateLimiterChecker {
    private static final Logger log = Logger.getLogger(RateLimiterChecker.class.getName());
    private static String HEADER_REQUEST_ADDRESS = "X-MB-Remote-Addr";
    private static String HEADER_APPLY_RATE_LIMIT = "X-Apply-Rate-Limit";
    public static String HEADER_RATE_LIMITED = "X-Rate-Limited";
    private static String MSG_SERVER_BUSY_SIMPLE = "The MusicBrainz search server is currently busy. Please try again later.";
    private static String MSG_SERVER_BUSY = "Your requests are exceeding the allowable rate limit, you are limited to making %s requests per %s seconds, but you're currently making %s requests in that period. Please see http://wiki.musicbrainz.org/XMLWebService for more information.";
    private static String MSG_HEADER = "%s %s %s";
    private static Pattern pe;
    private static InetAddress rateLimiterHost;
    private static Integer rateLimiterPort;
    private static boolean rateLimiterConfigured;
    private static final String OVER_LIMIT_SEARCH_IP = " over_limit search ip=";
    private static AtomicInteger count;
    private static final RateLimiterResponse ALWAYS_TRUE;
    private static final int MAX_SIZE_OFRESPONSE_PACKET = 100;

    public static void init(String host, String port) {
        try {
            pe = Pattern.compile("^(?:[0-9]{1,3}\\.){3}[0-9]{1,3}$");
        }
        catch (PatternSyntaxException pe) {
            log.log(Level.SEVERE, "Unable to compile pattern:" + pe.getMessage(), pe);
            return;
        }
        try {
            rateLimiterHost = InetAddress.getByName(host);
        }
        catch (java.net.UnknownHostException uhe) {
            log.log(Level.SEVERE, "Unable to init rate limiter:" + uhe.getMessage(), uhe);
            return;
        }
        try {
            rateLimiterPort = Integer.parseInt(port);
        }
        catch (NumberFormatException ne) {
            log.log(Level.SEVERE, "Unable to init rate limiter:" + ne.getMessage(), pe);
            return;
        }
        rateLimiterConfigured = true;
    }

    private static boolean isValidIpAddress(String ipaddress) {
        return pe.matcher(ipaddress).matches();
    }

    private static boolean isRateLimiterConfigured() {
        return rateLimiterConfigured;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RateLimiterResponse validateAgainstRateLimiter(String remoteIpAddress) {
        DatagramSocket ds = null;
        try {
            int requestId = count.incrementAndGet();
            String requestIdAsString = String.valueOf(requestId);
            String rateLimiter = requestId + " over_limit search ip=" + remoteIpAddress;
            byte[] msg = rateLimiter.getBytes();
            ds = new DatagramSocket();
            DatagramPacket dp = new DatagramPacket(msg, msg.length, rateLimiterHost, rateLimiterPort);
            ds.send(dp);
            byte[] receiveData = new byte[100];
            DatagramPacket dpReceive = new DatagramPacket(receiveData, receiveData.length);
            ds.receive(dpReceive);
            String result = new String(dpReceive.getData(), dpReceive.getOffset(), dpReceive.getLength());
            if (result.startsWith(requestIdAsString)) {
                RateLimiterResponse rlr;
                RateLimiterResponse rateLimiterResponse = rlr = new RateLimiterResponse(result.substring(requestIdAsString.length() + 1));
                return rateLimiterResponse;
            }
            RateLimiterResponse rateLimiterResponse = ALWAYS_TRUE;
            return rateLimiterResponse;
        }
        catch (UnknownHostException uhe) {
            log.log(Level.SEVERE, "ValidateAgainstRateLimiter:" + uhe.getMessage(), uhe);
        }
        catch (SocketException se) {
            log.log(Level.SEVERE, "ValidateAgainstRateLimiter:" + se.getMessage(), se);
        }
        catch (IOException ioe) {
            log.log(Level.SEVERE, "ValidateAgainstRateLimiter:" + ioe.getMessage(), ioe);
        }
        finally {
            if (ds != null && !ds.isClosed()) {
                ds.close();
            }
        }
        return ALWAYS_TRUE;
    }

    public static RateLimiterResponse checkRateLimiter(HttpServletRequest request) {
        if (!RateLimiterChecker.isRateLimiterConfigured()) {
            return ALWAYS_TRUE;
        }
        String applyRateLimiter = request.getHeader(HEADER_APPLY_RATE_LIMIT);
        if (applyRateLimiter == null || applyRateLimiter.length() == 0 || !applyRateLimiter.equals("yes")) {
            return ALWAYS_TRUE;
        }
        String remoteIpAddress = request.getHeader(HEADER_REQUEST_ADDRESS);
        if (remoteIpAddress == null || remoteIpAddress.length() == 0 || !RateLimiterChecker.isValidIpAddress((String)remoteIpAddress)) {
            return ALWAYS_TRUE;
        }
        return RateLimiterChecker.validateAgainstRateLimiter((String)remoteIpAddress);
    }

    static /* synthetic */ String access$000() {
        return MSG_SERVER_BUSY;
    }

    static /* synthetic */ String access$100() {
        return MSG_HEADER;
    }

    static /* synthetic */ String access$200() {
        return MSG_SERVER_BUSY_SIMPLE;
    }

    static {
        rateLimiterConfigured = false;
        count = new AtomicInteger(0);
        ALWAYS_TRUE = new RateLimiterResponse();
    }
}

