/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TopDocs;
import org.musicbrainz.search.index.DatabaseIndex;
import org.musicbrainz.search.index.UrlIndexField;
import org.musicbrainz.search.servlet.AbstractSearchServer;
import org.musicbrainz.search.servlet.ResourceType;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.UrlQueryParser;
import org.musicbrainz.search.servlet.mmd2.UrlWriter;

public class UrlSearch
extends AbstractSearchServer {
    protected void setupDefaultFields() {
        this.defaultFields = new ArrayList();
        this.defaultFields.add(UrlIndexField.URL.getName());
    }

    public UrlSearch() throws Exception {
        this.resultsWriter = new UrlWriter();
        this.setupDefaultFields();
        this.analyzer = DatabaseIndex.getAnalyzer(UrlIndexField.class);
    }

    public UrlSearch(SearcherManager searcherManager) throws Exception {
        this();
        this.searcherManager = searcherManager;
        this.setLastServerUpdatedDate();
        this.resultsWriter.setLastServerUpdatedDate(this.getServerLastUpdatedDate());
    }

    public UrlSearch(SearcherManager searcherManager, String query, int offset, int limit) throws Exception {
        this(searcherManager);
        this.query = query;
        this.offset = offset;
        this.limit = limit;
    }

    public QueryParser getParser() {
        return new UrlQueryParser((String)this.defaultFields.get(0), this.analyzer);
    }

    protected String printExplainHeader(Document doc) throws IOException, ParseException {
        return doc.get(UrlIndexField.ID.getName()) + ':' + doc.get(UrlIndexField.URL.getName()) + '\n';
    }

    protected Results processResults(IndexSearcher searcher, TopDocs topDocs, int offset) throws IOException {
        Results results = super.processResults(searcher, topDocs, offset);
        results.setResourceType(ResourceType.URL);
        return results;
    }
}

