/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLDecoder;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.musicbrainz.search.servlet.AbstractSearchServer;
import org.musicbrainz.search.servlet.ResourceType;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.ResultsWriter;
import org.musicbrainz.search.servlet.SearchServer;
import org.musicbrainz.search.servlet.TestSearchOnly;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestSearchOnly {
    static final String WS_VERSION_1 = "1";
    static final Logger log = Logger.getLogger(TestSearchOnly.class.getName());
    static final int DEFAULT_OFFSET = 0;
    static final int DEFAULT_MATCHES_LIMIT = 25;
    static final int MAX_MATCHES_LIMIT = 100;
    static final String CHARSET = "UTF-8";
    private static EnumMap<ResourceType, AbstractSearchServer> searchers = new EnumMap(ResourceType.class);
    private String initMessage = null;
    static long totalQueryTime = 0L;
    static Map<URL, Integer> map = new LinkedHashMap();

    public static void main(String[] args) throws Exception {
        Thread.sleep(30000L);
        Options options = new Options();
        CmdLineParser parser = new CmdLineParser((Object)options);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            e.printStackTrace();
            System.err.println("Couldn't parse command line parameters");
            parser.printUsage((OutputStream)System.out);
            System.exit(1);
        }
        if (options.getIndexesDir().equals("") || options.getTestFile().equals("")) {
            System.err.println("Require both Index Dir and Test File");
            System.exit(1);
        }
        boolean useMMapDirectory = options.isMMap();
        File indexDir = new File(options.getIndexesDir());
        File urlFile = new File(options.getTestFile());
        for (ResourceType resourceType : ResourceType.values()) {
            File indexFileDir = new File(indexDir + System.getProperty("file.separator") + resourceType.getIndexName() + "_index");
            AbstractSearchServer searchServer = null;
            try {
                MMapDirectory directory = useMMapDirectory ? new MMapDirectory(indexFileDir.toPath()) : new NIOFSDirectory(indexFileDir.toPath());
                IndexSearcher indexSearcher = new IndexSearcher((IndexReader)DirectoryReader.open((Directory)directory));
                searchServer = (AbstractSearchServer)resourceType.getSearchServerClass().getConstructor(IndexSearcher.class).newInstance(indexSearcher);
            }
            catch (CorruptIndexException e) {
                log.warning("Could not load " + resourceType.getIndexName() + " index, index is corrupted: " + e.getMessage());
            }
            catch (IOException e) {
                log.warning("Could not load " + resourceType.getIndexName() + " index: " + e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            searchers.put(resourceType, searchServer);
        }
        TestSearchOnly.processUrls((File)urlFile);
    }

    private static void processUrls(File urlFile) throws Exception {
        String input;
        BufferedReader in = new BufferedReader(new FileReader(urlFile));
        while ((input = in.readLine()) != null) {
            map.put(new URL(input), null);
        }
        in.close();
        for (URL url : map.keySet()) {
            TestSearchOnly.processURL((URL)url);
        }
        System.out.println("Total Query TIme was:" + totalQueryTime + "Ms");
    }

    protected static void processURL(URL url) throws Exception {
        Pattern p = Pattern.compile("/ws/1/(.*)/");
        Matcher m = p.matcher(url.getPath());
        m.find();
        if (!m.matches()) {
            return;
        }
        String type = m.group(1);
        if (type.equals("track")) {
            type = ResourceType.RECORDING.getName();
        }
        ResourceType resourceType = ResourceType.getValue((String)type);
        Pattern p2 = Pattern.compile("query=(.*)&offset.*");
        Matcher m2 = p2.matcher(url.getQuery());
        m2.find();
        if (!m2.matches()) {
            return;
        }
        String query = m2.group(1);
        String responseVersion = "1";
        Integer offset = 0;
        Integer limit = 25;
        long start = System.nanoTime();
        SearchServer searchServer = (SearchServer)searchers.get(resourceType);
        Results results = searchServer.search(query, offset.intValue(), limit.intValue());
        ResultsWriter writer = searchServer.getWriter(responseVersion);
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new NullOutputStream(), "UTF-8")));
        writer.write(out, results, "xml", false);
        out.close();
        long end = System.nanoTime();
        long queryInMs = (end - start) / 1000000L;
        totalQueryTime += queryInMs;
        System.out.println("url ok :" + URLDecoder.decode(url.toString(), "UTF8") + ":" + results.getTotalHits() + ":" + queryInMs + " ms");
    }
}

