/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TopDocs;
import org.musicbrainz.search.index.DatabaseIndex;
import org.musicbrainz.search.index.EventIndexField;
import org.musicbrainz.search.servlet.AbstractSearchServer;
import org.musicbrainz.search.servlet.ResourceType;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.mmd2.EventWriter;

public class EventSearch
extends AbstractSearchServer {
    protected void setupDefaultFields() {
        this.defaultFields = new ArrayList();
        this.defaultFields.add(EventIndexField.EVENT.getName());
        this.defaultFields.add(EventIndexField.ALIAS.getName());
    }

    public EventSearch() throws Exception {
        this.resultsWriter = new EventWriter();
        this.setupDefaultFields();
        this.analyzer = DatabaseIndex.getAnalyzer(EventIndexField.class);
    }

    public EventSearch(SearcherManager searcherManager) throws Exception {
        this();
        this.searcherManager = searcherManager;
        this.setLastServerUpdatedDate();
        this.resultsWriter.setLastServerUpdatedDate(this.getServerLastUpdatedDate());
    }

    public QueryParser getParser() {
        return new QueryParser((String)this.defaultFields.get(0), this.analyzer);
    }

    protected String printExplainHeader(Document doc) throws IOException, ParseException {
        return doc.get(EventIndexField.EVENT_ID.getName()) + ':' + doc.get(EventIndexField.EVENT.getName()) + '\n';
    }

    protected Results processResults(IndexSearcher searcher, TopDocs topDocs, int offset) throws IOException {
        Results results = super.processResults(searcher, topDocs, offset);
        results.setResourceType(ResourceType.EVENT);
        return results;
    }
}

