/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TopDocs;
import org.musicbrainz.search.index.CDStubIndexField;
import org.musicbrainz.search.index.DatabaseIndex;
import org.musicbrainz.search.servlet.AbstractSearchServer;
import org.musicbrainz.search.servlet.ResourceType;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.mmd2.CDStubWriter;

public class CDStubSearch
extends AbstractSearchServer {
    protected void setupDefaultFields() {
        this.defaultFields = new ArrayList();
        this.defaultFields.add(CDStubIndexField.ARTIST.getName());
        this.defaultFields.add(CDStubIndexField.TITLE.getName());
    }

    public CDStubSearch(SearcherManager searcherManager) throws Exception {
        this.resultsWriter = new CDStubWriter();
        this.mmd1Writer = null;
        this.setupDefaultFields();
        this.analyzer = DatabaseIndex.getAnalyzer(CDStubIndexField.class);
        this.searcherManager = searcherManager;
        this.setLastServerUpdatedDate();
        this.resultsWriter.setLastServerUpdatedDate(this.getServerLastUpdatedDate());
    }

    public QueryParser getParser() {
        return new MultiFieldQueryParser(this.defaultFields.toArray(new String[0]), this.analyzer);
    }

    protected String printExplainHeader(Document doc) throws IOException, ParseException {
        return doc.get(CDStubIndexField.ID.getName()) + ':' + doc.get(CDStubIndexField.ARTIST.getName()) + ':' + doc.get(CDStubIndexField.TITLE.getName()) + '\n';
    }

    protected Results processResults(IndexSearcher searcher, TopDocs topDocs, int offset) throws IOException {
        Results results = super.processResults(searcher, topDocs, offset);
        results.setResourceType(ResourceType.CDSTUB);
        return results;
    }
}

