/* C code produced by gperf version 2.7.2 */
/* Command-line: gperf -tCcTonD -K id -N id3_2_3_compat_lookup -s -3 -k '*' compat.gperf  */
/*
 * libid3tag - ID3 tag manipulation library
 * Copyright (C) 2000-2003 Underbit Technologies, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: compat.c,v 1.1 2005/05/24 05:29:15 robert Exp $
 */

# ifdef HAVE_CONFIG_H
#  include "config.h"
# endif

# include "global.h"

# include <stdlib.h>
# include <string.h>

# ifdef HAVE_ASSERT_H
#  include <assert.h>
# endif

# include "id3tag.h"
# include "compat.h"
# include "frame.h"
# include "field.h"
# include "parse.h"
# include "ucs4.h"

# define EQ(id)    #id, 0
# define OBSOLETE    0, 0
# define TX(id)    #id, translate_##id

static id3_2_3_compat_func_t translate_TCON;

#define TOTAL_KEYWORDS 73
#define MIN_WORD_LENGTH 3
#define MAX_WORD_LENGTH 7
#define MIN_HASH_VALUE 1
#define MAX_HASH_VALUE 89
/* maximum key range = 89, duplicates = 7 */

#ifdef __GNUC__
__inline
#else
#ifdef __cplusplus
inline
#endif
#endif
static unsigned int
hash (str, len)
     register const char *str;
     register unsigned int len;
{
  static const unsigned char asso_values[] =
    {
      90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
      90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
      90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
      90, 90, 28, 90, 90, 90, 90, 90, 90, 90,
      90, 90,  5, 90, 90, 90, 90,  0, 90,  1,
      13,  4, 15, 90, 90, 90, 90, 90, 90, 90,
      90, 90, 90, 90, 90,  5, 14, 20,  5,  0,
      18,  3, 90, 21, 90, 31,  9, 16, 26,  3,
      28, 23, 25, 31,  0, 16, 30, 31, 11, 19,
      20, 90, 90, 90, 90, 90, 90, 90, 90, 90,
      90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
      90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
      90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
      90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
      90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
      90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
      90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
      90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
      90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
      90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
      90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
      90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
      90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
      90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
      90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
      90, 90, 90, 90, 90, 90
    };
  register int hval = 0;

  switch (len)
    {
      default:
      case 7:
        hval += asso_values[(unsigned char)str[6]];
      case 6:
        hval += asso_values[(unsigned char)str[5]];
      case 5:
        hval += asso_values[(unsigned char)str[4]];
      case 4:
        hval += asso_values[(unsigned char)str[3]];
      case 3:
        hval += asso_values[(unsigned char)str[2]];
      case 2:
        hval += asso_values[(unsigned char)str[1]];
      case 1:
        hval += asso_values[(unsigned char)str[0]];
        break;
    }
  return hval;
}

#ifdef __GNUC__
__inline
#endif
const struct id3_2_3_compat *
id3_2_3_compat_lookup (str, len)
     register const char *str;
     register unsigned int len;
{
  static const struct id3_2_3_compat wordlist[] =
    {
      {"TT1",  EQ(TIT1)  /* Content group description */},
      {"TOT",  EQ(TOAL)  /* Original album/movie/show title */},
      {"TT3",  EQ(TIT3)  /* Subtitle/description refinement */},
      {"GEO",  EQ(GEOB)  /* General encapsulated object */},
      {"TOA",  EQ(TOPE)  /* Original artist(s)/performer(s) */},
      {"TLE",  EQ(TLEN)  /* Length */},
      {"TDA",  OBSOLETE  /* Date [obsolete] */},
      {"TXT",  EQ(TEXT)  /* Lyricist/text writer */},
      {"TOL",  EQ(TOLY)  /* Original lyricist(s)/text writer(s) */},
      {"TT2",  EQ(TIT2)  /* Title/songname/content description */},
      {"TAL",  EQ(TALB)  /* Album/movie/show title */},
      {"TLA",  EQ(TLAN)  /* Language(s) */},
      {"TMT",  EQ(TMED)  /* Media type */},
      {"TFT",  EQ(TFLT)  /* File type */},
      {"TYE",  OBSOLETE  /* Year [obsolete] */},
      {"ETC",  EQ(ETCO)  /* Event timing codes */},
      {"TOF",  EQ(TOFN)  /* Original filename */},
      {"TXX",  EQ(TXXX)  /* User defined text information frame */},
      {"TCO",  TX(TCON)  /* Content type */},
      {"TDY",  EQ(TDLY)  /* Playlist delay */},
      {"ULT",  EQ(USLT)  /* Unsynchronised lyric/text transcription */},
      {"TEN",  EQ(TENC)  /* Encoded by */},
      {"TOR",  EQ(TDOR)  /* Original release year [obsolete] */},
      {"TP1",  EQ(TPE1)  /* Lead performer(s)/soloist(s) */},
      {"TRD",  OBSOLETE  /* Recording dates [obsolete] */},
      {"TKE",  EQ(TKEY)  /* Initial key */},
      {"TP3",  EQ(TPE3)  /* Conductor/performer refinement */},
      {"TPA",  EQ(TPOS)  /* Part of a set */},
      {"MLL",  EQ(MLLT)  /* MPEG location lookup table */},
      {"TRDA", OBSOLETE  /* Recording dates [obsolete] */},
      {"TCM",  EQ(TCOM)  /* Composer */},
      {"TIM",  OBSOLETE  /* Time [obsolete] */},
      {"COM",  EQ(COMM)  /* Comments */},
      {"EQU",  OBSOLETE  /* Equalization [obsolete] */},
      {"SLT",  EQ(SYLT)  /* Synchronised lyric/text */},
      {"TP2",  EQ(TPE2)  /* Band/orchestra/accompaniment */},
      {"TBP",  EQ(TBPM)  /* BPM (beats per minute) */},
      {"TPB",  EQ(TPUB)  /* Publisher */},
      {"TP4",  EQ(TPE4)  /* Interpreted, remixed, or otherwise modified by */},
      {"EQUA", OBSOLETE  /* Equalization [obsolete] */},
      {"TCR",  EQ(TCOP)  /* Copyright message */},
      {"TRC",  EQ(TSRC)  /* ISRC (international standard recording code) */},
      {"CNT",  EQ(PCNT)  /* Play counter */},
      {"TORY", EQ(TDOR)  /* Original release year [obsolete] */},
      {"BUF",  EQ(RBUF)  /* Recommended buffer size */},
      {"TCON", TX(TCON)  /* Content type */},
      {"CRA",  EQ(AENC)  /* Audio encryption */},
      {"STC",  EQ(SYTC)  /* Synchronised tempo codes */},
      {"TSI",  OBSOLETE  /* Size [obsolete] */},
      {"WXX",  EQ(WXXX)  /* User defined URL link frame */},
      {"WAF",  EQ(WOAF)  /* Official audio file webpage */},
      {"UFI",  EQ(UFID)  /* Unique file identifier */},
      {"REV",  EQ(RVRB)  /* Reverb */},
      {"TRK",  EQ(TRCK)  /* Track number/position in set */},
      {"MCI",  EQ(MCDI)  /* Music CD identifier */},
      {"IPL",  EQ(TIPL)  /* Involved people list */},
      {"POP",  EQ(POPM)  /* Popularimeter */},
      {"RVA",  OBSOLETE  /* Relative volume adjustment [obsolete] */},
      {"WAR",  EQ(WOAR)  /* Official artist/performer webpage */},
      {"CRM",  OBSOLETE  /* Encrypted meta frame [obsolete] */},
      {"TSS",  EQ(TSSE)  /* Software/hardware and settings used for encoding */},
      {"RVAD", OBSOLETE  /* Relative volume adjustment [obsolete] */},
      {"LNK",  EQ(LINK)  /* Linked information */},
      {"WCM",  EQ(WCOM)  /* Commercial information */},
      {"WAS",  EQ(WOAS)  /* Official audio source webpage */},
      {"PIC",  EQ(APIC)  /* Attached picture */},
      {"TSIZ", OBSOLETE  /* Size [obsolete] */},
      {"WPB",  EQ(WPUB)  /* Publishers official webpage */},
      {"WCP",  EQ(WCOP)  /* Copyright/legal information */},
      {"IPLS", EQ(TIPL)  /* Involved people list */}
    };

  static const short lookup[] =
    {
        -1,    0,   -1,    1,    2,   -1,    3,   -1,
         4,    5,    6,    7,    8,    9, -164,   12,
        13,   -1,   14,   15,   16,   17,   18,   19,
        20,   21,   22,   -1,   23,   24,   25,   26,
        27,   28,   29,   30,   31,   32,   -1, -160,
        35,   36, -158,   39,   40, -156,   43,   44,
        45,   46,   47,   48,   49,   50,   51, -154,
        54,   55,   56,   57,   58, -137,   61,  -14,
        -2,   62,   63, -148,   -1,   66,   67,   -1,
        68,   69,   -9,   -2,   -1,   70,   -1,   71,
       -21,   -2,  -32,   -2,  -36,   -2,  -40,   -2,
        -1,   72,  -63,   -2
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register int index = lookup[key];

          if (index >= 0)
            {
              register const char *s = wordlist[index].id;

              if (*str == *s && !strncmp (str + 1, s + 1, len - 1) && s[len] == '\0')
                return &wordlist[index];
            }
          else if (index < -TOTAL_KEYWORDS)
            {
              register int offset = - 1 - TOTAL_KEYWORDS - index;
              register const struct id3_2_3_compat *wordptr = &wordlist[TOTAL_KEYWORDS + lookup[offset]];
              register const struct id3_2_3_compat *wordendptr = wordptr + -lookup[offset + 1];

              while (wordptr < wordendptr)
                {
                  register const char *s = wordptr->id;

                  if (*str == *s && !strncmp (str + 1, s + 1, len - 1) && s[len] == '\0')
                    return wordptr;
                  wordptr++;
                }
            }
        }
    }
  return 0;
}

static
int translate_TCON(struct id3_2_3_frame *frame, char const *oldid,
		   id3_2_3_byte_t const *data, id3_2_3_length_t length)
{
  id3_2_3_byte_t const *end;
  enum id3_2_3_field_textencoding encoding;
  id3_2_3_ucs4_t *string = 0, *ptr, *endptr;
  int result = 0;

  /* translate old TCON syntax into multiple strings */

  assert(frame->nfields == 2);

  encoding = ID3_2_3_FIELD_TEXTENCODING_ISO_8859_1;

  end = data + length;

  if (id3_2_3_field_parse(&frame->fields[0], &data, end - data, &encoding) == -1)
    goto fail;

  string = id3_2_3_parse_string(&data, end - data, encoding, 0);
  if (string == 0)
    goto fail;

  ptr = string;
  while (*ptr == '(') {
    if (*++ptr == '(')
      break;

    endptr = ptr;
    while (*endptr && *endptr != ')')
      ++endptr;

    if (*endptr)
      *endptr++ = 0;

    if (id3_2_3_field_addstring(&frame->fields[1], ptr) == -1)
      goto fail;

    ptr = endptr;
  }

  if (*ptr && id3_2_3_field_addstring(&frame->fields[1], ptr) == -1)
    goto fail;

  if (0) {
  fail:
    result = -1;
  }

  if (string)
    free(string);

  return result;
}

/*
 * NAME:	compat->fixup()
 * DESCRIPTION:	finish compatibility translations
 */
int id3_2_3_compat_fixup(struct id3_2_3_tag *tag)
{
  struct id3_2_3_frame *frame;
  unsigned int index;
  id3_2_3_ucs4_t timestamp[17] = { 0 };
  int result = 0;

  /* create a TDRC frame from obsolete TYER/TDAT/TIME frames */

  /*
   * TYE/TYER: YYYY
   * TDA/TDAT: DDMM
   * TIM/TIME: HHMM
   *
   * TDRC: yyyy-MM-ddTHH:mm
   */

  index = 0;
  while ((frame = id3_2_3_tag_findframe(tag, ID3_2_3_FRAME_OBSOLETE, index++))) {
    char const *id;
    id3_2_3_byte_t const *data, *end;
    id3_2_3_length_t length;
    enum id3_2_3_field_textencoding encoding;
    id3_2_3_ucs4_t *string;

    id = id3_2_3_field_getframeid(&frame->fields[0]);
    assert(id);

    if (strcmp(id, "TYER") != 0 && strcmp(id, "YTYE") != 0 &&
	strcmp(id, "TDAT") != 0 && strcmp(id, "YTDA") != 0 &&
	strcmp(id, "TIME") != 0 && strcmp(id, "YTIM") != 0)
      continue;

    data = id3_2_3_field_getbinarydata(&frame->fields[1], &length);
    assert(data);

    if (length < 1)
      continue;

    end = data + length;

    encoding = id3_2_3_parse_uint(&data, 1);
    string   = id3_2_3_parse_string(&data, end - data, encoding, 0);

    if (id3_2_3_ucs4_length(string) < 4) {
      free(string);
      continue;
    }

    if (strcmp(id, "TYER") == 0 ||
	strcmp(id, "YTYE") == 0) {
      timestamp[0] = string[0];
      timestamp[1] = string[1];
      timestamp[2] = string[2];
      timestamp[3] = string[3];
    }
    else if (strcmp(id, "TDAT") == 0 ||
	     strcmp(id, "YTDA") == 0) {
      timestamp[4] = '-';
      timestamp[5] = string[2];
      timestamp[6] = string[3];
      timestamp[7] = '-';
      timestamp[8] = string[0];
      timestamp[9] = string[1];
    }
    else {  /* TIME or YTIM */
      timestamp[10] = 'T';
      timestamp[11] = string[0];
      timestamp[12] = string[1];
      timestamp[13] = ':';
      timestamp[14] = string[2];
      timestamp[15] = string[3];
    }

    free(string);
  }

  if (timestamp[0]) {
    id3_2_3_ucs4_t *strings;

    frame = id3_2_3_frame_new("TDRC");
    if (frame == 0)
      goto fail;

    strings = timestamp;

    if (id3_2_3_field_settextencoding(&frame->fields[0],
				  ID3_2_3_FIELD_TEXTENCODING_ISO_8859_1) == -1 ||
	id3_2_3_field_setstrings(&frame->fields[1], 1, &strings) == -1 ||
	id3_2_3_tag_attachframe(tag, frame) == -1) {
      id3_2_3_frame_delete(frame);
      goto fail;
    }
  }

  if (0) {
  fail:
    result = -1;
  }

  return result;
}
