/*	$OpenBSD: explicit_bzero.c,v 1.3 2014/06/21 02:34:26 matthew Exp $ */
/*
 * Public domain.
 * Written by Matthew Dempsky.
 */

#include <sys/cdefs.h>
#ifdef _KERNEL
#include <sys/libkern.h>
#else
#include <string.h>
#endif /* _KERNEL */

__attribute__((weak)) void __explicit_bzero_hook(void *, size_t);

__attribute__((weak)) void
__explicit_bzero_hook(void *buf, size_t len)
{
}

void
explicit_bzero(void *buf, size_t len)
{
	memset(buf, 0, len);
	__explicit_bzero_hook(buf, len);
}
