/* Tests imported from Project Wycheproof (https://github.com/google/wycheproof)
 * The following vectors have been extracted from the json files in:
 * 	https://github.com/google/wycheproof/tree/master/testvectors
 *
 */

/**
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * <p>http://www.apache.org/licenses/LICENSE-2.0
 *
 * <p>Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing permissions and
 * limitations under the License.
 */


/* Test 0 for ECDSA, tcId is 1 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_0_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_0_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_0_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0x13, 0x9c, 0x78, 0x24, 0x3a, 0x6e, 0x36, 0xe1, 0x24, 0xd5, 0xf5, 0xe1, 0x4b, 0x4c, 0xb8, 0x75, 0x4a, 0xbd, 0xf2, 0x0f, 0xf1, 0xa5, 0x01, 0xd5, 0x66, 0x6a, 0x42, 0x8f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_0 = {
	.name = "ecdsa_brainpoolp224r1_sha224_0",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_0_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_0_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_0_sig,
	.siglen = 56,
	.result = 1,
	.comment = "signature malleability, tcId is 1 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 1 for ECDSA, tcId is 2 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_1_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_1_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_1_sig[] = {
	0x01, 0xa3, 0x29, 0xe1, 0x41, 0x8c, 0x0a, 0xca, 0x9d, 0xaf, 0xf7, 0x53, 0xa4, 0x0f, 0x22, 0xdc, 0xdb, 0x66, 0x98, 0x43, 0xe6, 0x60, 0x41, 0xd1, 0x03, 0xaa, 0x30, 0xf5, 0x72, 0x00, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_1 = {
	.name = "ecdsa_brainpoolp224r1_sha224_1",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_1_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_1_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_1_sig,
	.siglen = 58,
	.result = -1,
	.comment = "Modified r or s, e.g. by adding or subtracting the order of the group, tcId is 2 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 2 for ECDSA, tcId is 3 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_2_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_2_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_2_sig[] = {
	0x0c, 0x58, 0x88, 0x12, 0xc0, 0x7c, 0x02, 0x6e, 0xa4, 0x39, 0x0c, 0xa6, 0xdc, 0x7f, 0x1a, 0x56, 0x3b, 0x95, 0x34, 0xb0, 0x7b, 0x7b, 0xa8, 0x43, 0xa1, 0x1e, 0x31, 0xcc, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_2 = {
	.name = "ecdsa_brainpoolp224r1_sha224_2",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_2_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_2_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_2_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Modified r or s, e.g. by adding or subtracting the order of the group, tcId is 3 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 3 for ECDSA, tcId is 4 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_3_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_3_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_3_sig[] = {
	0x01, 0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0x00, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_3 = {
	.name = "ecdsa_brainpoolp224r1_sha224_3",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_3_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_3_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_3_sig,
	.siglen = 58,
	.result = -1,
	.comment = "Modified r or s, e.g. by adding or subtracting the order of the group, tcId is 4 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 4 for ECDSA, tcId is 5 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_4_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_4_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_4_sig[] = {
	0x34, 0x97, 0x53, 0x68, 0x9a, 0x38, 0x9b, 0xe8, 0x7a, 0x20, 0xdc, 0x81, 0x66, 0xae, 0x1e, 0xbd, 0x6a, 0x7e, 0x78, 0x65, 0x0d, 0x9c, 0xeb, 0x9f, 0xfb, 0x76, 0x9e, 0x2d, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_4 = {
	.name = "ecdsa_brainpoolp224r1_sha224_4",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_4_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_4_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_4_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Modified r or s, e.g. by adding or subtracting the order of the group, tcId is 5 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 5 for ECDSA, tcId is 6 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_5_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_5_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_5_sig[] = {
	0x00, 0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0x01, 0x9b, 0xe5, 0xf1, 0x30, 0x12, 0x18, 0x96, 0x2b, 0x2f, 0x5a, 0x6a, 0x69, 0xa0, 0x55, 0x3e, 0xbc, 0x57, 0x6f, 0x86, 0x86, 0xea, 0x18, 0x77, 0x71, 0xe4, 0xe4, 0xe4, 0xaf, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_5 = {
	.name = "ecdsa_brainpoolp224r1_sha224_5",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_5_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_5_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_5_sig,
	.siglen = 58,
	.result = -1,
	.comment = "Modified r or s, e.g. by adding or subtracting the order of the group, tcId is 6 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 6 for ECDSA, tcId is 7 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_6_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_6_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_6_sig[] = {
	0x00, 0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0x01, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_6 = {
	.name = "ecdsa_brainpoolp224r1_sha224_6",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_6_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_6_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_6_sig,
	.siglen = 58,
	.result = -1,
	.comment = "Modified r or s, e.g. by adding or subtracting the order of the group, tcId is 7 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 7 for ECDSA, tcId is 8 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_7_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_7_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_7_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0x3b, 0xdb, 0x43, 0x7a, 0x14, 0x2a, 0xd0, 0x5a, 0xfa, 0xbd, 0xc5, 0xbb, 0xd5, 0x7b, 0xbc, 0xdc, 0x79, 0xa7, 0x35, 0xc4, 0x83, 0xc6, 0x45, 0x31, 0xc0, 0xc2, 0xae, 0xf0, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_7 = {
	.name = "ecdsa_brainpoolp224r1_sha224_7",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_7_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_7_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_7_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Modified r or s, e.g. by adding or subtracting the order of the group, tcId is 8 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 8 for ECDSA, tcId is 9 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_8_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_8_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_8_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_8 = {
	.name = "ecdsa_brainpoolp224r1_sha224_8",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_8_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_8_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_8_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 9 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 9 for ECDSA, tcId is 10 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_9_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_9_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_9_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_9 = {
	.name = "ecdsa_brainpoolp224r1_sha224_9",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_9_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_9_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_9_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 10 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 10 for ECDSA, tcId is 11 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_10_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_10_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_10_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_10 = {
	.name = "ecdsa_brainpoolp224r1_sha224_10",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_10_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_10_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_10_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 11 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 11 for ECDSA, tcId is 12 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_11_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_11_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_11_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_11 = {
	.name = "ecdsa_brainpoolp224r1_sha224_11",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_11_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_11_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_11_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 12 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 12 for ECDSA, tcId is 13 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_12_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_12_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_12_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_12 = {
	.name = "ecdsa_brainpoolp224r1_sha224_12",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_12_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_12_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_12_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 13 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 13 for ECDSA, tcId is 14 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_13_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_13_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_13_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_13 = {
	.name = "ecdsa_brainpoolp224r1_sha224_13",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_13_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_13_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_13_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 14 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 14 for ECDSA, tcId is 15 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_14_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_14_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_14_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_14 = {
	.name = "ecdsa_brainpoolp224r1_sha224_14",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_14_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_14_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_14_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 15 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 15 for ECDSA, tcId is 16 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_15_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_15_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_15_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_15 = {
	.name = "ecdsa_brainpoolp224r1_sha224_15",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_15_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_15_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_15_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 16 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 16 for ECDSA, tcId is 17 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_16_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_16_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_16_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_16 = {
	.name = "ecdsa_brainpoolp224r1_sha224_16",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_16_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_16_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_16_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 17 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 17 for ECDSA, tcId is 18 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_17_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_17_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_17_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_17 = {
	.name = "ecdsa_brainpoolp224r1_sha224_17",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_17_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_17_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_17_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 18 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 18 for ECDSA, tcId is 19 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_18_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_18_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_18_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_18 = {
	.name = "ecdsa_brainpoolp224r1_sha224_18",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_18_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_18_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_18_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 19 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 19 for ECDSA, tcId is 20 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_19_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_19_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_19_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_19 = {
	.name = "ecdsa_brainpoolp224r1_sha224_19",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_19_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_19_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_19_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 20 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 20 for ECDSA, tcId is 21 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_20_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_20_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_20_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_20 = {
	.name = "ecdsa_brainpoolp224r1_sha224_20",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_20_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_20_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_20_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 21 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 21 for ECDSA, tcId is 22 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_21_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_21_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_21_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_21 = {
	.name = "ecdsa_brainpoolp224r1_sha224_21",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_21_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_21_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_21_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 22 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 22 for ECDSA, tcId is 23 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_22_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_22_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_22_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_22 = {
	.name = "ecdsa_brainpoolp224r1_sha224_22",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_22_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_22_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_22_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 23 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 23 for ECDSA, tcId is 24 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_23_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_23_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_23_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_23 = {
	.name = "ecdsa_brainpoolp224r1_sha224_23",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_23_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_23_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_23_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 24 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 24 for ECDSA, tcId is 25 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_24_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_24_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_24_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_24 = {
	.name = "ecdsa_brainpoolp224r1_sha224_24",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_24_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_24_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_24_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 25 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 25 for ECDSA, tcId is 26 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_25_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_25_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_25_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_25 = {
	.name = "ecdsa_brainpoolp224r1_sha224_25",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_25_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_25_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_25_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 26 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 26 for ECDSA, tcId is 27 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_26_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_26_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_26_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_26 = {
	.name = "ecdsa_brainpoolp224r1_sha224_26",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_26_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_26_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_26_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 27 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 27 for ECDSA, tcId is 28 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_27_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_27_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_27_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_27 = {
	.name = "ecdsa_brainpoolp224r1_sha224_27",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_27_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_27_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_27_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 28 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 28 for ECDSA, tcId is 29 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_28_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_28_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_28_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_28 = {
	.name = "ecdsa_brainpoolp224r1_sha224_28",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_28_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_28_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_28_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 29 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 29 for ECDSA, tcId is 30 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_29_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_29_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_29_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_29 = {
	.name = "ecdsa_brainpoolp224r1_sha224_29",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_29_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_29_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_29_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 30 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 30 for ECDSA, tcId is 31 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_30_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_30_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_30_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_30 = {
	.name = "ecdsa_brainpoolp224r1_sha224_30",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_30_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_30_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_30_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 31 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 31 for ECDSA, tcId is 32 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_31_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_31_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_31_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_31 = {
	.name = "ecdsa_brainpoolp224r1_sha224_31",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_31_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_31_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_31_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 32 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 32 for ECDSA, tcId is 33 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_32_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_32_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_32_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_32 = {
	.name = "ecdsa_brainpoolp224r1_sha224_32",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_32_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_32_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_32_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 33 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 33 for ECDSA, tcId is 34 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_33_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_33_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_33_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_33 = {
	.name = "ecdsa_brainpoolp224r1_sha224_33",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_33_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_33_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_33_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 34 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 34 for ECDSA, tcId is 35 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_34_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_34_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_34_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_34 = {
	.name = "ecdsa_brainpoolp224r1_sha224_34",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_34_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_34_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_34_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 35 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 35 for ECDSA, tcId is 36 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_35_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_35_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_35_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_35 = {
	.name = "ecdsa_brainpoolp224r1_sha224_35",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_35_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_35_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_35_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 36 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 36 for ECDSA, tcId is 37 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_36_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_36_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_36_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_36 = {
	.name = "ecdsa_brainpoolp224r1_sha224_36",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_36_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_36_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_36_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 37 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 37 for ECDSA, tcId is 38 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_37_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_37_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_37_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_37 = {
	.name = "ecdsa_brainpoolp224r1_sha224_37",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_37_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_37_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_37_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 38 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 38 for ECDSA, tcId is 39 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_38_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_38_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_38_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_38 = {
	.name = "ecdsa_brainpoolp224r1_sha224_38",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_38_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_38_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_38_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 39 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 39 for ECDSA, tcId is 40 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_39_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_39_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_39_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_39 = {
	.name = "ecdsa_brainpoolp224r1_sha224_39",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_39_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_39_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_39_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 40 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 40 for ECDSA, tcId is 41 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_40_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_40_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_40_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_40 = {
	.name = "ecdsa_brainpoolp224r1_sha224_40",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_40_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_40_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_40_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 41 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 41 for ECDSA, tcId is 42 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_41_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_41_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_41_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_41 = {
	.name = "ecdsa_brainpoolp224r1_sha224_41",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_41_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_41_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_41_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 42 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 42 for ECDSA, tcId is 43 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_42_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_42_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_42_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_42 = {
	.name = "ecdsa_brainpoolp224r1_sha224_42",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_42_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_42_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_42_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 43 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 43 for ECDSA, tcId is 44 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_43_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_43_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_43_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_43 = {
	.name = "ecdsa_brainpoolp224r1_sha224_43",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_43_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_43_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_43_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 44 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 44 for ECDSA, tcId is 45 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_44_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_44_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_44_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_44 = {
	.name = "ecdsa_brainpoolp224r1_sha224_44",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_44_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_44_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_44_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 45 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 45 for ECDSA, tcId is 46 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_45_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_45_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_45_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_45 = {
	.name = "ecdsa_brainpoolp224r1_sha224_45",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_45_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_45_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_45_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 46 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 46 for ECDSA, tcId is 47 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_46_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_46_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_46_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_46 = {
	.name = "ecdsa_brainpoolp224r1_sha224_46",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_46_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_46_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_46_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 47 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 47 for ECDSA, tcId is 48 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_47_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_47_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_47_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_47 = {
	.name = "ecdsa_brainpoolp224r1_sha224_47",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_47_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_47_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_47_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 48 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 48 for ECDSA, tcId is 49 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_48_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_48_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_48_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_48 = {
	.name = "ecdsa_brainpoolp224r1_sha224_48",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_48_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_48_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_48_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 49 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 49 for ECDSA, tcId is 50 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_49_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_49_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_49_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_49 = {
	.name = "ecdsa_brainpoolp224r1_sha224_49",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_49_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_49_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_49_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 50 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 50 for ECDSA, tcId is 51 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_50_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_50_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_50_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_50 = {
	.name = "ecdsa_brainpoolp224r1_sha224_50",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_50_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_50_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_50_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 51 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 51 for ECDSA, tcId is 52 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_51_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_51_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_51_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_51 = {
	.name = "ecdsa_brainpoolp224r1_sha224_51",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_51_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_51_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_51_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 52 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 52 for ECDSA, tcId is 53 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_52_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_52_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_52_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_52 = {
	.name = "ecdsa_brainpoolp224r1_sha224_52",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_52_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_52_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_52_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 53 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 53 for ECDSA, tcId is 54 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_53_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_53_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_53_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_53 = {
	.name = "ecdsa_brainpoolp224r1_sha224_53",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_53_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_53_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_53_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 54 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 54 for ECDSA, tcId is 55 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_54_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_54_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_54_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_54 = {
	.name = "ecdsa_brainpoolp224r1_sha224_54",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_54_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_54_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_54_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 55 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 55 for ECDSA, tcId is 56 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_55_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_55_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_55_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_55 = {
	.name = "ecdsa_brainpoolp224r1_sha224_55",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_55_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_55_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_55_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 56 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 56 for ECDSA, tcId is 57 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_56_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_56_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_56_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_56 = {
	.name = "ecdsa_brainpoolp224r1_sha224_56",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_56_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_56_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_56_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 57 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 57 for ECDSA, tcId is 58 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_57_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_57_msg[] = {
	0x39, 0x35, 0x33, 0x38, 0x38, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_57_sig[] = {
	0x0e, 0x7e, 0xca, 0xb2, 0x27, 0x6f, 0x03, 0x5c, 0x0d, 0xc7, 0x05, 0x20, 0xeb, 0xd5, 0xae, 0x3c, 0xb7, 0xb7, 0xa8, 0xf2, 0x1f, 0xa5, 0x68, 0x7e, 0xee, 0x92, 0xc4, 0x62, 0x85, 0xa8, 0x53, 0x32, 0xf8, 0xc8, 0x99, 0xb5, 0x3d, 0x43, 0x09, 0x1b, 0x02, 0xe6, 0x95, 0x6b, 0x39, 0x18, 0x17, 0xe1, 0x75, 0xa8, 0xb1, 0xf4, 0x0d, 0xca, 0x7e, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_57 = {
	.name = "ecdsa_brainpoolp224r1_sha224_57",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_57_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_57_msg,
	.msglen = 5,
	.sig = ecdsa_brainpoolp224r1_sha224_57_sig,
	.siglen = 56,
	.result = 1,
	.comment = "Edge case for Shamir multiplication, tcId is 58 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 58 for ECDSA, tcId is 59 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_58_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_58_msg[] = {
	0x32, 0x32, 0x35, 0x34, 0x36, 0x32, 0x38, 0x39, 0x38, 0x34, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_58_sig[] = {
	0x2f, 0xc2, 0xef, 0x9f, 0x76, 0x63, 0xf6, 0x6f, 0x13, 0xb0, 0x4e, 0x49, 0xf2, 0x06, 0xc2, 0x24, 0x41, 0xeb, 0x3e, 0xe1, 0x91, 0x7b, 0x8b, 0xf8, 0x1a, 0x9b, 0x53, 0x76, 0xd1, 0xdf, 0x3d, 0xd0, 0x27, 0x0e, 0x58, 0x84, 0xe9, 0x84, 0x8e, 0xa2, 0x81, 0x2b, 0x66, 0xf5, 0x01, 0x5b, 0xe9, 0x6d, 0x25, 0x85, 0xfe, 0xd3, 0x95, 0x7b, 0x31, 0x3c, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_58 = {
	.name = "ecdsa_brainpoolp224r1_sha224_58",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_58_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_58_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_58_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 59 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 59 for ECDSA, tcId is 60 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_59_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_59_msg[] = {
	0x31, 0x38, 0x32, 0x37, 0x38, 0x37, 0x38, 0x36, 0x31, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_59_sig[] = {
	0xc6, 0x82, 0x58, 0x7b, 0xf4, 0x3e, 0x0c, 0x95, 0x4e, 0xb5, 0x8b, 0xbc, 0xfe, 0xb9, 0x4d, 0xfa, 0xc8, 0xba, 0xd4, 0x04, 0x99, 0x5a, 0xc2, 0x6e, 0x8e, 0x51, 0xff, 0x20, 0x92, 0xbf, 0x10, 0xda, 0x10, 0x32, 0x4c, 0xc3, 0x22, 0xf7, 0x9c, 0x41, 0x2d, 0xae, 0xd3, 0x05, 0xb2, 0x75, 0xfc, 0x19, 0x93, 0xbf, 0x3a, 0xf5, 0x23, 0xde, 0xd6, 0x2a, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_59 = {
	.name = "ecdsa_brainpoolp224r1_sha224_59",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_59_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_59_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_59_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 60 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 60 for ECDSA, tcId is 61 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_60_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_60_msg[] = {
	0x31, 0x35, 0x31, 0x38, 0x38, 0x36, 0x31, 0x37, 0x30, 0x39, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_60_sig[] = {
	0x02, 0x5d, 0x1c, 0xf1, 0x6f, 0x03, 0x34, 0x1f, 0x3c, 0x8d, 0x16, 0xa7, 0x78, 0x39, 0xb5, 0xc1, 0xd6, 0x96, 0x36, 0x3d, 0xae, 0x89, 0x8d, 0x91, 0xe1, 0x4a, 0xd5, 0x22, 0xb7, 0x37, 0x9c, 0xc3, 0x5c, 0x97, 0xa8, 0xf0, 0x8b, 0x0e, 0xfb, 0x32, 0xee, 0x82, 0xce, 0x0e, 0x19, 0x11, 0x69, 0x5d, 0x37, 0x2e, 0xe6, 0xd6, 0x79, 0xec, 0x54, 0x66, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_60 = {
	.name = "ecdsa_brainpoolp224r1_sha224_60",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_60_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_60_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_60_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 61 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 61 for ECDSA, tcId is 62 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_61_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_61_msg[] = {
	0x32, 0x31, 0x32, 0x39, 0x32, 0x33, 0x33, 0x34, 0x32, 0x32, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_61_sig[] = {
	0xc0, 0xc9, 0x49, 0xe0, 0xf0, 0xf8, 0x57, 0x18, 0x02, 0xea, 0x7e, 0x02, 0x61, 0x7c, 0xa9, 0x25, 0xb9, 0x5d, 0x29, 0x0a, 0x17, 0x4f, 0x68, 0x6d, 0x80, 0xbb, 0xa1, 0xd4, 0xb9, 0x66, 0x17, 0x3c, 0xe3, 0xf1, 0x3c, 0xa5, 0x4c, 0xcd, 0xc8, 0xa2, 0x49, 0xfe, 0xa7, 0x2e, 0x32, 0x60, 0xad, 0x3e, 0x78, 0x54, 0xa7, 0x31, 0x05, 0x1d, 0x8c, 0x03, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_61 = {
	.name = "ecdsa_brainpoolp224r1_sha224_61",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_61_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_61_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_61_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 62 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 62 for ECDSA, tcId is 63 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_62_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_62_msg[] = {
	0x31, 0x32, 0x32, 0x31, 0x39, 0x37, 0x39, 0x30, 0x35, 0x39, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_62_sig[] = {
	0x5d, 0x57, 0xf1, 0x42, 0x75, 0x94, 0x7c, 0x9b, 0xff, 0xea, 0x66, 0xf9, 0xf3, 0x0a, 0xe2, 0x03, 0x19, 0x45, 0x35, 0xf8, 0x02, 0x0c, 0x42, 0xbb, 0xc1, 0xef, 0xec, 0x73, 0xc3, 0x58, 0x65, 0x1b, 0xa2, 0x52, 0x7c, 0x32, 0xd8, 0x58, 0x65, 0x7c, 0xcf, 0x08, 0xe5, 0x35, 0xd3, 0x28, 0x51, 0xfb, 0xd8, 0xc3, 0x54, 0x77, 0xba, 0x17, 0x56, 0x80, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_62 = {
	.name = "ecdsa_brainpoolp224r1_sha224_62",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_62_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_62_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_62_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 63 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 63 for ECDSA, tcId is 64 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_63_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_63_msg[] = {
	0x32, 0x33, 0x30, 0x32, 0x35, 0x36, 0x37, 0x36, 0x31, 0x31, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_63_sig[] = {
	0x13, 0x3b, 0xb1, 0x2f, 0x10, 0x96, 0x98, 0x9d, 0xc8, 0x67, 0xd8, 0x74, 0xf6, 0x75, 0xfd, 0xf9, 0xe9, 0x79, 0x75, 0xc2, 0xe2, 0x2c, 0x71, 0xe4, 0x4f, 0x59, 0xbf, 0x35, 0x65, 0x57, 0xee, 0xb2, 0xb5, 0xb4, 0xf1, 0xf7, 0xc8, 0x51, 0x84, 0xdc, 0xc6, 0x53, 0x85, 0x0c, 0x34, 0xb1, 0xc3, 0x48, 0x0d, 0x2f, 0x32, 0xd1, 0x56, 0x7c, 0x25, 0xc1, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_63 = {
	.name = "ecdsa_brainpoolp224r1_sha224_63",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_63_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_63_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_63_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 64 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 64 for ECDSA, tcId is 65 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_64_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_64_msg[] = {
	0x31, 0x31, 0x30, 0x35, 0x38, 0x36, 0x38, 0x34, 0x37, 0x32, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_64_sig[] = {
	0xd1, 0xdc, 0x7d, 0x1c, 0xc8, 0x86, 0xca, 0x90, 0xe0, 0xd9, 0x60, 0xb6, 0xc7, 0xfd, 0xa9, 0x2e, 0xd5, 0x82, 0xec, 0x61, 0x6c, 0x1c, 0x79, 0xb1, 0x71, 0xef, 0x31, 0x08, 0x41, 0xa7, 0xd2, 0x14, 0x38, 0xe7, 0xc3, 0x4b, 0x27, 0x17, 0x60, 0x05, 0xef, 0x67, 0xc0, 0x4a, 0x63, 0xf3, 0x62, 0xd2, 0xda, 0xf1, 0x0b, 0x62, 0xc5, 0x3b, 0x88, 0xb4, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_64 = {
	.name = "ecdsa_brainpoolp224r1_sha224_64",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_64_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_64_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_64_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 65 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 65 for ECDSA, tcId is 66 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_65_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_65_msg[] = {
	0x31, 0x34, 0x36, 0x36, 0x36, 0x31, 0x34, 0x34, 0x34, 0x32, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_65_sig[] = {
	0x9e, 0xc3, 0xb7, 0xb4, 0xa0, 0xf1, 0x23, 0x51, 0x69, 0xb6, 0x4a, 0x20, 0x58, 0x4d, 0x36, 0xb9, 0x6b, 0xb7, 0xa2, 0xbd, 0xe0, 0x0d, 0x23, 0x16, 0x3c, 0xc3, 0xb1, 0xbf, 0xac, 0x32, 0xef, 0x3b, 0x9e, 0x94, 0x8d, 0x96, 0x7f, 0x96, 0xcd, 0x08, 0x50, 0x78, 0x09, 0xe3, 0xb9, 0xa0, 0xe0, 0x93, 0xbe, 0x3e, 0x76, 0xb8, 0x18, 0x33, 0x1d, 0xd5, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_65 = {
	.name = "ecdsa_brainpoolp224r1_sha224_65",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_65_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_65_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_65_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 66 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 66 for ECDSA, tcId is 67 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_66_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_66_msg[] = {
	0x34, 0x34, 0x31, 0x39, 0x35, 0x36, 0x34, 0x32, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_66_sig[] = {
	0x39, 0x2a, 0xe3, 0x81, 0xda, 0x4c, 0xcf, 0xd9, 0xd5, 0xad, 0x09, 0x3d, 0x49, 0xb2, 0x2d, 0x57, 0x94, 0x11, 0xf7, 0xc1, 0xcd, 0x04, 0xe8, 0x84, 0x73, 0xab, 0x6e, 0xf5, 0xa2, 0x89, 0x8b, 0x8b, 0xf1, 0x20, 0xd1, 0x8e, 0x4e, 0xe0, 0xd1, 0x5c, 0x41, 0x90, 0x44, 0x32, 0x4d, 0xe3, 0xc0, 0x92, 0x7e, 0xe9, 0x0f, 0xd6, 0xf3, 0x87, 0x11, 0xf4, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_66 = {
	.name = "ecdsa_brainpoolp224r1_sha224_66",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_66_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_66_msg,
	.msglen = 9,
	.sig = ecdsa_brainpoolp224r1_sha224_66_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 67 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 67 for ECDSA, tcId is 68 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_67_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_67_msg[] = {
	0x31, 0x39, 0x36, 0x39, 0x34, 0x38, 0x36, 0x30, 0x36, 0x34, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_67_sig[] = {
	0xa3, 0x7b, 0x0c, 0xc8, 0x7f, 0x6d, 0x46, 0x20, 0x30, 0x30, 0x30, 0xd7, 0xac, 0x4a, 0x65, 0x72, 0xf9, 0x4c, 0x0c, 0xf4, 0x4f, 0x0a, 0x03, 0x5c, 0x0e, 0x59, 0xd0, 0x7c, 0x30, 0xc7, 0xac, 0xd8, 0xdb, 0x9e, 0x72, 0x01, 0x22, 0x08, 0xf0, 0x8d, 0xb5, 0x38, 0x1a, 0x1e, 0x54, 0xfa, 0x09, 0x8c, 0x03, 0x14, 0xa0, 0x9a, 0x30, 0x58, 0xc4, 0x21, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_67 = {
	.name = "ecdsa_brainpoolp224r1_sha224_67",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_67_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_67_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_67_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 68 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 68 for ECDSA, tcId is 69 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_68_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_68_msg[] = {
	0x32, 0x32, 0x33, 0x35, 0x36, 0x37, 0x32, 0x38, 0x38, 0x33, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_68_sig[] = {
	0x62, 0xf6, 0x60, 0xd9, 0x3a, 0x45, 0xdf, 0xa3, 0xb6, 0x61, 0xf8, 0xb6, 0xa4, 0xd5, 0xe0, 0x6e, 0x5a, 0x1e, 0xe8, 0xa8, 0x85, 0x5a, 0xba, 0xfa, 0x40, 0x73, 0xb5, 0x13, 0xd6, 0x97, 0x8f, 0x5d, 0xa8, 0xaf, 0xcc, 0x5b, 0x39, 0x5f, 0xd4, 0xb5, 0xf3, 0xc0, 0xfd, 0xb7, 0xa2, 0x68, 0x9e, 0x6d, 0xe4, 0x6d, 0x08, 0xfb, 0x9d, 0xe7, 0x18, 0x60, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_68 = {
	.name = "ecdsa_brainpoolp224r1_sha224_68",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_68_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_68_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_68_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 69 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 69 for ECDSA, tcId is 70 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_69_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_69_msg[] = {
	0x32, 0x32, 0x35, 0x37, 0x38, 0x34, 0x33, 0x37, 0x30, 0x33, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_69_sig[] = {
	0x61, 0xaf, 0x9a, 0x2c, 0xa2, 0x05, 0x03, 0xfd, 0x62, 0xbc, 0x3c, 0x6f, 0x84, 0x34, 0x99, 0x5c, 0x6c, 0xf3, 0x03, 0x7e, 0xb6, 0xf9, 0xff, 0x62, 0x13, 0x48, 0xcf, 0x53, 0x09, 0xf8, 0xf6, 0x47, 0x13, 0x87, 0x69, 0x54, 0x8d, 0xb4, 0x60, 0xef, 0xdd, 0x83, 0x23, 0xf8, 0xca, 0xd1, 0x8a, 0x70, 0x71, 0xd3, 0xd0, 0x4d, 0x6a, 0xd3, 0x3d, 0x82, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_69 = {
	.name = "ecdsa_brainpoolp224r1_sha224_69",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_69_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_69_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_69_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 70 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 70 for ECDSA, tcId is 71 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_70_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_70_msg[] = {
	0x39, 0x34, 0x34, 0x35, 0x30, 0x30, 0x39, 0x34, 0x36, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_70_sig[] = {
	0x0e, 0x45, 0x9c, 0xfe, 0x37, 0x01, 0x7c, 0x8b, 0x60, 0x5e, 0x38, 0xbf, 0x5d, 0x25, 0x17, 0x65, 0x76, 0xd4, 0x75, 0xfa, 0x88, 0xde, 0xd2, 0x7b, 0xe2, 0x6a, 0xbc, 0xa7, 0xb1, 0xbb, 0x6a, 0x60, 0xcc, 0xc3, 0xd4, 0x8e, 0x8d, 0x1d, 0x4c, 0x53, 0xf9, 0x01, 0x42, 0x80, 0x6e, 0x44, 0xd9, 0x94, 0x9e, 0xbc, 0xaa, 0x05, 0xb8, 0x3e, 0x20, 0xf4, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_70 = {
	.name = "ecdsa_brainpoolp224r1_sha224_70",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_70_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_70_msg,
	.msglen = 9,
	.sig = ecdsa_brainpoolp224r1_sha224_70_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 71 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 71 for ECDSA, tcId is 72 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_71_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_71_msg[] = {
	0x31, 0x36, 0x38, 0x37, 0x37, 0x38, 0x39, 0x34, 0x31, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_71_sig[] = {
	0xd0, 0x18, 0x48, 0x82, 0xbd, 0xd6, 0xfa, 0x09, 0x99, 0x6c, 0x2f, 0xec, 0xf3, 0xcd, 0x26, 0xed, 0x86, 0xa3, 0xce, 0x15, 0x98, 0x7e, 0x06, 0xdb, 0x85, 0x0b, 0x8b, 0x2b, 0xcf, 0xf0, 0x72, 0xb2, 0x7c, 0x33, 0xf9, 0x16, 0x81, 0xd3, 0xe9, 0x5a, 0x47, 0xbe, 0xc0, 0x00, 0xcc, 0x96, 0xc5, 0xdc, 0x91, 0xf6, 0x8e, 0xcc, 0xc2, 0x1c, 0xa3, 0xc4, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_71 = {
	.name = "ecdsa_brainpoolp224r1_sha224_71",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_71_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_71_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_71_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 72 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 72 for ECDSA, tcId is 73 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_72_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_72_msg[] = {
	0x33, 0x39, 0x33, 0x32, 0x36, 0x31, 0x32, 0x32, 0x38, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_72_sig[] = {
	0x35, 0x7e, 0x96, 0xab, 0x54, 0xf4, 0xdb, 0xb3, 0xa6, 0xa3, 0xa9, 0xd1, 0xed, 0xe6, 0xdf, 0x52, 0x94, 0x63, 0x9a, 0xed, 0xfd, 0xea, 0x96, 0xe7, 0xff, 0xc9, 0xda, 0x31, 0x24, 0xeb, 0x6b, 0x7f, 0x55, 0x90, 0x67, 0x39, 0x31, 0x3e, 0xa2, 0x66, 0x5a, 0x05, 0x04, 0xa3, 0xb0, 0xbf, 0x7a, 0x9b, 0x32, 0x9c, 0x69, 0x0f, 0x4a, 0x2e, 0xdf, 0x51, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_72 = {
	.name = "ecdsa_brainpoolp224r1_sha224_72",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_72_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_72_msg,
	.msglen = 9,
	.sig = ecdsa_brainpoolp224r1_sha224_72_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 73 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 73 for ECDSA, tcId is 74 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_73_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_73_msg[] = {
	0x31, 0x30, 0x37, 0x33, 0x35, 0x37, 0x31, 0x30, 0x39, 0x35, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_73_sig[] = {
	0x0b, 0xaa, 0xf7, 0x9d, 0x52, 0x35, 0xe3, 0x26, 0x8e, 0x55, 0x43, 0x1c, 0xbd, 0x79, 0x00, 0x46, 0xc2, 0x58, 0x1e, 0xbd, 0x3f, 0x8b, 0x90, 0x62, 0x7b, 0xd4, 0x6b, 0x8b, 0x83, 0xd5, 0x6f, 0x6b, 0x56, 0xca, 0x93, 0x81, 0xb1, 0x4c, 0xa8, 0x88, 0x28, 0x1b, 0x48, 0x1c, 0xf8, 0x28, 0xe9, 0xb4, 0x3b, 0x0d, 0x41, 0x81, 0x08, 0xe8, 0x2d, 0x58, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_73 = {
	.name = "ecdsa_brainpoolp224r1_sha224_73",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_73_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_73_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_73_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 74 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 74 for ECDSA, tcId is 75 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_74_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_74_msg[] = {
	0x36, 0x30, 0x38, 0x38, 0x37, 0x34, 0x37, 0x34, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_74_sig[] = {
	0x7e, 0xbe, 0xf1, 0xad, 0x41, 0xde, 0x94, 0x34, 0xeb, 0x3f, 0x6f, 0x83, 0x33, 0x8f, 0x01, 0x09, 0x66, 0x6c, 0x26, 0x4d, 0x89, 0x12, 0x33, 0x42, 0xb0, 0x90, 0x0f, 0x05, 0x78, 0xa3, 0xa9, 0xfa, 0x72, 0x01, 0xc4, 0x8f, 0x92, 0x83, 0x44, 0x00, 0x4a, 0x1f, 0x51, 0x80, 0x53, 0x09, 0x9d, 0xf8, 0x69, 0x08, 0xde, 0x29, 0xee, 0xb7, 0x6a, 0x4c, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_74 = {
	.name = "ecdsa_brainpoolp224r1_sha224_74",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_74_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_74_msg,
	.msglen = 8,
	.sig = ecdsa_brainpoolp224r1_sha224_74_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 75 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 75 for ECDSA, tcId is 76 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_75_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_75_msg[] = {
	0x31, 0x31, 0x39, 0x32, 0x35, 0x36, 0x39, 0x39, 0x36, 0x32, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_75_sig[] = {
	0x9f, 0x20, 0xab, 0xef, 0xf0, 0xaf, 0x96, 0x5d, 0xa9, 0xc5, 0x1c, 0x99, 0x50, 0x7c, 0xf5, 0xf9, 0x1d, 0x75, 0xf2, 0x3f, 0xe0, 0x2b, 0x61, 0x15, 0x02, 0x96, 0x16, 0x7c, 0xbf, 0x6f, 0xed, 0x8a, 0x8e, 0xf7, 0x26, 0xf2, 0xf6, 0x62, 0x9c, 0x4e, 0x4b, 0x50, 0xb3, 0xc2, 0xce, 0x14, 0xff, 0x43, 0x9f, 0xe9, 0xbf, 0xe6, 0x15, 0x78, 0x68, 0xd4, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_75 = {
	.name = "ecdsa_brainpoolp224r1_sha224_75",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_75_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_75_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_75_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 76 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 76 for ECDSA, tcId is 77 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_76_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_76_msg[] = {
	0x39, 0x30, 0x30, 0x37, 0x36, 0x30, 0x39, 0x33, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_76_sig[] = {
	0x5a, 0xd6, 0x7f, 0xf0, 0xdd, 0xf8, 0xcb, 0x88, 0x40, 0x79, 0x74, 0xf8, 0x3f, 0xea, 0x43, 0xd9, 0xd1, 0x47, 0xcb, 0xb2, 0x3d, 0xba, 0x26, 0x1f, 0xad, 0xad, 0xae, 0xdb, 0x7f, 0xd3, 0x1c, 0xcc, 0x4b, 0x36, 0x05, 0xdb, 0x42, 0xb7, 0x00, 0xa2, 0x45, 0xdf, 0x8f, 0xc6, 0x0e, 0xfb, 0xf1, 0x40, 0x6a, 0xfb, 0x4d, 0x6c, 0x8c, 0x16, 0xe0, 0xa3, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_76 = {
	.name = "ecdsa_brainpoolp224r1_sha224_76",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_76_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_76_msg,
	.msglen = 8,
	.sig = ecdsa_brainpoolp224r1_sha224_76_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 77 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 77 for ECDSA, tcId is 78 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_77_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_77_msg[] = {
	0x31, 0x36, 0x30, 0x32, 0x38, 0x33, 0x36, 0x31, 0x33, 0x37, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_77_sig[] = {
	0x40, 0xe0, 0xbd, 0x9a, 0x2f, 0xa5, 0xa8, 0x86, 0x78, 0xc8, 0x5c, 0x3f, 0x4d, 0x27, 0xe2, 0xae, 0x2d, 0xd0, 0x46, 0xf2, 0x9a, 0x36, 0x39, 0xec, 0x2f, 0xf2, 0x51, 0x1a, 0x16, 0xcd, 0x49, 0x21, 0x5c, 0xb0, 0x05, 0x33, 0xfd, 0x13, 0x9a, 0xe1, 0xd3, 0x63, 0x1d, 0x45, 0xfb, 0x06, 0xd5, 0xec, 0xd1, 0x13, 0x8a, 0xb4, 0x6c, 0x48, 0xa4, 0x5c, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_77 = {
	.name = "ecdsa_brainpoolp224r1_sha224_77",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_77_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_77_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_77_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 78 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 78 for ECDSA, tcId is 79 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_78_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_78_msg[] = {
	0x32, 0x30, 0x38, 0x30, 0x32, 0x34, 0x35, 0x36, 0x37, 0x34, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_78_sig[] = {
	0x9a, 0x70, 0x5d, 0xdc, 0x87, 0x67, 0xe5, 0x4c, 0xec, 0x4d, 0x1c, 0x37, 0xa2, 0x46, 0x0b, 0x3c, 0x0b, 0x31, 0xe9, 0x81, 0x1c, 0x3a, 0x42, 0x75, 0x26, 0x49, 0x9c, 0x01, 0x36, 0xa6, 0xb9, 0xdc, 0xd7, 0xc8, 0xa8, 0x1e, 0x34, 0xaf, 0xdf, 0x84, 0x5c, 0x4c, 0xc0, 0xe7, 0x34, 0x55, 0x01, 0x1b, 0xbc, 0xd7, 0x98, 0x7f, 0x88, 0x72, 0x58, 0xba, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_78 = {
	.name = "ecdsa_brainpoolp224r1_sha224_78",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_78_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_78_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_78_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 79 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 79 for ECDSA, tcId is 80 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_79_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_79_msg[] = {
	0x31, 0x37, 0x39, 0x38, 0x32, 0x37, 0x34, 0x36, 0x35, 0x39, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_79_sig[] = {
	0xa5, 0x1a, 0x62, 0x5b, 0x99, 0x56, 0x8d, 0x00, 0x3e, 0x4b, 0x96, 0xe6, 0x93, 0x13, 0x6b, 0xa7, 0x52, 0x21, 0xe8, 0xe5, 0x6c, 0x9a, 0xb5, 0xe9, 0xec, 0x68, 0x16, 0xee, 0x7e, 0x20, 0x89, 0x18, 0x78, 0x55, 0x16, 0xcd, 0xa7, 0xcf, 0x70, 0x87, 0x0d, 0xd8, 0x12, 0xe8, 0x0e, 0x8f, 0x9f, 0x1b, 0x52, 0x48, 0xd9, 0x19, 0xb1, 0xff, 0x1d, 0x06, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_79 = {
	.name = "ecdsa_brainpoolp224r1_sha224_79",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_79_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_79_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_79_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 80 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 80 for ECDSA, tcId is 81 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_80_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_80_msg[] = {
	0x31, 0x31, 0x35, 0x35, 0x35, 0x37, 0x37, 0x37, 0x32, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_80_sig[] = {
	0x47, 0x20, 0xf9, 0x37, 0x10, 0x0d, 0xf5, 0x2e, 0x6a, 0xe1, 0xba, 0xf4, 0x0f, 0x8b, 0xc9, 0x50, 0xe5, 0xaf, 0x2b, 0x1f, 0x94, 0x7d, 0x04, 0x17, 0x80, 0x4a, 0x82, 0x25, 0x8b, 0x82, 0x22, 0x73, 0xfb, 0x5d, 0x47, 0x3c, 0x9c, 0x88, 0xaa, 0x3c, 0x8d, 0xde, 0xa1, 0x67, 0x61, 0x9c, 0xda, 0x12, 0xee, 0x41, 0xce, 0x65, 0xde, 0x26, 0x8a, 0x75, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_80 = {
	.name = "ecdsa_brainpoolp224r1_sha224_80",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_80_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_80_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_80_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 81 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 81 for ECDSA, tcId is 82 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_81_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_81_msg[] = {
	0x32, 0x34, 0x33, 0x32, 0x34, 0x37, 0x34, 0x36, 0x36, 0x34, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_81_sig[] = {
	0x3d, 0x28, 0x1d, 0x98, 0xb6, 0xa6, 0x76, 0xa6, 0xed, 0xa7, 0x57, 0x0d, 0x7b, 0x4f, 0x9a, 0x08, 0xe9, 0x24, 0xc7, 0x1a, 0xfd, 0x2c, 0xb6, 0xe0, 0x62, 0xa7, 0xeb, 0xfd, 0x84, 0x46, 0xe4, 0x27, 0x47, 0xa3, 0x52, 0x51, 0x8e, 0xf6, 0x8e, 0xff, 0x05, 0x56, 0x95, 0xb4, 0x76, 0x6b, 0xdc, 0x2a, 0xd8, 0xd3, 0xfa, 0x97, 0xbc, 0x20, 0x2b, 0x43, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_81 = {
	.name = "ecdsa_brainpoolp224r1_sha224_81",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_81_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_81_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_81_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 82 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 82 for ECDSA, tcId is 83 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_82_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_82_msg[] = {
	0x32, 0x34, 0x31, 0x37, 0x32, 0x38, 0x32, 0x32, 0x37, 0x37, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_82_sig[] = {
	0x4d, 0x34, 0x69, 0xe9, 0x39, 0xff, 0xea, 0xd9, 0x41, 0xe3, 0xcb, 0xce, 0xbc, 0xa3, 0xbc, 0xb6, 0xf3, 0xc0, 0x29, 0x64, 0x1f, 0x97, 0x70, 0x0e, 0x02, 0x81, 0x77, 0x38, 0x42, 0xcb, 0x87, 0xa1, 0x0e, 0xa1, 0x7c, 0x0e, 0x58, 0xc3, 0x82, 0x2f, 0x6a, 0xe1, 0xf3, 0xa8, 0x91, 0x8d, 0x86, 0xa8, 0x32, 0x5d, 0xef, 0x4a, 0x8c, 0x80, 0x82, 0xf2, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_82 = {
	.name = "ecdsa_brainpoolp224r1_sha224_82",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_82_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_82_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_82_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 83 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 83 for ECDSA, tcId is 84 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_83_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_83_msg[] = {
	0x37, 0x37, 0x38, 0x37, 0x34, 0x37, 0x37, 0x31, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_83_sig[] = {
	0x21, 0xe5, 0x1b, 0x79, 0xe8, 0x55, 0x4e, 0x22, 0x93, 0x7c, 0x3e, 0x5b, 0x19, 0x83, 0xb3, 0x77, 0x62, 0x59, 0x1e, 0x21, 0xf5, 0x70, 0x6e, 0x5c, 0x19, 0x82, 0xa5, 0x0c, 0x4b, 0xcd, 0xbd, 0x23, 0xb0, 0xa4, 0x71, 0xdb, 0x84, 0xd1, 0xee, 0x3e, 0xdf, 0x76, 0x77, 0xbb, 0xb1, 0x43, 0x07, 0xec, 0xc5, 0xe1, 0x02, 0x31, 0x74, 0xec, 0x5b, 0x8c, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_83 = {
	.name = "ecdsa_brainpoolp224r1_sha224_83",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_83_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_83_msg,
	.msglen = 8,
	.sig = ecdsa_brainpoolp224r1_sha224_83_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 84 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 84 for ECDSA, tcId is 85 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_84_pubkey[] = {
	0xa0, 0xef, 0x7d, 0xb1, 0xbe, 0xe0, 0xae, 0xdb, 0x5a, 0x56, 0x34, 0xf4, 0xf3, 0xb1, 0xb8, 0x8d, 0x97, 0xd2, 0xa0, 0x7f, 0x80, 0x6a, 0x71, 0x8e, 0xfe, 0x19, 0x01, 0x4d, 0xae, 0xe1, 0x04, 0x3f, 0x9e, 0x92, 0x9c, 0x32, 0xd7, 0x4a, 0xb0, 0xe4, 0xee, 0xba, 0x26, 0x23, 0xf1, 0x7b, 0xa2, 0x81, 0xb6, 0xbe, 0x87, 0x74, 0x5b, 0x59, 0xf6, 0x0e, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_84_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_84_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdb, 0xee, 0xdf, 0x88, 0x4b, 0x0c, 0x29, 0xfb, 0xcd, 0x51, 0xd9, 0x21, 0x2d, 0x5f, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9c, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_84 = {
	.name = "ecdsa_brainpoolp224r1_sha224_84",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_84_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_84_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_84_sig,
	.siglen = 56,
	.result = 1,
	.comment = "k*G has a large x-coordinate, tcId is 85 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 85 for ECDSA, tcId is 86 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_85_pubkey[] = {
	0xa0, 0xef, 0x7d, 0xb1, 0xbe, 0xe0, 0xae, 0xdb, 0x5a, 0x56, 0x34, 0xf4, 0xf3, 0xb1, 0xb8, 0x8d, 0x97, 0xd2, 0xa0, 0x7f, 0x80, 0x6a, 0x71, 0x8e, 0xfe, 0x19, 0x01, 0x4d, 0xae, 0xe1, 0x04, 0x3f, 0x9e, 0x92, 0x9c, 0x32, 0xd7, 0x4a, 0xb0, 0xe4, 0xee, 0xba, 0x26, 0x23, 0xf1, 0x7b, 0xa2, 0x81, 0xb6, 0xbe, 0x87, 0x74, 0x5b, 0x59, 0xf6, 0x0e, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_85_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_85_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xfe, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9c, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_85 = {
	.name = "ecdsa_brainpoolp224r1_sha224_85",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_85_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_85_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_85_sig,
	.siglen = 56,
	.result = -1,
	.comment = "r too large, tcId is 86 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 86 for ECDSA, tcId is 87 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_86_pubkey[] = {
	0x3a, 0xdd, 0xa4, 0x07, 0xba, 0xd7, 0xf5, 0x93, 0xe8, 0x3d, 0x7d, 0x48, 0x4f, 0xd1, 0x4c, 0x23, 0xdd, 0xa1, 0x7f, 0x8d, 0x46, 0x0c, 0x22, 0x2a, 0xa7, 0x25, 0x75, 0x77, 0xcd, 0x62, 0x44, 0x3b, 0x2b, 0x77, 0x02, 0x91, 0xf6, 0x59, 0x04, 0xda, 0xcf, 0x75, 0xff, 0x97, 0x5f, 0x1a, 0x66, 0x71, 0x87, 0xe0, 0xe4, 0xf5, 0x0c, 0x14, 0x88, 0x9c, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_86_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_86_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9d, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_86 = {
	.name = "ecdsa_brainpoolp224r1_sha224_86",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_86_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_86_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_86_sig,
	.siglen = 56,
	.result = 1,
	.comment = "r,s are large, tcId is 87 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 87 for ECDSA, tcId is 88 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_87_pubkey[] = {
	0x24, 0x58, 0x7c, 0xe1, 0xdb, 0xff, 0x28, 0x1d, 0xca, 0xb1, 0x79, 0x45, 0x19, 0x80, 0x62, 0x81, 0xad, 0x4e, 0x09, 0x97, 0x49, 0x25, 0x10, 0x67, 0x7f, 0xb6, 0x51, 0x06, 0x92, 0x96, 0x99, 0x6e, 0x83, 0xb8, 0x08, 0x67, 0x6c, 0xbf, 0x6f, 0x28, 0xc9, 0x2b, 0x84, 0x30, 0x33, 0x14, 0xb6, 0x3a, 0x03, 0x08, 0x13, 0x4f, 0x22, 0x2d, 0x0e, 0xc2, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_87_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_87_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x63, 0xf0, 0xe3, 0x42, 0x58, 0xbb, 0x90, 0x61, 0x54, 0x79, 0x06, 0xd0, 0xc3, 0x82, 0x7c, 0x50, 0x44, 0x22, 0xc1, 0x39, 0xe6, 0xd6, 0xe1, 0x07, 0x8b, 0x37, 0xaa, 0x44, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_87 = {
	.name = "ecdsa_brainpoolp224r1_sha224_87",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_87_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_87_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_87_sig,
	.siglen = 56,
	.result = 1,
	.comment = "r and s^-1 have a large Hamming weight, tcId is 88 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 88 for ECDSA, tcId is 89 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_88_pubkey[] = {
	0xc4, 0x5c, 0x51, 0xd5, 0xa9, 0xb2, 0x13, 0xe4, 0x1c, 0xa6, 0xf1, 0x5c, 0xb8, 0xaa, 0x1b, 0xc0, 0xb8, 0xb7, 0x3d, 0x3a, 0x8a, 0x23, 0xa1, 0x4f, 0x5a, 0x3d, 0xa4, 0xdf, 0xbc, 0x78, 0xcc, 0x61, 0x76, 0xd3, 0xb8, 0x31, 0xe6, 0x88, 0x00, 0x67, 0x17, 0x68, 0x04, 0x3c, 0x11, 0xbf, 0x63, 0xa6, 0x95, 0x91, 0x8d, 0xf6, 0xec, 0x87, 0x37, 0x8a, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_88_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_88_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6e, 0xb1, 0xfb, 0xfa, 0x8d, 0xf8, 0x7d, 0x4f, 0xa1, 0x0c, 0x83, 0x3f, 0x7d, 0xd1, 0xbb, 0xe7, 0xef, 0x01, 0x44, 0xff, 0x71, 0x53, 0x79, 0x75, 0x37, 0x8f, 0x91, 0xec, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_88 = {
	.name = "ecdsa_brainpoolp224r1_sha224_88",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_88_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_88_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_88_sig,
	.siglen = 56,
	.result = 1,
	.comment = "r and s^-1 have a large Hamming weight, tcId is 89 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 89 for ECDSA, tcId is 90 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_89_pubkey[] = {
	0x36, 0xa5, 0x34, 0x4d, 0xa0, 0x8a, 0x42, 0x1e, 0xdc, 0x6c, 0x3b, 0xeb, 0x7d, 0xe9, 0x7a, 0x75, 0x59, 0xfc, 0x10, 0x1c, 0x14, 0x89, 0xff, 0x2b, 0x50, 0x36, 0xd8, 0xf6, 0x20, 0x7b, 0xf4, 0x66, 0x6e, 0x4d, 0xf6, 0x06, 0xbd, 0x0d, 0x98, 0x23, 0xa5, 0x2b, 0x58, 0xdd, 0xfd, 0xfc, 0x1d, 0xa7, 0x05, 0x13, 0xc5, 0xf9, 0x99, 0x0f, 0x80, 0x85, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_89_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_89_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_89 = {
	.name = "ecdsa_brainpoolp224r1_sha224_89",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_89_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_89_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_89_sig,
	.siglen = 56,
	.result = 1,
	.comment = "small r and s, tcId is 90 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 90 for ECDSA, tcId is 91 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_90_pubkey[] = {
	0x36, 0xa5, 0x34, 0x4d, 0xa0, 0x8a, 0x42, 0x1e, 0xdc, 0x6c, 0x3b, 0xeb, 0x7d, 0xe9, 0x7a, 0x75, 0x59, 0xfc, 0x10, 0x1c, 0x14, 0x89, 0xff, 0x2b, 0x50, 0x36, 0xd8, 0xf6, 0x20, 0x7b, 0xf4, 0x66, 0x6e, 0x4d, 0xf6, 0x06, 0xbd, 0x0d, 0x98, 0x23, 0xa5, 0x2b, 0x58, 0xdd, 0xfd, 0xfc, 0x1d, 0xa7, 0x05, 0x13, 0xc5, 0xf9, 0x99, 0x0f, 0x80, 0x85, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_90_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_90_sig[] = {
	0x01, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_90 = {
	.name = "ecdsa_brainpoolp224r1_sha224_90",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_90_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_90_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_90_sig,
	.siglen = 2,
	.result = 0,
	.comment = "incorrect size of signature, tcId is 91 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 91 for ECDSA, tcId is 92 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_91_pubkey[] = {
	0x40, 0x95, 0xc0, 0x95, 0xa9, 0x64, 0x89, 0x51, 0xda, 0x35, 0x2b, 0x83, 0x7f, 0x36, 0x8e, 0x0b, 0xe6, 0x7d, 0x79, 0xfd, 0x57, 0xea, 0xdf, 0xff, 0xed, 0xdf, 0xb4, 0x55, 0xcc, 0xdc, 0xfa, 0xbe, 0xa1, 0x9e, 0x96, 0xd4, 0xd2, 0x0e, 0x42, 0xb8, 0xae, 0x23, 0xc2, 0x51, 0x94, 0x26, 0x01, 0x8e, 0x25, 0xa6, 0x4d, 0xea, 0x85, 0xd8, 0xa6, 0x8b, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_91_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_91_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_91 = {
	.name = "ecdsa_brainpoolp224r1_sha224_91",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_91_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_91_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_91_sig,
	.siglen = 56,
	.result = 1,
	.comment = "small r and s, tcId is 92 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 92 for ECDSA, tcId is 93 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_92_pubkey[] = {
	0x40, 0x95, 0xc0, 0x95, 0xa9, 0x64, 0x89, 0x51, 0xda, 0x35, 0x2b, 0x83, 0x7f, 0x36, 0x8e, 0x0b, 0xe6, 0x7d, 0x79, 0xfd, 0x57, 0xea, 0xdf, 0xff, 0xed, 0xdf, 0xb4, 0x55, 0xcc, 0xdc, 0xfa, 0xbe, 0xa1, 0x9e, 0x96, 0xd4, 0xd2, 0x0e, 0x42, 0xb8, 0xae, 0x23, 0xc2, 0x51, 0x94, 0x26, 0x01, 0x8e, 0x25, 0xa6, 0x4d, 0xea, 0x85, 0xd8, 0xa6, 0x8b, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_92_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_92_sig[] = {
	0x01, 0x02, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_92 = {
	.name = "ecdsa_brainpoolp224r1_sha224_92",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_92_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_92_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_92_sig,
	.siglen = 2,
	.result = 0,
	.comment = "incorrect size of signature, tcId is 93 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 93 for ECDSA, tcId is 94 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_93_pubkey[] = {
	0xcc, 0x35, 0x2a, 0xc4, 0x8a, 0xac, 0xb6, 0x49, 0x5e, 0xc3, 0x83, 0x1b, 0x21, 0xcc, 0xd4, 0xd3, 0x19, 0x71, 0x36, 0x29, 0x2b, 0xf6, 0xf2, 0x0f, 0x22, 0x80, 0x25, 0x66, 0x64, 0x32, 0x19, 0x91, 0xe6, 0x7f, 0x7d, 0xbc, 0x22, 0x60, 0x2e, 0xcb, 0xdb, 0x31, 0x22, 0xed, 0xce, 0x5f, 0xf8, 0x5d, 0x92, 0x31, 0x43, 0xce, 0xcc, 0x0d, 0x4f, 0x6d, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_93_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_93_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_93 = {
	.name = "ecdsa_brainpoolp224r1_sha224_93",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_93_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_93_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_93_sig,
	.siglen = 56,
	.result = 1,
	.comment = "small r and s, tcId is 94 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 94 for ECDSA, tcId is 95 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_94_pubkey[] = {
	0xcc, 0x35, 0x2a, 0xc4, 0x8a, 0xac, 0xb6, 0x49, 0x5e, 0xc3, 0x83, 0x1b, 0x21, 0xcc, 0xd4, 0xd3, 0x19, 0x71, 0x36, 0x29, 0x2b, 0xf6, 0xf2, 0x0f, 0x22, 0x80, 0x25, 0x66, 0x64, 0x32, 0x19, 0x91, 0xe6, 0x7f, 0x7d, 0xbc, 0x22, 0x60, 0x2e, 0xcb, 0xdb, 0x31, 0x22, 0xed, 0xce, 0x5f, 0xf8, 0x5d, 0x92, 0x31, 0x43, 0xce, 0xcc, 0x0d, 0x4f, 0x6d, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_94_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_94_sig[] = {
	0x01, 0x03, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_94 = {
	.name = "ecdsa_brainpoolp224r1_sha224_94",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_94_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_94_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_94_sig,
	.siglen = 2,
	.result = 0,
	.comment = "incorrect size of signature, tcId is 95 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 95 for ECDSA, tcId is 96 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_95_pubkey[] = {
	0xcc, 0x35, 0x2a, 0xc4, 0x8a, 0xac, 0xb6, 0x49, 0x5e, 0xc3, 0x83, 0x1b, 0x21, 0xcc, 0xd4, 0xd3, 0x19, 0x71, 0x36, 0x29, 0x2b, 0xf6, 0xf2, 0x0f, 0x22, 0x80, 0x25, 0x66, 0x64, 0x32, 0x19, 0x91, 0xe6, 0x7f, 0x7d, 0xbc, 0x22, 0x60, 0x2e, 0xcb, 0xdb, 0x31, 0x22, 0xed, 0xce, 0x5f, 0xf8, 0x5d, 0x92, 0x31, 0x43, 0xce, 0xcc, 0x0d, 0x4f, 0x6d, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_95_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_95_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_95 = {
	.name = "ecdsa_brainpoolp224r1_sha224_95",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_95_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_95_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_95_sig,
	.siglen = 56,
	.result = -1,
	.comment = "r is larger than n, tcId is 96 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 96 for ECDSA, tcId is 97 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_96_pubkey[] = {
	0x91, 0x48, 0xf2, 0x9c, 0x67, 0xf8, 0x3c, 0x70, 0x5e, 0xef, 0xb5, 0x9c, 0x92, 0x95, 0x47, 0x75, 0xf9, 0x0c, 0x15, 0xe2, 0x25, 0xda, 0x2e, 0x99, 0x6a, 0xbc, 0xdd, 0x1d, 0xc9, 0xdb, 0x1a, 0xa1, 0xe1, 0x52, 0x77, 0xc4, 0x55, 0x5d, 0x24, 0x11, 0x82, 0x39, 0xe5, 0x3f, 0xd2, 0xf0, 0xb5, 0xe7, 0xea, 0x80, 0x7e, 0xb3, 0xde, 0x1e, 0xe3, 0x50, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_96_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_96_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xba, 0x6a, 0x26, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_96 = {
	.name = "ecdsa_brainpoolp224r1_sha224_96",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_96_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_96_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_96_sig,
	.siglen = 56,
	.result = -1,
	.comment = "s is larger than n, tcId is 97 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 97 for ECDSA, tcId is 98 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_97_pubkey[] = {
	0x9b, 0xf0, 0x45, 0xa4, 0x3a, 0x5f, 0x14, 0xd5, 0xe4, 0x12, 0xee, 0x18, 0x1f, 0x11, 0x1d, 0x6e, 0x53, 0x96, 0x11, 0x20, 0x53, 0x1f, 0x3c, 0x50, 0xca, 0x70, 0x1e, 0x78, 0xbe, 0x9e, 0xb9, 0x51, 0x46, 0xf4, 0xf2, 0xbe, 0x96, 0x94, 0x99, 0x76, 0xa7, 0xaa, 0x49, 0xd3, 0x15, 0x93, 0xa7, 0xda, 0x2e, 0xdd, 0x90, 0x76, 0x52, 0x39, 0x8c, 0x3a, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_97_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_97_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x9d, 0xfe, 0x5c, 0xfd, 0x9b, 0x02, 0xfe, 0x7a, 0x6f, 0x74, 0x7b, 0xf3, 0x1d, 0xd5, 0x81, 0xd0, 0xa9, 0x3c, 0xfe, 0xcc, 0x66, 0xa1, 0x17, 0x3d, 0x61, 0x1d, 0xfd, 0x3c, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_97 = {
	.name = "ecdsa_brainpoolp224r1_sha224_97",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_97_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_97_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_97_sig,
	.siglen = 56,
	.result = 1,
	.comment = "small r and s^-1, tcId is 98 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 98 for ECDSA, tcId is 99 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_98_pubkey[] = {
	0x87, 0x73, 0x9e, 0x28, 0x21, 0xed, 0x95, 0x67, 0xe8, 0x87, 0x02, 0xfa, 0x8c, 0x6d, 0x08, 0x3c, 0x97, 0xc1, 0xf3, 0xf1, 0xeb, 0x32, 0xd1, 0x3f, 0x75, 0x1f, 0xb0, 0x73, 0x6d, 0x02, 0xeb, 0xa0, 0x5e, 0x8c, 0xb9, 0x46, 0x72, 0xd0, 0x9e, 0xbc, 0x11, 0x05, 0x1d, 0x52, 0xec, 0x7b, 0xd4, 0xdc, 0x77, 0x67, 0x30, 0x1b, 0x67, 0x03, 0x42, 0x12, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_98_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_98_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x9b, 0x4d, 0x34, 0x79, 0x52, 0xcc, 0x43, 0xe2, 0x35, 0x74, 0x8b, 0xd3, 0xb1, 0xbf, 0xa1, 0x4c, 0x92, 0x23, 0x4a, 0x90, 0x26, 0x1a, 0xcc, 0x3e, 0x90, 0x86, 0x81, 0x08, 0x01, 0xa3, 0x67, 0x46, 0xbc, 0xee, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_98 = {
	.name = "ecdsa_brainpoolp224r1_sha224_98",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_98_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_98_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_98_sig,
	.siglen = 56,
	.result = 1,
	.comment = "smallish r and s^-1, tcId is 99 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 99 for ECDSA, tcId is 100 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_99_pubkey[] = {
	0x1a, 0x51, 0x5c, 0xbe, 0x95, 0x7b, 0xfc, 0x07, 0x0e, 0x4c, 0x4a, 0x75, 0xd6, 0xfd, 0x5e, 0x7c, 0x15, 0xb1, 0xe2, 0x55, 0xeb, 0x42, 0xfe, 0xad, 0x06, 0xc9, 0xd2, 0x63, 0x62, 0x52, 0xcc, 0x0d, 0x23, 0x43, 0x18, 0x39, 0x4d, 0xf7, 0xdb, 0x65, 0xb0, 0xa5, 0x2e, 0x06, 0x95, 0x3c, 0xa6, 0xc2, 0x1e, 0xc9, 0x57, 0x74, 0xd3, 0x9e, 0xfd, 0xc9, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_99_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_99_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x33, 0xe6, 0x7e, 0x37, 0xb3, 0x2b, 0x44, 0x55, 0x80, 0xbf, 0x4e, 0xfb, 0xa8, 0xbd, 0xf4, 0x65, 0x32, 0xd8, 0x13, 0x6b, 0xeb, 0x21, 0xdb, 0xf1, 0x78, 0x09, 0x0c, 0x7e, 0x7d, 0xad, 0x2c, 0xaa, 0x8e, 0xb5, 0x2c, 0xef, 0x8d, 0x83, 0x0f, 0xd8, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_99 = {
	.name = "ecdsa_brainpoolp224r1_sha224_99",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_99_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_99_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_99_sig,
	.siglen = 56,
	.result = 1,
	.comment = "100-bit r and small s^-1, tcId is 100 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 100 for ECDSA, tcId is 101 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_100_pubkey[] = {
	0xd6, 0xa1, 0x6e, 0x19, 0x4e, 0x12, 0xb9, 0x6d, 0xb8, 0xe1, 0xbb, 0x02, 0x50, 0xd9, 0x50, 0xf7, 0xb3, 0x12, 0x9b, 0x14, 0xbb, 0xa0, 0xef, 0xb1, 0x57, 0xc4, 0x42, 0x3e, 0x62, 0x5a, 0x0c, 0x8c, 0x20, 0x83, 0x8b, 0xd9, 0x7f, 0xbc, 0x89, 0xf1, 0x67, 0x00, 0x28, 0x75, 0x4a, 0x09, 0xad, 0x28, 0xf6, 0x2d, 0xe5, 0xee, 0xa6, 0xe0, 0x7b, 0xc1, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_100_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_100_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x73, 0x16, 0x8a, 0x89, 0x94, 0xe5, 0xf7, 0x17, 0x93, 0x08, 0x1c, 0xb7, 0xaf, 0xbe, 0x3c, 0x0a, 0xf4, 0xbf, 0x7a, 0xa3, 0x36, 0xcf, 0x9d, 0xe3, 0x1e, 0xf8, 0x53, 0x14, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_100 = {
	.name = "ecdsa_brainpoolp224r1_sha224_100",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_100_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_100_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_100_sig,
	.siglen = 56,
	.result = 1,
	.comment = "small r and 100 bit s^-1, tcId is 101 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 101 for ECDSA, tcId is 102 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_101_pubkey[] = {
	0xc0, 0x12, 0x95, 0x0d, 0x07, 0x4b, 0xb0, 0x1b, 0x0a, 0x19, 0x88, 0xa5, 0xb5, 0x9b, 0x95, 0x91, 0x04, 0x27, 0x5b, 0xaf, 0x75, 0x7e, 0x53, 0x02, 0x9b, 0x04, 0x6a, 0x15, 0x42, 0xf5, 0x0f, 0xe2, 0x7f, 0x3e, 0xba, 0xc9, 0x03, 0x65, 0x58, 0xef, 0x30, 0xeb, 0xcb, 0x81, 0x20, 0x27, 0xbf, 0x0e, 0xf4, 0x6c, 0xda, 0x51, 0x96, 0x95, 0x41, 0xbb, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_101_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_101_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x25, 0x22, 0xbb, 0xd3, 0xec, 0xbe, 0x7c, 0x39, 0xe9, 0x3e, 0x7c, 0x24, 0x73, 0x16, 0x8a, 0x89, 0x94, 0xe5, 0xf7, 0x17, 0x93, 0x08, 0x1c, 0xb7, 0xaf, 0xbe, 0x3c, 0x0a, 0xf4, 0xbf, 0x7a, 0xa3, 0x36, 0xcf, 0x9d, 0xe3, 0x1e, 0xf8, 0x53, 0x14, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_101 = {
	.name = "ecdsa_brainpoolp224r1_sha224_101",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_101_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_101_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_101_sig,
	.siglen = 56,
	.result = 1,
	.comment = "100-bit r and s^-1, tcId is 102 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 102 for ECDSA, tcId is 103 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_102_pubkey[] = {
	0xd1, 0x5c, 0x13, 0xa1, 0xbe, 0x99, 0xd9, 0xeb, 0x77, 0xd6, 0x88, 0x10, 0x4a, 0x18, 0xe2, 0x42, 0x42, 0xd2, 0x05, 0xa4, 0x02, 0x6f, 0x4a, 0x65, 0x62, 0x9e, 0x59, 0xee, 0x7e, 0x3d, 0xdf, 0x9a, 0xbb, 0xb7, 0xd5, 0x32, 0xb6, 0xe8, 0x1a, 0x6e, 0x11, 0xf3, 0x0d, 0x5b, 0x55, 0xfe, 0xb8, 0xee, 0x70, 0x7c, 0x4f, 0xed, 0xf9, 0x9c, 0x06, 0x07, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_102_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_102_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x1f, 0x47, 0xeb, 0x11, 0x8e, 0x0c, 0xc1, 0x22, 0x2c, 0xb8, 0xb2, 0xba, 0xb7, 0x27, 0x45, 0xa9, 0x32, 0xf0, 0x5c, 0xe9, 0x6e, 0x79, 0xf4, 0xe9, 0x8b, 0xe1, 0xe2, 0x86, 0x8a, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_102 = {
	.name = "ecdsa_brainpoolp224r1_sha224_102",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_102_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_102_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_102_sig,
	.siglen = 56,
	.result = 1,
	.comment = "r and s^-1 are close to n, tcId is 103 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 103 for ECDSA, tcId is 104 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_103_pubkey[] = {
	0x3f, 0xe0, 0x19, 0x72, 0xc0, 0x62, 0x2e, 0xa8, 0x12, 0xd3, 0x06, 0x52, 0xc9, 0xfe, 0x2f, 0xeb, 0xee, 0x70, 0x81, 0x23, 0xb1, 0x62, 0x6d, 0x74, 0x4f, 0x87, 0xdb, 0x0d, 0xa5, 0x72, 0xc7, 0xe1, 0xe3, 0xa4, 0x81, 0x95, 0xe6, 0x22, 0x1d, 0x98, 0x3f, 0x78, 0x2f, 0xdc, 0x9e, 0x7c, 0x55, 0xbd, 0x5f, 0xdf, 0x7b, 0x67, 0x9b, 0x0f, 0x87, 0x56, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_103_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_103_sig[] = {
	0x47, 0xeb, 0x11, 0x8e, 0x0c, 0xc1, 0x22, 0x2c, 0xb8, 0xb2, 0xba, 0xb7, 0x27, 0x45, 0xa9, 0x32, 0xf0, 0x5c, 0xe9, 0x6e, 0x79, 0xf4, 0xe9, 0x8b, 0xe1, 0xe2, 0x86, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_103 = {
	.name = "ecdsa_brainpoolp224r1_sha224_103",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_103_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_103_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_103_sig,
	.siglen = 56,
	.result = 1,
	.comment = "s == 1, tcId is 104 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 104 for ECDSA, tcId is 105 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_104_pubkey[] = {
	0x3f, 0xe0, 0x19, 0x72, 0xc0, 0x62, 0x2e, 0xa8, 0x12, 0xd3, 0x06, 0x52, 0xc9, 0xfe, 0x2f, 0xeb, 0xee, 0x70, 0x81, 0x23, 0xb1, 0x62, 0x6d, 0x74, 0x4f, 0x87, 0xdb, 0x0d, 0xa5, 0x72, 0xc7, 0xe1, 0xe3, 0xa4, 0x81, 0x95, 0xe6, 0x22, 0x1d, 0x98, 0x3f, 0x78, 0x2f, 0xdc, 0x9e, 0x7c, 0x55, 0xbd, 0x5f, 0xdf, 0x7b, 0x67, 0x9b, 0x0f, 0x87, 0x56, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_104_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_104_sig[] = {
	0x47, 0xeb, 0x11, 0x8e, 0x0c, 0xc1, 0x22, 0x2c, 0xb8, 0xb2, 0xba, 0xb7, 0x27, 0x45, 0xa9, 0x32, 0xf0, 0x5c, 0xe9, 0x6e, 0x79, 0xf4, 0xe9, 0x8b, 0xe1, 0xe2, 0x86, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_104 = {
	.name = "ecdsa_brainpoolp224r1_sha224_104",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_104_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_104_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_104_sig,
	.siglen = 56,
	.result = -1,
	.comment = "s == 0, tcId is 105 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 105 for ECDSA, tcId is 106 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_105_pubkey[] = {
	0xd4, 0xb6, 0xe5, 0x11, 0x24, 0x06, 0xfb, 0x74, 0x3b, 0x6b, 0xb5, 0x5f, 0x49, 0xea, 0x20, 0x30, 0xd9, 0x04, 0x42, 0x08, 0x31, 0xeb, 0xdd, 0xac, 0xd6, 0x7b, 0xba, 0x89, 0x65, 0x22, 0x65, 0x38, 0x4b, 0x75, 0xd8, 0x50, 0xe7, 0xc2, 0x7f, 0x4e, 0x33, 0xed, 0x6c, 0x57, 0x6d, 0xf0, 0xff, 0x96, 0x94, 0x70, 0xa9, 0xef, 0x25, 0xff, 0xaf, 0xcd, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_105_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_105_sig[] = {
	0x6b, 0xe0, 0x9a, 0x55, 0x13, 0x21, 0xb3, 0x43, 0x15, 0x0c, 0x18, 0x12, 0xba, 0xe8, 0x7d, 0xcc, 0x68, 0x8b, 0x5e, 0x25, 0xb6, 0xef, 0x5e, 0x51, 0xd2, 0xd3, 0xc9, 0xcf, 0x47, 0xeb, 0x11, 0x8e, 0x0c, 0xc1, 0x22, 0x2c, 0xb8, 0xb2, 0xba, 0xb7, 0x27, 0x45, 0xa9, 0x32, 0xf0, 0x5c, 0xe9, 0x6e, 0x79, 0xf4, 0xe9, 0x8b, 0xe1, 0xe2, 0x86, 0x8a, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_105 = {
	.name = "ecdsa_brainpoolp224r1_sha224_105",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_105_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_105_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_105_sig,
	.siglen = 56,
	.result = -1,
	.comment = "point at infinity during verify, tcId is 106 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 106 for ECDSA, tcId is 107 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_106_pubkey[] = {
	0x16, 0xc2, 0x12, 0x9d, 0x54, 0xb9, 0x34, 0x79, 0xb5, 0x6a, 0x9f, 0xf5, 0xb8, 0x3e, 0x4c, 0x75, 0x0b, 0xb4, 0xf3, 0x3e, 0xe1, 0xe7, 0x0f, 0x38, 0xb5, 0x44, 0x9f, 0x2d, 0x34, 0xcc, 0xaf, 0x79, 0xc5, 0x1c, 0x7d, 0xff, 0x3a, 0x7f, 0x9a, 0x05, 0xcd, 0x15, 0xa3, 0x96, 0xe0, 0xcf, 0xfe, 0x25, 0x42, 0x1c, 0x37, 0xe9, 0xb8, 0x0e, 0x14, 0x89, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_106_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_106_sig[] = {
	0x6b, 0xe0, 0x9a, 0x55, 0x13, 0x21, 0xb3, 0x43, 0x15, 0x0c, 0x18, 0x12, 0xba, 0xe8, 0x7d, 0xcc, 0x68, 0x8b, 0x5e, 0x25, 0xb6, 0xef, 0x5e, 0x51, 0xd2, 0xd3, 0xc9, 0xd0, 0x6b, 0xe0, 0x9a, 0x55, 0x13, 0x21, 0xb3, 0x43, 0x15, 0x0c, 0x18, 0x12, 0xba, 0xe8, 0x7d, 0xcc, 0x68, 0x8b, 0x5e, 0x25, 0xb6, 0xef, 0x5e, 0x51, 0xd2, 0xd3, 0xc9, 0xcf, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_106 = {
	.name = "ecdsa_brainpoolp224r1_sha224_106",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_106_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_106_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_106_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for signature malleability, tcId is 107 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 107 for ECDSA, tcId is 108 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_107_pubkey[] = {
	0x65, 0xab, 0xa0, 0xe4, 0x42, 0x7a, 0x0a, 0xe5, 0x58, 0x72, 0x1a, 0x5a, 0x8e, 0x72, 0xcb, 0x37, 0x62, 0xeb, 0x50, 0x22, 0x3b, 0xbe, 0x4c, 0x41, 0xa4, 0x50, 0xfe, 0x49, 0xc8, 0x1d, 0x3a, 0xe4, 0x86, 0x47, 0x8b, 0x42, 0x98, 0xc9, 0x43, 0x28, 0x3d, 0x2e, 0xc2, 0x13, 0x0b, 0xac, 0x22, 0xfa, 0xbc, 0x52, 0xf7, 0x43, 0xb1, 0xab, 0x7f, 0xa7, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_107_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_107_sig[] = {
	0x6b, 0xe0, 0x9a, 0x55, 0x13, 0x21, 0xb3, 0x43, 0x15, 0x0c, 0x18, 0x12, 0xba, 0xe8, 0x7d, 0xcc, 0x68, 0x8b, 0x5e, 0x25, 0xb6, 0xef, 0x5e, 0x51, 0xd2, 0xd3, 0xc9, 0xd0, 0x6b, 0xe0, 0x9a, 0x55, 0x13, 0x21, 0xb3, 0x43, 0x15, 0x0c, 0x18, 0x12, 0xba, 0xe8, 0x7d, 0xcc, 0x68, 0x8b, 0x5e, 0x25, 0xb6, 0xef, 0x5e, 0x51, 0xd2, 0xd3, 0xc9, 0xd0, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_107 = {
	.name = "ecdsa_brainpoolp224r1_sha224_107",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_107_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_107_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_107_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for signature malleability, tcId is 108 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 108 for ECDSA, tcId is 109 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_108_pubkey[] = {
	0x55, 0xa7, 0xb0, 0x10, 0x06, 0x13, 0xfa, 0xbd, 0x95, 0x7b, 0x42, 0x60, 0x08, 0x35, 0xc6, 0xd4, 0x2e, 0x01, 0xe0, 0x42, 0x52, 0x59, 0x3b, 0xdd, 0xe3, 0xb1, 0x72, 0x78, 0x87, 0x70, 0x8a, 0x05, 0xab, 0xa2, 0xf9, 0x3f, 0x1a, 0x1e, 0x1e, 0xcb, 0x70, 0x3e, 0xc9, 0xa8, 0xee, 0x6d, 0x60, 0x13, 0xa1, 0x01, 0xd3, 0x97, 0x01, 0x2a, 0x8c, 0xce, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_108_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_108_sig[] = {
	0x47, 0xeb, 0x11, 0x8e, 0x0c, 0xc1, 0x22, 0x2c, 0xb8, 0xb2, 0xba, 0xb7, 0x27, 0x45, 0xa9, 0x32, 0xf0, 0x5c, 0xe9, 0x6e, 0x79, 0xf4, 0xe9, 0x8b, 0xe1, 0xe2, 0x86, 0x8a, 0x75, 0x3b, 0xb4, 0x00, 0x78, 0x93, 0x40, 0x81, 0xd7, 0xbd, 0x11, 0x3e, 0xc4, 0x9b, 0x19, 0xef, 0x09, 0xd1, 0xba, 0x33, 0x49, 0x86, 0x90, 0x51, 0x6d, 0x4d, 0x12, 0x2c, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_108 = {
	.name = "ecdsa_brainpoolp224r1_sha224_108",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_108_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_108_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_108_sig,
	.siglen = 56,
	.result = 1,
	.comment = "u1 == 1, tcId is 109 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 109 for ECDSA, tcId is 110 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_109_pubkey[] = {
	0x1a, 0xda, 0x54, 0xdc, 0x01, 0x58, 0x61, 0x68, 0x0d, 0x8b, 0xb2, 0xd3, 0x11, 0xb9, 0x0e, 0x82, 0xdb, 0x75, 0xaa, 0x9e, 0x82, 0x17, 0xb9, 0x26, 0x11, 0xfa, 0x03, 0xcb, 0x84, 0xc6, 0x11, 0x55, 0x11, 0x97, 0x29, 0x8b, 0x32, 0x74, 0x87, 0x5c, 0xb9, 0x46, 0x86, 0xe7, 0x58, 0xf0, 0xa1, 0xa9, 0x67, 0x5c, 0x0b, 0xc1, 0x57, 0x45, 0x1a, 0x76, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_109_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_109_sig[] = {
	0x47, 0xeb, 0x11, 0x8e, 0x0c, 0xc1, 0x22, 0x2c, 0xb8, 0xb2, 0xba, 0xb7, 0x27, 0x45, 0xa9, 0x32, 0xf0, 0x5c, 0xe9, 0x6e, 0x79, 0xf4, 0xe9, 0x8b, 0xe1, 0xe2, 0x86, 0x8a, 0x62, 0x85, 0x80, 0xa9, 0xad, 0xb0, 0x26, 0x04, 0x52, 0x5b, 0x1e, 0xe6, 0xb1, 0x35, 0xe1, 0xa9, 0xc7, 0x45, 0x02, 0x18, 0x24, 0x58, 0x2c, 0x52, 0x38, 0x5a, 0x81, 0x73, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_109 = {
	.name = "ecdsa_brainpoolp224r1_sha224_109",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_109_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_109_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_109_sig,
	.siglen = 56,
	.result = 1,
	.comment = "u1 == n - 1, tcId is 110 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 110 for ECDSA, tcId is 111 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_110_pubkey[] = {
	0xc6, 0x7b, 0x64, 0x29, 0x78, 0x53, 0x34, 0xa6, 0x08, 0xdd, 0xe9, 0x49, 0xa8, 0xab, 0xe6, 0x41, 0xdb, 0xd3, 0x60, 0x1e, 0xbc, 0xe1, 0xe6, 0x75, 0xfe, 0x71, 0xa8, 0xe5, 0x27, 0xd2, 0xe8, 0x72, 0x7d, 0xc4, 0xf6, 0x18, 0x49, 0x35, 0x50, 0xbb, 0x94, 0x01, 0x51, 0xbc, 0xa6, 0x82, 0x6f, 0x71, 0x4c, 0x5b, 0x31, 0x85, 0x40, 0x38, 0xf4, 0x4d, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_110_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_110_sig[] = {
	0x47, 0xeb, 0x11, 0x8e, 0x0c, 0xc1, 0x22, 0x2c, 0xb8, 0xb2, 0xba, 0xb7, 0x27, 0x45, 0xa9, 0x32, 0xf0, 0x5c, 0xe9, 0x6e, 0x79, 0xf4, 0xe9, 0x8b, 0xe1, 0xe2, 0x86, 0x8a, 0x47, 0xeb, 0x11, 0x8e, 0x0c, 0xc1, 0x22, 0x2c, 0xb8, 0xb2, 0xba, 0xb7, 0x27, 0x45, 0xa9, 0x32, 0xf0, 0x5c, 0xe9, 0x6e, 0x79, 0xf4, 0xe9, 0x8b, 0xe1, 0xe2, 0x86, 0x8a, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_110 = {
	.name = "ecdsa_brainpoolp224r1_sha224_110",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_110_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_110_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_110_sig,
	.siglen = 56,
	.result = 1,
	.comment = "u2 == 1, tcId is 111 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 111 for ECDSA, tcId is 112 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_111_pubkey[] = {
	0x1d, 0xcc, 0x7a, 0x5a, 0xd1, 0x11, 0xa3, 0x36, 0x27, 0xf9, 0x2d, 0xd8, 0x75, 0xba, 0x4a, 0x06, 0xf6, 0xa7, 0xc2, 0xbe, 0xfd, 0xd1, 0x05, 0x04, 0x88, 0xd0, 0x57, 0xa7, 0x34, 0x1c, 0xae, 0x0b, 0xe7, 0x2a, 0x99, 0x77, 0x6d, 0xb5, 0xbd, 0x79, 0xb4, 0x63, 0xe2, 0xd3, 0x88, 0x27, 0x64, 0xaf, 0x9c, 0x02, 0x45, 0xd0, 0x84, 0xa3, 0x34, 0x2d, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_111_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_111_sig[] = {
	0x47, 0xeb, 0x11, 0x8e, 0x0c, 0xc1, 0x22, 0x2c, 0xb8, 0xb2, 0xba, 0xb7, 0x27, 0x45, 0xa9, 0x32, 0xf0, 0x5c, 0xe9, 0x6e, 0x79, 0xf4, 0xe9, 0x8b, 0xe1, 0xe2, 0x86, 0x8a, 0x8f, 0xd6, 0x23, 0x1c, 0x19, 0x82, 0x44, 0x59, 0x71, 0x65, 0x75, 0x6e, 0x4e, 0x8b, 0x52, 0x65, 0xe0, 0xb9, 0xd2, 0xdc, 0xf3, 0xe9, 0xd3, 0x17, 0xc3, 0xc5, 0x0d, 0x15, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_111 = {
	.name = "ecdsa_brainpoolp224r1_sha224_111",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_111_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_111_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_111_sig,
	.siglen = 56,
	.result = 1,
	.comment = "u2 == n - 1, tcId is 112 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 112 for ECDSA, tcId is 113 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_112_pubkey[] = {
	0xbd, 0xf7, 0x08, 0xa0, 0x1c, 0x6a, 0x81, 0x47, 0x28, 0xd3, 0x94, 0xb7, 0xf2, 0x9b, 0xf6, 0x57, 0x97, 0x34, 0x86, 0x2d, 0x8a, 0xf8, 0xe6, 0xff, 0x78, 0x6f, 0xbe, 0x49, 0x90, 0x1c, 0xd4, 0x62, 0x94, 0x6e, 0x5e, 0x36, 0xcc, 0x97, 0xc9, 0x89, 0x6d, 0xf2, 0xe1, 0x81, 0x77, 0x45, 0x6d, 0x28, 0x2a, 0x7a, 0x26, 0xa3, 0x80, 0x84, 0xc0, 0x86, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_112_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_112_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xb6, 0xea, 0x09, 0xc6, 0xec, 0x5e, 0x04, 0x84, 0xb9, 0x4f, 0x25, 0xd8, 0x90, 0x14, 0x5b, 0x0a, 0xe3, 0xff, 0xbb, 0x98, 0xb7, 0x16, 0xad, 0xdd, 0x92, 0xde, 0xbd, 0xce, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_112 = {
	.name = "ecdsa_brainpoolp224r1_sha224_112",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_112_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_112_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_112_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u1, tcId is 113 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 113 for ECDSA, tcId is 114 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_113_pubkey[] = {
	0x0c, 0x53, 0x1f, 0xb3, 0xd9, 0x96, 0xfa, 0xa2, 0x24, 0x07, 0xdf, 0x13, 0x05, 0xff, 0x6a, 0xe0, 0xbf, 0xe9, 0x4e, 0x1c, 0x20, 0x22, 0xf4, 0x73, 0x0d, 0x0f, 0x8a, 0x4a, 0xbd, 0x80, 0x73, 0x95, 0x04, 0x59, 0x56, 0x2e, 0x53, 0x9a, 0xc0, 0x89, 0x54, 0x33, 0x75, 0x7e, 0x25, 0x20, 0x9b, 0x12, 0x53, 0x4f, 0xf3, 0x0f, 0xe3, 0xd3, 0x7c, 0x71, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_113_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_113_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x2f, 0x62, 0xa9, 0xcf, 0x48, 0xe3, 0xca, 0x60, 0x2e, 0xef, 0x4e, 0x33, 0xaf, 0xa4, 0x3f, 0x2d, 0xce, 0xb9, 0x22, 0xa4, 0x0a, 0x67, 0xde, 0x79, 0xf7, 0xb1, 0xae, 0x38, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_113 = {
	.name = "ecdsa_brainpoolp224r1_sha224_113",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_113_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_113_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_113_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u1, tcId is 114 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 114 for ECDSA, tcId is 115 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_114_pubkey[] = {
	0x67, 0x82, 0x95, 0x40, 0x82, 0x41, 0x8e, 0x00, 0x02, 0xa0, 0x81, 0x26, 0x72, 0xac, 0x21, 0x23, 0xb6, 0x33, 0x4b, 0x34, 0x13, 0x40, 0x55, 0x50, 0x96, 0xbc, 0xf6, 0xc6, 0x1f, 0x6f, 0xa1, 0xa8, 0xfe, 0xa6, 0x17, 0xd9, 0xdd, 0xa1, 0x44, 0x61, 0xd6, 0x3a, 0xa4, 0x48, 0xf2, 0x05, 0xa3, 0x9b, 0x25, 0x50, 0x1a, 0x6b, 0x1d, 0x42, 0xee, 0x5f, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_114_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_114_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x61, 0x8d, 0xfc, 0x54, 0x40, 0x8b, 0xec, 0x1c, 0xb3, 0x7c, 0x7e, 0xe5, 0x2b, 0x60, 0xad, 0xbc, 0x8d, 0x3a, 0x6c, 0x26, 0x45, 0x7c, 0x39, 0xd0, 0x13, 0xe8, 0x8e, 0x81, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_114 = {
	.name = "ecdsa_brainpoolp224r1_sha224_114",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_114_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_114_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_114_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u1, tcId is 115 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 115 for ECDSA, tcId is 116 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_115_pubkey[] = {
	0x5b, 0x5e, 0x6e, 0xab, 0xa7, 0x59, 0x7a, 0xe6, 0x41, 0x42, 0x0a, 0xce, 0x6a, 0xf2, 0x57, 0x58, 0x39, 0xf1, 0x61, 0xb2, 0x7b, 0x91, 0xb2, 0x70, 0xf1, 0x8b, 0xf7, 0xd0, 0x49, 0x6a, 0xb3, 0xc3, 0x07, 0x2f, 0xa6, 0xee, 0x55, 0x78, 0xfc, 0x81, 0x4f, 0x74, 0xd1, 0x48, 0xec, 0xbc, 0x2a, 0x98, 0xcf, 0xdc, 0x5d, 0x40, 0xec, 0x7e, 0x69, 0x80, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_115_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_115_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x01, 0x0d, 0xe5, 0x71, 0x24, 0xc0, 0x93, 0x0e, 0xf8, 0x00, 0xe7, 0x64, 0xb5, 0x58, 0x59, 0x27, 0x97, 0x7e, 0x2a, 0xd2, 0xd8, 0xb8, 0x2e, 0x7c, 0xb6, 0x48, 0xaf, 0x52, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_115 = {
	.name = "ecdsa_brainpoolp224r1_sha224_115",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_115_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_115_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_115_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u1, tcId is 116 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 116 for ECDSA, tcId is 117 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_116_pubkey[] = {
	0x8e, 0x66, 0x1a, 0x06, 0xad, 0x55, 0xb5, 0x22, 0x78, 0x01, 0xea, 0x43, 0x09, 0xa7, 0x2b, 0x9c, 0xd9, 0x49, 0x73, 0xbc, 0x87, 0x3c, 0x04, 0x05, 0xe1, 0x24, 0x7d, 0x1e, 0x64, 0x89, 0x8b, 0x82, 0x2c, 0x36, 0x3c, 0xac, 0x88, 0x21, 0x30, 0x2d, 0xe3, 0x8a, 0x91, 0x42, 0x68, 0xaa, 0xa6, 0x7d, 0xb2, 0x56, 0x18, 0x78, 0xf0, 0xf9, 0x0a, 0x02, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_116_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_116_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x03, 0x3e, 0xf5, 0x01, 0x0b, 0xec, 0xed, 0x04, 0xc4, 0x92, 0x88, 0x68, 0x51, 0x3e, 0xd1, 0x87, 0x8c, 0xe6, 0x77, 0xa6, 0xed, 0x81, 0x0e, 0x9b, 0x99, 0xdd, 0x97, 0x94, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_116 = {
	.name = "ecdsa_brainpoolp224r1_sha224_116",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_116_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_116_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_116_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u1, tcId is 117 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 117 for ECDSA, tcId is 118 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_117_pubkey[] = {
	0xb3, 0xd2, 0xb9, 0x3f, 0x14, 0x88, 0x65, 0x72, 0x62, 0x14, 0x0f, 0x96, 0xc1, 0x08, 0xaa, 0x04, 0x85, 0x93, 0x9b, 0xd9, 0x94, 0x40, 0x24, 0x0a, 0x7a, 0x7d, 0x54, 0xe3, 0x88, 0x96, 0x81, 0x74, 0xb0, 0x61, 0x85, 0x37, 0x39, 0xf8, 0xb0, 0x47, 0x1c, 0x76, 0x12, 0x65, 0x39, 0xdc, 0x57, 0xcc, 0x6d, 0x7c, 0x1f, 0x53, 0x9f, 0x68, 0x66, 0x74, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_117_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_117_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x06, 0x7d, 0xea, 0x02, 0x17, 0xd9, 0xda, 0x09, 0x89, 0x25, 0x10, 0xd0, 0xa2, 0x7d, 0xa3, 0x0f, 0x19, 0xcc, 0xef, 0x4d, 0xdb, 0x02, 0x1d, 0x37, 0x33, 0xbb, 0x2f, 0x28, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_117 = {
	.name = "ecdsa_brainpoolp224r1_sha224_117",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_117_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_117_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_117_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u1, tcId is 118 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 118 for ECDSA, tcId is 119 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_118_pubkey[] = {
	0xba, 0x83, 0x0d, 0xbf, 0x83, 0x07, 0x5c, 0xd1, 0x82, 0xbc, 0x93, 0x22, 0xc1, 0xf6, 0x29, 0x9a, 0x4c, 0xe3, 0xcf, 0x4d, 0xdd, 0xe0, 0xe6, 0xfc, 0xee, 0x50, 0xf0, 0xd6, 0x2b, 0x15, 0x3f, 0x6f, 0x37, 0x7a, 0x88, 0x80, 0x9c, 0x9d, 0xd5, 0x0d, 0x8d, 0x61, 0xeb, 0x67, 0x94, 0x51, 0x44, 0x48, 0x16, 0x57, 0x86, 0xa7, 0xc6, 0x55, 0x8d, 0xcc, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_118_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_118_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x45, 0x84, 0x7e, 0x02, 0xfd, 0x01, 0xa3, 0xcc, 0x9e, 0x06, 0x3f, 0x96, 0x1f, 0xb9, 0x20, 0xab, 0x32, 0x71, 0xec, 0x09, 0x99, 0x6f, 0x75, 0xbc, 0xa7, 0xfe, 0x6d, 0x3f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_118 = {
	.name = "ecdsa_brainpoolp224r1_sha224_118",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_118_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_118_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_118_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u1, tcId is 119 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 119 for ECDSA, tcId is 120 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_119_pubkey[] = {
	0x77, 0xf4, 0x02, 0x22, 0xe4, 0xa7, 0x9a, 0x0f, 0xa7, 0xe5, 0x10, 0x88, 0x7e, 0x69, 0xeb, 0xa3, 0x1f, 0x6d, 0xd7, 0x06, 0x71, 0x21, 0xda, 0xfe, 0x73, 0x9b, 0xbe, 0x13, 0xd0, 0xff, 0xab, 0x72, 0x22, 0xcf, 0x6d, 0x82, 0x7c, 0x51, 0xeb, 0x53, 0xab, 0xac, 0x50, 0x6b, 0xc0, 0xa5, 0xd7, 0xc1, 0xa5, 0xa7, 0xe1, 0x68, 0x3d, 0x49, 0xe4, 0x3e, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_119_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_119_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0b, 0x4c, 0xbe, 0x86, 0x6d, 0x19, 0x20, 0x63, 0x41, 0x38, 0xc8, 0x79, 0x8f, 0xcc, 0x41, 0x47, 0x94, 0x47, 0xe5, 0xae, 0x76, 0x07, 0x94, 0xe1, 0xe5, 0x79, 0x79, 0x28, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_119 = {
	.name = "ecdsa_brainpoolp224r1_sha224_119",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_119_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_119_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_119_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u1, tcId is 120 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 120 for ECDSA, tcId is 121 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_120_pubkey[] = {
	0x59, 0x7b, 0x5a, 0x3c, 0x10, 0x6b, 0x8c, 0x4e, 0x9a, 0x7e, 0x7a, 0x51, 0x7c, 0xd7, 0x40, 0xe7, 0x76, 0x67, 0xc8, 0xa2, 0xd0, 0x6c, 0x51, 0x0e, 0x5e, 0x3b, 0x72, 0x8d, 0x9c, 0xc2, 0x49, 0xe8, 0x27, 0xf5, 0xff, 0xf9, 0x02, 0x12, 0x2e, 0xb2, 0x6b, 0xad, 0xc4, 0xa7, 0xda, 0x65, 0x55, 0xb4, 0x89, 0xba, 0x98, 0x98, 0x2d, 0x38, 0x81, 0x25, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_120_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_120_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x20, 0xd7, 0x2a, 0xe3, 0x39, 0xe5, 0x62, 0x01, 0x70, 0xc9, 0x0a, 0x4c, 0xe5, 0xbc, 0xa0, 0x8d, 0xed, 0x17, 0x00, 0xb2, 0xb6, 0xc8, 0x0e, 0xc6, 0x12, 0xc8, 0xd5, 0xd1, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_120 = {
	.name = "ecdsa_brainpoolp224r1_sha224_120",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_120_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_120_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_120_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u1, tcId is 121 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 121 for ECDSA, tcId is 122 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_121_pubkey[] = {
	0x0f, 0x24, 0x53, 0xe7, 0x58, 0x5c, 0xb1, 0x39, 0x2f, 0xf4, 0xfa, 0x11, 0x86, 0x9f, 0x8c, 0x10, 0xb2, 0xf9, 0xcf, 0x4f, 0x2a, 0x18, 0xb8, 0x66, 0xe8, 0xf3, 0x7c, 0x2b, 0xd1, 0x56, 0x6e, 0xf0, 0x49, 0x28, 0x79, 0x75, 0x79, 0xd4, 0x0f, 0x33, 0x10, 0xeb, 0xaf, 0x47, 0x7a, 0x4e, 0x78, 0xa2, 0x35, 0x86, 0x19, 0x28, 0x32, 0x86, 0x34, 0xdf, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_121_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_121_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x9d, 0x23, 0x5a, 0xa9, 0xe9, 0xf9, 0xc6, 0x45, 0x3e, 0x39, 0xa7, 0x86, 0x13, 0x83, 0x6e, 0xa1, 0x4c, 0x2d, 0xdf, 0x31, 0xc9, 0x1b, 0x74, 0x7a, 0xef, 0x01, 0x0a, 0x89, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_121 = {
	.name = "ecdsa_brainpoolp224r1_sha224_121",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_121_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_121_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_121_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u1, tcId is 122 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 122 for ECDSA, tcId is 123 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_122_pubkey[] = {
	0x10, 0xcb, 0x3d, 0xbc, 0xe4, 0xda, 0x51, 0x8e, 0x04, 0xeb, 0x12, 0x5c, 0xf3, 0xb4, 0x4b, 0xef, 0x04, 0x51, 0xba, 0xd3, 0xe7, 0xcb, 0xba, 0xd5, 0x32, 0x8b, 0x85, 0xbb, 0x35, 0x86, 0x51, 0xb4, 0x78, 0xbc, 0xf2, 0x00, 0x68, 0x4f, 0xd3, 0x10, 0xe6, 0xd1, 0x4a, 0xcd, 0x23, 0xdc, 0x2a, 0x76, 0x04, 0x75, 0xdf, 0x0f, 0x5b, 0x8a, 0x75, 0x8c, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_122_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_122_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x9c, 0xa7, 0x98, 0x7f, 0x33, 0x67, 0xa9, 0x51, 0x6e, 0xca, 0x57, 0x85, 0x50, 0x98, 0xd4, 0xaa, 0xaf, 0x28, 0x94, 0x38, 0xd9, 0xad, 0x7b, 0x39, 0xdc, 0xc8, 0x11, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_122 = {
	.name = "ecdsa_brainpoolp224r1_sha224_122",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_122_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_122_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_122_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u1, tcId is 123 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 123 for ECDSA, tcId is 124 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_123_pubkey[] = {
	0x2c, 0x27, 0x73, 0x2a, 0xaa, 0xa3, 0xf8, 0xb1, 0x66, 0x64, 0xa4, 0x8a, 0x1d, 0xd0, 0x6f, 0xc0, 0xfe, 0x40, 0xf6, 0x57, 0x42, 0x75, 0x1e, 0x5c, 0x04, 0xb7, 0xef, 0xf5, 0x07, 0x80, 0x4b, 0x2d, 0xbe, 0xe7, 0x9f, 0xfe, 0x56, 0xdc, 0x4f, 0x4a, 0x60, 0x62, 0xce, 0xd6, 0xf3, 0x75, 0xb8, 0x0b, 0x5a, 0xd2, 0xcf, 0x3a, 0x29, 0x21, 0xb3, 0x95, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_123_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_123_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x72, 0x95, 0xbc, 0x38, 0xb7, 0x6b, 0xcc, 0xd7, 0x63, 0x5d, 0x65, 0x61, 0xd1, 0xf0, 0x53, 0xdd, 0x9b, 0x07, 0x94, 0x19, 0x24, 0x9f, 0x94, 0x36, 0x8c, 0x8d, 0x31, 0x33, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_123 = {
	.name = "ecdsa_brainpoolp224r1_sha224_123",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_123_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_123_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_123_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u2, tcId is 124 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 124 for ECDSA, tcId is 125 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_124_pubkey[] = {
	0x8c, 0xed, 0x55, 0x68, 0x77, 0xee, 0x15, 0xaf, 0x31, 0x4a, 0xed, 0x5d, 0xfc, 0x43, 0xa0, 0x0f, 0xbb, 0x76, 0x26, 0xfb, 0xdc, 0x7b, 0x81, 0xff, 0x7d, 0xbe, 0xa2, 0xf8, 0x98, 0xf5, 0xe2, 0x6f, 0x7f, 0xc3, 0x27, 0x6d, 0xa2, 0xa8, 0xe8, 0x69, 0xb0, 0xaf, 0xbc, 0x41, 0xef, 0x3b, 0x40, 0x32, 0x60, 0x80, 0xaa, 0x85, 0xce, 0x62, 0xc2, 0xab, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_124_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_124_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x93, 0x8f, 0x2d, 0xb2, 0xb7, 0x20, 0x61, 0xab, 0xd7, 0xeb, 0x6e, 0x5c, 0x8f, 0xe6, 0x85, 0x39, 0x1e, 0x96, 0x6e, 0xc0, 0xc7, 0x69, 0xd0, 0xc5, 0x38, 0xe0, 0x67, 0x8a, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_124 = {
	.name = "ecdsa_brainpoolp224r1_sha224_124",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_124_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_124_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_124_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u2, tcId is 125 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 125 for ECDSA, tcId is 126 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_125_pubkey[] = {
	0x42, 0xb1, 0x9b, 0x22, 0x50, 0x6c, 0x4f, 0xd8, 0x9f, 0xa2, 0x8c, 0x59, 0x09, 0xd9, 0x7f, 0x8f, 0xfe, 0xbd, 0xc8, 0x28, 0x04, 0xdc, 0xc7, 0xbf, 0x6a, 0x57, 0x0a, 0xe2, 0x1a, 0x97, 0x4e, 0xe0, 0x8b, 0x48, 0x4f, 0xa0, 0x5e, 0x1f, 0xbb, 0x89, 0xc4, 0x8c, 0x50, 0x75, 0x4b, 0xa1, 0xe4, 0x0a, 0x65, 0x8a, 0x5c, 0xed, 0x40, 0x9c, 0x63, 0x61, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_125_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_125_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x7f, 0x90, 0x7c, 0x8e, 0x32, 0xe6, 0x0e, 0x2b, 0xa4, 0x03, 0x3e, 0xe7, 0xd6, 0x5f, 0x3f, 0xe8, 0xfd, 0x23, 0x71, 0x9c, 0x7a, 0x9c, 0x6f, 0x5e, 0x52, 0xf1, 0x8c, 0x47, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_125 = {
	.name = "ecdsa_brainpoolp224r1_sha224_125",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_125_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_125_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_125_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u2, tcId is 126 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 126 for ECDSA, tcId is 127 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_126_pubkey[] = {
	0x20, 0x95, 0xe1, 0x21, 0x16, 0xce, 0xbd, 0xd4, 0xe8, 0xbc, 0x1c, 0xc1, 0x84, 0xb5, 0x38, 0xb1, 0x51, 0x5f, 0x78, 0x9e, 0x3b, 0xe4, 0xb0, 0x3a, 0x41, 0x83, 0xfa, 0xe5, 0xd0, 0x92, 0x6e, 0x44, 0x68, 0x75, 0xab, 0xdc, 0xd1, 0x2c, 0x82, 0x39, 0xe6, 0x07, 0x96, 0x1c, 0xad, 0xd0, 0x0a, 0x2e, 0x89, 0x9d, 0x82, 0x1d, 0xb1, 0x1d, 0x56, 0x79, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_126_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_126_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x34, 0xc3, 0x97, 0x8c, 0x3a, 0x1d, 0xac, 0x92, 0x1f, 0x62, 0x35, 0xc8, 0x2a, 0x02, 0xed, 0xb9, 0x34, 0x22, 0x85, 0x46, 0x94, 0x26, 0xbb, 0x10, 0xf8, 0x28, 0x97, 0xc4, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_126 = {
	.name = "ecdsa_brainpoolp224r1_sha224_126",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_126_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_126_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_126_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u2, tcId is 127 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 127 for ECDSA, tcId is 128 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_127_pubkey[] = {
	0x58, 0xf8, 0x2e, 0xb2, 0xca, 0x6e, 0x34, 0x74, 0xa9, 0x0e, 0x29, 0xac, 0x56, 0xdc, 0xb6, 0x3d, 0x88, 0xe6, 0x69, 0xe0, 0xa4, 0x02, 0x04, 0xe6, 0x20, 0x2a, 0xf7, 0xc5, 0xa0, 0xe8, 0x5e, 0x40, 0x39, 0xf3, 0x43, 0x25, 0x5b, 0x4f, 0xe4, 0xbd, 0xc1, 0x19, 0x1a, 0x78, 0x45, 0xbd, 0xd7, 0xeb, 0x90, 0x8e, 0xcd, 0x87, 0x79, 0xa2, 0x79, 0x63, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_127_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_127_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x97, 0x01, 0xd6, 0x52, 0x3d, 0x3d, 0x3f, 0x5b, 0x8a, 0xc8, 0x40, 0x26, 0x80, 0xb3, 0xca, 0xb8, 0x96, 0x6e, 0x26, 0x51, 0xcf, 0xc1, 0x73, 0x9f, 0xcd, 0x3c, 0x07, 0x49, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_127 = {
	.name = "ecdsa_brainpoolp224r1_sha224_127",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_127_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_127_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_127_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u2, tcId is 128 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 128 for ECDSA, tcId is 129 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_128_pubkey[] = {
	0x71, 0xf2, 0xc4, 0xa7, 0xc3, 0xf7, 0x13, 0x11, 0xa7, 0x93, 0x45, 0x8f, 0xf1, 0x22, 0x62, 0xa8, 0x63, 0x51, 0x8f, 0xb3, 0x0d, 0xbb, 0x7a, 0x80, 0x70, 0x10, 0x30, 0xb8, 0xb6, 0xb0, 0x84, 0x28, 0xfa, 0xbd, 0xb6, 0x9c, 0x8a, 0x8e, 0x9e, 0x32, 0x7d, 0xae, 0xd0, 0x79, 0x5f, 0xb8, 0x4e, 0x0d, 0x88, 0x17, 0x08, 0x60, 0x22, 0xd3, 0xb2, 0x3b, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_128_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_128_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x56, 0x42, 0x77, 0xfa, 0x54, 0x37, 0x18, 0x30, 0xeb, 0x78, 0x50, 0x27, 0x8b, 0x96, 0x99, 0xd8, 0x5b, 0xc5, 0x90, 0x58, 0x31, 0xa4, 0x2a, 0x9b, 0xf4, 0xd0, 0x7a, 0xf3, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_128 = {
	.name = "ecdsa_brainpoolp224r1_sha224_128",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_128_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_128_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_128_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u2, tcId is 129 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 129 for ECDSA, tcId is 130 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_129_pubkey[] = {
	0x3c, 0xfc, 0xf6, 0x4e, 0xec, 0xe9, 0x94, 0xc3, 0x5c, 0x56, 0xe9, 0x15, 0xe4, 0xed, 0x18, 0x83, 0xba, 0x6e, 0xc3, 0x4f, 0xe3, 0x96, 0xc1, 0x1a, 0xcd, 0x8f, 0x47, 0xd2, 0x63, 0xcd, 0xfb, 0xaa, 0x34, 0x40, 0x11, 0x00, 0xb5, 0xb1, 0x0a, 0xf7, 0x71, 0xbb, 0x46, 0xc0, 0xd5, 0x34, 0x46, 0xf7, 0xaa, 0x84, 0x79, 0x56, 0xc9, 0x36, 0x34, 0x94, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_129_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_129_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x77, 0x94, 0xfb, 0xde, 0xe6, 0x38, 0xf6, 0x57, 0xac, 0x1e, 0x4c, 0x65, 0x28, 0x4c, 0x14, 0x4b, 0x3e, 0xfa, 0x7b, 0xf4, 0x10, 0x9e, 0x6c, 0xca, 0x60, 0x5c, 0x4f, 0x4c, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_129 = {
	.name = "ecdsa_brainpoolp224r1_sha224_129",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_129_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_129_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_129_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u2, tcId is 130 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 130 for ECDSA, tcId is 131 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_130_pubkey[] = {
	0x4c, 0x40, 0x4d, 0xec, 0xbc, 0x06, 0x97, 0xb2, 0x07, 0xfa, 0x08, 0x98, 0x2e, 0xf0, 0xfe, 0xdb, 0x00, 0x1e, 0xeb, 0x43, 0xf3, 0x74, 0x04, 0xda, 0xb9, 0x7a, 0x9a, 0x77, 0x47, 0x19, 0x1b, 0xc2, 0x40, 0xdf, 0xd4, 0x40, 0x27, 0x4e, 0x06, 0x95, 0x56, 0x11, 0xf9, 0x92, 0x3f, 0xad, 0x69, 0x49, 0xb2, 0xcc, 0x15, 0x7a, 0x18, 0x5c, 0x82, 0x29, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_130_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_130_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xb5, 0x20, 0x0d, 0xa7, 0xa4, 0x58, 0x37, 0xf5, 0xb7, 0x1c, 0x47, 0xe1, 0xb9, 0x4c, 0x78, 0x62, 0xa1, 0xe4, 0xbe, 0xcb, 0xa3, 0x0a, 0x90, 0x8a, 0xda, 0x21, 0x94, 0x87, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_130 = {
	.name = "ecdsa_brainpoolp224r1_sha224_130",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_130_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_130_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_130_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u2, tcId is 131 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 131 for ECDSA, tcId is 132 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_131_pubkey[] = {
	0x7b, 0xe4, 0xb0, 0xea, 0x0b, 0x15, 0xb9, 0x6f, 0x91, 0x31, 0x2c, 0x15, 0xc8, 0x16, 0x29, 0xe4, 0x0c, 0x44, 0x18, 0xf7, 0x0b, 0x86, 0xc5, 0xbc, 0xdc, 0x25, 0x8f, 0xd9, 0x79, 0xcb, 0xef, 0x8e, 0xa2, 0xa7, 0x7c, 0xa0, 0x92, 0xdb, 0x0e, 0xb9, 0x54, 0xa9, 0xe3, 0x3e, 0x82, 0xb9, 0xc5, 0xf1, 0x10, 0xc8, 0xc9, 0x90, 0xb9, 0x23, 0x5a, 0x57, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_131_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_131_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x65, 0x2b, 0x78, 0x71, 0x6e, 0xd7, 0x99, 0xae, 0xc6, 0xba, 0xca, 0xc3, 0xa3, 0xe0, 0xa7, 0xbb, 0x36, 0x0f, 0x28, 0x32, 0x49, 0x3f, 0x28, 0x6d, 0x19, 0x1a, 0x62, 0x6c, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_131 = {
	.name = "ecdsa_brainpoolp224r1_sha224_131",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_131_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_131_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_131_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u2, tcId is 132 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 132 for ECDSA, tcId is 133 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_132_pubkey[] = {
	0x64, 0xa6, 0x4c, 0xff, 0xa5, 0x40, 0x66, 0x49, 0x92, 0x64, 0x99, 0x1e, 0x47, 0xa0, 0xf1, 0x4b, 0xca, 0x63, 0x19, 0xa1, 0xc2, 0x7e, 0x15, 0x08, 0xe2, 0x01, 0x6b, 0x56, 0xbd, 0xa7, 0xc1, 0x7a, 0x04, 0xd9, 0xcb, 0x88, 0xea, 0xdb, 0x72, 0x96, 0xcf, 0x87, 0xdf, 0xbf, 0xad, 0xfe, 0x65, 0x05, 0x68, 0x37, 0xa7, 0x97, 0xd6, 0x69, 0x97, 0xdd, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_132_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_132_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x97, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa2, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_132 = {
	.name = "ecdsa_brainpoolp224r1_sha224_132",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_132_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_132_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_132_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u2, tcId is 133 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 133 for ECDSA, tcId is 134 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_133_pubkey[] = {
	0x3d, 0x4c, 0x4e, 0x3c, 0x5b, 0xa7, 0xa5, 0x33, 0xc8, 0xa3, 0x38, 0x6d, 0x6f, 0xf7, 0x7a, 0x81, 0x35, 0x13, 0x46, 0xe1, 0x89, 0x4b, 0x25, 0x60, 0xb4, 0x06, 0xa6, 0x3e, 0xa3, 0x49, 0x77, 0x59, 0x46, 0x79, 0x9e, 0xeb, 0x27, 0x49, 0x26, 0xb4, 0xd9, 0x57, 0x32, 0x8f, 0x6c, 0x7d, 0x50, 0xf6, 0x76, 0x02, 0x91, 0xac, 0xda, 0xeb, 0x11, 0x4f, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_133_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_133_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xab, 0xa8, 0xd8, 0x9c, 0x2c, 0x94, 0xba, 0x58, 0xe7, 0x0d, 0xb7, 0x86, 0xa6, 0x18, 0x1d, 0xc0, 0xe7, 0x1d, 0x16, 0xf3, 0xf4, 0x3d, 0x96, 0x00, 0xfc, 0x4c, 0x8f, 0xf3, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_133 = {
	.name = "ecdsa_brainpoolp224r1_sha224_133",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_133_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_133_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_133_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u2, tcId is 134 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 134 for ECDSA, tcId is 135 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_134_pubkey[] = {
	0x4d, 0xb8, 0xe8, 0xac, 0x43, 0xf2, 0x2d, 0xf7, 0x5c, 0x9c, 0x09, 0xfe, 0x19, 0x3b, 0x9c, 0xd8, 0x3d, 0x5c, 0x9b, 0x73, 0xf3, 0x7d, 0x14, 0x94, 0x76, 0x17, 0x24, 0xb0, 0xa7, 0x60, 0x82, 0xc3, 0x5d, 0xa8, 0x62, 0xa1, 0xe2, 0xe8, 0x62, 0x6f, 0xfa, 0x94, 0xed, 0x18, 0xfc, 0xb1, 0xd8, 0x97, 0xec, 0x7a, 0xb5, 0x2c, 0x32, 0x25, 0x53, 0xff, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_134_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_134_sig[] = {
	0x7a, 0xf2, 0x95, 0xe6, 0xe4, 0x78, 0x72, 0x52, 0xf3, 0x4c, 0x52, 0x7a, 0xf5, 0x62, 0xca, 0x27, 0x21, 0x4a, 0x66, 0xf6, 0xd6, 0xdb, 0x4f, 0xd2, 0xc1, 0x12, 0xb5, 0x64, 0xb1, 0xd0, 0x10, 0xf7, 0x40, 0x62, 0xee, 0xaa, 0xc0, 0xce, 0xcb, 0x2c, 0x3c, 0x2c, 0x4d, 0x28, 0x8a, 0x57, 0x6b, 0xf6, 0xf0, 0xa0, 0x03, 0x47, 0xc6, 0xa5, 0xb5, 0x62, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_134 = {
	.name = "ecdsa_brainpoolp224r1_sha224_134",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_134_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_134_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_134_sig,
	.siglen = 56,
	.result = 1,
	.comment = "point duplication during verification, tcId is 135 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 135 for ECDSA, tcId is 136 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_135_pubkey[] = {
	0x4d, 0xb8, 0xe8, 0xac, 0x43, 0xf2, 0x2d, 0xf7, 0x5c, 0x9c, 0x09, 0xfe, 0x19, 0x3b, 0x9c, 0xd8, 0x3d, 0x5c, 0x9b, 0x73, 0xf3, 0x7d, 0x14, 0x94, 0x76, 0x17, 0x24, 0xb0, 0x30, 0x60, 0xb1, 0xe6, 0xc8, 0x9b, 0x03, 0xe4, 0x47, 0x2f, 0xcd, 0xb5, 0x7b, 0x3c, 0xea, 0x6e, 0xb3, 0xed, 0x2e, 0xbf, 0xab, 0x5f, 0xd4, 0xc9, 0x4c, 0xa3, 0x6d, 0x00, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_135_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_135_sig[] = {
	0x7a, 0xf2, 0x95, 0xe6, 0xe4, 0x78, 0x72, 0x52, 0xf3, 0x4c, 0x52, 0x7a, 0xf5, 0x62, 0xca, 0x27, 0x21, 0x4a, 0x66, 0xf6, 0xd6, 0xdb, 0x4f, 0xd2, 0xc1, 0x12, 0xb5, 0x64, 0xb1, 0xd0, 0x10, 0xf7, 0x40, 0x62, 0xee, 0xaa, 0xc0, 0xce, 0xcb, 0x2c, 0x3c, 0x2c, 0x4d, 0x28, 0x8a, 0x57, 0x6b, 0xf6, 0xf0, 0xa0, 0x03, 0x47, 0xc6, 0xa5, 0xb5, 0x62, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_135 = {
	.name = "ecdsa_brainpoolp224r1_sha224_135",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_135_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_135_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_135_sig,
	.siglen = 56,
	.result = -1,
	.comment = "duplication bug, tcId is 136 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 136 for ECDSA, tcId is 137 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_136_pubkey[] = {
	0x2b, 0x92, 0x26, 0x82, 0x08, 0xd5, 0x22, 0x45, 0x0c, 0x42, 0xf3, 0xfc, 0xbd, 0xa4, 0x09, 0xc3, 0xac, 0xe2, 0xa5, 0xf8, 0x57, 0xea, 0x10, 0x61, 0x2c, 0x60, 0x93, 0xf8, 0x31, 0x5e, 0xb2, 0xd4, 0x48, 0x13, 0x4e, 0x71, 0x6b, 0x03, 0x20, 0x78, 0xb6, 0x83, 0x01, 0x62, 0x2e, 0x3c, 0x21, 0x86, 0xab, 0x58, 0x3d, 0x97, 0x6e, 0x76, 0x9f, 0xeb, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_136_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_136_sig[] = {
	0x47, 0xeb, 0x11, 0x8e, 0x0c, 0xc1, 0x22, 0x2c, 0xb8, 0xb2, 0xba, 0xb7, 0x27, 0x45, 0xa9, 0x32, 0xf0, 0x5c, 0xe9, 0x6e, 0x79, 0xf4, 0xe9, 0x8b, 0xe1, 0xe2, 0x86, 0x8a, 0x2b, 0x26, 0xa4, 0x22, 0x07, 0xa7, 0x14, 0x81, 0x3b, 0x9e, 0x70, 0x07, 0x7d, 0xf6, 0x98, 0xb8, 0x29, 0xd1, 0x58, 0xdb, 0xe2, 0xc6, 0x25, 0xba, 0x54, 0x54, 0xb7, 0x1f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_136 = {
	.name = "ecdsa_brainpoolp224r1_sha224_136",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_136_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_136_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_136_sig,
	.siglen = 56,
	.result = -1,
	.comment = "comparison with point at infinity , tcId is 137 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 137 for ECDSA, tcId is 138 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_137_pubkey[] = {
	0x4d, 0x4b, 0xd5, 0x69, 0x3d, 0x86, 0xdd, 0x9a, 0x60, 0x16, 0xba, 0x80, 0x6d, 0x80, 0x31, 0xf9, 0x4d, 0xc8, 0xe2, 0xd3, 0x3c, 0x6f, 0x58, 0x71, 0xa0, 0x0b, 0x64, 0x73, 0x2a, 0x46, 0x62, 0xf2, 0x95, 0x24, 0xec, 0xe7, 0x54, 0x82, 0x8b, 0x9d, 0x82, 0x9c, 0x0a, 0x07, 0x24, 0xd9, 0xbd, 0x9d, 0x28, 0x8d, 0x21, 0xf8, 0x7e, 0x3f, 0xb1, 0xfa, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_137_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_137_sig[] = {
	0x33, 0xb7, 0xe4, 0x98, 0xbc, 0xda, 0x1a, 0x33, 0xe6, 0x1a, 0x67, 0xaf, 0x56, 0xa3, 0x6d, 0x12, 0xdf, 0x70, 0x32, 0x25, 0x5d, 0xdf, 0x5e, 0x1e, 0xc6, 0x5a, 0x56, 0x69, 0x47, 0xeb, 0x11, 0x8e, 0x0c, 0xc1, 0x22, 0x2c, 0xb8, 0xb2, 0xba, 0xb7, 0x27, 0x45, 0xa9, 0x32, 0xf0, 0x5c, 0xe9, 0x6e, 0x79, 0xf4, 0xe9, 0x8b, 0xe1, 0xe2, 0x86, 0x8a, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_137 = {
	.name = "ecdsa_brainpoolp224r1_sha224_137",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_137_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_137_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_137_sig,
	.siglen = 56,
	.result = 1,
	.comment = "extreme value for k and edgecase s, tcId is 138 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 138 for ECDSA, tcId is 139 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_138_pubkey[] = {
	0xbe, 0x0e, 0xfb, 0x48, 0x41, 0xdf, 0x37, 0xab, 0xcd, 0xcf, 0x3f, 0x28, 0xdd, 0xb0, 0xd5, 0x75, 0x1a, 0x92, 0xa0, 0xfe, 0x7a, 0x3e, 0x88, 0xd1, 0xab, 0x02, 0x83, 0x2c, 0xbb, 0x53, 0xcc, 0xd6, 0x6b, 0x9c, 0x0e, 0x42, 0x43, 0x80, 0x69, 0x3d, 0x64, 0x16, 0xfc, 0x2e, 0x1a, 0x3c, 0x79, 0x3a, 0x35, 0x5f, 0x7d, 0x05, 0xf9, 0x63, 0xf4, 0x35, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_138_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_138_sig[] = {
	0x33, 0xb7, 0xe4, 0x98, 0xbc, 0xda, 0x1a, 0x33, 0xe6, 0x1a, 0x67, 0xaf, 0x56, 0xa3, 0x6d, 0x12, 0xdf, 0x70, 0x32, 0x25, 0x5d, 0xdf, 0x5e, 0x1e, 0xc6, 0x5a, 0x56, 0x69, 0xb8, 0xee, 0xbf, 0x6d, 0x45, 0x5e, 0x57, 0xe0, 0xb6, 0x5d, 0xe0, 0x20, 0x1b, 0xd7, 0xb3, 0x15, 0x45, 0x81, 0x33, 0xae, 0x5e, 0x2c, 0xa1, 0xb0, 0xd7, 0x21, 0xec, 0x3f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_138 = {
	.name = "ecdsa_brainpoolp224r1_sha224_138",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_138_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_138_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_138_sig,
	.siglen = 56,
	.result = 1,
	.comment = "extreme value for k and s^-1, tcId is 139 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 139 for ECDSA, tcId is 140 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_139_pubkey[] = {
	0xbc, 0x02, 0x72, 0xe3, 0x69, 0x3a, 0x05, 0xe7, 0x88, 0x39, 0x2c, 0x88, 0x0f, 0x9d, 0xe9, 0x5c, 0x72, 0xe2, 0x93, 0xfd, 0x1b, 0x13, 0xf1, 0xe2, 0x2a, 0x99, 0x07, 0xa3, 0x69, 0x95, 0x06, 0xe4, 0x59, 0x0f, 0xa9, 0x0c, 0x62, 0x57, 0xb1, 0xc4, 0xe3, 0x63, 0x2c, 0xcc, 0x48, 0x6c, 0xb8, 0x33, 0xcb, 0xbc, 0xbf, 0x21, 0xb4, 0xa2, 0x60, 0x41, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_139_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_139_sig[] = {
	0x33, 0xb7, 0xe4, 0x98, 0xbc, 0xda, 0x1a, 0x33, 0xe6, 0x1a, 0x67, 0xaf, 0x56, 0xa3, 0x6d, 0x12, 0xdf, 0x70, 0x32, 0x25, 0x5d, 0xdf, 0x5e, 0x1e, 0xc6, 0x5a, 0x56, 0x69, 0xac, 0x9a, 0x90, 0x88, 0x1e, 0x9c, 0x52, 0x04, 0xee, 0x79, 0xc0, 0x1d, 0xf7, 0xda, 0x62, 0xe0, 0xa7, 0x45, 0x63, 0x6f, 0x8b, 0x18, 0x96, 0xe9, 0x51, 0x52, 0xdc, 0x7f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_139 = {
	.name = "ecdsa_brainpoolp224r1_sha224_139",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_139_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_139_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_139_sig,
	.siglen = 56,
	.result = 1,
	.comment = "extreme value for k and s^-1, tcId is 140 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 140 for ECDSA, tcId is 141 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_140_pubkey[] = {
	0xa8, 0x3b, 0xc3, 0xe9, 0x04, 0x3c, 0xb9, 0x38, 0xda, 0xe1, 0x67, 0xbb, 0xea, 0x2f, 0x7d, 0x62, 0x34, 0x86, 0xf4, 0x03, 0x8d, 0xf4, 0x53, 0x12, 0xe8, 0x46, 0x7b, 0xda, 0x73, 0x63, 0xfa, 0x58, 0xaf, 0x36, 0x3a, 0x71, 0x83, 0x5d, 0xa0, 0x94, 0x13, 0xc8, 0x82, 0x27, 0x84, 0x9c, 0x6f, 0x0f, 0xfe, 0x8e, 0x4e, 0x40, 0xaf, 0xf5, 0x10, 0x23, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_140_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_140_sig[] = {
	0x33, 0xb7, 0xe4, 0x98, 0xbc, 0xda, 0x1a, 0x33, 0xe6, 0x1a, 0x67, 0xaf, 0x56, 0xa3, 0x6d, 0x12, 0xdf, 0x70, 0x32, 0x25, 0x5d, 0xdf, 0x5e, 0x1e, 0xc6, 0x5a, 0x56, 0x69, 0x2b, 0x26, 0xa4, 0x22, 0x07, 0xa7, 0x14, 0x81, 0x3b, 0x9e, 0x70, 0x07, 0x7d, 0xf6, 0x98, 0xb8, 0x29, 0xd1, 0x58, 0xdb, 0xe2, 0xc6, 0x25, 0xba, 0x54, 0x54, 0xb7, 0x20, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_140 = {
	.name = "ecdsa_brainpoolp224r1_sha224_140",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_140_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_140_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_140_sig,
	.siglen = 56,
	.result = 1,
	.comment = "extreme value for k and s^-1, tcId is 141 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 141 for ECDSA, tcId is 142 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_141_pubkey[] = {
	0x3b, 0xd0, 0x8a, 0x1c, 0x46, 0x63, 0x85, 0x64, 0x52, 0x1d, 0xed, 0x3f, 0xa7, 0x7c, 0xe9, 0xc9, 0x55, 0x38, 0xe4, 0x97, 0x03, 0xeb, 0xb9, 0xf8, 0xd3, 0x6b, 0xe6, 0xf7, 0x27, 0x6f, 0xfa, 0x12, 0x80, 0x51, 0x67, 0x1f, 0x7e, 0x4c, 0x63, 0xe9, 0xb8, 0x13, 0x2d, 0xe9, 0xf3, 0x38, 0x9c, 0xc5, 0x25, 0xd7, 0x26, 0x82, 0xb6, 0x01, 0x9e, 0xc3, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_141_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_141_sig[] = {
	0x33, 0xb7, 0xe4, 0x98, 0xbc, 0xda, 0x1a, 0x33, 0xe6, 0x1a, 0x67, 0xaf, 0x56, 0xa3, 0x6d, 0x12, 0xdf, 0x70, 0x32, 0x25, 0x5d, 0xdf, 0x5e, 0x1e, 0xc6, 0x5a, 0x56, 0x69, 0x1e, 0xd2, 0x75, 0x3c, 0xe0, 0xe5, 0x0e, 0xa5, 0x73, 0xba, 0x50, 0x05, 0x59, 0xf9, 0x48, 0x83, 0x8b, 0x95, 0x88, 0x9d, 0x0f, 0xb2, 0x1a, 0xf2, 0xce, 0x85, 0xa7, 0x60, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_141 = {
	.name = "ecdsa_brainpoolp224r1_sha224_141",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_141_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_141_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_141_sig,
	.siglen = 56,
	.result = 1,
	.comment = "extreme value for k and s^-1, tcId is 142 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 142 for ECDSA, tcId is 143 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_142_pubkey[] = {
	0xa3, 0xdb, 0x2b, 0x3e, 0x2c, 0x62, 0xc4, 0x2b, 0xf4, 0xfb, 0x0e, 0x11, 0xc2, 0x90, 0x8f, 0xd1, 0x7f, 0xe8, 0x3d, 0xa3, 0xac, 0x9c, 0x09, 0x80, 0x23, 0x4e, 0xfd, 0xbd, 0x3c, 0xbe, 0xec, 0x40, 0x27, 0xbd, 0x7c, 0x10, 0x9b, 0x27, 0xae, 0x2f, 0x7c, 0xf0, 0x4d, 0xc6, 0x5e, 0xea, 0xf1, 0x3f, 0xaa, 0x22, 0x4d, 0x32, 0xa2, 0x0f, 0x31, 0x63, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_142_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_142_sig[] = {
	0x33, 0xb7, 0xe4, 0x98, 0xbc, 0xda, 0x1a, 0x33, 0xe6, 0x1a, 0x67, 0xaf, 0x56, 0xa3, 0x6d, 0x12, 0xdf, 0x70, 0x32, 0x25, 0x5d, 0xdf, 0x5e, 0x1e, 0xc6, 0x5a, 0x56, 0x69, 0x58, 0xe3, 0x75, 0x18, 0xc6, 0xe4, 0x7a, 0x84, 0xde, 0x10, 0xcc, 0xb2, 0x54, 0xc0, 0x36, 0x93, 0x27, 0x11, 0x45, 0xf1, 0x3e, 0x00, 0xa9, 0x12, 0x37, 0xa4, 0xa5, 0x47, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_142 = {
	.name = "ecdsa_brainpoolp224r1_sha224_142",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_142_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_142_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_142_sig,
	.siglen = 56,
	.result = 1,
	.comment = "extreme value for k, tcId is 143 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 143 for ECDSA, tcId is 144 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_143_pubkey[] = {
	0x60, 0x6c, 0xe6, 0xf8, 0xc7, 0x7a, 0xc1, 0x7d, 0x5b, 0x75, 0x15, 0xd5, 0x85, 0x1e, 0xed, 0x15, 0x5e, 0xa1, 0x20, 0xcd, 0x07, 0xca, 0x42, 0x77, 0xb3, 0x5b, 0x8d, 0x36, 0x5f, 0x71, 0x6b, 0x62, 0xae, 0xe9, 0xa8, 0x1a, 0x01, 0x1b, 0xd1, 0xd2, 0xbc, 0xea, 0xf3, 0x7d, 0x5f, 0x3a, 0x61, 0xe5, 0xf7, 0x30, 0x7e, 0x0b, 0xb9, 0xc8, 0x92, 0xc8, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_143_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_143_sig[] = {
	0x0d, 0x90, 0x29, 0xad, 0x2c, 0x7e, 0x5c, 0xf4, 0x34, 0x08, 0x23, 0xb2, 0xa8, 0x7d, 0xc6, 0x8c, 0x9e, 0x4c, 0xe3, 0x17, 0x4c, 0x1e, 0x6e, 0xfd, 0xee, 0x12, 0xc0, 0x7d, 0x47, 0xeb, 0x11, 0x8e, 0x0c, 0xc1, 0x22, 0x2c, 0xb8, 0xb2, 0xba, 0xb7, 0x27, 0x45, 0xa9, 0x32, 0xf0, 0x5c, 0xe9, 0x6e, 0x79, 0xf4, 0xe9, 0x8b, 0xe1, 0xe2, 0x86, 0x8a, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_143 = {
	.name = "ecdsa_brainpoolp224r1_sha224_143",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_143_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_143_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_143_sig,
	.siglen = 56,
	.result = 1,
	.comment = "extreme value for k and edgecase s, tcId is 144 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 144 for ECDSA, tcId is 145 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_144_pubkey[] = {
	0x2a, 0xff, 0xbb, 0x82, 0x69, 0xcb, 0x78, 0x83, 0xda, 0xda, 0x33, 0x50, 0x39, 0x45, 0x79, 0x91, 0x2e, 0xf7, 0x56, 0xa8, 0xdf, 0x6b, 0xdd, 0x7d, 0xa3, 0x5d, 0x39, 0x8e, 0x90, 0x21, 0x3d, 0x93, 0x82, 0xb3, 0xd5, 0xfb, 0x9d, 0xde, 0x82, 0x72, 0x4d, 0x38, 0xe5, 0x67, 0x8c, 0x17, 0xe6, 0x10, 0xf4, 0x17, 0xcf, 0xe6, 0xf7, 0xef, 0xcd, 0x91, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_144_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_144_sig[] = {
	0x0d, 0x90, 0x29, 0xad, 0x2c, 0x7e, 0x5c, 0xf4, 0x34, 0x08, 0x23, 0xb2, 0xa8, 0x7d, 0xc6, 0x8c, 0x9e, 0x4c, 0xe3, 0x17, 0x4c, 0x1e, 0x6e, 0xfd, 0xee, 0x12, 0xc0, 0x7d, 0xb8, 0xee, 0xbf, 0x6d, 0x45, 0x5e, 0x57, 0xe0, 0xb6, 0x5d, 0xe0, 0x20, 0x1b, 0xd7, 0xb3, 0x15, 0x45, 0x81, 0x33, 0xae, 0x5e, 0x2c, 0xa1, 0xb0, 0xd7, 0x21, 0xec, 0x3f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_144 = {
	.name = "ecdsa_brainpoolp224r1_sha224_144",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_144_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_144_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_144_sig,
	.siglen = 56,
	.result = 1,
	.comment = "extreme value for k and s^-1, tcId is 145 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 145 for ECDSA, tcId is 146 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_145_pubkey[] = {
	0x19, 0xcd, 0xd4, 0x4e, 0x2a, 0x33, 0x11, 0x3a, 0x88, 0x45, 0x58, 0xe7, 0xee, 0x0e, 0xfb, 0x41, 0xba, 0xfe, 0x1a, 0xdc, 0xdc, 0xf9, 0x5d, 0xf6, 0xde, 0x6a, 0x25, 0x11, 0x5f, 0x42, 0x8e, 0xe9, 0x98, 0xa3, 0x48, 0x56, 0xf2, 0xac, 0x3f, 0x6f, 0x39, 0xc7, 0x23, 0x7b, 0xf1, 0xf9, 0xde, 0x23, 0x21, 0x75, 0xd7, 0x47, 0xb5, 0xcd, 0x97, 0xfe, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_145_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_145_sig[] = {
	0x0d, 0x90, 0x29, 0xad, 0x2c, 0x7e, 0x5c, 0xf4, 0x34, 0x08, 0x23, 0xb2, 0xa8, 0x7d, 0xc6, 0x8c, 0x9e, 0x4c, 0xe3, 0x17, 0x4c, 0x1e, 0x6e, 0xfd, 0xee, 0x12, 0xc0, 0x7d, 0xac, 0x9a, 0x90, 0x88, 0x1e, 0x9c, 0x52, 0x04, 0xee, 0x79, 0xc0, 0x1d, 0xf7, 0xda, 0x62, 0xe0, 0xa7, 0x45, 0x63, 0x6f, 0x8b, 0x18, 0x96, 0xe9, 0x51, 0x52, 0xdc, 0x7f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_145 = {
	.name = "ecdsa_brainpoolp224r1_sha224_145",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_145_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_145_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_145_sig,
	.siglen = 56,
	.result = 1,
	.comment = "extreme value for k and s^-1, tcId is 146 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 146 for ECDSA, tcId is 147 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_146_pubkey[] = {
	0xb7, 0x2f, 0x7c, 0x1a, 0x3c, 0x85, 0x62, 0xcb, 0x8d, 0xe9, 0x92, 0x5e, 0xec, 0x04, 0x1c, 0xcc, 0x26, 0x36, 0x49, 0xc6, 0x52, 0x47, 0x62, 0xb9, 0xf4, 0x58, 0x5e, 0xe3, 0x9d, 0xf7, 0x56, 0xda, 0x08, 0xd1, 0x27, 0x4a, 0xd7, 0x2d, 0x8c, 0xac, 0x29, 0x3a, 0xa6, 0x0d, 0x15, 0x0c, 0x77, 0x13, 0x1f, 0x9f, 0xa2, 0x8c, 0xcd, 0xff, 0xdf, 0xa0, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_146_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_146_sig[] = {
	0x0d, 0x90, 0x29, 0xad, 0x2c, 0x7e, 0x5c, 0xf4, 0x34, 0x08, 0x23, 0xb2, 0xa8, 0x7d, 0xc6, 0x8c, 0x9e, 0x4c, 0xe3, 0x17, 0x4c, 0x1e, 0x6e, 0xfd, 0xee, 0x12, 0xc0, 0x7d, 0x2b, 0x26, 0xa4, 0x22, 0x07, 0xa7, 0x14, 0x81, 0x3b, 0x9e, 0x70, 0x07, 0x7d, 0xf6, 0x98, 0xb8, 0x29, 0xd1, 0x58, 0xdb, 0xe2, 0xc6, 0x25, 0xba, 0x54, 0x54, 0xb7, 0x20, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_146 = {
	.name = "ecdsa_brainpoolp224r1_sha224_146",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_146_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_146_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_146_sig,
	.siglen = 56,
	.result = 1,
	.comment = "extreme value for k and s^-1, tcId is 147 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 147 for ECDSA, tcId is 148 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_147_pubkey[] = {
	0x9d, 0x37, 0x03, 0xb3, 0x20, 0x5b, 0x12, 0x3c, 0x90, 0x3a, 0x04, 0x46, 0x97, 0x32, 0x47, 0xc1, 0x6a, 0x88, 0xd1, 0x03, 0xfe, 0xa9, 0xd0, 0x4d, 0xd0, 0x2a, 0x70, 0x2b, 0x65, 0x18, 0x6b, 0x77, 0x7b, 0x57, 0xea, 0xde, 0xe8, 0x15, 0x4c, 0x02, 0xfc, 0xe0, 0xe9, 0x5c, 0x3f, 0x06, 0x14, 0x68, 0x49, 0x9b, 0xac, 0x3d, 0xc6, 0x02, 0x9e, 0x8c, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_147_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_147_sig[] = {
	0x0d, 0x90, 0x29, 0xad, 0x2c, 0x7e, 0x5c, 0xf4, 0x34, 0x08, 0x23, 0xb2, 0xa8, 0x7d, 0xc6, 0x8c, 0x9e, 0x4c, 0xe3, 0x17, 0x4c, 0x1e, 0x6e, 0xfd, 0xee, 0x12, 0xc0, 0x7d, 0x1e, 0xd2, 0x75, 0x3c, 0xe0, 0xe5, 0x0e, 0xa5, 0x73, 0xba, 0x50, 0x05, 0x59, 0xf9, 0x48, 0x83, 0x8b, 0x95, 0x88, 0x9d, 0x0f, 0xb2, 0x1a, 0xf2, 0xce, 0x85, 0xa7, 0x60, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_147 = {
	.name = "ecdsa_brainpoolp224r1_sha224_147",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_147_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_147_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_147_sig,
	.siglen = 56,
	.result = 1,
	.comment = "extreme value for k and s^-1, tcId is 148 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 148 for ECDSA, tcId is 149 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_148_pubkey[] = {
	0x3e, 0xa5, 0x72, 0x50, 0x5a, 0x48, 0xb1, 0xbe, 0xd0, 0x85, 0x95, 0x3d, 0xa7, 0xd4, 0xc9, 0x63, 0xc2, 0xc5, 0xb6, 0xad, 0x99, 0x77, 0x9d, 0x9d, 0x54, 0xba, 0x40, 0x12, 0x94, 0x47, 0x00, 0x74, 0xe0, 0x25, 0x2d, 0xa1, 0x59, 0xa0, 0xc0, 0xd0, 0xb2, 0xf8, 0xd4, 0xc2, 0x42, 0xcb, 0x94, 0xba, 0xb2, 0xc2, 0x02, 0x0c, 0x4b, 0x2d, 0xf4, 0x99, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_148_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_148_sig[] = {
	0x0d, 0x90, 0x29, 0xad, 0x2c, 0x7e, 0x5c, 0xf4, 0x34, 0x08, 0x23, 0xb2, 0xa8, 0x7d, 0xc6, 0x8c, 0x9e, 0x4c, 0xe3, 0x17, 0x4c, 0x1e, 0x6e, 0xfd, 0xee, 0x12, 0xc0, 0x7d, 0x58, 0xe3, 0x75, 0x18, 0xc6, 0xe4, 0x7a, 0x84, 0xde, 0x10, 0xcc, 0xb2, 0x54, 0xc0, 0x36, 0x93, 0x27, 0x11, 0x45, 0xf1, 0x3e, 0x00, 0xa9, 0x12, 0x37, 0xa4, 0xa5, 0x47, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_148 = {
	.name = "ecdsa_brainpoolp224r1_sha224_148",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_148_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_148_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_148_sig,
	.siglen = 56,
	.result = 1,
	.comment = "extreme value for k, tcId is 149 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 149 for ECDSA, tcId is 150 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_149_pubkey[] = {
	0x0d, 0x90, 0x29, 0xad, 0x2c, 0x7e, 0x5c, 0xf4, 0x34, 0x08, 0x23, 0xb2, 0xa8, 0x7d, 0xc6, 0x8c, 0x9e, 0x4c, 0xe3, 0x17, 0x4c, 0x1e, 0x6e, 0xfd, 0xee, 0x12, 0xc0, 0x7d, 0x58, 0xaa, 0x56, 0xf7, 0x72, 0xc0, 0x72, 0x6f, 0x24, 0xc6, 0xb8, 0x9e, 0x4e, 0xcd, 0xac, 0x24, 0x35, 0x4b, 0x9e, 0x99, 0xca, 0xa3, 0xf6, 0xd3, 0x76, 0x14, 0x02, 0xcd, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_149_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_149_sig[] = {
	0x75, 0x3b, 0xb4, 0x00, 0x78, 0x93, 0x40, 0x81, 0xd7, 0xbd, 0x11, 0x3e, 0xc4, 0x9b, 0x19, 0xef, 0x09, 0xd1, 0xba, 0x33, 0x49, 0x86, 0x90, 0x51, 0x6d, 0x4d, 0x12, 0x2c, 0x1e, 0xd2, 0x75, 0x3c, 0xe0, 0xe5, 0x0e, 0xa5, 0x73, 0xba, 0x50, 0x05, 0x59, 0xf9, 0x48, 0x83, 0x8b, 0x95, 0x88, 0x9d, 0x0f, 0xb2, 0x1a, 0xf2, 0xce, 0x85, 0xa7, 0x5f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_149 = {
	.name = "ecdsa_brainpoolp224r1_sha224_149",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_149_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_149_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_149_sig,
	.siglen = 56,
	.result = -1,
	.comment = "testing point duplication, tcId is 150 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 150 for ECDSA, tcId is 151 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_150_pubkey[] = {
	0x0d, 0x90, 0x29, 0xad, 0x2c, 0x7e, 0x5c, 0xf4, 0x34, 0x08, 0x23, 0xb2, 0xa8, 0x7d, 0xc6, 0x8c, 0x9e, 0x4c, 0xe3, 0x17, 0x4c, 0x1e, 0x6e, 0xfd, 0xee, 0x12, 0xc0, 0x7d, 0x58, 0xaa, 0x56, 0xf7, 0x72, 0xc0, 0x72, 0x6f, 0x24, 0xc6, 0xb8, 0x9e, 0x4e, 0xcd, 0xac, 0x24, 0x35, 0x4b, 0x9e, 0x99, 0xca, 0xa3, 0xf6, 0xd3, 0x76, 0x14, 0x02, 0xcd, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_150_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_150_sig[] = {
	0x62, 0x85, 0x80, 0xa9, 0xad, 0xb0, 0x26, 0x04, 0x52, 0x5b, 0x1e, 0xe6, 0xb1, 0x35, 0xe1, 0xa9, 0xc7, 0x45, 0x02, 0x18, 0x24, 0x58, 0x2c, 0x52, 0x38, 0x5a, 0x81, 0x73, 0x1e, 0xd2, 0x75, 0x3c, 0xe0, 0xe5, 0x0e, 0xa5, 0x73, 0xba, 0x50, 0x05, 0x59, 0xf9, 0x48, 0x83, 0x8b, 0x95, 0x88, 0x9d, 0x0f, 0xb2, 0x1a, 0xf2, 0xce, 0x85, 0xa7, 0x5f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_150 = {
	.name = "ecdsa_brainpoolp224r1_sha224_150",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_150_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_150_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_150_sig,
	.siglen = 56,
	.result = -1,
	.comment = "testing point duplication, tcId is 151 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 151 for ECDSA, tcId is 152 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_151_pubkey[] = {
	0x0d, 0x90, 0x29, 0xad, 0x2c, 0x7e, 0x5c, 0xf4, 0x34, 0x08, 0x23, 0xb2, 0xa8, 0x7d, 0xc6, 0x8c, 0x9e, 0x4c, 0xe3, 0x17, 0x4c, 0x1e, 0x6e, 0xfd, 0xee, 0x12, 0xc0, 0x7d, 0x7f, 0x16, 0xdd, 0xb2, 0xb3, 0x82, 0xf4, 0x17, 0x05, 0x51, 0x77, 0x87, 0x27, 0x04, 0x2b, 0x63, 0x7b, 0x53, 0x68, 0xbd, 0xcd, 0x36, 0x93, 0x22, 0x08, 0xb4, 0xbe, 0x32, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_151_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_151_sig[] = {
	0x75, 0x3b, 0xb4, 0x00, 0x78, 0x93, 0x40, 0x81, 0xd7, 0xbd, 0x11, 0x3e, 0xc4, 0x9b, 0x19, 0xef, 0x09, 0xd1, 0xba, 0x33, 0x49, 0x86, 0x90, 0x51, 0x6d, 0x4d, 0x12, 0x2c, 0x1e, 0xd2, 0x75, 0x3c, 0xe0, 0xe5, 0x0e, 0xa5, 0x73, 0xba, 0x50, 0x05, 0x59, 0xf9, 0x48, 0x83, 0x8b, 0x95, 0x88, 0x9d, 0x0f, 0xb2, 0x1a, 0xf2, 0xce, 0x85, 0xa7, 0x5f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_151 = {
	.name = "ecdsa_brainpoolp224r1_sha224_151",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_151_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_151_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_151_sig,
	.siglen = 56,
	.result = -1,
	.comment = "testing point duplication, tcId is 152 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 152 for ECDSA, tcId is 153 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_152_pubkey[] = {
	0x0d, 0x90, 0x29, 0xad, 0x2c, 0x7e, 0x5c, 0xf4, 0x34, 0x08, 0x23, 0xb2, 0xa8, 0x7d, 0xc6, 0x8c, 0x9e, 0x4c, 0xe3, 0x17, 0x4c, 0x1e, 0x6e, 0xfd, 0xee, 0x12, 0xc0, 0x7d, 0x7f, 0x16, 0xdd, 0xb2, 0xb3, 0x82, 0xf4, 0x17, 0x05, 0x51, 0x77, 0x87, 0x27, 0x04, 0x2b, 0x63, 0x7b, 0x53, 0x68, 0xbd, 0xcd, 0x36, 0x93, 0x22, 0x08, 0xb4, 0xbe, 0x32, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_152_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_152_sig[] = {
	0x62, 0x85, 0x80, 0xa9, 0xad, 0xb0, 0x26, 0x04, 0x52, 0x5b, 0x1e, 0xe6, 0xb1, 0x35, 0xe1, 0xa9, 0xc7, 0x45, 0x02, 0x18, 0x24, 0x58, 0x2c, 0x52, 0x38, 0x5a, 0x81, 0x73, 0x1e, 0xd2, 0x75, 0x3c, 0xe0, 0xe5, 0x0e, 0xa5, 0x73, 0xba, 0x50, 0x05, 0x59, 0xf9, 0x48, 0x83, 0x8b, 0x95, 0x88, 0x9d, 0x0f, 0xb2, 0x1a, 0xf2, 0xce, 0x85, 0xa7, 0x5f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_152 = {
	.name = "ecdsa_brainpoolp224r1_sha224_152",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_152_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_152_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_152_sig,
	.siglen = 56,
	.result = -1,
	.comment = "testing point duplication, tcId is 153 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 153 for ECDSA, tcId is 154 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_153_pubkey[] = {
	0xb5, 0x54, 0xfc, 0x25, 0xe9, 0xf0, 0x98, 0xea, 0xf1, 0x46, 0x6c, 0x35, 0x32, 0x8c, 0x97, 0x30, 0x5d, 0x0d, 0x4a, 0xa0, 0xe4, 0x46, 0x2e, 0x8b, 0xaf, 0x7a, 0x8e, 0x7e, 0xd0, 0x8f, 0xc4, 0x0e, 0xb0, 0x1d, 0xc8, 0x55, 0x57, 0x7b, 0xae, 0xa9, 0xe3, 0x07, 0x07, 0x70, 0x61, 0x6f, 0x57, 0xb1, 0x7e, 0xa9, 0x85, 0x4c, 0xad, 0x93, 0x88, 0x1a, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_153_sig[] = {
	0xb9, 0x82, 0xbe, 0xa8, 0x0d, 0x10, 0x81, 0x6b, 0xb4, 0x50, 0xa3, 0xfa, 0xaa, 0xed, 0x4e, 0xd5, 0x4f, 0xb1, 0x97, 0xb3, 0xbf, 0xf9, 0x5a, 0xf2, 0x5d, 0x7d, 0x37, 0x86, 0x9e, 0x6e, 0xa2, 0xe5, 0x87, 0x13, 0xf1, 0x30, 0x4d, 0x29, 0xde, 0xbf, 0x85, 0x59, 0xa7, 0x4a, 0x89, 0xe0, 0x18, 0xba, 0xe2, 0x8b, 0x05, 0x55, 0x6e, 0x54, 0x82, 0xa1, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_153 = {
	.name = "ecdsa_brainpoolp224r1_sha224_153",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_153_pubkey,
	.pubkeylen = 56,
	.msg = (const unsigned char*)"",
	.msglen = 0,
	.sig = ecdsa_brainpoolp224r1_sha224_153_sig,
	.siglen = 56,
	.result = 1,
	.comment = "pseudorandom signature, tcId is 154 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 154 for ECDSA, tcId is 155 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_154_pubkey[] = {
	0xb5, 0x54, 0xfc, 0x25, 0xe9, 0xf0, 0x98, 0xea, 0xf1, 0x46, 0x6c, 0x35, 0x32, 0x8c, 0x97, 0x30, 0x5d, 0x0d, 0x4a, 0xa0, 0xe4, 0x46, 0x2e, 0x8b, 0xaf, 0x7a, 0x8e, 0x7e, 0xd0, 0x8f, 0xc4, 0x0e, 0xb0, 0x1d, 0xc8, 0x55, 0x57, 0x7b, 0xae, 0xa9, 0xe3, 0x07, 0x07, 0x70, 0x61, 0x6f, 0x57, 0xb1, 0x7e, 0xa9, 0x85, 0x4c, 0xad, 0x93, 0x88, 0x1a, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_154_msg[] = {
	0x4d, 0x73, 0x67, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_154_sig[] = {
	0x4d, 0xab, 0xc5, 0xfe, 0x96, 0x2b, 0x5f, 0x8a, 0x66, 0x81, 0xe9, 0x4a, 0x21, 0x65, 0xd9, 0xb6, 0xbe, 0x19, 0x40, 0xf2, 0x0e, 0x27, 0xce, 0xb7, 0x3f, 0xc4, 0xea, 0x7d, 0x74, 0x6e, 0x9b, 0xba, 0x7e, 0xfb, 0x90, 0xfc, 0xec, 0xc2, 0x63, 0xc2, 0x29, 0xa1, 0x6d, 0x80, 0x9d, 0x35, 0x47, 0xc2, 0x8a, 0x26, 0xcd, 0x71, 0xa5, 0x2a, 0xbd, 0xc5, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_154 = {
	.name = "ecdsa_brainpoolp224r1_sha224_154",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_154_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_154_msg,
	.msglen = 3,
	.sig = ecdsa_brainpoolp224r1_sha224_154_sig,
	.siglen = 56,
	.result = 1,
	.comment = "pseudorandom signature, tcId is 155 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 155 for ECDSA, tcId is 156 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_155_pubkey[] = {
	0xb5, 0x54, 0xfc, 0x25, 0xe9, 0xf0, 0x98, 0xea, 0xf1, 0x46, 0x6c, 0x35, 0x32, 0x8c, 0x97, 0x30, 0x5d, 0x0d, 0x4a, 0xa0, 0xe4, 0x46, 0x2e, 0x8b, 0xaf, 0x7a, 0x8e, 0x7e, 0xd0, 0x8f, 0xc4, 0x0e, 0xb0, 0x1d, 0xc8, 0x55, 0x57, 0x7b, 0xae, 0xa9, 0xe3, 0x07, 0x07, 0x70, 0x61, 0x6f, 0x57, 0xb1, 0x7e, 0xa9, 0x85, 0x4c, 0xad, 0x93, 0x88, 0x1a, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_155_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_155_sig[] = {
	0x95, 0xb1, 0x1e, 0x32, 0x00, 0x07, 0xa2, 0xe0, 0xf8, 0xce, 0x00, 0xf9, 0x05, 0x8c, 0xa9, 0xb9, 0x19, 0xe8, 0xd6, 0xaa, 0xd5, 0x44, 0xa8, 0xf9, 0x80, 0x8b, 0x44, 0xa1, 0x15, 0xa9, 0x62, 0x01, 0x9c, 0x85, 0xa5, 0xb1, 0xfa, 0x74, 0x74, 0x16, 0x2d, 0x03, 0xcd, 0x0e, 0x52, 0x8e, 0x8b, 0x93, 0xbc, 0xc8, 0x49, 0x20, 0xaf, 0x57, 0x9f, 0x61, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_155 = {
	.name = "ecdsa_brainpoolp224r1_sha224_155",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_155_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_155_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_155_sig,
	.siglen = 56,
	.result = 1,
	.comment = "pseudorandom signature, tcId is 156 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 156 for ECDSA, tcId is 157 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_156_pubkey[] = {
	0xb5, 0x54, 0xfc, 0x25, 0xe9, 0xf0, 0x98, 0xea, 0xf1, 0x46, 0x6c, 0x35, 0x32, 0x8c, 0x97, 0x30, 0x5d, 0x0d, 0x4a, 0xa0, 0xe4, 0x46, 0x2e, 0x8b, 0xaf, 0x7a, 0x8e, 0x7e, 0xd0, 0x8f, 0xc4, 0x0e, 0xb0, 0x1d, 0xc8, 0x55, 0x57, 0x7b, 0xae, 0xa9, 0xe3, 0x07, 0x07, 0x70, 0x61, 0x6f, 0x57, 0xb1, 0x7e, 0xa9, 0x85, 0x4c, 0xad, 0x93, 0x88, 0x1a, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_156_msg[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_156_sig[] = {
	0x9e, 0x4d, 0xab, 0x9e, 0x0b, 0x00, 0x97, 0xe3, 0x65, 0x78, 0x3f, 0xc0, 0x5f, 0x01, 0x0c, 0x16, 0x0d, 0x36, 0x1d, 0xf7, 0x92, 0x5b, 0x0d, 0xdb, 0xdf, 0xec, 0xe8, 0x8b, 0x84, 0x06, 0xa3, 0x65, 0xf0, 0x78, 0xf0, 0x31, 0xe6, 0xfa, 0xd6, 0x51, 0x1d, 0x69, 0xf8, 0xa6, 0x54, 0x83, 0xc1, 0x9a, 0x5a, 0x80, 0x0c, 0x39, 0x49, 0x0f, 0x75, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_156 = {
	.name = "ecdsa_brainpoolp224r1_sha224_156",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_156_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_156_msg,
	.msglen = 20,
	.sig = ecdsa_brainpoolp224r1_sha224_156_sig,
	.siglen = 56,
	.result = 1,
	.comment = "pseudorandom signature, tcId is 157 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 157 for ECDSA, tcId is 158 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_157_pubkey[] = {
	0x80, 0x2a, 0x0f, 0x51, 0x20, 0x4e, 0xf6, 0xa8, 0x29, 0x21, 0x1b, 0xc0, 0x74, 0x08, 0x87, 0x46, 0x1e, 0xe4, 0xab, 0xa7, 0x36, 0xe9, 0xca, 0xee, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xb9, 0x31, 0xe0, 0x63, 0x00, 0x45, 0x13, 0x62, 0xd4, 0x44, 0x10, 0x6e, 0xeb, 0x5d, 0xab, 0xdd, 0xca, 0x65, 0x0f, 0xec, 0x4b, 0xe5, 0x5f, 0xc5, 0x45, 0xf7, 0xc8, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_157_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_157_sig[] = {
	0x0c, 0x93, 0xfd, 0x7f, 0x6d, 0xd0, 0xb6, 0x97, 0xd5, 0xc2, 0x87, 0xee, 0x61, 0xae, 0xe4, 0xdc, 0xbe, 0xdc, 0xc2, 0x08, 0x85, 0xc1, 0xe6, 0x21, 0x5b, 0x8b, 0x36, 0x08, 0x3b, 0xc7, 0xa1, 0xbe, 0xcc, 0xf1, 0xa8, 0xe8, 0x3a, 0xf2, 0xf5, 0x16, 0x2f, 0xc5, 0x39, 0xa1, 0xd0, 0x62, 0xbd, 0x63, 0x9a, 0x2f, 0xbe, 0xc5, 0x12, 0x90, 0x7a, 0x27, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_157 = {
	.name = "ecdsa_brainpoolp224r1_sha224_157",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_157_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_157_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_157_sig,
	.siglen = 56,
	.result = 1,
	.comment = "x-coordinate of the public key has many trailing 0's, tcId is 158 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 158 for ECDSA, tcId is 159 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_158_pubkey[] = {
	0x80, 0x2a, 0x0f, 0x51, 0x20, 0x4e, 0xf6, 0xa8, 0x29, 0x21, 0x1b, 0xc0, 0x74, 0x08, 0x87, 0x46, 0x1e, 0xe4, 0xab, 0xa7, 0x36, 0xe9, 0xca, 0xee, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xb9, 0x31, 0xe0, 0x63, 0x00, 0x45, 0x13, 0x62, 0xd4, 0x44, 0x10, 0x6e, 0xeb, 0x5d, 0xab, 0xdd, 0xca, 0x65, 0x0f, 0xec, 0x4b, 0xe5, 0x5f, 0xc5, 0x45, 0xf7, 0xc8, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_158_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_158_sig[] = {
	0x9e, 0x0b, 0x62, 0x0a, 0x2f, 0x31, 0x3a, 0xda, 0x75, 0x64, 0x63, 0xa2, 0x29, 0x88, 0xaf, 0xb6, 0x57, 0x1b, 0x3b, 0x03, 0x0a, 0x42, 0x85, 0xb1, 0x85, 0xe1, 0xcc, 0x80, 0xc3, 0xeb, 0xa0, 0x4c, 0x42, 0xe6, 0x4d, 0x40, 0x28, 0xac, 0xab, 0xcd, 0xcb, 0x7b, 0x2e, 0xed, 0x1b, 0x3c, 0xfb, 0x56, 0x0b, 0x8d, 0x7d, 0x14, 0xfb, 0x26, 0xac, 0xa3, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_158 = {
	.name = "ecdsa_brainpoolp224r1_sha224_158",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_158_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_158_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_158_sig,
	.siglen = 56,
	.result = 1,
	.comment = "x-coordinate of the public key has many trailing 0's, tcId is 159 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 159 for ECDSA, tcId is 160 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_159_pubkey[] = {
	0x80, 0x2a, 0x0f, 0x51, 0x20, 0x4e, 0xf6, 0xa8, 0x29, 0x21, 0x1b, 0xc0, 0x74, 0x08, 0x87, 0x46, 0x1e, 0xe4, 0xab, 0xa7, 0x36, 0xe9, 0xca, 0xee, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xb9, 0x31, 0xe0, 0x63, 0x00, 0x45, 0x13, 0x62, 0xd4, 0x44, 0x10, 0x6e, 0xeb, 0x5d, 0xab, 0xdd, 0xca, 0x65, 0x0f, 0xec, 0x4b, 0xe5, 0x5f, 0xc5, 0x45, 0xf7, 0xc8, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_159_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_159_sig[] = {
	0xa3, 0x06, 0xf5, 0x00, 0xda, 0x4f, 0x0a, 0x30, 0x94, 0x64, 0x79, 0x93, 0x6a, 0xaf, 0x9c, 0x63, 0x76, 0x76, 0xb0, 0xf0, 0x2d, 0x20, 0xae, 0x0d, 0x98, 0x1c, 0x25, 0xeb, 0x01, 0x56, 0x47, 0xf2, 0x50, 0x0b, 0xcb, 0xe3, 0x20, 0x4b, 0xdb, 0x80, 0x49, 0x72, 0xb8, 0x41, 0x89, 0x0b, 0x4e, 0x53, 0x19, 0x6c, 0xd8, 0xb1, 0x88, 0x99, 0x31, 0x51, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_159 = {
	.name = "ecdsa_brainpoolp224r1_sha224_159",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_159_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_159_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_159_sig,
	.siglen = 56,
	.result = 1,
	.comment = "x-coordinate of the public key has many trailing 0's, tcId is 160 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 160 for ECDSA, tcId is 161 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_160_pubkey[] = {
	0xcb, 0x32, 0x0c, 0x84, 0xf2, 0x6c, 0x00, 0xa1, 0xb4, 0xad, 0x71, 0x46, 0x91, 0x4c, 0xae, 0x12, 0x65, 0x29, 0x16, 0x5d, 0xe7, 0x36, 0x3d, 0x8a, 0xef, 0x9a, 0xbd, 0x05, 0xa3, 0x97, 0xd4, 0x6b, 0x87, 0x28, 0x31, 0x76, 0xb7, 0xf6, 0x9d, 0xa1, 0xf9, 0x46, 0x15, 0xca, 0x44, 0x31, 0xfc, 0x47, 0xb2, 0xa0, 0xe6, 0x0c, 0x00, 0x00, 0x00, 0x00, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_160_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_160_sig[] = {
	0x04, 0xf0, 0x0d, 0xd4, 0x4f, 0xdd, 0x8a, 0xe6, 0xb0, 0x8b, 0x86, 0xcc, 0xbd, 0xd7, 0xd6, 0x15, 0xaa, 0x9e, 0x49, 0x8a, 0x89, 0xb3, 0x50, 0x94, 0xc8, 0xa9, 0xa6, 0xfe, 0x49, 0x61, 0x7a, 0x16, 0x17, 0xc5, 0x6c, 0xe9, 0x0d, 0x41, 0xc5, 0x3e, 0xef, 0x4e, 0x62, 0x8f, 0x24, 0xc0, 0x47, 0xa0, 0x6e, 0x02, 0xc1, 0xf9, 0x21, 0x23, 0x44, 0x1f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_160 = {
	.name = "ecdsa_brainpoolp224r1_sha224_160",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_160_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_160_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_160_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key has many trailing 0's, tcId is 161 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 161 for ECDSA, tcId is 162 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_161_pubkey[] = {
	0xcb, 0x32, 0x0c, 0x84, 0xf2, 0x6c, 0x00, 0xa1, 0xb4, 0xad, 0x71, 0x46, 0x91, 0x4c, 0xae, 0x12, 0x65, 0x29, 0x16, 0x5d, 0xe7, 0x36, 0x3d, 0x8a, 0xef, 0x9a, 0xbd, 0x05, 0xa3, 0x97, 0xd4, 0x6b, 0x87, 0x28, 0x31, 0x76, 0xb7, 0xf6, 0x9d, 0xa1, 0xf9, 0x46, 0x15, 0xca, 0x44, 0x31, 0xfc, 0x47, 0xb2, 0xa0, 0xe6, 0x0c, 0x00, 0x00, 0x00, 0x00, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_161_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_161_sig[] = {
	0x12, 0x86, 0xf6, 0xa7, 0x37, 0x5b, 0xf6, 0x80, 0x51, 0xe3, 0x1b, 0x2e, 0x32, 0xb5, 0xf6, 0xc0, 0x98, 0x8c, 0x91, 0x89, 0x79, 0x92, 0x56, 0xe7, 0xce, 0x64, 0xe2, 0x91, 0x52, 0xd3, 0xc1, 0xf9, 0xe7, 0x77, 0xf2, 0x3c, 0x17, 0xcb, 0xc8, 0x32, 0xd0, 0xe5, 0xa8, 0x4b, 0xb6, 0x8b, 0x13, 0xde, 0xbf, 0x39, 0x38, 0x78, 0xd1, 0xa0, 0x64, 0x98, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_161 = {
	.name = "ecdsa_brainpoolp224r1_sha224_161",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_161_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_161_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_161_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key has many trailing 0's, tcId is 162 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 162 for ECDSA, tcId is 163 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_162_pubkey[] = {
	0xcb, 0x32, 0x0c, 0x84, 0xf2, 0x6c, 0x00, 0xa1, 0xb4, 0xad, 0x71, 0x46, 0x91, 0x4c, 0xae, 0x12, 0x65, 0x29, 0x16, 0x5d, 0xe7, 0x36, 0x3d, 0x8a, 0xef, 0x9a, 0xbd, 0x05, 0xa3, 0x97, 0xd4, 0x6b, 0x87, 0x28, 0x31, 0x76, 0xb7, 0xf6, 0x9d, 0xa1, 0xf9, 0x46, 0x15, 0xca, 0x44, 0x31, 0xfc, 0x47, 0xb2, 0xa0, 0xe6, 0x0c, 0x00, 0x00, 0x00, 0x00, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_162_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_162_sig[] = {
	0x58, 0x28, 0x25, 0xdf, 0x23, 0x68, 0xdc, 0xb9, 0x2f, 0xbb, 0xa3, 0xfa, 0x64, 0x54, 0xd1, 0x49, 0xd3, 0xb8, 0x60, 0xe3, 0xff, 0x32, 0x6a, 0xfe, 0x36, 0x21, 0x58, 0x13, 0x49, 0x33, 0x4f, 0xc6, 0xa7, 0x04, 0x18, 0xdb, 0xc4, 0x54, 0xda, 0x6a, 0x99, 0x7b, 0xc8, 0x37, 0x62, 0x70, 0xc3, 0xa3, 0x88, 0x63, 0xad, 0xb2, 0xaa, 0x70, 0xbb, 0x0f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_162 = {
	.name = "ecdsa_brainpoolp224r1_sha224_162",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_162_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_162_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_162_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key has many trailing 0's, tcId is 163 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 163 for ECDSA, tcId is 164 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_163_pubkey[] = {
	0x00, 0x00, 0x00, 0x00, 0x81, 0xdf, 0x97, 0x17, 0x44, 0xa2, 0x5a, 0xc9, 0x94, 0x72, 0xc3, 0xff, 0x5a, 0x8f, 0xc4, 0x9b, 0x86, 0xfc, 0x9f, 0xb5, 0x70, 0x44, 0x8f, 0xf9, 0x77, 0xf2, 0xd0, 0x7c, 0x1c, 0x92, 0x96, 0xb2, 0xf7, 0x74, 0x78, 0xd1, 0x3d, 0x5a, 0xb1, 0xc6, 0x39, 0x93, 0x96, 0x2f, 0x2d, 0xd0, 0x8e, 0xe7, 0xc3, 0x13, 0xde, 0xce, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_163_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_163_sig[] = {
	0x5a, 0x11, 0x71, 0x8c, 0x90, 0xa0, 0x24, 0x59, 0x80, 0x0f, 0x10, 0x9e, 0x4e, 0x84, 0x0c, 0xc2, 0x61, 0xd7, 0x82, 0xd6, 0x4e, 0x1c, 0x8a, 0x47, 0x12, 0xdd, 0x90, 0x81, 0xd2, 0x83, 0xb1, 0xc1, 0xe1, 0x10, 0xa4, 0x62, 0x0a, 0x69, 0x6f, 0xdf, 0x74, 0xa9, 0xc7, 0x79, 0x23, 0x52, 0x13, 0x9d, 0x54, 0xcc, 0xed, 0x8c, 0x97, 0x3d, 0x9e, 0x7e, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_163 = {
	.name = "ecdsa_brainpoolp224r1_sha224_163",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_163_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_163_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_163_sig,
	.siglen = 56,
	.result = 1,
	.comment = "x-coordinate of the public key is small, tcId is 164 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 164 for ECDSA, tcId is 165 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_164_pubkey[] = {
	0x00, 0x00, 0x00, 0x00, 0x81, 0xdf, 0x97, 0x17, 0x44, 0xa2, 0x5a, 0xc9, 0x94, 0x72, 0xc3, 0xff, 0x5a, 0x8f, 0xc4, 0x9b, 0x86, 0xfc, 0x9f, 0xb5, 0x70, 0x44, 0x8f, 0xf9, 0x77, 0xf2, 0xd0, 0x7c, 0x1c, 0x92, 0x96, 0xb2, 0xf7, 0x74, 0x78, 0xd1, 0x3d, 0x5a, 0xb1, 0xc6, 0x39, 0x93, 0x96, 0x2f, 0x2d, 0xd0, 0x8e, 0xe7, 0xc3, 0x13, 0xde, 0xce, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_164_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_164_sig[] = {
	0xd5, 0x77, 0xf2, 0x3e, 0x59, 0x24, 0x14, 0xe3, 0x51, 0xb3, 0x92, 0x8a, 0x59, 0x3c, 0x5d, 0x2f, 0x89, 0xf0, 0xc7, 0x2d, 0xf5, 0x13, 0xbf, 0xbc, 0x65, 0x35, 0xba, 0xbb, 0x1b, 0xb0, 0x9d, 0xd2, 0x35, 0x12, 0x4a, 0x14, 0xe0, 0x24, 0x69, 0x46, 0xf2, 0x80, 0x45, 0x0f, 0x15, 0x57, 0x69, 0x12, 0xae, 0xb7, 0x35, 0xb7, 0x3c, 0xe8, 0x28, 0xbc, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_164 = {
	.name = "ecdsa_brainpoolp224r1_sha224_164",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_164_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_164_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_164_sig,
	.siglen = 56,
	.result = 1,
	.comment = "x-coordinate of the public key is small, tcId is 165 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 165 for ECDSA, tcId is 166 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_165_pubkey[] = {
	0x00, 0x00, 0x00, 0x00, 0x81, 0xdf, 0x97, 0x17, 0x44, 0xa2, 0x5a, 0xc9, 0x94, 0x72, 0xc3, 0xff, 0x5a, 0x8f, 0xc4, 0x9b, 0x86, 0xfc, 0x9f, 0xb5, 0x70, 0x44, 0x8f, 0xf9, 0x77, 0xf2, 0xd0, 0x7c, 0x1c, 0x92, 0x96, 0xb2, 0xf7, 0x74, 0x78, 0xd1, 0x3d, 0x5a, 0xb1, 0xc6, 0x39, 0x93, 0x96, 0x2f, 0x2d, 0xd0, 0x8e, 0xe7, 0xc3, 0x13, 0xde, 0xce, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_165_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_165_sig[] = {
	0xaf, 0x8f, 0x83, 0x6e, 0x63, 0x99, 0x5d, 0xc7, 0x15, 0xa4, 0xd3, 0xc6, 0x84, 0x2c, 0x4e, 0x6c, 0x6c, 0xf4, 0x58, 0x6d, 0xf7, 0x6e, 0x46, 0x59, 0xd8, 0x09, 0xee, 0xc9, 0x85, 0xbe, 0xfd, 0x0b, 0x1b, 0xb8, 0xae, 0x18, 0x2c, 0x05, 0xd0, 0x71, 0xda, 0xd1, 0x80, 0x22, 0x4d, 0x22, 0x53, 0x3d, 0xce, 0x73, 0x7d, 0x4d, 0xda, 0x74, 0xd5, 0xd1, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_165 = {
	.name = "ecdsa_brainpoolp224r1_sha224_165",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_165_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_165_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_165_sig,
	.siglen = 56,
	.result = 1,
	.comment = "x-coordinate of the public key is small, tcId is 166 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 166 for ECDSA, tcId is 167 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_166_pubkey[] = {
	0x0d, 0x28, 0xb4, 0xf7, 0xfe, 0x1f, 0x6c, 0x6f, 0xa6, 0xa7, 0x7d, 0x11, 0xe4, 0x3b, 0xd3, 0xe9, 0x27, 0x17, 0x58, 0xdf, 0x34, 0xc6, 0x5f, 0xa5, 0x77, 0xa6, 0xdd, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x28, 0x01, 0xd4, 0x83, 0x82, 0x86, 0x16, 0x84, 0xb8, 0xd2, 0xcb, 0xd7, 0xe5, 0x98, 0x9a, 0x0d, 0x7c, 0x15, 0xa7, 0xe8, 0x19, 0xb5, 0x73, 0xaa, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_166_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_166_sig[] = {
	0x15, 0x6a, 0xa7, 0x86, 0x92, 0xc7, 0x8e, 0x97, 0x69, 0xab, 0xa7, 0x28, 0xc9, 0xee, 0xa7, 0x88, 0x35, 0xb5, 0x50, 0x00, 0x90, 0x1b, 0xa5, 0x07, 0x94, 0xa3, 0x3e, 0xfc, 0xb9, 0x78, 0x5d, 0xf4, 0x0a, 0x22, 0x13, 0x37, 0x74, 0x81, 0x31, 0x1b, 0x1a, 0x81, 0xd3, 0x10, 0xe7, 0x63, 0x41, 0x92, 0x7b, 0x8f, 0xba, 0x0d, 0x6e, 0x3e, 0xc7, 0xad, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_166 = {
	.name = "ecdsa_brainpoolp224r1_sha224_166",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_166_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_166_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_166_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key is small, tcId is 167 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 167 for ECDSA, tcId is 168 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_167_pubkey[] = {
	0x0d, 0x28, 0xb4, 0xf7, 0xfe, 0x1f, 0x6c, 0x6f, 0xa6, 0xa7, 0x7d, 0x11, 0xe4, 0x3b, 0xd3, 0xe9, 0x27, 0x17, 0x58, 0xdf, 0x34, 0xc6, 0x5f, 0xa5, 0x77, 0xa6, 0xdd, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x28, 0x01, 0xd4, 0x83, 0x82, 0x86, 0x16, 0x84, 0xb8, 0xd2, 0xcb, 0xd7, 0xe5, 0x98, 0x9a, 0x0d, 0x7c, 0x15, 0xa7, 0xe8, 0x19, 0xb5, 0x73, 0xaa, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_167_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_167_sig[] = {
	0x92, 0x74, 0xd4, 0x6a, 0x7f, 0xfa, 0x12, 0x99, 0xa3, 0x72, 0xe8, 0x21, 0xbd, 0x89, 0x72, 0x8d, 0xe8, 0x3e, 0xf8, 0x7c, 0x46, 0xaf, 0x67, 0x04, 0x3a, 0x63, 0x4b, 0x02, 0x19, 0xe4, 0xbb, 0xec, 0x8b, 0x03, 0xfa, 0x77, 0x2a, 0x36, 0x22, 0xbf, 0x48, 0x93, 0xe5, 0x81, 0xef, 0xad, 0xf9, 0xd2, 0x0b, 0xd6, 0x08, 0x06, 0xd8, 0x26, 0x76, 0xb6, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_167 = {
	.name = "ecdsa_brainpoolp224r1_sha224_167",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_167_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_167_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_167_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key is small, tcId is 168 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 168 for ECDSA, tcId is 169 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_168_pubkey[] = {
	0x0d, 0x28, 0xb4, 0xf7, 0xfe, 0x1f, 0x6c, 0x6f, 0xa6, 0xa7, 0x7d, 0x11, 0xe4, 0x3b, 0xd3, 0xe9, 0x27, 0x17, 0x58, 0xdf, 0x34, 0xc6, 0x5f, 0xa5, 0x77, 0xa6, 0xdd, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x28, 0x01, 0xd4, 0x83, 0x82, 0x86, 0x16, 0x84, 0xb8, 0xd2, 0xcb, 0xd7, 0xe5, 0x98, 0x9a, 0x0d, 0x7c, 0x15, 0xa7, 0xe8, 0x19, 0xb5, 0x73, 0xaa, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_168_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_168_sig[] = {
	0xcf, 0x6a, 0x9c, 0xba, 0x28, 0x5e, 0x56, 0x49, 0x3c, 0xbb, 0x46, 0x2b, 0x7b, 0x16, 0x12, 0x8a, 0x0c, 0xf1, 0xc7, 0x05, 0x84, 0x47, 0x94, 0x5d, 0xae, 0xf3, 0x41, 0x49, 0x29, 0xa6, 0x87, 0x83, 0x9e, 0x8e, 0xe0, 0x3c, 0x53, 0x72, 0xa1, 0x13, 0x73, 0x3c, 0x08, 0x1f, 0x41, 0x3d, 0x1f, 0x94, 0x05, 0xdd, 0xfe, 0x47, 0xe1, 0x8f, 0xcc, 0x54, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_168 = {
	.name = "ecdsa_brainpoolp224r1_sha224_168",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_168_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_168_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_168_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key is small, tcId is 169 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 169 for ECDSA, tcId is 170 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_169_pubkey[] = {
	0x0d, 0x28, 0xb4, 0xf7, 0xfe, 0x1f, 0x6c, 0x6f, 0xa6, 0xa7, 0x7d, 0x11, 0xe4, 0x3b, 0xd3, 0xe9, 0x27, 0x17, 0x58, 0xdf, 0x34, 0xc6, 0x5f, 0xa5, 0x77, 0xa6, 0xdd, 0x3b, 0xd7, 0xc1, 0x34, 0xa9, 0xfe, 0x41, 0x92, 0x02, 0xa7, 0x92, 0x19, 0xa0, 0xbc, 0xff, 0x0b, 0xaf, 0xcb, 0x06, 0x6d, 0x4a, 0x1b, 0xc4, 0xe2, 0x0d, 0x65, 0x13, 0x4d, 0x55, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_169_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_169_sig[] = {
	0x59, 0x2e, 0x54, 0xa0, 0xea, 0x95, 0x0a, 0xc7, 0xcd, 0x83, 0x0f, 0x56, 0xc7, 0x95, 0x4a, 0x76, 0x9f, 0x81, 0xaa, 0x55, 0xe8, 0xe1, 0x01, 0xbe, 0xe1, 0x9b, 0x3b, 0x27, 0x48, 0x37, 0x5f, 0xdd, 0x4d, 0x90, 0x14, 0xc9, 0xb6, 0x0b, 0x63, 0xc7, 0x0b, 0xfe, 0x98, 0xc8, 0x44, 0xbe, 0x66, 0x8f, 0x2d, 0x3a, 0x2e, 0x25, 0x92, 0x62, 0xb9, 0x45, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_169 = {
	.name = "ecdsa_brainpoolp224r1_sha224_169",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_169_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_169_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_169_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key is large, tcId is 170 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 170 for ECDSA, tcId is 171 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_170_pubkey[] = {
	0x0d, 0x28, 0xb4, 0xf7, 0xfe, 0x1f, 0x6c, 0x6f, 0xa6, 0xa7, 0x7d, 0x11, 0xe4, 0x3b, 0xd3, 0xe9, 0x27, 0x17, 0x58, 0xdf, 0x34, 0xc6, 0x5f, 0xa5, 0x77, 0xa6, 0xdd, 0x3b, 0xd7, 0xc1, 0x34, 0xa9, 0xfe, 0x41, 0x92, 0x02, 0xa7, 0x92, 0x19, 0xa0, 0xbc, 0xff, 0x0b, 0xaf, 0xcb, 0x06, 0x6d, 0x4a, 0x1b, 0xc4, 0xe2, 0x0d, 0x65, 0x13, 0x4d, 0x55, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_170_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_170_sig[] = {
	0x1e, 0xc0, 0xef, 0x4d, 0x5b, 0xed, 0xaf, 0xe5, 0x08, 0x1f, 0x7a, 0xda, 0xe3, 0x2d, 0xb4, 0xd0, 0xaa, 0x94, 0x6f, 0x13, 0x0a, 0xce, 0xda, 0xba, 0xe2, 0x6d, 0x90, 0xdc, 0x62, 0x7e, 0x81, 0xd7, 0xeb, 0x35, 0x8f, 0x59, 0xe8, 0xa8, 0x63, 0x05, 0x27, 0xd4, 0xe8, 0x94, 0x6d, 0x1c, 0xad, 0x21, 0x96, 0x76, 0x18, 0x36, 0xd9, 0x7d, 0x95, 0x3c, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_170 = {
	.name = "ecdsa_brainpoolp224r1_sha224_170",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_170_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_170_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_170_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key is large, tcId is 171 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 171 for ECDSA, tcId is 172 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_171_pubkey[] = {
	0x0d, 0x28, 0xb4, 0xf7, 0xfe, 0x1f, 0x6c, 0x6f, 0xa6, 0xa7, 0x7d, 0x11, 0xe4, 0x3b, 0xd3, 0xe9, 0x27, 0x17, 0x58, 0xdf, 0x34, 0xc6, 0x5f, 0xa5, 0x77, 0xa6, 0xdd, 0x3b, 0xd7, 0xc1, 0x34, 0xa9, 0xfe, 0x41, 0x92, 0x02, 0xa7, 0x92, 0x19, 0xa0, 0xbc, 0xff, 0x0b, 0xaf, 0xcb, 0x06, 0x6d, 0x4a, 0x1b, 0xc4, 0xe2, 0x0d, 0x65, 0x13, 0x4d, 0x55, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_171_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_171_sig[] = {
	0x5f, 0xaf, 0x03, 0x5e, 0xd5, 0x77, 0x4e, 0xeb, 0x0a, 0xdc, 0x18, 0x7f, 0xf4, 0x85, 0xa8, 0x46, 0xaa, 0x2a, 0xbc, 0xf1, 0xe7, 0xf8, 0x59, 0xb1, 0xb9, 0x10, 0xf2, 0x5c, 0x8b, 0xf1, 0x2a, 0x1c, 0x00, 0xb1, 0x8f, 0x66, 0xc2, 0x28, 0x35, 0x2d, 0xe4, 0x9c, 0xc4, 0xfb, 0x82, 0x7a, 0x09, 0xfc, 0x86, 0xf7, 0x22, 0xce, 0x56, 0x1b, 0xa5, 0xfa, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_171 = {
	.name = "ecdsa_brainpoolp224r1_sha224_171",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_171_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_171_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_171_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key is large, tcId is 172 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 172 for ECDSA, tcId is 173 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_172_pubkey[] = {
	0x51, 0x2e, 0x58, 0x17, 0x31, 0xc9, 0xc4, 0x60, 0xbb, 0x70, 0x5b, 0x60, 0xda, 0x97, 0x6c, 0xcb, 0x1b, 0x0e, 0xf4, 0x21, 0x78, 0x51, 0x06, 0xba, 0x2c, 0xcd, 0xd2, 0x38, 0x0f, 0x21, 0xd5, 0xba, 0xcd, 0xf8, 0x1c, 0x0c, 0xb7, 0x8f, 0xa1, 0x51, 0x23, 0x7d, 0xb3, 0x13, 0x0a, 0xd4, 0xde, 0xf3, 0x73, 0xf3, 0xe5, 0x23, 0x39, 0x8c, 0x2c, 0xf7, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_172_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_172_sig[] = {
	0x52, 0xb2, 0xd3, 0x69, 0xf1, 0x8d, 0xf5, 0x63, 0x72, 0xaf, 0xe7, 0xfe, 0xb3, 0x84, 0x13, 0xf2, 0x32, 0xb4, 0xfb, 0x9c, 0xa1, 0x6c, 0x6f, 0x6f, 0xed, 0xc6, 0x41, 0x89, 0xc1, 0xb1, 0x9f, 0x13, 0x77, 0x73, 0xef, 0x32, 0x01, 0xcd, 0x34, 0x1c, 0x38, 0x1e, 0x4f, 0x94, 0x49, 0xcc, 0x0e, 0x6c, 0x68, 0x8a, 0x35, 0x1d, 0x7a, 0x60, 0x70, 0xb2, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_172 = {
	.name = "ecdsa_brainpoolp224r1_sha224_172",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_172_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_172_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_172_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key has many trailing 1's on brainpoolP224t1, tcId is 173 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 173 for ECDSA, tcId is 174 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_173_pubkey[] = {
	0x51, 0x2e, 0x58, 0x17, 0x31, 0xc9, 0xc4, 0x60, 0xbb, 0x70, 0x5b, 0x60, 0xda, 0x97, 0x6c, 0xcb, 0x1b, 0x0e, 0xf4, 0x21, 0x78, 0x51, 0x06, 0xba, 0x2c, 0xcd, 0xd2, 0x38, 0x0f, 0x21, 0xd5, 0xba, 0xcd, 0xf8, 0x1c, 0x0c, 0xb7, 0x8f, 0xa1, 0x51, 0x23, 0x7d, 0xb3, 0x13, 0x0a, 0xd4, 0xde, 0xf3, 0x73, 0xf3, 0xe5, 0x23, 0x39, 0x8c, 0x2c, 0xf7, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_173_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_173_sig[] = {
	0x5b, 0x88, 0x9d, 0x28, 0x8a, 0xaa, 0x81, 0x67, 0x4d, 0x32, 0x00, 0x6e, 0x81, 0x27, 0x9c, 0x57, 0xed, 0x56, 0xa0, 0x35, 0xc8, 0x78, 0xd3, 0xe2, 0xb6, 0x87, 0xbe, 0xc3, 0x0d, 0xa6, 0x21, 0xd5, 0xfa, 0x98, 0x13, 0x26, 0x3c, 0x7f, 0x58, 0xf8, 0xe0, 0x15, 0x5d, 0x6f, 0x0c, 0x33, 0x0a, 0x56, 0xc5, 0x94, 0xde, 0xfc, 0x2e, 0xbd, 0xf0, 0xa0, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_173 = {
	.name = "ecdsa_brainpoolp224r1_sha224_173",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_173_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_173_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_173_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key has many trailing 1's on brainpoolP224t1, tcId is 174 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 174 for ECDSA, tcId is 175 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_174_pubkey[] = {
	0x51, 0x2e, 0x58, 0x17, 0x31, 0xc9, 0xc4, 0x60, 0xbb, 0x70, 0x5b, 0x60, 0xda, 0x97, 0x6c, 0xcb, 0x1b, 0x0e, 0xf4, 0x21, 0x78, 0x51, 0x06, 0xba, 0x2c, 0xcd, 0xd2, 0x38, 0x0f, 0x21, 0xd5, 0xba, 0xcd, 0xf8, 0x1c, 0x0c, 0xb7, 0x8f, 0xa1, 0x51, 0x23, 0x7d, 0xb3, 0x13, 0x0a, 0xd4, 0xde, 0xf3, 0x73, 0xf3, 0xe5, 0x23, 0x39, 0x8c, 0x2c, 0xf7, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_174_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_174_sig[] = {
	0xb6, 0xf8, 0xa8, 0x01, 0x87, 0x18, 0x0a, 0xad, 0x8a, 0x5c, 0x89, 0x6b, 0xe2, 0x14, 0x31, 0x46, 0x01, 0xa1, 0x58, 0x5f, 0x2c, 0xcb, 0x28, 0xbc, 0x7e, 0x8e, 0x8f, 0x01, 0xa9, 0x0c, 0x68, 0xc1, 0x4a, 0x67, 0xf5, 0xd5, 0x9c, 0xec, 0x70, 0xdc, 0x0f, 0x47, 0x3b, 0x5c, 0x14, 0x01, 0x3b, 0x05, 0x6d, 0x12, 0xcb, 0xc0, 0xf7, 0x15, 0x3b, 0x1d, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_174 = {
	.name = "ecdsa_brainpoolp224r1_sha224_174",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_174_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_174_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_174_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key has many trailing 1's on brainpoolP224t1, tcId is 175 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 175 for ECDSA, tcId is 176 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_175_pubkey[] = {
	0xac, 0x55, 0xd1, 0xb3, 0xfe, 0xd4, 0xae, 0xe0, 0x3f, 0xa3, 0x61, 0x5d, 0x22, 0x5a, 0x9c, 0xba, 0x5c, 0x02, 0x84, 0x41, 0x6f, 0xba, 0xf9, 0xa7, 0x61, 0x35, 0xf7, 0x62, 0x17, 0xa8, 0x88, 0x39, 0x5b, 0xce, 0xd3, 0x49, 0x77, 0xa8, 0x48, 0x23, 0x70, 0xd5, 0x6e, 0xbc, 0x62, 0xaa, 0x1c, 0xa8, 0x1b, 0xc3, 0x30, 0xf4, 0x9d, 0x4a, 0x14, 0x1d, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_175_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_175_sig[] = {
	0x16, 0xd4, 0xa8, 0x50, 0x9c, 0x9b, 0xce, 0x2c, 0x73, 0xf8, 0xdb, 0x4b, 0x73, 0x25, 0x7c, 0x7e, 0x33, 0xf4, 0x17, 0x26, 0xc2, 0x5c, 0x4c, 0x64, 0x54, 0x6b, 0x1d, 0xcc, 0x79, 0xba, 0x35, 0xa9, 0x6d, 0x23, 0x45, 0xad, 0x19, 0x4f, 0x39, 0x10, 0x91, 0x20, 0x9d, 0xfc, 0xce, 0xd7, 0x99, 0x17, 0xe0, 0x4d, 0xf3, 0xb6, 0x5f, 0x44, 0xd1, 0xeb, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_175 = {
	.name = "ecdsa_brainpoolp224r1_sha224_175",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_175_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_175_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_175_sig,
	.siglen = 56,
	.result = 1,
	.comment = "x-coordinate of the public key is small on brainpoolP224t1, tcId is 176 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 176 for ECDSA, tcId is 177 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_176_pubkey[] = {
	0xac, 0x55, 0xd1, 0xb3, 0xfe, 0xd4, 0xae, 0xe0, 0x3f, 0xa3, 0x61, 0x5d, 0x22, 0x5a, 0x9c, 0xba, 0x5c, 0x02, 0x84, 0x41, 0x6f, 0xba, 0xf9, 0xa7, 0x61, 0x35, 0xf7, 0x62, 0x17, 0xa8, 0x88, 0x39, 0x5b, 0xce, 0xd3, 0x49, 0x77, 0xa8, 0x48, 0x23, 0x70, 0xd5, 0x6e, 0xbc, 0x62, 0xaa, 0x1c, 0xa8, 0x1b, 0xc3, 0x30, 0xf4, 0x9d, 0x4a, 0x14, 0x1d, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_176_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_176_sig[] = {
	0x5d, 0xa1, 0x56, 0x97, 0xbb, 0xe4, 0xeb, 0xa7, 0x70, 0x7e, 0x34, 0x9f, 0xf3, 0x23, 0x9d, 0x50, 0x84, 0x55, 0x37, 0x81, 0x13, 0xd2, 0x4e, 0x7e, 0x1d, 0x7a, 0x02, 0x0c, 0x45, 0xbe, 0x44, 0xa5, 0x70, 0xfb, 0x53, 0x0c, 0x49, 0xd7, 0x59, 0x71, 0x2c, 0x10, 0x04, 0x13, 0x45, 0xf7, 0xc0, 0x89, 0x0a, 0x79, 0x46, 0xd9, 0x1d, 0x32, 0xba, 0xc6, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_176 = {
	.name = "ecdsa_brainpoolp224r1_sha224_176",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_176_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_176_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_176_sig,
	.siglen = 56,
	.result = 1,
	.comment = "x-coordinate of the public key is small on brainpoolP224t1, tcId is 177 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 177 for ECDSA, tcId is 178 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_177_pubkey[] = {
	0xac, 0x55, 0xd1, 0xb3, 0xfe, 0xd4, 0xae, 0xe0, 0x3f, 0xa3, 0x61, 0x5d, 0x22, 0x5a, 0x9c, 0xba, 0x5c, 0x02, 0x84, 0x41, 0x6f, 0xba, 0xf9, 0xa7, 0x61, 0x35, 0xf7, 0x62, 0x17, 0xa8, 0x88, 0x39, 0x5b, 0xce, 0xd3, 0x49, 0x77, 0xa8, 0x48, 0x23, 0x70, 0xd5, 0x6e, 0xbc, 0x62, 0xaa, 0x1c, 0xa8, 0x1b, 0xc3, 0x30, 0xf4, 0x9d, 0x4a, 0x14, 0x1d, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_177_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_177_sig[] = {
	0xc1, 0xf8, 0xd4, 0x34, 0x79, 0xc4, 0xf2, 0x9b, 0x19, 0xb9, 0xb2, 0xc7, 0xb5, 0x74, 0x70, 0x10, 0x49, 0x14, 0x40, 0x74, 0x6c, 0xc8, 0x00, 0xd5, 0xbe, 0x89, 0xb0, 0x11, 0x81, 0x54, 0x34, 0x8b, 0x7c, 0x37, 0xf0, 0x50, 0x4d, 0xca, 0x2b, 0x11, 0x59, 0x41, 0xf7, 0xba, 0x58, 0x57, 0x32, 0x1e, 0xae, 0x8f, 0x64, 0x17, 0x5b, 0xe9, 0xcb, 0xb9, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_177 = {
	.name = "ecdsa_brainpoolp224r1_sha224_177",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_177_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_177_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_177_sig,
	.siglen = 56,
	.result = 1,
	.comment = "x-coordinate of the public key is small on brainpoolP224t1, tcId is 178 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 178 for ECDSA, tcId is 179 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_178_pubkey[] = {
	0x8b, 0x31, 0x9f, 0x2e, 0xd0, 0x74, 0xa2, 0x0e, 0xc4, 0x2d, 0x86, 0x9c, 0x7f, 0x99, 0xbd, 0x91, 0x46, 0xed, 0x82, 0x63, 0x29, 0x7b, 0xfe, 0x00, 0x4f, 0x27, 0xc5, 0x9b, 0x12, 0x0f, 0x96, 0x34, 0x3d, 0xeb, 0x80, 0x09, 0x3e, 0xcb, 0x76, 0x95, 0xc2, 0xd2, 0xa5, 0xbe, 0x99, 0x37, 0xa2, 0x58, 0x72, 0x3d, 0x78, 0xed, 0x00, 0xaa, 0x1e, 0xdf, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_178_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_178_sig[] = {
	0x87, 0x15, 0x81, 0xb5, 0x00, 0x92, 0x57, 0x82, 0x11, 0x16, 0x0e, 0x47, 0x0d, 0xdd, 0xaa, 0x64, 0x0d, 0x5a, 0x2d, 0x9e, 0x22, 0x4f, 0xaf, 0xca, 0x87, 0x91, 0x06, 0xd4, 0xbe, 0x70, 0xfd, 0x5c, 0x75, 0x91, 0xa3, 0x13, 0x0f, 0x5c, 0x2a, 0xf5, 0x36, 0xff, 0xff, 0x8e, 0x72, 0xc1, 0x62, 0x51, 0x74, 0x4c, 0x97, 0x96, 0x8f, 0x92, 0x17, 0x28, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_178 = {
	.name = "ecdsa_brainpoolp224r1_sha224_178",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_178_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_178_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_178_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key is small on brainpoolP224t1, tcId is 179 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 179 for ECDSA, tcId is 180 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_179_pubkey[] = {
	0x8b, 0x31, 0x9f, 0x2e, 0xd0, 0x74, 0xa2, 0x0e, 0xc4, 0x2d, 0x86, 0x9c, 0x7f, 0x99, 0xbd, 0x91, 0x46, 0xed, 0x82, 0x63, 0x29, 0x7b, 0xfe, 0x00, 0x4f, 0x27, 0xc5, 0x9b, 0x12, 0x0f, 0x96, 0x34, 0x3d, 0xeb, 0x80, 0x09, 0x3e, 0xcb, 0x76, 0x95, 0xc2, 0xd2, 0xa5, 0xbe, 0x99, 0x37, 0xa2, 0x58, 0x72, 0x3d, 0x78, 0xed, 0x00, 0xaa, 0x1e, 0xdf, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_179_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_179_sig[] = {
	0xa9, 0x87, 0x35, 0xe5, 0x65, 0x90, 0x22, 0xb0, 0x27, 0x4a, 0xe6, 0xf7, 0xbc, 0xb1, 0x64, 0x6e, 0x9e, 0x6b, 0x4b, 0x88, 0x40, 0x8d, 0xb3, 0xf9, 0x26, 0xec, 0xcc, 0x89, 0xa9, 0x23, 0xff, 0x5e, 0x15, 0xe0, 0xd7, 0x64, 0xcd, 0x5c, 0xef, 0xff, 0xc5, 0xc4, 0x0c, 0x08, 0x2c, 0x6e, 0xb7, 0x72, 0xdb, 0x76, 0x62, 0xfb, 0x1b, 0x82, 0xd5, 0x25, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_179 = {
	.name = "ecdsa_brainpoolp224r1_sha224_179",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_179_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_179_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_179_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key is small on brainpoolP224t1, tcId is 180 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 180 for ECDSA, tcId is 181 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_180_pubkey[] = {
	0x8b, 0x31, 0x9f, 0x2e, 0xd0, 0x74, 0xa2, 0x0e, 0xc4, 0x2d, 0x86, 0x9c, 0x7f, 0x99, 0xbd, 0x91, 0x46, 0xed, 0x82, 0x63, 0x29, 0x7b, 0xfe, 0x00, 0x4f, 0x27, 0xc5, 0x9b, 0x12, 0x0f, 0x96, 0x34, 0x3d, 0xeb, 0x80, 0x09, 0x3e, 0xcb, 0x76, 0x95, 0xc2, 0xd2, 0xa5, 0xbe, 0x99, 0x37, 0xa2, 0x58, 0x72, 0x3d, 0x78, 0xed, 0x00, 0xaa, 0x1e, 0xdf, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_180_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_180_sig[] = {
	0xa9, 0x6b, 0x5c, 0x24, 0xe3, 0x3d, 0x59, 0x00, 0x4c, 0xf3, 0x1a, 0xae, 0xf4, 0x4a, 0xe4, 0xc7, 0x57, 0x9e, 0x0b, 0x5b, 0x21, 0x9a, 0xb2, 0x5d, 0x7f, 0x1c, 0x69, 0x0a, 0x88, 0xc0, 0x13, 0x78, 0x84, 0x7c, 0x38, 0x41, 0xf4, 0x9e, 0xc1, 0x48, 0x40, 0xe2, 0xd0, 0x23, 0xd7, 0xb9, 0x12, 0xb5, 0x03, 0xf2, 0xd9, 0x8a, 0x92, 0x3b, 0xe8, 0xc9, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_180 = {
	.name = "ecdsa_brainpoolp224r1_sha224_180",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_180_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_180_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_180_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key is small on brainpoolP224t1, tcId is 181 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 181 for ECDSA, tcId is 182 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_181_pubkey[] = {
	0x8b, 0x31, 0x9f, 0x2e, 0xd0, 0x74, 0xa2, 0x0e, 0xc4, 0x2d, 0x86, 0x9c, 0x7f, 0x99, 0xbd, 0x91, 0x46, 0xed, 0x82, 0x63, 0x29, 0x7b, 0xfe, 0x00, 0x4f, 0x27, 0xc5, 0x9b, 0xc5, 0xb1, 0x9e, 0x75, 0xe8, 0x57, 0xe6, 0x7c, 0xeb, 0x4c, 0xb9, 0x8f, 0xb2, 0xff, 0x31, 0xc9, 0x17, 0x67, 0x64, 0xff, 0x25, 0x9d, 0x11, 0x08, 0x7e, 0x1e, 0xa2, 0x20, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_181_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_181_sig[] = {
	0x6b, 0x57, 0xb7, 0x3a, 0xb7, 0xc3, 0x9b, 0x56, 0x98, 0x54, 0x9d, 0xd5, 0xcd, 0xd4, 0xdf, 0x73, 0x98, 0x18, 0x1b, 0x55, 0x6e, 0x7c, 0x72, 0x83, 0x37, 0x5e, 0x3f, 0x86, 0x9f, 0x59, 0xd1, 0x86, 0x3d, 0x6f, 0xd6, 0x01, 0x32, 0x47, 0xd4, 0xe6, 0x78, 0xa1, 0xc4, 0xfc, 0x1d, 0x89, 0x6d, 0xc6, 0x61, 0xfa, 0x31, 0xfb, 0x73, 0xc3, 0x3f, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_181 = {
	.name = "ecdsa_brainpoolp224r1_sha224_181",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_181_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_181_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_181_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key is large on brainpoolP224t1, tcId is 182 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 182 for ECDSA, tcId is 183 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_182_pubkey[] = {
	0x8b, 0x31, 0x9f, 0x2e, 0xd0, 0x74, 0xa2, 0x0e, 0xc4, 0x2d, 0x86, 0x9c, 0x7f, 0x99, 0xbd, 0x91, 0x46, 0xed, 0x82, 0x63, 0x29, 0x7b, 0xfe, 0x00, 0x4f, 0x27, 0xc5, 0x9b, 0xc5, 0xb1, 0x9e, 0x75, 0xe8, 0x57, 0xe6, 0x7c, 0xeb, 0x4c, 0xb9, 0x8f, 0xb2, 0xff, 0x31, 0xc9, 0x17, 0x67, 0x64, 0xff, 0x25, 0x9d, 0x11, 0x08, 0x7e, 0x1e, 0xa2, 0x20, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_182_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_182_sig[] = {
	0x2f, 0x85, 0xaf, 0x7e, 0x53, 0x5f, 0x66, 0xcf, 0xc9, 0xa9, 0xda, 0xb7, 0xbe, 0x78, 0x16, 0x31, 0xdd, 0x62, 0x2b, 0xe4, 0x35, 0xd7, 0x64, 0x2b, 0x5b, 0x51, 0xfc, 0xc7, 0x61, 0x93, 0x01, 0xc2, 0x1c, 0x93, 0x42, 0x55, 0xdf, 0x93, 0xee, 0xdd, 0x5b, 0x45, 0x9c, 0x8d, 0xd2, 0x80, 0xfd, 0xd0, 0x7e, 0xe6, 0x56, 0xa7, 0x14, 0x7d, 0x4d, 0x69, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_182 = {
	.name = "ecdsa_brainpoolp224r1_sha224_182",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_182_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_182_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_182_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key is large on brainpoolP224t1, tcId is 183 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 183 for ECDSA, tcId is 184 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_183_pubkey[] = {
	0x8b, 0x31, 0x9f, 0x2e, 0xd0, 0x74, 0xa2, 0x0e, 0xc4, 0x2d, 0x86, 0x9c, 0x7f, 0x99, 0xbd, 0x91, 0x46, 0xed, 0x82, 0x63, 0x29, 0x7b, 0xfe, 0x00, 0x4f, 0x27, 0xc5, 0x9b, 0xc5, 0xb1, 0x9e, 0x75, 0xe8, 0x57, 0xe6, 0x7c, 0xeb, 0x4c, 0xb9, 0x8f, 0xb2, 0xff, 0x31, 0xc9, 0x17, 0x67, 0x64, 0xff, 0x25, 0x9d, 0x11, 0x08, 0x7e, 0x1e, 0xa2, 0x20, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_183_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_183_sig[] = {
	0x98, 0xa8, 0xa9, 0x8f, 0xcc, 0x82, 0xf8, 0x04, 0xa8, 0x23, 0xcc, 0x91, 0x07, 0x24, 0x37, 0xcf, 0xd8, 0x83, 0x22, 0xb8, 0x67, 0x16, 0x86, 0x51, 0x7f, 0x19, 0x78, 0xab, 0x6a, 0xc3, 0xe8, 0x37, 0x76, 0x68, 0x5b, 0xce, 0xce, 0xfe, 0xba, 0xe4, 0x73, 0xac, 0x07, 0xc7, 0x71, 0xe8, 0x3b, 0x0c, 0x5a, 0x55, 0x7e, 0xfe, 0x83, 0x50, 0x20, 0x36, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_183 = {
	.name = "ecdsa_brainpoolp224r1_sha224_183",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_183_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_183_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_183_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key is large on brainpoolP224t1, tcId is 184 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 184 for ECDSA, tcId is 185 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_184_pubkey[] = {
	0xc5, 0xdc, 0x51, 0x35, 0xf0, 0x50, 0xa9, 0x6b, 0xbb, 0x0d, 0x21, 0x88, 0x51, 0x95, 0xb4, 0x9a, 0x57, 0x4d, 0x51, 0x98, 0xba, 0xac, 0x4b, 0x46, 0x02, 0xb2, 0x1b, 0xc8, 0xb5, 0xf3, 0x8b, 0x7f, 0xe6, 0x61, 0x00, 0x3f, 0xae, 0xe1, 0xb7, 0xaf, 0x67, 0x0e, 0x16, 0x5b, 0xfa, 0xb7, 0x0b, 0x01, 0x89, 0x65, 0xe8, 0x33, 0x29, 0xd4, 0x05, 0xbc, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_184_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_184_sig[] = {
	0x69, 0x9c, 0x40, 0xb7, 0x35, 0x23, 0x6b, 0xd9, 0x23, 0x97, 0x70, 0xa5, 0xde, 0x2c, 0x1a, 0x75, 0x54, 0x63, 0x1e, 0x6b, 0xa6, 0xef, 0x51, 0x2f, 0x85, 0x53, 0xd0, 0x2f, 0x0b, 0xca, 0x9c, 0x51, 0x6c, 0xa4, 0x05, 0xff, 0xc9, 0xae, 0x2d, 0xce, 0xe1, 0x2a, 0xd7, 0xd9, 0x6b, 0x58, 0x6b, 0xfd, 0xc8, 0x18, 0xa3, 0xd4, 0x5d, 0xcf, 0xcf, 0x26, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_184 = {
	.name = "ecdsa_brainpoolp224r1_sha224_184",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_184_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_184_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_184_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key has many trailing 0's on brainpoolP224t1, tcId is 185 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 185 for ECDSA, tcId is 186 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_185_pubkey[] = {
	0xc5, 0xdc, 0x51, 0x35, 0xf0, 0x50, 0xa9, 0x6b, 0xbb, 0x0d, 0x21, 0x88, 0x51, 0x95, 0xb4, 0x9a, 0x57, 0x4d, 0x51, 0x98, 0xba, 0xac, 0x4b, 0x46, 0x02, 0xb2, 0x1b, 0xc8, 0xb5, 0xf3, 0x8b, 0x7f, 0xe6, 0x61, 0x00, 0x3f, 0xae, 0xe1, 0xb7, 0xaf, 0x67, 0x0e, 0x16, 0x5b, 0xfa, 0xb7, 0x0b, 0x01, 0x89, 0x65, 0xe8, 0x33, 0x29, 0xd4, 0x05, 0xbc, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_185_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_185_sig[] = {
	0x76, 0x8a, 0x81, 0x9d, 0x39, 0x43, 0xfc, 0x30, 0x78, 0x1a, 0xae, 0xf2, 0x8f, 0xa1, 0x20, 0x18, 0x4c, 0x72, 0x12, 0xd0, 0x91, 0x1f, 0xe0, 0x3d, 0xfc, 0x8c, 0x62, 0x60, 0x51, 0xb3, 0xdb, 0x0e, 0x1c, 0x3e, 0x93, 0x91, 0x49, 0xcc, 0xbf, 0x9d, 0x46, 0x19, 0xbb, 0xbf, 0xf0, 0xe2, 0xe1, 0x74, 0x11, 0x0f, 0x6e, 0xce, 0x43, 0x13, 0xb4, 0xca, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_185 = {
	.name = "ecdsa_brainpoolp224r1_sha224_185",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_185_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_185_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_185_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key has many trailing 0's on brainpoolP224t1, tcId is 186 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 186 for ECDSA, tcId is 187 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_186_pubkey[] = {
	0xc5, 0xdc, 0x51, 0x35, 0xf0, 0x50, 0xa9, 0x6b, 0xbb, 0x0d, 0x21, 0x88, 0x51, 0x95, 0xb4, 0x9a, 0x57, 0x4d, 0x51, 0x98, 0xba, 0xac, 0x4b, 0x46, 0x02, 0xb2, 0x1b, 0xc8, 0xb5, 0xf3, 0x8b, 0x7f, 0xe6, 0x61, 0x00, 0x3f, 0xae, 0xe1, 0xb7, 0xaf, 0x67, 0x0e, 0x16, 0x5b, 0xfa, 0xb7, 0x0b, 0x01, 0x89, 0x65, 0xe8, 0x33, 0x29, 0xd4, 0x05, 0xbc, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_186_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_186_sig[] = {
	0x58, 0xfc, 0xc0, 0xff, 0xb1, 0x25, 0xc2, 0x3c, 0x43, 0x57, 0x35, 0xb7, 0xc3, 0x90, 0x69, 0x20, 0x37, 0xc0, 0x3a, 0x67, 0x65, 0xef, 0x7b, 0x53, 0x65, 0xa1, 0x7d, 0xd4, 0x95, 0x18, 0xd2, 0x9d, 0x78, 0xed, 0xa9, 0xcb, 0x25, 0x03, 0xfd, 0xe3, 0x8d, 0x3b, 0x73, 0xd6, 0xfb, 0x90, 0xa0, 0xd4, 0x0a, 0x23, 0xf0, 0xec, 0x26, 0x16, 0x69, 0x69, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_186 = {
	.name = "ecdsa_brainpoolp224r1_sha224_186",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_186_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_186_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_186_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key has many trailing 0's on brainpoolP224t1, tcId is 187 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 187 for ECDSA, tcId is 188 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_187_pubkey[] = {
	0xc1, 0xb5, 0x6a, 0x1a, 0xd1, 0x54, 0xe1, 0x15, 0x56, 0xb7, 0x23, 0xfc, 0x74, 0x93, 0xf3, 0x6e, 0x66, 0x50, 0x9d, 0x8f, 0x68, 0xfa, 0xd0, 0xe6, 0x2c, 0x40, 0xf0, 0x85, 0x9b, 0x04, 0x78, 0x0a, 0x85, 0xe6, 0x9a, 0xbf, 0x98, 0xde, 0xf3, 0x33, 0x5c, 0xe6, 0x43, 0xcd, 0x35, 0x54, 0x16, 0x7a, 0x8b, 0x50, 0xd5, 0x96, 0xb9, 0x53, 0x88, 0x95, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_187_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_187_sig[] = {
	0xd1, 0x93, 0xee, 0x0a, 0x3d, 0x42, 0xa2, 0x3a, 0xf0, 0x18, 0xab, 0x90, 0x89, 0x6b, 0x35, 0xd5, 0xc2, 0x50, 0x18, 0x7b, 0xf9, 0xfb, 0x1c, 0xca, 0xc3, 0x64, 0x74, 0x8c, 0xa0, 0x92, 0x2a, 0xcc, 0xc7, 0x56, 0x2d, 0x01, 0x71, 0x09, 0xe9, 0x1d, 0x2f, 0x83, 0xe4, 0x8b, 0xfa, 0x3c, 0x1f, 0xa2, 0xee, 0x04, 0xd8, 0x46, 0x9b, 0xe9, 0x40, 0x33, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_187 = {
	.name = "ecdsa_brainpoolp224r1_sha224_187",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_187_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_187_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_187_sig,
	.siglen = 56,
	.result = 1,
	.comment = "x-coordinate of the public key has many trailing 1's on brainpoolP224t1, tcId is 188 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 188 for ECDSA, tcId is 189 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_188_pubkey[] = {
	0xc1, 0xb5, 0x6a, 0x1a, 0xd1, 0x54, 0xe1, 0x15, 0x56, 0xb7, 0x23, 0xfc, 0x74, 0x93, 0xf3, 0x6e, 0x66, 0x50, 0x9d, 0x8f, 0x68, 0xfa, 0xd0, 0xe6, 0x2c, 0x40, 0xf0, 0x85, 0x9b, 0x04, 0x78, 0x0a, 0x85, 0xe6, 0x9a, 0xbf, 0x98, 0xde, 0xf3, 0x33, 0x5c, 0xe6, 0x43, 0xcd, 0x35, 0x54, 0x16, 0x7a, 0x8b, 0x50, 0xd5, 0x96, 0xb9, 0x53, 0x88, 0x95, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_188_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_188_sig[] = {
	0x09, 0x74, 0x52, 0x1d, 0x7c, 0xe7, 0x53, 0xde, 0xa5, 0xd1, 0x15, 0x6f, 0xb4, 0xd9, 0x92, 0xcc, 0x61, 0x40, 0x79, 0xeb, 0x86, 0x77, 0xab, 0x36, 0xa4, 0x07, 0x8a, 0x4f, 0x83, 0x74, 0xdf, 0xba, 0xe8, 0xd0, 0x42, 0x9a, 0x6f, 0xba, 0x60, 0xfb, 0xb5, 0xd2, 0xfd, 0x55, 0x98, 0x56, 0xa5, 0xd7, 0x39, 0xf3, 0x9a, 0xa2, 0xbf, 0x1d, 0xa1, 0xc9, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_188 = {
	.name = "ecdsa_brainpoolp224r1_sha224_188",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_188_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_188_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_188_sig,
	.siglen = 56,
	.result = 1,
	.comment = "x-coordinate of the public key has many trailing 1's on brainpoolP224t1, tcId is 189 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 189 for ECDSA, tcId is 190 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_189_pubkey[] = {
	0xc1, 0xb5, 0x6a, 0x1a, 0xd1, 0x54, 0xe1, 0x15, 0x56, 0xb7, 0x23, 0xfc, 0x74, 0x93, 0xf3, 0x6e, 0x66, 0x50, 0x9d, 0x8f, 0x68, 0xfa, 0xd0, 0xe6, 0x2c, 0x40, 0xf0, 0x85, 0x9b, 0x04, 0x78, 0x0a, 0x85, 0xe6, 0x9a, 0xbf, 0x98, 0xde, 0xf3, 0x33, 0x5c, 0xe6, 0x43, 0xcd, 0x35, 0x54, 0x16, 0x7a, 0x8b, 0x50, 0xd5, 0x96, 0xb9, 0x53, 0x88, 0x95, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_189_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_189_sig[] = {
	0x62, 0x5f, 0x47, 0x3c, 0xa2, 0xd1, 0x5b, 0xb7, 0xf1, 0x2d, 0xa1, 0x23, 0x5f, 0x90, 0xad, 0xcb, 0x69, 0xed, 0x48, 0x18, 0x74, 0x6c, 0xae, 0x2e, 0x2d, 0xb2, 0x6f, 0xe6, 0x4a, 0xb8, 0x17, 0xf6, 0xf1, 0xb9, 0xc8, 0xc4, 0x9f, 0x68, 0x1b, 0xed, 0x15, 0x68, 0x34, 0x6f, 0x53, 0xec, 0xbf, 0xac, 0xfd, 0x52, 0xd4, 0x5e, 0x27, 0xab, 0xcb, 0xb0, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_189 = {
	.name = "ecdsa_brainpoolp224r1_sha224_189",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_189_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_189_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_189_sig,
	.siglen = 56,
	.result = 1,
	.comment = "x-coordinate of the public key has many trailing 1's on brainpoolP224t1, tcId is 190 in file ecdsa_brainpoolP224r1_sha224_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 190 for ECDSA, tcId is 1 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_190_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_190_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_190_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0x13, 0x9c, 0x78, 0x24, 0x3a, 0x6e, 0x36, 0xe1, 0x24, 0xd5, 0xf5, 0xe1, 0x4b, 0x4c, 0xb8, 0x75, 0x4a, 0xbd, 0xf2, 0x0f, 0xf1, 0xa5, 0x01, 0xd5, 0x66, 0x6a, 0x42, 0x8f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_190 = {
	.name = "ecdsa_brainpoolp224r1_sha224_190",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_190_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_190_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_190_sig,
	.siglen = 56,
	.result = 1,
	.comment = "signature malleability, tcId is 1 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 191 for ECDSA, tcId is 2 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_191_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_191_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_191_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_191 = {
	.name = "ecdsa_brainpoolp224r1_sha224_191",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_191_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_191_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_191_sig,
	.siglen = 56,
	.result = 0,
	.comment = "Legacy:ASN encoding of r misses leading 0, tcId is 2 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 192 for ECDSA, tcId is 3 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_192_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_192_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_192_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_192 = {
	.name = "ecdsa_brainpoolp224r1_sha224_192",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_192_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_192_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_192_sig,
	.siglen = 56,
	.result = 0,
	.comment = "Legacy:ASN encoding of s misses leading 0, tcId is 3 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 193 for ECDSA, tcId is 4 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_193_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_193_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_193_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_193 = {
	.name = "ecdsa_brainpoolp224r1_sha224_193",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_193_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_193_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_193_sig,
	.siglen = 56,
	.result = 1,
	.comment = "valid, tcId is 4 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 194 for ECDSA, tcId is 5 in file ecdsa_brainpoolP224r1_sha224_test.json  [!!!WARNING: this test has been patched from 'invalid' to 'acceptable' due to lax DER parser] */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_194_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_194_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_194_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_194 = {
	.name = "ecdsa_brainpoolp224r1_sha224_194",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_194_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_194_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_194_sig,
	.siglen = 56,
	.result = 0,
	.comment = "long form encoding of length of sequence, tcId is 5 in file ecdsa_brainpoolP224r1_sha224_test.json [!!!WARNING: this test has been patched from 'invalid' to 'acceptable' due to lax DER parser]",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 195 for ECDSA, tcId is 6 in file ecdsa_brainpoolP224r1_sha224_test.json  [!!!WARNING: this test has been patched from 'invalid' to 'acceptable' due to lax DER parser] */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_195_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_195_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_195_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_195 = {
	.name = "ecdsa_brainpoolp224r1_sha224_195",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_195_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_195_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_195_sig,
	.siglen = 56,
	.result = 0,
	.comment = "length of sequence contains leading 0, tcId is 6 in file ecdsa_brainpoolP224r1_sha224_test.json [!!!WARNING: this test has been patched from 'invalid' to 'acceptable' due to lax DER parser]",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 196 for ECDSA, tcId is 69 in file ecdsa_brainpoolP224r1_sha224_test.json  [!!!WARNING: this test has been patched from 'invalid' to 'acceptable' due to lax DER parser] */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_196_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_196_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_196_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_196 = {
	.name = "ecdsa_brainpoolp224r1_sha224_196",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_196_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_196_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_196_sig,
	.siglen = 56,
	.result = 0,
	.comment = "long form encoding of length of integer, tcId is 69 in file ecdsa_brainpoolP224r1_sha224_test.json [!!!WARNING: this test has been patched from 'invalid' to 'acceptable' due to lax DER parser]",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 197 for ECDSA, tcId is 70 in file ecdsa_brainpoolP224r1_sha224_test.json  [!!!WARNING: this test has been patched from 'invalid' to 'acceptable' due to lax DER parser] */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_197_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_197_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_197_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_197 = {
	.name = "ecdsa_brainpoolp224r1_sha224_197",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_197_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_197_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_197_sig,
	.siglen = 56,
	.result = 0,
	.comment = "long form encoding of length of integer, tcId is 70 in file ecdsa_brainpoolP224r1_sha224_test.json [!!!WARNING: this test has been patched from 'invalid' to 'acceptable' due to lax DER parser]",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 198 for ECDSA, tcId is 71 in file ecdsa_brainpoolP224r1_sha224_test.json  [!!!WARNING: this test has been patched from 'invalid' to 'acceptable' due to lax DER parser] */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_198_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_198_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_198_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_198 = {
	.name = "ecdsa_brainpoolp224r1_sha224_198",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_198_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_198_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_198_sig,
	.siglen = 56,
	.result = 0,
	.comment = "length of integer contains leading 0, tcId is 71 in file ecdsa_brainpoolP224r1_sha224_test.json [!!!WARNING: this test has been patched from 'invalid' to 'acceptable' due to lax DER parser]",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 199 for ECDSA, tcId is 72 in file ecdsa_brainpoolP224r1_sha224_test.json  [!!!WARNING: this test has been patched from 'invalid' to 'acceptable' due to lax DER parser] */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_199_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_199_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_199_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_199 = {
	.name = "ecdsa_brainpoolp224r1_sha224_199",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_199_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_199_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_199_sig,
	.siglen = 56,
	.result = 0,
	.comment = "length of integer contains leading 0, tcId is 72 in file ecdsa_brainpoolP224r1_sha224_test.json [!!!WARNING: this test has been patched from 'invalid' to 'acceptable' due to lax DER parser]",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 200 for ECDSA, tcId is 94 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_200_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_200_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_200_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0x00, 0x00, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_200 = {
	.name = "ecdsa_brainpoolp224r1_sha224_200",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_200_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_200_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_200_sig,
	.siglen = 58,
	.result = -1,
	.comment = "appending 0's to integer, tcId is 94 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 201 for ECDSA, tcId is 95 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_201_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_201_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_201_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_201 = {
	.name = "ecdsa_brainpoolp224r1_sha224_201",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_201_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_201_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_201_sig,
	.siglen = 58,
	.result = -1,
	.comment = "appending 0's to integer, tcId is 95 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 202 for ECDSA, tcId is 96 in file ecdsa_brainpoolP224r1_sha224_test.json  [!!!WARNING: this test has been patched from 'invalid' to 'acceptable' due to lax DER parser] */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_202_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_202_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_202_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_202 = {
	.name = "ecdsa_brainpoolp224r1_sha224_202",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_202_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_202_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_202_sig,
	.siglen = 56,
	.result = 0,
	.comment = "prepending 0's to integer, tcId is 96 in file ecdsa_brainpoolP224r1_sha224_test.json [!!!WARNING: this test has been patched from 'invalid' to 'acceptable' due to lax DER parser]",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 203 for ECDSA, tcId is 97 in file ecdsa_brainpoolP224r1_sha224_test.json  [!!!WARNING: this test has been patched from 'invalid' to 'acceptable' due to lax DER parser] */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_203_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_203_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_203_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_203 = {
	.name = "ecdsa_brainpoolp224r1_sha224_203",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_203_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_203_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_203_sig,
	.siglen = 56,
	.result = 0,
	.comment = "prepending 0's to integer, tcId is 97 in file ecdsa_brainpoolP224r1_sha224_test.json [!!!WARNING: this test has been patched from 'invalid' to 'acceptable' due to lax DER parser]",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 204 for ECDSA, tcId is 99 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_204_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_204_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_204_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0x05, 0x00, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_204 = {
	.name = "ecdsa_brainpoolp224r1_sha224_204",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_204_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_204_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_204_sig,
	.siglen = 58,
	.result = -1,
	.comment = "appending null value to integer, tcId is 99 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 205 for ECDSA, tcId is 100 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_205_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_205_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_205_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 0x05, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_205 = {
	.name = "ecdsa_brainpoolp224r1_sha224_205",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_205_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_205_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_205_sig,
	.siglen = 58,
	.result = -1,
	.comment = "appending null value to integer, tcId is 100 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 206 for ECDSA, tcId is 115 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_206_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_206_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_206_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_206 = {
	.name = "ecdsa_brainpoolp224r1_sha224_206",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_206_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_206_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_206_sig,
	.siglen = 56,
	.result = -1,
	.comment = "dropping value of integer, tcId is 115 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 207 for ECDSA, tcId is 116 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_207_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_207_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_207_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_207 = {
	.name = "ecdsa_brainpoolp224r1_sha224_207",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_207_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_207_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_207_sig,
	.siglen = 56,
	.result = -1,
	.comment = "dropping value of integer, tcId is 116 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 208 for ECDSA, tcId is 119 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_208_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_208_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_208_sig[] = {
	0x02, 0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_208 = {
	.name = "ecdsa_brainpoolp224r1_sha224_208",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_208_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_208_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_208_sig,
	.siglen = 57,
	.result = -1,
	.comment = "modify first byte of integer, tcId is 119 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 209 for ECDSA, tcId is 120 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_209_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_209_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_209_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0x02, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_209 = {
	.name = "ecdsa_brainpoolp224r1_sha224_209",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_209_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_209_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_209_sig,
	.siglen = 57,
	.result = -1,
	.comment = "modify first byte of integer, tcId is 120 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 210 for ECDSA, tcId is 121 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_210_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_210_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_210_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0x53, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_210 = {
	.name = "ecdsa_brainpoolp224r1_sha224_210",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_210_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_210_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_210_sig,
	.siglen = 56,
	.result = -1,
	.comment = "modify last byte of integer, tcId is 121 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 211 for ECDSA, tcId is 122 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_211_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_211_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_211_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x90, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_211 = {
	.name = "ecdsa_brainpoolp224r1_sha224_211",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_211_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_211_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_211_sig,
	.siglen = 56,
	.result = -1,
	.comment = "modify last byte of integer, tcId is 122 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 212 for ECDSA, tcId is 123 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_212_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_212_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_212_sig[] = {
	0x00, 0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_212 = {
	.name = "ecdsa_brainpoolp224r1_sha224_212",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_212_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_212_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_212_sig,
	.siglen = 56,
	.result = -1,
	.comment = "truncated integer, tcId is 123 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 213 for ECDSA, tcId is 124 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_213_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_213_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_213_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0x00, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_213 = {
	.name = "ecdsa_brainpoolp224r1_sha224_213",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_213_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_213_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_213_sig,
	.siglen = 56,
	.result = -1,
	.comment = "truncated integer, tcId is 124 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 214 for ECDSA, tcId is 125 in file ecdsa_brainpoolP224r1_sha224_test.json  [!!!WARNING: this test has been patched from 'invalid' to 'acceptable' due to lax DER parser] */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_214_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_214_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_214_sig[] = {
	0x00, 0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_214 = {
	.name = "ecdsa_brainpoolp224r1_sha224_214",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_214_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_214_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_214_sig,
	.siglen = 57,
	.result = 0,
	.comment = "leading ff in integer, tcId is 125 in file ecdsa_brainpoolP224r1_sha224_test.json [!!!WARNING: this test has been patched from 'invalid' to 'acceptable' due to lax DER parser]",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 215 for ECDSA, tcId is 126 in file ecdsa_brainpoolP224r1_sha224_test.json  [!!!WARNING: this test has been patched from 'invalid' to 'acceptable' due to lax DER parser] */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_215_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_215_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_215_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0x00, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_215 = {
	.name = "ecdsa_brainpoolp224r1_sha224_215",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_215_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_215_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_215_sig,
	.siglen = 57,
	.result = 0,
	.comment = "leading ff in integer, tcId is 126 in file ecdsa_brainpoolP224r1_sha224_test.json [!!!WARNING: this test has been patched from 'invalid' to 'acceptable' due to lax DER parser]",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 216 for ECDSA, tcId is 129 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_216_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_216_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_216_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_216 = {
	.name = "ecdsa_brainpoolp224r1_sha224_216",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_216_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_216_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_216_sig,
	.siglen = 56,
	.result = -1,
	.comment = "replacing integer with zero, tcId is 129 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 217 for ECDSA, tcId is 130 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_217_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_217_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_217_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_217 = {
	.name = "ecdsa_brainpoolp224r1_sha224_217",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_217_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_217_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_217_sig,
	.siglen = 56,
	.result = -1,
	.comment = "replacing integer with zero, tcId is 130 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 218 for ECDSA, tcId is 131 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_218_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_218_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_218_sig[] = {
	0x01, 0xa3, 0x29, 0xe1, 0x41, 0x8c, 0x0a, 0xca, 0x9d, 0xaf, 0xf7, 0x53, 0xa4, 0x0f, 0x22, 0xdc, 0xdb, 0x66, 0x98, 0x43, 0xe6, 0x60, 0x41, 0xd1, 0x03, 0xaa, 0x30, 0xf5, 0x72, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_218 = {
	.name = "ecdsa_brainpoolp224r1_sha224_218",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_218_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_218_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_218_sig,
	.siglen = 57,
	.result = -1,
	.comment = "Modified r or s, e.g. by adding or subtracting the order of the group, tcId is 131 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 219 for ECDSA, tcId is 132 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_219_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_219_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_219_sig[] = {
	0xf3, 0xa7, 0x77, 0xed, 0x3f, 0x83, 0xfd, 0x91, 0x5b, 0xc6, 0xf3, 0x59, 0x23, 0x80, 0xe5, 0xa9, 0xc4, 0x6a, 0xcb, 0x4f, 0x84, 0x84, 0x57, 0xbc, 0x5e, 0xe1, 0xce, 0x34, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_219 = {
	.name = "ecdsa_brainpoolp224r1_sha224_219",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_219_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_219_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_219_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Modified r or s, e.g. by adding or subtracting the order of the group, tcId is 132 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 220 for ECDSA, tcId is 133 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_220_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_220_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_220_sig[] = {
	0x34, 0x97, 0x53, 0x68, 0x9a, 0x38, 0x9b, 0xe8, 0x7a, 0x20, 0xdc, 0x81, 0x66, 0xae, 0x1e, 0xbd, 0x6a, 0x7e, 0x78, 0x65, 0x0d, 0x9c, 0xeb, 0x9f, 0xfb, 0x76, 0x9e, 0x2d, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_220 = {
	.name = "ecdsa_brainpoolp224r1_sha224_220",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_220_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_220_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_220_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Modified r or s, e.g. by adding or subtracting the order of the group, tcId is 133 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 221 for ECDSA, tcId is 134 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_221_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_221_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_221_sig[] = {
	0x0c, 0x58, 0x88, 0x12, 0xc0, 0x7c, 0x02, 0x6e, 0xa4, 0x39, 0x0c, 0xa6, 0xdc, 0x7f, 0x1a, 0x56, 0x3b, 0x95, 0x34, 0xb0, 0x7b, 0x7b, 0xa8, 0x43, 0xa1, 0x1e, 0x31, 0xcc, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_221 = {
	.name = "ecdsa_brainpoolp224r1_sha224_221",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_221_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_221_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_221_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Modified r or s, e.g. by adding or subtracting the order of the group, tcId is 134 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 222 for ECDSA, tcId is 135 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_222_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_222_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_222_sig[] = {
	0xfe, 0x5c, 0xd6, 0x1e, 0xbe, 0x73, 0xf5, 0x35, 0x62, 0x50, 0x08, 0xac, 0x5b, 0xf0, 0xdd, 0x23, 0x24, 0x99, 0x67, 0xbc, 0x19, 0x9f, 0xbe, 0x2e, 0xfc, 0x55, 0xcf, 0x0a, 0x8e, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_222 = {
	.name = "ecdsa_brainpoolp224r1_sha224_222",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_222_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_222_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_222_sig,
	.siglen = 57,
	.result = -1,
	.comment = "Modified r or s, e.g. by adding or subtracting the order of the group, tcId is 135 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 223 for ECDSA, tcId is 136 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_223_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_223_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_223_sig[] = {
	0x01, 0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_223 = {
	.name = "ecdsa_brainpoolp224r1_sha224_223",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_223_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_223_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_223_sig,
	.siglen = 57,
	.result = -1,
	.comment = "Modified r or s, e.g. by adding or subtracting the order of the group, tcId is 136 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 224 for ECDSA, tcId is 137 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_224_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_224_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_224_sig[] = {
	0x34, 0x97, 0x53, 0x68, 0x9a, 0x38, 0x9b, 0xe8, 0x7a, 0x20, 0xdc, 0x81, 0x66, 0xae, 0x1e, 0xbd, 0x6a, 0x7e, 0x78, 0x65, 0x0d, 0x9c, 0xeb, 0x9f, 0xfb, 0x76, 0x9e, 0x2d, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_224 = {
	.name = "ecdsa_brainpoolp224r1_sha224_224",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_224_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_224_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_224_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Modified r or s, e.g. by adding or subtracting the order of the group, tcId is 137 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 225 for ECDSA, tcId is 138 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_225_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_225_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_225_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0x01, 0x9b, 0xe5, 0xf1, 0x30, 0x12, 0x18, 0x96, 0x2b, 0x2f, 0x5a, 0x6a, 0x69, 0xa0, 0x55, 0x3e, 0xbc, 0x57, 0x6f, 0x86, 0x86, 0xea, 0x18, 0x77, 0x71, 0xe4, 0xe4, 0xe4, 0xaf, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_225 = {
	.name = "ecdsa_brainpoolp224r1_sha224_225",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_225_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_225_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_225_sig,
	.siglen = 57,
	.result = -1,
	.comment = "Modified r or s, e.g. by adding or subtracting the order of the group, tcId is 138 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 226 for ECDSA, tcId is 139 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_226_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_226_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_226_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0xec, 0x63, 0x87, 0xdb, 0xc5, 0x91, 0xc9, 0x1e, 0xdb, 0x2a, 0x0a, 0x1e, 0xb4, 0xb3, 0x47, 0x8a, 0xb5, 0x42, 0x0d, 0xf0, 0x0e, 0x5a, 0xfe, 0x2a, 0x99, 0x95, 0xbd, 0x71, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_226 = {
	.name = "ecdsa_brainpoolp224r1_sha224_226",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_226_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_226_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_226_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Modified r or s, e.g. by adding or subtracting the order of the group, tcId is 139 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 227 for ECDSA, tcId is 140 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_227_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_227_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_227_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0x3b, 0xdb, 0x43, 0x7a, 0x14, 0x2a, 0xd0, 0x5a, 0xfa, 0xbd, 0xc5, 0xbb, 0xd5, 0x7b, 0xbc, 0xdc, 0x79, 0xa7, 0x35, 0xc4, 0x83, 0xc6, 0x45, 0x31, 0xc0, 0xc2, 0xae, 0xf0, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_227 = {
	.name = "ecdsa_brainpoolp224r1_sha224_227",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_227_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_227_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_227_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Modified r or s, e.g. by adding or subtracting the order of the group, tcId is 140 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 228 for ECDSA, tcId is 141 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_228_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_228_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_228_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0xfe, 0x64, 0x1a, 0x0e, 0xcf, 0xed, 0xe7, 0x69, 0xd4, 0xd0, 0xa5, 0x95, 0x96, 0x5f, 0xaa, 0xc1, 0x43, 0xa8, 0x90, 0x79, 0x79, 0x15, 0xe7, 0x88, 0x8e, 0x1b, 0x1b, 0x1b, 0x51, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_228 = {
	.name = "ecdsa_brainpoolp224r1_sha224_228",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_228_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_228_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_228_sig,
	.siglen = 57,
	.result = -1,
	.comment = "Modified r or s, e.g. by adding or subtracting the order of the group, tcId is 141 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 229 for ECDSA, tcId is 142 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_229_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_229_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_229_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0x01, 0xc4, 0x24, 0xbc, 0x85, 0xeb, 0xd5, 0x2f, 0xa5, 0x05, 0x42, 0x3a, 0x44, 0x2a, 0x84, 0x43, 0x23, 0x86, 0x58, 0xca, 0x3b, 0x7c, 0x39, 0xba, 0xce, 0x3f, 0x3d, 0x51, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_229 = {
	.name = "ecdsa_brainpoolp224r1_sha224_229",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_229_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_229_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_229_sig,
	.siglen = 57,
	.result = -1,
	.comment = "Modified r or s, e.g. by adding or subtracting the order of the group, tcId is 142 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 230 for ECDSA, tcId is 143 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_230_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_230_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_230_sig[] = {
	0xcb, 0x68, 0xac, 0x97, 0x65, 0xc7, 0x64, 0x17, 0x85, 0xdf, 0x23, 0x7e, 0x99, 0x51, 0xe1, 0x42, 0x95, 0x81, 0x87, 0x9a, 0xf2, 0x63, 0x14, 0x60, 0x04, 0x89, 0x61, 0xd3, 0x3b, 0xdb, 0x43, 0x7a, 0x14, 0x2a, 0xd0, 0x5a, 0xfa, 0xbd, 0xc5, 0xbb, 0xd5, 0x7b, 0xbc, 0xdc, 0x79, 0xa7, 0x35, 0xc4, 0x83, 0xc6, 0x45, 0x31, 0xc0, 0xc2, 0xae, 0xf0, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_230 = {
	.name = "ecdsa_brainpoolp224r1_sha224_230",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_230_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_230_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_230_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Modified r or s, e.g. by adding or subtracting the order of the group, tcId is 143 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 231 for ECDSA, tcId is 144 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_231_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_231_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_231_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_231 = {
	.name = "ecdsa_brainpoolp224r1_sha224_231",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_231_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_231_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_231_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 144 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 232 for ECDSA, tcId is 145 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_232_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_232_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_232_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_232 = {
	.name = "ecdsa_brainpoolp224r1_sha224_232",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_232_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_232_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_232_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 145 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 233 for ECDSA, tcId is 146 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_233_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_233_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_233_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_233 = {
	.name = "ecdsa_brainpoolp224r1_sha224_233",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_233_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_233_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_233_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 146 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 234 for ECDSA, tcId is 147 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_234_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_234_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_234_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_234 = {
	.name = "ecdsa_brainpoolp224r1_sha224_234",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_234_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_234_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_234_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 147 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 235 for ECDSA, tcId is 148 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_235_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_235_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_235_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_235 = {
	.name = "ecdsa_brainpoolp224r1_sha224_235",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_235_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_235_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_235_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 148 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 236 for ECDSA, tcId is 149 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_236_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_236_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_236_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_236 = {
	.name = "ecdsa_brainpoolp224r1_sha224_236",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_236_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_236_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_236_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 149 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 237 for ECDSA, tcId is 150 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_237_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_237_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_237_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_237 = {
	.name = "ecdsa_brainpoolp224r1_sha224_237",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_237_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_237_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_237_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 150 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 238 for ECDSA, tcId is 151 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_238_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_238_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_238_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_238 = {
	.name = "ecdsa_brainpoolp224r1_sha224_238",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_238_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_238_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_238_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 151 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 239 for ECDSA, tcId is 154 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_239_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_239_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_239_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_239 = {
	.name = "ecdsa_brainpoolp224r1_sha224_239",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_239_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_239_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_239_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 154 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 240 for ECDSA, tcId is 155 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_240_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_240_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_240_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_240 = {
	.name = "ecdsa_brainpoolp224r1_sha224_240",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_240_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_240_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_240_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 155 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 241 for ECDSA, tcId is 156 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_241_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_241_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_241_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_241 = {
	.name = "ecdsa_brainpoolp224r1_sha224_241",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_241_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_241_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_241_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 156 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 242 for ECDSA, tcId is 157 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_242_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_242_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_242_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_242 = {
	.name = "ecdsa_brainpoolp224r1_sha224_242",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_242_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_242_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_242_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 157 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 243 for ECDSA, tcId is 158 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_243_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_243_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_243_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_243 = {
	.name = "ecdsa_brainpoolp224r1_sha224_243",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_243_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_243_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_243_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 158 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 244 for ECDSA, tcId is 159 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_244_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_244_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_244_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_244 = {
	.name = "ecdsa_brainpoolp224r1_sha224_244",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_244_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_244_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_244_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 159 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 245 for ECDSA, tcId is 160 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_245_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_245_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_245_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_245 = {
	.name = "ecdsa_brainpoolp224r1_sha224_245",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_245_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_245_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_245_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 160 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 246 for ECDSA, tcId is 161 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_246_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_246_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_246_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_246 = {
	.name = "ecdsa_brainpoolp224r1_sha224_246",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_246_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_246_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_246_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 161 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 247 for ECDSA, tcId is 164 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_247_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_247_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_247_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_247 = {
	.name = "ecdsa_brainpoolp224r1_sha224_247",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_247_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_247_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_247_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 164 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 248 for ECDSA, tcId is 165 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_248_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_248_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_248_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_248 = {
	.name = "ecdsa_brainpoolp224r1_sha224_248",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_248_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_248_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_248_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 165 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 249 for ECDSA, tcId is 166 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_249_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_249_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_249_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_249 = {
	.name = "ecdsa_brainpoolp224r1_sha224_249",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_249_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_249_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_249_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 166 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 250 for ECDSA, tcId is 167 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_250_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_250_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_250_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_250 = {
	.name = "ecdsa_brainpoolp224r1_sha224_250",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_250_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_250_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_250_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 167 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 251 for ECDSA, tcId is 168 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_251_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_251_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_251_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_251 = {
	.name = "ecdsa_brainpoolp224r1_sha224_251",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_251_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_251_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_251_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 168 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 252 for ECDSA, tcId is 169 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_252_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_252_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_252_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_252 = {
	.name = "ecdsa_brainpoolp224r1_sha224_252",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_252_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_252_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_252_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 169 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 253 for ECDSA, tcId is 170 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_253_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_253_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_253_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_253 = {
	.name = "ecdsa_brainpoolp224r1_sha224_253",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_253_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_253_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_253_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 170 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 254 for ECDSA, tcId is 171 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_254_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_254_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_254_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_254 = {
	.name = "ecdsa_brainpoolp224r1_sha224_254",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_254_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_254_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_254_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 171 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 255 for ECDSA, tcId is 174 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_255_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_255_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_255_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_255 = {
	.name = "ecdsa_brainpoolp224r1_sha224_255",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_255_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_255_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_255_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 174 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 256 for ECDSA, tcId is 175 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_256_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_256_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_256_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_256 = {
	.name = "ecdsa_brainpoolp224r1_sha224_256",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_256_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_256_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_256_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 175 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 257 for ECDSA, tcId is 176 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_257_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_257_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_257_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_257 = {
	.name = "ecdsa_brainpoolp224r1_sha224_257",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_257_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_257_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_257_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 176 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 258 for ECDSA, tcId is 177 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_258_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_258_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_258_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_258 = {
	.name = "ecdsa_brainpoolp224r1_sha224_258",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_258_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_258_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_258_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 177 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 259 for ECDSA, tcId is 178 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_259_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_259_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_259_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_259 = {
	.name = "ecdsa_brainpoolp224r1_sha224_259",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_259_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_259_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_259_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 178 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 260 for ECDSA, tcId is 179 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_260_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_260_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_260_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_260 = {
	.name = "ecdsa_brainpoolp224r1_sha224_260",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_260_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_260_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_260_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 179 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 261 for ECDSA, tcId is 180 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_261_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_261_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_261_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_261 = {
	.name = "ecdsa_brainpoolp224r1_sha224_261",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_261_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_261_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_261_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 180 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 262 for ECDSA, tcId is 181 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_262_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_262_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_262_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_262 = {
	.name = "ecdsa_brainpoolp224r1_sha224_262",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_262_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_262_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_262_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 181 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 263 for ECDSA, tcId is 184 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_263_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_263_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_263_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_263 = {
	.name = "ecdsa_brainpoolp224r1_sha224_263",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_263_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_263_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_263_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 184 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 264 for ECDSA, tcId is 185 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_264_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_264_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_264_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_264 = {
	.name = "ecdsa_brainpoolp224r1_sha224_264",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_264_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_264_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_264_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 185 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 265 for ECDSA, tcId is 186 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_265_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_265_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_265_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_265 = {
	.name = "ecdsa_brainpoolp224r1_sha224_265",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_265_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_265_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_265_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 186 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 266 for ECDSA, tcId is 187 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_266_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_266_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_266_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_266 = {
	.name = "ecdsa_brainpoolp224r1_sha224_266",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_266_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_266_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_266_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 187 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 267 for ECDSA, tcId is 188 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_267_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_267_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_267_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_267 = {
	.name = "ecdsa_brainpoolp224r1_sha224_267",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_267_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_267_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_267_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 188 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 268 for ECDSA, tcId is 189 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_268_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_268_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_268_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_268 = {
	.name = "ecdsa_brainpoolp224r1_sha224_268",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_268_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_268_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_268_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 189 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 269 for ECDSA, tcId is 190 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_269_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_269_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_269_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_269 = {
	.name = "ecdsa_brainpoolp224r1_sha224_269",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_269_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_269_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_269_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 190 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 270 for ECDSA, tcId is 191 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_270_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_270_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_270_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_270 = {
	.name = "ecdsa_brainpoolp224r1_sha224_270",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_270_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_270_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_270_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 191 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 271 for ECDSA, tcId is 194 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_271_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_271_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_271_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_271 = {
	.name = "ecdsa_brainpoolp224r1_sha224_271",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_271_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_271_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_271_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 194 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 272 for ECDSA, tcId is 195 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_272_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_272_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_272_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_272 = {
	.name = "ecdsa_brainpoolp224r1_sha224_272",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_272_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_272_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_272_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 195 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 273 for ECDSA, tcId is 196 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_273_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_273_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_273_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_273 = {
	.name = "ecdsa_brainpoolp224r1_sha224_273",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_273_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_273_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_273_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 196 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 274 for ECDSA, tcId is 197 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_274_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_274_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_274_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_274 = {
	.name = "ecdsa_brainpoolp224r1_sha224_274",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_274_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_274_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_274_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 197 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 275 for ECDSA, tcId is 198 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_275_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_275_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_275_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_275 = {
	.name = "ecdsa_brainpoolp224r1_sha224_275",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_275_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_275_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_275_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 198 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 276 for ECDSA, tcId is 199 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_276_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_276_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_276_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_276 = {
	.name = "ecdsa_brainpoolp224r1_sha224_276",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_276_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_276_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_276_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 199 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 277 for ECDSA, tcId is 200 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_277_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_277_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_277_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_277 = {
	.name = "ecdsa_brainpoolp224r1_sha224_277",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_277_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_277_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_277_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 200 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 278 for ECDSA, tcId is 201 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_278_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_278_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_278_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_278 = {
	.name = "ecdsa_brainpoolp224r1_sha224_278",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_278_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_278_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_278_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 201 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 279 for ECDSA, tcId is 204 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_279_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_279_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_279_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_279 = {
	.name = "ecdsa_brainpoolp224r1_sha224_279",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_279_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_279_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_279_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 204 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 280 for ECDSA, tcId is 205 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_280_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_280_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_280_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_280 = {
	.name = "ecdsa_brainpoolp224r1_sha224_280",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_280_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_280_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_280_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 205 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 281 for ECDSA, tcId is 206 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_281_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_281_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_281_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_281 = {
	.name = "ecdsa_brainpoolp224r1_sha224_281",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_281_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_281_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_281_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 206 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 282 for ECDSA, tcId is 207 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_282_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_282_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_282_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_282 = {
	.name = "ecdsa_brainpoolp224r1_sha224_282",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_282_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_282_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_282_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 207 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 283 for ECDSA, tcId is 208 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_283_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_283_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_283_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_283 = {
	.name = "ecdsa_brainpoolp224r1_sha224_283",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_283_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_283_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_283_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 208 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 284 for ECDSA, tcId is 209 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_284_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_284_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_284_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_284 = {
	.name = "ecdsa_brainpoolp224r1_sha224_284",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_284_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_284_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_284_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 209 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 285 for ECDSA, tcId is 210 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_285_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_285_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_285_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_285 = {
	.name = "ecdsa_brainpoolp224r1_sha224_285",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_285_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_285_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_285_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 210 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 286 for ECDSA, tcId is 211 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_286_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_286_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_286_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_286 = {
	.name = "ecdsa_brainpoolp224r1_sha224_286",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_286_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_286_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_286_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 211 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 287 for ECDSA, tcId is 214 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_287_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_287_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_287_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_287 = {
	.name = "ecdsa_brainpoolp224r1_sha224_287",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_287_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_287_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_287_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 214 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 288 for ECDSA, tcId is 215 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_288_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_288_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_288_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_288 = {
	.name = "ecdsa_brainpoolp224r1_sha224_288",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_288_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_288_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_288_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 215 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 289 for ECDSA, tcId is 216 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_289_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_289_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_289_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_289 = {
	.name = "ecdsa_brainpoolp224r1_sha224_289",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_289_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_289_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_289_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 216 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 290 for ECDSA, tcId is 217 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_290_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_290_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_290_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_290 = {
	.name = "ecdsa_brainpoolp224r1_sha224_290",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_290_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_290_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_290_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 217 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 291 for ECDSA, tcId is 218 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_291_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_291_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_291_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_291 = {
	.name = "ecdsa_brainpoolp224r1_sha224_291",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_291_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_291_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_291_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 218 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 292 for ECDSA, tcId is 219 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_292_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_292_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_292_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_292 = {
	.name = "ecdsa_brainpoolp224r1_sha224_292",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_292_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_292_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_292_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 219 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 293 for ECDSA, tcId is 220 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_293_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_293_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_293_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_293 = {
	.name = "ecdsa_brainpoolp224r1_sha224_293",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_293_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_293_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_293_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 220 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 294 for ECDSA, tcId is 221 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_294_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_294_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_294_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc1, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_294 = {
	.name = "ecdsa_brainpoolp224r1_sha224_294",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_294_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_294_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_294_sig,
	.siglen = 56,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 221 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 295 for ECDSA, tcId is 230 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_295_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_295_msg[] = {
	0x39, 0x35, 0x33, 0x38, 0x38, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_295_sig[] = {
	0x0e, 0x7e, 0xca, 0xb2, 0x27, 0x6f, 0x03, 0x5c, 0x0d, 0xc7, 0x05, 0x20, 0xeb, 0xd5, 0xae, 0x3c, 0xb7, 0xb7, 0xa8, 0xf2, 0x1f, 0xa5, 0x68, 0x7e, 0xee, 0x92, 0xc4, 0x62, 0x85, 0xa8, 0x53, 0x32, 0xf8, 0xc8, 0x99, 0xb5, 0x3d, 0x43, 0x09, 0x1b, 0x02, 0xe6, 0x95, 0x6b, 0x39, 0x18, 0x17, 0xe1, 0x75, 0xa8, 0xb1, 0xf4, 0x0d, 0xca, 0x7e, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_295 = {
	.name = "ecdsa_brainpoolp224r1_sha224_295",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_295_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_295_msg,
	.msglen = 5,
	.sig = ecdsa_brainpoolp224r1_sha224_295_sig,
	.siglen = 56,
	.result = 1,
	.comment = "Edge case for Shamir multiplication, tcId is 230 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 296 for ECDSA, tcId is 231 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_296_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_296_msg[] = {
	0x32, 0x32, 0x35, 0x34, 0x36, 0x32, 0x38, 0x39, 0x38, 0x34, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_296_sig[] = {
	0x2f, 0xc2, 0xef, 0x9f, 0x76, 0x63, 0xf6, 0x6f, 0x13, 0xb0, 0x4e, 0x49, 0xf2, 0x06, 0xc2, 0x24, 0x41, 0xeb, 0x3e, 0xe1, 0x91, 0x7b, 0x8b, 0xf8, 0x1a, 0x9b, 0x53, 0x76, 0xd1, 0xdf, 0x3d, 0xd0, 0x27, 0x0e, 0x58, 0x84, 0xe9, 0x84, 0x8e, 0xa2, 0x81, 0x2b, 0x66, 0xf5, 0x01, 0x5b, 0xe9, 0x6d, 0x25, 0x85, 0xfe, 0xd3, 0x95, 0x7b, 0x31, 0x3c, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_296 = {
	.name = "ecdsa_brainpoolp224r1_sha224_296",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_296_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_296_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_296_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 231 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 297 for ECDSA, tcId is 232 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_297_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_297_msg[] = {
	0x31, 0x38, 0x32, 0x37, 0x38, 0x37, 0x38, 0x36, 0x31, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_297_sig[] = {
	0xc6, 0x82, 0x58, 0x7b, 0xf4, 0x3e, 0x0c, 0x95, 0x4e, 0xb5, 0x8b, 0xbc, 0xfe, 0xb9, 0x4d, 0xfa, 0xc8, 0xba, 0xd4, 0x04, 0x99, 0x5a, 0xc2, 0x6e, 0x8e, 0x51, 0xff, 0x20, 0x92, 0xbf, 0x10, 0xda, 0x10, 0x32, 0x4c, 0xc3, 0x22, 0xf7, 0x9c, 0x41, 0x2d, 0xae, 0xd3, 0x05, 0xb2, 0x75, 0xfc, 0x19, 0x93, 0xbf, 0x3a, 0xf5, 0x23, 0xde, 0xd6, 0x2a, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_297 = {
	.name = "ecdsa_brainpoolp224r1_sha224_297",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_297_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_297_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_297_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 232 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 298 for ECDSA, tcId is 233 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_298_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_298_msg[] = {
	0x31, 0x35, 0x31, 0x38, 0x38, 0x36, 0x31, 0x37, 0x30, 0x39, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_298_sig[] = {
	0x02, 0x5d, 0x1c, 0xf1, 0x6f, 0x03, 0x34, 0x1f, 0x3c, 0x8d, 0x16, 0xa7, 0x78, 0x39, 0xb5, 0xc1, 0xd6, 0x96, 0x36, 0x3d, 0xae, 0x89, 0x8d, 0x91, 0xe1, 0x4a, 0xd5, 0x22, 0xb7, 0x37, 0x9c, 0xc3, 0x5c, 0x97, 0xa8, 0xf0, 0x8b, 0x0e, 0xfb, 0x32, 0xee, 0x82, 0xce, 0x0e, 0x19, 0x11, 0x69, 0x5d, 0x37, 0x2e, 0xe6, 0xd6, 0x79, 0xec, 0x54, 0x66, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_298 = {
	.name = "ecdsa_brainpoolp224r1_sha224_298",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_298_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_298_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_298_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 233 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 299 for ECDSA, tcId is 234 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_299_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_299_msg[] = {
	0x32, 0x31, 0x32, 0x39, 0x32, 0x33, 0x33, 0x34, 0x32, 0x32, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_299_sig[] = {
	0xc0, 0xc9, 0x49, 0xe0, 0xf0, 0xf8, 0x57, 0x18, 0x02, 0xea, 0x7e, 0x02, 0x61, 0x7c, 0xa9, 0x25, 0xb9, 0x5d, 0x29, 0x0a, 0x17, 0x4f, 0x68, 0x6d, 0x80, 0xbb, 0xa1, 0xd4, 0xb9, 0x66, 0x17, 0x3c, 0xe3, 0xf1, 0x3c, 0xa5, 0x4c, 0xcd, 0xc8, 0xa2, 0x49, 0xfe, 0xa7, 0x2e, 0x32, 0x60, 0xad, 0x3e, 0x78, 0x54, 0xa7, 0x31, 0x05, 0x1d, 0x8c, 0x03, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_299 = {
	.name = "ecdsa_brainpoolp224r1_sha224_299",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_299_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_299_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_299_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 234 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 300 for ECDSA, tcId is 235 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_300_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_300_msg[] = {
	0x31, 0x32, 0x32, 0x31, 0x39, 0x37, 0x39, 0x30, 0x35, 0x39, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_300_sig[] = {
	0x5d, 0x57, 0xf1, 0x42, 0x75, 0x94, 0x7c, 0x9b, 0xff, 0xea, 0x66, 0xf9, 0xf3, 0x0a, 0xe2, 0x03, 0x19, 0x45, 0x35, 0xf8, 0x02, 0x0c, 0x42, 0xbb, 0xc1, 0xef, 0xec, 0x73, 0xc3, 0x58, 0x65, 0x1b, 0xa2, 0x52, 0x7c, 0x32, 0xd8, 0x58, 0x65, 0x7c, 0xcf, 0x08, 0xe5, 0x35, 0xd3, 0x28, 0x51, 0xfb, 0xd8, 0xc3, 0x54, 0x77, 0xba, 0x17, 0x56, 0x80, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_300 = {
	.name = "ecdsa_brainpoolp224r1_sha224_300",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_300_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_300_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_300_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 235 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 301 for ECDSA, tcId is 236 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_301_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_301_msg[] = {
	0x32, 0x33, 0x30, 0x32, 0x35, 0x36, 0x37, 0x36, 0x31, 0x31, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_301_sig[] = {
	0x13, 0x3b, 0xb1, 0x2f, 0x10, 0x96, 0x98, 0x9d, 0xc8, 0x67, 0xd8, 0x74, 0xf6, 0x75, 0xfd, 0xf9, 0xe9, 0x79, 0x75, 0xc2, 0xe2, 0x2c, 0x71, 0xe4, 0x4f, 0x59, 0xbf, 0x35, 0x65, 0x57, 0xee, 0xb2, 0xb5, 0xb4, 0xf1, 0xf7, 0xc8, 0x51, 0x84, 0xdc, 0xc6, 0x53, 0x85, 0x0c, 0x34, 0xb1, 0xc3, 0x48, 0x0d, 0x2f, 0x32, 0xd1, 0x56, 0x7c, 0x25, 0xc1, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_301 = {
	.name = "ecdsa_brainpoolp224r1_sha224_301",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_301_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_301_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_301_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 236 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 302 for ECDSA, tcId is 237 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_302_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_302_msg[] = {
	0x31, 0x31, 0x30, 0x35, 0x38, 0x36, 0x38, 0x34, 0x37, 0x32, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_302_sig[] = {
	0xd1, 0xdc, 0x7d, 0x1c, 0xc8, 0x86, 0xca, 0x90, 0xe0, 0xd9, 0x60, 0xb6, 0xc7, 0xfd, 0xa9, 0x2e, 0xd5, 0x82, 0xec, 0x61, 0x6c, 0x1c, 0x79, 0xb1, 0x71, 0xef, 0x31, 0x08, 0x41, 0xa7, 0xd2, 0x14, 0x38, 0xe7, 0xc3, 0x4b, 0x27, 0x17, 0x60, 0x05, 0xef, 0x67, 0xc0, 0x4a, 0x63, 0xf3, 0x62, 0xd2, 0xda, 0xf1, 0x0b, 0x62, 0xc5, 0x3b, 0x88, 0xb4, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_302 = {
	.name = "ecdsa_brainpoolp224r1_sha224_302",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_302_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_302_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_302_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 237 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 303 for ECDSA, tcId is 238 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_303_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_303_msg[] = {
	0x31, 0x34, 0x36, 0x36, 0x36, 0x31, 0x34, 0x34, 0x34, 0x32, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_303_sig[] = {
	0x9e, 0xc3, 0xb7, 0xb4, 0xa0, 0xf1, 0x23, 0x51, 0x69, 0xb6, 0x4a, 0x20, 0x58, 0x4d, 0x36, 0xb9, 0x6b, 0xb7, 0xa2, 0xbd, 0xe0, 0x0d, 0x23, 0x16, 0x3c, 0xc3, 0xb1, 0xbf, 0xac, 0x32, 0xef, 0x3b, 0x9e, 0x94, 0x8d, 0x96, 0x7f, 0x96, 0xcd, 0x08, 0x50, 0x78, 0x09, 0xe3, 0xb9, 0xa0, 0xe0, 0x93, 0xbe, 0x3e, 0x76, 0xb8, 0x18, 0x33, 0x1d, 0xd5, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_303 = {
	.name = "ecdsa_brainpoolp224r1_sha224_303",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_303_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_303_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_303_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 238 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 304 for ECDSA, tcId is 239 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_304_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_304_msg[] = {
	0x34, 0x34, 0x31, 0x39, 0x35, 0x36, 0x34, 0x32, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_304_sig[] = {
	0x39, 0x2a, 0xe3, 0x81, 0xda, 0x4c, 0xcf, 0xd9, 0xd5, 0xad, 0x09, 0x3d, 0x49, 0xb2, 0x2d, 0x57, 0x94, 0x11, 0xf7, 0xc1, 0xcd, 0x04, 0xe8, 0x84, 0x73, 0xab, 0x6e, 0xf5, 0xa2, 0x89, 0x8b, 0x8b, 0xf1, 0x20, 0xd1, 0x8e, 0x4e, 0xe0, 0xd1, 0x5c, 0x41, 0x90, 0x44, 0x32, 0x4d, 0xe3, 0xc0, 0x92, 0x7e, 0xe9, 0x0f, 0xd6, 0xf3, 0x87, 0x11, 0xf4, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_304 = {
	.name = "ecdsa_brainpoolp224r1_sha224_304",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_304_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_304_msg,
	.msglen = 9,
	.sig = ecdsa_brainpoolp224r1_sha224_304_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 239 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 305 for ECDSA, tcId is 240 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_305_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_305_msg[] = {
	0x31, 0x39, 0x36, 0x39, 0x34, 0x38, 0x36, 0x30, 0x36, 0x34, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_305_sig[] = {
	0xa3, 0x7b, 0x0c, 0xc8, 0x7f, 0x6d, 0x46, 0x20, 0x30, 0x30, 0x30, 0xd7, 0xac, 0x4a, 0x65, 0x72, 0xf9, 0x4c, 0x0c, 0xf4, 0x4f, 0x0a, 0x03, 0x5c, 0x0e, 0x59, 0xd0, 0x7c, 0x30, 0xc7, 0xac, 0xd8, 0xdb, 0x9e, 0x72, 0x01, 0x22, 0x08, 0xf0, 0x8d, 0xb5, 0x38, 0x1a, 0x1e, 0x54, 0xfa, 0x09, 0x8c, 0x03, 0x14, 0xa0, 0x9a, 0x30, 0x58, 0xc4, 0x21, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_305 = {
	.name = "ecdsa_brainpoolp224r1_sha224_305",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_305_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_305_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_305_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 240 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 306 for ECDSA, tcId is 241 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_306_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_306_msg[] = {
	0x32, 0x32, 0x33, 0x35, 0x36, 0x37, 0x32, 0x38, 0x38, 0x33, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_306_sig[] = {
	0x62, 0xf6, 0x60, 0xd9, 0x3a, 0x45, 0xdf, 0xa3, 0xb6, 0x61, 0xf8, 0xb6, 0xa4, 0xd5, 0xe0, 0x6e, 0x5a, 0x1e, 0xe8, 0xa8, 0x85, 0x5a, 0xba, 0xfa, 0x40, 0x73, 0xb5, 0x13, 0xd6, 0x97, 0x8f, 0x5d, 0xa8, 0xaf, 0xcc, 0x5b, 0x39, 0x5f, 0xd4, 0xb5, 0xf3, 0xc0, 0xfd, 0xb7, 0xa2, 0x68, 0x9e, 0x6d, 0xe4, 0x6d, 0x08, 0xfb, 0x9d, 0xe7, 0x18, 0x60, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_306 = {
	.name = "ecdsa_brainpoolp224r1_sha224_306",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_306_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_306_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_306_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 241 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 307 for ECDSA, tcId is 242 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_307_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_307_msg[] = {
	0x32, 0x32, 0x35, 0x37, 0x38, 0x34, 0x33, 0x37, 0x30, 0x33, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_307_sig[] = {
	0x61, 0xaf, 0x9a, 0x2c, 0xa2, 0x05, 0x03, 0xfd, 0x62, 0xbc, 0x3c, 0x6f, 0x84, 0x34, 0x99, 0x5c, 0x6c, 0xf3, 0x03, 0x7e, 0xb6, 0xf9, 0xff, 0x62, 0x13, 0x48, 0xcf, 0x53, 0x09, 0xf8, 0xf6, 0x47, 0x13, 0x87, 0x69, 0x54, 0x8d, 0xb4, 0x60, 0xef, 0xdd, 0x83, 0x23, 0xf8, 0xca, 0xd1, 0x8a, 0x70, 0x71, 0xd3, 0xd0, 0x4d, 0x6a, 0xd3, 0x3d, 0x82, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_307 = {
	.name = "ecdsa_brainpoolp224r1_sha224_307",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_307_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_307_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_307_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 242 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 308 for ECDSA, tcId is 243 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_308_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_308_msg[] = {
	0x39, 0x34, 0x34, 0x35, 0x30, 0x30, 0x39, 0x34, 0x36, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_308_sig[] = {
	0x0e, 0x45, 0x9c, 0xfe, 0x37, 0x01, 0x7c, 0x8b, 0x60, 0x5e, 0x38, 0xbf, 0x5d, 0x25, 0x17, 0x65, 0x76, 0xd4, 0x75, 0xfa, 0x88, 0xde, 0xd2, 0x7b, 0xe2, 0x6a, 0xbc, 0xa7, 0xb1, 0xbb, 0x6a, 0x60, 0xcc, 0xc3, 0xd4, 0x8e, 0x8d, 0x1d, 0x4c, 0x53, 0xf9, 0x01, 0x42, 0x80, 0x6e, 0x44, 0xd9, 0x94, 0x9e, 0xbc, 0xaa, 0x05, 0xb8, 0x3e, 0x20, 0xf4, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_308 = {
	.name = "ecdsa_brainpoolp224r1_sha224_308",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_308_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_308_msg,
	.msglen = 9,
	.sig = ecdsa_brainpoolp224r1_sha224_308_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 243 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 309 for ECDSA, tcId is 244 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_309_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_309_msg[] = {
	0x31, 0x36, 0x38, 0x37, 0x37, 0x38, 0x39, 0x34, 0x31, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_309_sig[] = {
	0xd0, 0x18, 0x48, 0x82, 0xbd, 0xd6, 0xfa, 0x09, 0x99, 0x6c, 0x2f, 0xec, 0xf3, 0xcd, 0x26, 0xed, 0x86, 0xa3, 0xce, 0x15, 0x98, 0x7e, 0x06, 0xdb, 0x85, 0x0b, 0x8b, 0x2b, 0xcf, 0xf0, 0x72, 0xb2, 0x7c, 0x33, 0xf9, 0x16, 0x81, 0xd3, 0xe9, 0x5a, 0x47, 0xbe, 0xc0, 0x00, 0xcc, 0x96, 0xc5, 0xdc, 0x91, 0xf6, 0x8e, 0xcc, 0xc2, 0x1c, 0xa3, 0xc4, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_309 = {
	.name = "ecdsa_brainpoolp224r1_sha224_309",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_309_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_309_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_309_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 244 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 310 for ECDSA, tcId is 245 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_310_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_310_msg[] = {
	0x33, 0x39, 0x33, 0x32, 0x36, 0x31, 0x32, 0x32, 0x38, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_310_sig[] = {
	0x35, 0x7e, 0x96, 0xab, 0x54, 0xf4, 0xdb, 0xb3, 0xa6, 0xa3, 0xa9, 0xd1, 0xed, 0xe6, 0xdf, 0x52, 0x94, 0x63, 0x9a, 0xed, 0xfd, 0xea, 0x96, 0xe7, 0xff, 0xc9, 0xda, 0x31, 0x24, 0xeb, 0x6b, 0x7f, 0x55, 0x90, 0x67, 0x39, 0x31, 0x3e, 0xa2, 0x66, 0x5a, 0x05, 0x04, 0xa3, 0xb0, 0xbf, 0x7a, 0x9b, 0x32, 0x9c, 0x69, 0x0f, 0x4a, 0x2e, 0xdf, 0x51, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_310 = {
	.name = "ecdsa_brainpoolp224r1_sha224_310",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_310_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_310_msg,
	.msglen = 9,
	.sig = ecdsa_brainpoolp224r1_sha224_310_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 245 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 311 for ECDSA, tcId is 246 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_311_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_311_msg[] = {
	0x31, 0x30, 0x37, 0x33, 0x35, 0x37, 0x31, 0x30, 0x39, 0x35, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_311_sig[] = {
	0x0b, 0xaa, 0xf7, 0x9d, 0x52, 0x35, 0xe3, 0x26, 0x8e, 0x55, 0x43, 0x1c, 0xbd, 0x79, 0x00, 0x46, 0xc2, 0x58, 0x1e, 0xbd, 0x3f, 0x8b, 0x90, 0x62, 0x7b, 0xd4, 0x6b, 0x8b, 0x83, 0xd5, 0x6f, 0x6b, 0x56, 0xca, 0x93, 0x81, 0xb1, 0x4c, 0xa8, 0x88, 0x28, 0x1b, 0x48, 0x1c, 0xf8, 0x28, 0xe9, 0xb4, 0x3b, 0x0d, 0x41, 0x81, 0x08, 0xe8, 0x2d, 0x58, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_311 = {
	.name = "ecdsa_brainpoolp224r1_sha224_311",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_311_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_311_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_311_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 246 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 312 for ECDSA, tcId is 247 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_312_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_312_msg[] = {
	0x36, 0x30, 0x38, 0x38, 0x37, 0x34, 0x37, 0x34, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_312_sig[] = {
	0x7e, 0xbe, 0xf1, 0xad, 0x41, 0xde, 0x94, 0x34, 0xeb, 0x3f, 0x6f, 0x83, 0x33, 0x8f, 0x01, 0x09, 0x66, 0x6c, 0x26, 0x4d, 0x89, 0x12, 0x33, 0x42, 0xb0, 0x90, 0x0f, 0x05, 0x78, 0xa3, 0xa9, 0xfa, 0x72, 0x01, 0xc4, 0x8f, 0x92, 0x83, 0x44, 0x00, 0x4a, 0x1f, 0x51, 0x80, 0x53, 0x09, 0x9d, 0xf8, 0x69, 0x08, 0xde, 0x29, 0xee, 0xb7, 0x6a, 0x4c, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_312 = {
	.name = "ecdsa_brainpoolp224r1_sha224_312",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_312_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_312_msg,
	.msglen = 8,
	.sig = ecdsa_brainpoolp224r1_sha224_312_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 247 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 313 for ECDSA, tcId is 248 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_313_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_313_msg[] = {
	0x31, 0x31, 0x39, 0x32, 0x35, 0x36, 0x39, 0x39, 0x36, 0x32, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_313_sig[] = {
	0x9f, 0x20, 0xab, 0xef, 0xf0, 0xaf, 0x96, 0x5d, 0xa9, 0xc5, 0x1c, 0x99, 0x50, 0x7c, 0xf5, 0xf9, 0x1d, 0x75, 0xf2, 0x3f, 0xe0, 0x2b, 0x61, 0x15, 0x02, 0x96, 0x16, 0x7c, 0xbf, 0x6f, 0xed, 0x8a, 0x8e, 0xf7, 0x26, 0xf2, 0xf6, 0x62, 0x9c, 0x4e, 0x4b, 0x50, 0xb3, 0xc2, 0xce, 0x14, 0xff, 0x43, 0x9f, 0xe9, 0xbf, 0xe6, 0x15, 0x78, 0x68, 0xd4, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_313 = {
	.name = "ecdsa_brainpoolp224r1_sha224_313",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_313_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_313_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_313_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 248 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 314 for ECDSA, tcId is 249 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_314_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_314_msg[] = {
	0x39, 0x30, 0x30, 0x37, 0x36, 0x30, 0x39, 0x33, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_314_sig[] = {
	0x5a, 0xd6, 0x7f, 0xf0, 0xdd, 0xf8, 0xcb, 0x88, 0x40, 0x79, 0x74, 0xf8, 0x3f, 0xea, 0x43, 0xd9, 0xd1, 0x47, 0xcb, 0xb2, 0x3d, 0xba, 0x26, 0x1f, 0xad, 0xad, 0xae, 0xdb, 0x7f, 0xd3, 0x1c, 0xcc, 0x4b, 0x36, 0x05, 0xdb, 0x42, 0xb7, 0x00, 0xa2, 0x45, 0xdf, 0x8f, 0xc6, 0x0e, 0xfb, 0xf1, 0x40, 0x6a, 0xfb, 0x4d, 0x6c, 0x8c, 0x16, 0xe0, 0xa3, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_314 = {
	.name = "ecdsa_brainpoolp224r1_sha224_314",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_314_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_314_msg,
	.msglen = 8,
	.sig = ecdsa_brainpoolp224r1_sha224_314_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 249 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 315 for ECDSA, tcId is 250 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_315_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_315_msg[] = {
	0x31, 0x36, 0x30, 0x32, 0x38, 0x33, 0x36, 0x31, 0x33, 0x37, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_315_sig[] = {
	0x40, 0xe0, 0xbd, 0x9a, 0x2f, 0xa5, 0xa8, 0x86, 0x78, 0xc8, 0x5c, 0x3f, 0x4d, 0x27, 0xe2, 0xae, 0x2d, 0xd0, 0x46, 0xf2, 0x9a, 0x36, 0x39, 0xec, 0x2f, 0xf2, 0x51, 0x1a, 0x16, 0xcd, 0x49, 0x21, 0x5c, 0xb0, 0x05, 0x33, 0xfd, 0x13, 0x9a, 0xe1, 0xd3, 0x63, 0x1d, 0x45, 0xfb, 0x06, 0xd5, 0xec, 0xd1, 0x13, 0x8a, 0xb4, 0x6c, 0x48, 0xa4, 0x5c, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_315 = {
	.name = "ecdsa_brainpoolp224r1_sha224_315",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_315_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_315_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_315_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 250 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 316 for ECDSA, tcId is 251 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_316_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_316_msg[] = {
	0x32, 0x30, 0x38, 0x30, 0x32, 0x34, 0x35, 0x36, 0x37, 0x34, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_316_sig[] = {
	0x9a, 0x70, 0x5d, 0xdc, 0x87, 0x67, 0xe5, 0x4c, 0xec, 0x4d, 0x1c, 0x37, 0xa2, 0x46, 0x0b, 0x3c, 0x0b, 0x31, 0xe9, 0x81, 0x1c, 0x3a, 0x42, 0x75, 0x26, 0x49, 0x9c, 0x01, 0x36, 0xa6, 0xb9, 0xdc, 0xd7, 0xc8, 0xa8, 0x1e, 0x34, 0xaf, 0xdf, 0x84, 0x5c, 0x4c, 0xc0, 0xe7, 0x34, 0x55, 0x01, 0x1b, 0xbc, 0xd7, 0x98, 0x7f, 0x88, 0x72, 0x58, 0xba, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_316 = {
	.name = "ecdsa_brainpoolp224r1_sha224_316",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_316_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_316_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_316_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 251 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 317 for ECDSA, tcId is 252 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_317_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_317_msg[] = {
	0x31, 0x37, 0x39, 0x38, 0x32, 0x37, 0x34, 0x36, 0x35, 0x39, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_317_sig[] = {
	0xa5, 0x1a, 0x62, 0x5b, 0x99, 0x56, 0x8d, 0x00, 0x3e, 0x4b, 0x96, 0xe6, 0x93, 0x13, 0x6b, 0xa7, 0x52, 0x21, 0xe8, 0xe5, 0x6c, 0x9a, 0xb5, 0xe9, 0xec, 0x68, 0x16, 0xee, 0x7e, 0x20, 0x89, 0x18, 0x78, 0x55, 0x16, 0xcd, 0xa7, 0xcf, 0x70, 0x87, 0x0d, 0xd8, 0x12, 0xe8, 0x0e, 0x8f, 0x9f, 0x1b, 0x52, 0x48, 0xd9, 0x19, 0xb1, 0xff, 0x1d, 0x06, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_317 = {
	.name = "ecdsa_brainpoolp224r1_sha224_317",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_317_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_317_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_317_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 252 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 318 for ECDSA, tcId is 253 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_318_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_318_msg[] = {
	0x31, 0x31, 0x35, 0x35, 0x35, 0x37, 0x37, 0x37, 0x32, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_318_sig[] = {
	0x47, 0x20, 0xf9, 0x37, 0x10, 0x0d, 0xf5, 0x2e, 0x6a, 0xe1, 0xba, 0xf4, 0x0f, 0x8b, 0xc9, 0x50, 0xe5, 0xaf, 0x2b, 0x1f, 0x94, 0x7d, 0x04, 0x17, 0x80, 0x4a, 0x82, 0x25, 0x8b, 0x82, 0x22, 0x73, 0xfb, 0x5d, 0x47, 0x3c, 0x9c, 0x88, 0xaa, 0x3c, 0x8d, 0xde, 0xa1, 0x67, 0x61, 0x9c, 0xda, 0x12, 0xee, 0x41, 0xce, 0x65, 0xde, 0x26, 0x8a, 0x75, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_318 = {
	.name = "ecdsa_brainpoolp224r1_sha224_318",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_318_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_318_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_318_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 253 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 319 for ECDSA, tcId is 254 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_319_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_319_msg[] = {
	0x32, 0x34, 0x33, 0x32, 0x34, 0x37, 0x34, 0x36, 0x36, 0x34, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_319_sig[] = {
	0x3d, 0x28, 0x1d, 0x98, 0xb6, 0xa6, 0x76, 0xa6, 0xed, 0xa7, 0x57, 0x0d, 0x7b, 0x4f, 0x9a, 0x08, 0xe9, 0x24, 0xc7, 0x1a, 0xfd, 0x2c, 0xb6, 0xe0, 0x62, 0xa7, 0xeb, 0xfd, 0x84, 0x46, 0xe4, 0x27, 0x47, 0xa3, 0x52, 0x51, 0x8e, 0xf6, 0x8e, 0xff, 0x05, 0x56, 0x95, 0xb4, 0x76, 0x6b, 0xdc, 0x2a, 0xd8, 0xd3, 0xfa, 0x97, 0xbc, 0x20, 0x2b, 0x43, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_319 = {
	.name = "ecdsa_brainpoolp224r1_sha224_319",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_319_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_319_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_319_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 254 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 320 for ECDSA, tcId is 255 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_320_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_320_msg[] = {
	0x32, 0x34, 0x31, 0x37, 0x32, 0x38, 0x32, 0x32, 0x37, 0x37, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_320_sig[] = {
	0x4d, 0x34, 0x69, 0xe9, 0x39, 0xff, 0xea, 0xd9, 0x41, 0xe3, 0xcb, 0xce, 0xbc, 0xa3, 0xbc, 0xb6, 0xf3, 0xc0, 0x29, 0x64, 0x1f, 0x97, 0x70, 0x0e, 0x02, 0x81, 0x77, 0x38, 0x42, 0xcb, 0x87, 0xa1, 0x0e, 0xa1, 0x7c, 0x0e, 0x58, 0xc3, 0x82, 0x2f, 0x6a, 0xe1, 0xf3, 0xa8, 0x91, 0x8d, 0x86, 0xa8, 0x32, 0x5d, 0xef, 0x4a, 0x8c, 0x80, 0x82, 0xf2, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_320 = {
	.name = "ecdsa_brainpoolp224r1_sha224_320",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_320_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_320_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp224r1_sha224_320_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 255 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 321 for ECDSA, tcId is 256 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_321_pubkey[] = {
	0x57, 0x2e, 0xab, 0x73, 0x76, 0xd0, 0x52, 0xdf, 0xc4, 0x09, 0x23, 0xdb, 0x25, 0x34, 0x2e, 0xa9, 0xcb, 0xfc, 0xe4, 0xb8, 0x58, 0x1e, 0x10, 0x4a, 0x4c, 0x8f, 0x37, 0xc9, 0x4a, 0x70, 0x0e, 0xc5, 0xdc, 0x05, 0xa4, 0x81, 0xb2, 0xb6, 0x95, 0x32, 0x0c, 0x6f, 0x1a, 0xd2, 0xdd, 0x86, 0x28, 0x63, 0x3c, 0xdb, 0x75, 0xa9, 0x12, 0x45, 0xc2, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_321_msg[] = {
	0x37, 0x37, 0x38, 0x37, 0x34, 0x37, 0x37, 0x31, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_321_sig[] = {
	0x21, 0xe5, 0x1b, 0x79, 0xe8, 0x55, 0x4e, 0x22, 0x93, 0x7c, 0x3e, 0x5b, 0x19, 0x83, 0xb3, 0x77, 0x62, 0x59, 0x1e, 0x21, 0xf5, 0x70, 0x6e, 0x5c, 0x19, 0x82, 0xa5, 0x0c, 0x4b, 0xcd, 0xbd, 0x23, 0xb0, 0xa4, 0x71, 0xdb, 0x84, 0xd1, 0xee, 0x3e, 0xdf, 0x76, 0x77, 0xbb, 0xb1, 0x43, 0x07, 0xec, 0xc5, 0xe1, 0x02, 0x31, 0x74, 0xec, 0x5b, 0x8c, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_321 = {
	.name = "ecdsa_brainpoolp224r1_sha224_321",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_321_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_321_msg,
	.msglen = 8,
	.sig = ecdsa_brainpoolp224r1_sha224_321_sig,
	.siglen = 56,
	.result = 1,
	.comment = "special case hash, tcId is 256 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 322 for ECDSA, tcId is 257 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_322_pubkey[] = {
	0xa0, 0xef, 0x7d, 0xb1, 0xbe, 0xe0, 0xae, 0xdb, 0x5a, 0x56, 0x34, 0xf4, 0xf3, 0xb1, 0xb8, 0x8d, 0x97, 0xd2, 0xa0, 0x7f, 0x80, 0x6a, 0x71, 0x8e, 0xfe, 0x19, 0x01, 0x4d, 0xae, 0xe1, 0x04, 0x3f, 0x9e, 0x92, 0x9c, 0x32, 0xd7, 0x4a, 0xb0, 0xe4, 0xee, 0xba, 0x26, 0x23, 0xf1, 0x7b, 0xa2, 0x81, 0xb6, 0xbe, 0x87, 0x74, 0x5b, 0x59, 0xf6, 0x0e, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_322_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_322_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdb, 0xee, 0xdf, 0x88, 0x4b, 0x0c, 0x29, 0xfb, 0xcd, 0x51, 0xd9, 0x21, 0x2d, 0x5f, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9c, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_322 = {
	.name = "ecdsa_brainpoolp224r1_sha224_322",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_322_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_322_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_322_sig,
	.siglen = 56,
	.result = 1,
	.comment = "k*G has a large x-coordinate, tcId is 257 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 323 for ECDSA, tcId is 258 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_323_pubkey[] = {
	0xa0, 0xef, 0x7d, 0xb1, 0xbe, 0xe0, 0xae, 0xdb, 0x5a, 0x56, 0x34, 0xf4, 0xf3, 0xb1, 0xb8, 0x8d, 0x97, 0xd2, 0xa0, 0x7f, 0x80, 0x6a, 0x71, 0x8e, 0xfe, 0x19, 0x01, 0x4d, 0xae, 0xe1, 0x04, 0x3f, 0x9e, 0x92, 0x9c, 0x32, 0xd7, 0x4a, 0xb0, 0xe4, 0xee, 0xba, 0x26, 0x23, 0xf1, 0x7b, 0xa2, 0x81, 0xb6, 0xbe, 0x87, 0x74, 0x5b, 0x59, 0xf6, 0x0e, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_323_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_323_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xfe, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9c, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_323 = {
	.name = "ecdsa_brainpoolp224r1_sha224_323",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_323_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_323_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_323_sig,
	.siglen = 56,
	.result = -1,
	.comment = "r too large, tcId is 258 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 324 for ECDSA, tcId is 259 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_324_pubkey[] = {
	0x3a, 0xdd, 0xa4, 0x07, 0xba, 0xd7, 0xf5, 0x93, 0xe8, 0x3d, 0x7d, 0x48, 0x4f, 0xd1, 0x4c, 0x23, 0xdd, 0xa1, 0x7f, 0x8d, 0x46, 0x0c, 0x22, 0x2a, 0xa7, 0x25, 0x75, 0x77, 0xcd, 0x62, 0x44, 0x3b, 0x2b, 0x77, 0x02, 0x91, 0xf6, 0x59, 0x04, 0xda, 0xcf, 0x75, 0xff, 0x97, 0x5f, 0x1a, 0x66, 0x71, 0x87, 0xe0, 0xe4, 0xf5, 0x0c, 0x14, 0x88, 0x9c, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_324_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_324_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9e, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9d, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_324 = {
	.name = "ecdsa_brainpoolp224r1_sha224_324",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_324_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_324_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_324_sig,
	.siglen = 56,
	.result = 1,
	.comment = "r,s are large, tcId is 259 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 325 for ECDSA, tcId is 260 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_325_pubkey[] = {
	0x24, 0x58, 0x7c, 0xe1, 0xdb, 0xff, 0x28, 0x1d, 0xca, 0xb1, 0x79, 0x45, 0x19, 0x80, 0x62, 0x81, 0xad, 0x4e, 0x09, 0x97, 0x49, 0x25, 0x10, 0x67, 0x7f, 0xb6, 0x51, 0x06, 0x92, 0x96, 0x99, 0x6e, 0x83, 0xb8, 0x08, 0x67, 0x6c, 0xbf, 0x6f, 0x28, 0xc9, 0x2b, 0x84, 0x30, 0x33, 0x14, 0xb6, 0x3a, 0x03, 0x08, 0x13, 0x4f, 0x22, 0x2d, 0x0e, 0xc2, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_325_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_325_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x63, 0xf0, 0xe3, 0x42, 0x58, 0xbb, 0x90, 0x61, 0x54, 0x79, 0x06, 0xd0, 0xc3, 0x82, 0x7c, 0x50, 0x44, 0x22, 0xc1, 0x39, 0xe6, 0xd6, 0xe1, 0x07, 0x8b, 0x37, 0xaa, 0x44, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_325 = {
	.name = "ecdsa_brainpoolp224r1_sha224_325",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_325_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_325_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_325_sig,
	.siglen = 56,
	.result = 1,
	.comment = "r and s^-1 have a large Hamming weight, tcId is 260 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 326 for ECDSA, tcId is 261 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_326_pubkey[] = {
	0xc4, 0x5c, 0x51, 0xd5, 0xa9, 0xb2, 0x13, 0xe4, 0x1c, 0xa6, 0xf1, 0x5c, 0xb8, 0xaa, 0x1b, 0xc0, 0xb8, 0xb7, 0x3d, 0x3a, 0x8a, 0x23, 0xa1, 0x4f, 0x5a, 0x3d, 0xa4, 0xdf, 0xbc, 0x78, 0xcc, 0x61, 0x76, 0xd3, 0xb8, 0x31, 0xe6, 0x88, 0x00, 0x67, 0x17, 0x68, 0x04, 0x3c, 0x11, 0xbf, 0x63, 0xa6, 0x95, 0x91, 0x8d, 0xf6, 0xec, 0x87, 0x37, 0x8a, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_326_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_326_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6e, 0xb1, 0xfb, 0xfa, 0x8d, 0xf8, 0x7d, 0x4f, 0xa1, 0x0c, 0x83, 0x3f, 0x7d, 0xd1, 0xbb, 0xe7, 0xef, 0x01, 0x44, 0xff, 0x71, 0x53, 0x79, 0x75, 0x37, 0x8f, 0x91, 0xec, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_326 = {
	.name = "ecdsa_brainpoolp224r1_sha224_326",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_326_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_326_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_326_sig,
	.siglen = 56,
	.result = 1,
	.comment = "r and s^-1 have a large Hamming weight, tcId is 261 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 327 for ECDSA, tcId is 262 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_327_pubkey[] = {
	0x36, 0xa5, 0x34, 0x4d, 0xa0, 0x8a, 0x42, 0x1e, 0xdc, 0x6c, 0x3b, 0xeb, 0x7d, 0xe9, 0x7a, 0x75, 0x59, 0xfc, 0x10, 0x1c, 0x14, 0x89, 0xff, 0x2b, 0x50, 0x36, 0xd8, 0xf6, 0x20, 0x7b, 0xf4, 0x66, 0x6e, 0x4d, 0xf6, 0x06, 0xbd, 0x0d, 0x98, 0x23, 0xa5, 0x2b, 0x58, 0xdd, 0xfd, 0xfc, 0x1d, 0xa7, 0x05, 0x13, 0xc5, 0xf9, 0x99, 0x0f, 0x80, 0x85, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_327_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_327_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_327 = {
	.name = "ecdsa_brainpoolp224r1_sha224_327",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_327_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_327_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_327_sig,
	.siglen = 56,
	.result = 1,
	.comment = "small r and s, tcId is 262 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 328 for ECDSA, tcId is 263 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_328_pubkey[] = {
	0x40, 0x95, 0xc0, 0x95, 0xa9, 0x64, 0x89, 0x51, 0xda, 0x35, 0x2b, 0x83, 0x7f, 0x36, 0x8e, 0x0b, 0xe6, 0x7d, 0x79, 0xfd, 0x57, 0xea, 0xdf, 0xff, 0xed, 0xdf, 0xb4, 0x55, 0xcc, 0xdc, 0xfa, 0xbe, 0xa1, 0x9e, 0x96, 0xd4, 0xd2, 0x0e, 0x42, 0xb8, 0xae, 0x23, 0xc2, 0x51, 0x94, 0x26, 0x01, 0x8e, 0x25, 0xa6, 0x4d, 0xea, 0x85, 0xd8, 0xa6, 0x8b, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_328_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_328_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_328 = {
	.name = "ecdsa_brainpoolp224r1_sha224_328",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_328_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_328_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_328_sig,
	.siglen = 56,
	.result = 1,
	.comment = "small r and s, tcId is 263 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 329 for ECDSA, tcId is 264 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_329_pubkey[] = {
	0xcc, 0x35, 0x2a, 0xc4, 0x8a, 0xac, 0xb6, 0x49, 0x5e, 0xc3, 0x83, 0x1b, 0x21, 0xcc, 0xd4, 0xd3, 0x19, 0x71, 0x36, 0x29, 0x2b, 0xf6, 0xf2, 0x0f, 0x22, 0x80, 0x25, 0x66, 0x64, 0x32, 0x19, 0x91, 0xe6, 0x7f, 0x7d, 0xbc, 0x22, 0x60, 0x2e, 0xcb, 0xdb, 0x31, 0x22, 0xed, 0xce, 0x5f, 0xf8, 0x5d, 0x92, 0x31, 0x43, 0xce, 0xcc, 0x0d, 0x4f, 0x6d, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_329_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_329_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_329 = {
	.name = "ecdsa_brainpoolp224r1_sha224_329",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_329_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_329_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_329_sig,
	.siglen = 56,
	.result = 1,
	.comment = "small r and s, tcId is 264 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 330 for ECDSA, tcId is 265 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_330_pubkey[] = {
	0xcc, 0x35, 0x2a, 0xc4, 0x8a, 0xac, 0xb6, 0x49, 0x5e, 0xc3, 0x83, 0x1b, 0x21, 0xcc, 0xd4, 0xd3, 0x19, 0x71, 0x36, 0x29, 0x2b, 0xf6, 0xf2, 0x0f, 0x22, 0x80, 0x25, 0x66, 0x64, 0x32, 0x19, 0x91, 0xe6, 0x7f, 0x7d, 0xbc, 0x22, 0x60, 0x2e, 0xcb, 0xdb, 0x31, 0x22, 0xed, 0xce, 0x5f, 0xf8, 0x5d, 0x92, 0x31, 0x43, 0xce, 0xcc, 0x0d, 0x4f, 0x6d, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_330_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_330_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_330 = {
	.name = "ecdsa_brainpoolp224r1_sha224_330",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_330_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_330_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_330_sig,
	.siglen = 56,
	.result = -1,
	.comment = "r is larger than n, tcId is 265 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 331 for ECDSA, tcId is 266 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_331_pubkey[] = {
	0x91, 0x48, 0xf2, 0x9c, 0x67, 0xf8, 0x3c, 0x70, 0x5e, 0xef, 0xb5, 0x9c, 0x92, 0x95, 0x47, 0x75, 0xf9, 0x0c, 0x15, 0xe2, 0x25, 0xda, 0x2e, 0x99, 0x6a, 0xbc, 0xdd, 0x1d, 0xc9, 0xdb, 0x1a, 0xa1, 0xe1, 0x52, 0x77, 0xc4, 0x55, 0x5d, 0x24, 0x11, 0x82, 0x39, 0xe5, 0x3f, 0xd2, 0xf0, 0xb5, 0xe7, 0xea, 0x80, 0x7e, 0xb3, 0xde, 0x1e, 0xe3, 0x50, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_331_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_331_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xba, 0x6a, 0x26, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_331 = {
	.name = "ecdsa_brainpoolp224r1_sha224_331",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_331_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_331_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_331_sig,
	.siglen = 56,
	.result = -1,
	.comment = "s is larger than n, tcId is 266 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 332 for ECDSA, tcId is 267 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_332_pubkey[] = {
	0x9b, 0xf0, 0x45, 0xa4, 0x3a, 0x5f, 0x14, 0xd5, 0xe4, 0x12, 0xee, 0x18, 0x1f, 0x11, 0x1d, 0x6e, 0x53, 0x96, 0x11, 0x20, 0x53, 0x1f, 0x3c, 0x50, 0xca, 0x70, 0x1e, 0x78, 0xbe, 0x9e, 0xb9, 0x51, 0x46, 0xf4, 0xf2, 0xbe, 0x96, 0x94, 0x99, 0x76, 0xa7, 0xaa, 0x49, 0xd3, 0x15, 0x93, 0xa7, 0xda, 0x2e, 0xdd, 0x90, 0x76, 0x52, 0x39, 0x8c, 0x3a, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_332_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_332_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x9d, 0xfe, 0x5c, 0xfd, 0x9b, 0x02, 0xfe, 0x7a, 0x6f, 0x74, 0x7b, 0xf3, 0x1d, 0xd5, 0x81, 0xd0, 0xa9, 0x3c, 0xfe, 0xcc, 0x66, 0xa1, 0x17, 0x3d, 0x61, 0x1d, 0xfd, 0x3c, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_332 = {
	.name = "ecdsa_brainpoolp224r1_sha224_332",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_332_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_332_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_332_sig,
	.siglen = 56,
	.result = 1,
	.comment = "small r and s^-1, tcId is 267 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 333 for ECDSA, tcId is 268 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_333_pubkey[] = {
	0x87, 0x73, 0x9e, 0x28, 0x21, 0xed, 0x95, 0x67, 0xe8, 0x87, 0x02, 0xfa, 0x8c, 0x6d, 0x08, 0x3c, 0x97, 0xc1, 0xf3, 0xf1, 0xeb, 0x32, 0xd1, 0x3f, 0x75, 0x1f, 0xb0, 0x73, 0x6d, 0x02, 0xeb, 0xa0, 0x5e, 0x8c, 0xb9, 0x46, 0x72, 0xd0, 0x9e, 0xbc, 0x11, 0x05, 0x1d, 0x52, 0xec, 0x7b, 0xd4, 0xdc, 0x77, 0x67, 0x30, 0x1b, 0x67, 0x03, 0x42, 0x12, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_333_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_333_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x9b, 0x4d, 0x34, 0x79, 0x52, 0xcc, 0x43, 0xe2, 0x35, 0x74, 0x8b, 0xd3, 0xb1, 0xbf, 0xa1, 0x4c, 0x92, 0x23, 0x4a, 0x90, 0x26, 0x1a, 0xcc, 0x3e, 0x90, 0x86, 0x81, 0x08, 0x01, 0xa3, 0x67, 0x46, 0xbc, 0xee, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_333 = {
	.name = "ecdsa_brainpoolp224r1_sha224_333",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_333_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_333_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_333_sig,
	.siglen = 56,
	.result = 1,
	.comment = "smallish r and s^-1, tcId is 268 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 334 for ECDSA, tcId is 269 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_334_pubkey[] = {
	0x1a, 0x51, 0x5c, 0xbe, 0x95, 0x7b, 0xfc, 0x07, 0x0e, 0x4c, 0x4a, 0x75, 0xd6, 0xfd, 0x5e, 0x7c, 0x15, 0xb1, 0xe2, 0x55, 0xeb, 0x42, 0xfe, 0xad, 0x06, 0xc9, 0xd2, 0x63, 0x62, 0x52, 0xcc, 0x0d, 0x23, 0x43, 0x18, 0x39, 0x4d, 0xf7, 0xdb, 0x65, 0xb0, 0xa5, 0x2e, 0x06, 0x95, 0x3c, 0xa6, 0xc2, 0x1e, 0xc9, 0x57, 0x74, 0xd3, 0x9e, 0xfd, 0xc9, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_334_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_334_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x33, 0xe6, 0x7e, 0x37, 0xb3, 0x2b, 0x44, 0x55, 0x80, 0xbf, 0x4e, 0xfb, 0xa8, 0xbd, 0xf4, 0x65, 0x32, 0xd8, 0x13, 0x6b, 0xeb, 0x21, 0xdb, 0xf1, 0x78, 0x09, 0x0c, 0x7e, 0x7d, 0xad, 0x2c, 0xaa, 0x8e, 0xb5, 0x2c, 0xef, 0x8d, 0x83, 0x0f, 0xd8, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_334 = {
	.name = "ecdsa_brainpoolp224r1_sha224_334",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_334_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_334_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_334_sig,
	.siglen = 56,
	.result = 1,
	.comment = "100-bit r and small s^-1, tcId is 269 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 335 for ECDSA, tcId is 270 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_335_pubkey[] = {
	0xd6, 0xa1, 0x6e, 0x19, 0x4e, 0x12, 0xb9, 0x6d, 0xb8, 0xe1, 0xbb, 0x02, 0x50, 0xd9, 0x50, 0xf7, 0xb3, 0x12, 0x9b, 0x14, 0xbb, 0xa0, 0xef, 0xb1, 0x57, 0xc4, 0x42, 0x3e, 0x62, 0x5a, 0x0c, 0x8c, 0x20, 0x83, 0x8b, 0xd9, 0x7f, 0xbc, 0x89, 0xf1, 0x67, 0x00, 0x28, 0x75, 0x4a, 0x09, 0xad, 0x28, 0xf6, 0x2d, 0xe5, 0xee, 0xa6, 0xe0, 0x7b, 0xc1, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_335_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_335_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x73, 0x16, 0x8a, 0x89, 0x94, 0xe5, 0xf7, 0x17, 0x93, 0x08, 0x1c, 0xb7, 0xaf, 0xbe, 0x3c, 0x0a, 0xf4, 0xbf, 0x7a, 0xa3, 0x36, 0xcf, 0x9d, 0xe3, 0x1e, 0xf8, 0x53, 0x14, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_335 = {
	.name = "ecdsa_brainpoolp224r1_sha224_335",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_335_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_335_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_335_sig,
	.siglen = 56,
	.result = 1,
	.comment = "small r and 100 bit s^-1, tcId is 270 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 336 for ECDSA, tcId is 271 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_336_pubkey[] = {
	0xc0, 0x12, 0x95, 0x0d, 0x07, 0x4b, 0xb0, 0x1b, 0x0a, 0x19, 0x88, 0xa5, 0xb5, 0x9b, 0x95, 0x91, 0x04, 0x27, 0x5b, 0xaf, 0x75, 0x7e, 0x53, 0x02, 0x9b, 0x04, 0x6a, 0x15, 0x42, 0xf5, 0x0f, 0xe2, 0x7f, 0x3e, 0xba, 0xc9, 0x03, 0x65, 0x58, 0xef, 0x30, 0xeb, 0xcb, 0x81, 0x20, 0x27, 0xbf, 0x0e, 0xf4, 0x6c, 0xda, 0x51, 0x96, 0x95, 0x41, 0xbb, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_336_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_336_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x25, 0x22, 0xbb, 0xd3, 0xec, 0xbe, 0x7c, 0x39, 0xe9, 0x3e, 0x7c, 0x24, 0x73, 0x16, 0x8a, 0x89, 0x94, 0xe5, 0xf7, 0x17, 0x93, 0x08, 0x1c, 0xb7, 0xaf, 0xbe, 0x3c, 0x0a, 0xf4, 0xbf, 0x7a, 0xa3, 0x36, 0xcf, 0x9d, 0xe3, 0x1e, 0xf8, 0x53, 0x14, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_336 = {
	.name = "ecdsa_brainpoolp224r1_sha224_336",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_336_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_336_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_336_sig,
	.siglen = 56,
	.result = 1,
	.comment = "100-bit r and s^-1, tcId is 271 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 337 for ECDSA, tcId is 272 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_337_pubkey[] = {
	0xd1, 0x5c, 0x13, 0xa1, 0xbe, 0x99, 0xd9, 0xeb, 0x77, 0xd6, 0x88, 0x10, 0x4a, 0x18, 0xe2, 0x42, 0x42, 0xd2, 0x05, 0xa4, 0x02, 0x6f, 0x4a, 0x65, 0x62, 0x9e, 0x59, 0xee, 0x7e, 0x3d, 0xdf, 0x9a, 0xbb, 0xb7, 0xd5, 0x32, 0xb6, 0xe8, 0x1a, 0x6e, 0x11, 0xf3, 0x0d, 0x5b, 0x55, 0xfe, 0xb8, 0xee, 0x70, 0x7c, 0x4f, 0xed, 0xf9, 0x9c, 0x06, 0x07, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_337_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_337_sig[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x1f, 0x47, 0xeb, 0x11, 0x8e, 0x0c, 0xc1, 0x22, 0x2c, 0xb8, 0xb2, 0xba, 0xb7, 0x27, 0x45, 0xa9, 0x32, 0xf0, 0x5c, 0xe9, 0x6e, 0x79, 0xf4, 0xe9, 0x8b, 0xe1, 0xe2, 0x86, 0x8a, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_337 = {
	.name = "ecdsa_brainpoolp224r1_sha224_337",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_337_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_337_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_337_sig,
	.siglen = 56,
	.result = 1,
	.comment = "r and s^-1 are close to n, tcId is 272 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 338 for ECDSA, tcId is 273 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_338_pubkey[] = {
	0x3f, 0xe0, 0x19, 0x72, 0xc0, 0x62, 0x2e, 0xa8, 0x12, 0xd3, 0x06, 0x52, 0xc9, 0xfe, 0x2f, 0xeb, 0xee, 0x70, 0x81, 0x23, 0xb1, 0x62, 0x6d, 0x74, 0x4f, 0x87, 0xdb, 0x0d, 0xa5, 0x72, 0xc7, 0xe1, 0xe3, 0xa4, 0x81, 0x95, 0xe6, 0x22, 0x1d, 0x98, 0x3f, 0x78, 0x2f, 0xdc, 0x9e, 0x7c, 0x55, 0xbd, 0x5f, 0xdf, 0x7b, 0x67, 0x9b, 0x0f, 0x87, 0x56, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_338_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_338_sig[] = {
	0x47, 0xeb, 0x11, 0x8e, 0x0c, 0xc1, 0x22, 0x2c, 0xb8, 0xb2, 0xba, 0xb7, 0x27, 0x45, 0xa9, 0x32, 0xf0, 0x5c, 0xe9, 0x6e, 0x79, 0xf4, 0xe9, 0x8b, 0xe1, 0xe2, 0x86, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_338 = {
	.name = "ecdsa_brainpoolp224r1_sha224_338",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_338_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_338_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_338_sig,
	.siglen = 56,
	.result = 1,
	.comment = "s == 1, tcId is 273 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 339 for ECDSA, tcId is 274 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_339_pubkey[] = {
	0x3f, 0xe0, 0x19, 0x72, 0xc0, 0x62, 0x2e, 0xa8, 0x12, 0xd3, 0x06, 0x52, 0xc9, 0xfe, 0x2f, 0xeb, 0xee, 0x70, 0x81, 0x23, 0xb1, 0x62, 0x6d, 0x74, 0x4f, 0x87, 0xdb, 0x0d, 0xa5, 0x72, 0xc7, 0xe1, 0xe3, 0xa4, 0x81, 0x95, 0xe6, 0x22, 0x1d, 0x98, 0x3f, 0x78, 0x2f, 0xdc, 0x9e, 0x7c, 0x55, 0xbd, 0x5f, 0xdf, 0x7b, 0x67, 0x9b, 0x0f, 0x87, 0x56, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_339_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_339_sig[] = {
	0x47, 0xeb, 0x11, 0x8e, 0x0c, 0xc1, 0x22, 0x2c, 0xb8, 0xb2, 0xba, 0xb7, 0x27, 0x45, 0xa9, 0x32, 0xf0, 0x5c, 0xe9, 0x6e, 0x79, 0xf4, 0xe9, 0x8b, 0xe1, 0xe2, 0x86, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_339 = {
	.name = "ecdsa_brainpoolp224r1_sha224_339",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_339_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_339_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_339_sig,
	.siglen = 56,
	.result = -1,
	.comment = "s == 0, tcId is 274 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 340 for ECDSA, tcId is 275 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_340_pubkey[] = {
	0xd4, 0xb6, 0xe5, 0x11, 0x24, 0x06, 0xfb, 0x74, 0x3b, 0x6b, 0xb5, 0x5f, 0x49, 0xea, 0x20, 0x30, 0xd9, 0x04, 0x42, 0x08, 0x31, 0xeb, 0xdd, 0xac, 0xd6, 0x7b, 0xba, 0x89, 0x65, 0x22, 0x65, 0x38, 0x4b, 0x75, 0xd8, 0x50, 0xe7, 0xc2, 0x7f, 0x4e, 0x33, 0xed, 0x6c, 0x57, 0x6d, 0xf0, 0xff, 0x96, 0x94, 0x70, 0xa9, 0xef, 0x25, 0xff, 0xaf, 0xcd, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_340_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_340_sig[] = {
	0x6b, 0xe0, 0x9a, 0x55, 0x13, 0x21, 0xb3, 0x43, 0x15, 0x0c, 0x18, 0x12, 0xba, 0xe8, 0x7d, 0xcc, 0x68, 0x8b, 0x5e, 0x25, 0xb6, 0xef, 0x5e, 0x51, 0xd2, 0xd3, 0xc9, 0xcf, 0x47, 0xeb, 0x11, 0x8e, 0x0c, 0xc1, 0x22, 0x2c, 0xb8, 0xb2, 0xba, 0xb7, 0x27, 0x45, 0xa9, 0x32, 0xf0, 0x5c, 0xe9, 0x6e, 0x79, 0xf4, 0xe9, 0x8b, 0xe1, 0xe2, 0x86, 0x8a, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_340 = {
	.name = "ecdsa_brainpoolp224r1_sha224_340",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_340_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_340_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_340_sig,
	.siglen = 56,
	.result = -1,
	.comment = "point at infinity during verify, tcId is 275 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 341 for ECDSA, tcId is 276 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_341_pubkey[] = {
	0x16, 0xc2, 0x12, 0x9d, 0x54, 0xb9, 0x34, 0x79, 0xb5, 0x6a, 0x9f, 0xf5, 0xb8, 0x3e, 0x4c, 0x75, 0x0b, 0xb4, 0xf3, 0x3e, 0xe1, 0xe7, 0x0f, 0x38, 0xb5, 0x44, 0x9f, 0x2d, 0x34, 0xcc, 0xaf, 0x79, 0xc5, 0x1c, 0x7d, 0xff, 0x3a, 0x7f, 0x9a, 0x05, 0xcd, 0x15, 0xa3, 0x96, 0xe0, 0xcf, 0xfe, 0x25, 0x42, 0x1c, 0x37, 0xe9, 0xb8, 0x0e, 0x14, 0x89, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_341_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_341_sig[] = {
	0x6b, 0xe0, 0x9a, 0x55, 0x13, 0x21, 0xb3, 0x43, 0x15, 0x0c, 0x18, 0x12, 0xba, 0xe8, 0x7d, 0xcc, 0x68, 0x8b, 0x5e, 0x25, 0xb6, 0xef, 0x5e, 0x51, 0xd2, 0xd3, 0xc9, 0xd0, 0x6b, 0xe0, 0x9a, 0x55, 0x13, 0x21, 0xb3, 0x43, 0x15, 0x0c, 0x18, 0x12, 0xba, 0xe8, 0x7d, 0xcc, 0x68, 0x8b, 0x5e, 0x25, 0xb6, 0xef, 0x5e, 0x51, 0xd2, 0xd3, 0xc9, 0xcf, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_341 = {
	.name = "ecdsa_brainpoolp224r1_sha224_341",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_341_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_341_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_341_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for signature malleability, tcId is 276 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 342 for ECDSA, tcId is 277 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_342_pubkey[] = {
	0x65, 0xab, 0xa0, 0xe4, 0x42, 0x7a, 0x0a, 0xe5, 0x58, 0x72, 0x1a, 0x5a, 0x8e, 0x72, 0xcb, 0x37, 0x62, 0xeb, 0x50, 0x22, 0x3b, 0xbe, 0x4c, 0x41, 0xa4, 0x50, 0xfe, 0x49, 0xc8, 0x1d, 0x3a, 0xe4, 0x86, 0x47, 0x8b, 0x42, 0x98, 0xc9, 0x43, 0x28, 0x3d, 0x2e, 0xc2, 0x13, 0x0b, 0xac, 0x22, 0xfa, 0xbc, 0x52, 0xf7, 0x43, 0xb1, 0xab, 0x7f, 0xa7, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_342_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_342_sig[] = {
	0x6b, 0xe0, 0x9a, 0x55, 0x13, 0x21, 0xb3, 0x43, 0x15, 0x0c, 0x18, 0x12, 0xba, 0xe8, 0x7d, 0xcc, 0x68, 0x8b, 0x5e, 0x25, 0xb6, 0xef, 0x5e, 0x51, 0xd2, 0xd3, 0xc9, 0xd0, 0x6b, 0xe0, 0x9a, 0x55, 0x13, 0x21, 0xb3, 0x43, 0x15, 0x0c, 0x18, 0x12, 0xba, 0xe8, 0x7d, 0xcc, 0x68, 0x8b, 0x5e, 0x25, 0xb6, 0xef, 0x5e, 0x51, 0xd2, 0xd3, 0xc9, 0xd0, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_342 = {
	.name = "ecdsa_brainpoolp224r1_sha224_342",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_342_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_342_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_342_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for signature malleability, tcId is 277 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 343 for ECDSA, tcId is 278 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_343_pubkey[] = {
	0x55, 0xa7, 0xb0, 0x10, 0x06, 0x13, 0xfa, 0xbd, 0x95, 0x7b, 0x42, 0x60, 0x08, 0x35, 0xc6, 0xd4, 0x2e, 0x01, 0xe0, 0x42, 0x52, 0x59, 0x3b, 0xdd, 0xe3, 0xb1, 0x72, 0x78, 0x87, 0x70, 0x8a, 0x05, 0xab, 0xa2, 0xf9, 0x3f, 0x1a, 0x1e, 0x1e, 0xcb, 0x70, 0x3e, 0xc9, 0xa8, 0xee, 0x6d, 0x60, 0x13, 0xa1, 0x01, 0xd3, 0x97, 0x01, 0x2a, 0x8c, 0xce, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_343_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_343_sig[] = {
	0x47, 0xeb, 0x11, 0x8e, 0x0c, 0xc1, 0x22, 0x2c, 0xb8, 0xb2, 0xba, 0xb7, 0x27, 0x45, 0xa9, 0x32, 0xf0, 0x5c, 0xe9, 0x6e, 0x79, 0xf4, 0xe9, 0x8b, 0xe1, 0xe2, 0x86, 0x8a, 0x75, 0x3b, 0xb4, 0x00, 0x78, 0x93, 0x40, 0x81, 0xd7, 0xbd, 0x11, 0x3e, 0xc4, 0x9b, 0x19, 0xef, 0x09, 0xd1, 0xba, 0x33, 0x49, 0x86, 0x90, 0x51, 0x6d, 0x4d, 0x12, 0x2c, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_343 = {
	.name = "ecdsa_brainpoolp224r1_sha224_343",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_343_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_343_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_343_sig,
	.siglen = 56,
	.result = 1,
	.comment = "u1 == 1, tcId is 278 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 344 for ECDSA, tcId is 279 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_344_pubkey[] = {
	0x1a, 0xda, 0x54, 0xdc, 0x01, 0x58, 0x61, 0x68, 0x0d, 0x8b, 0xb2, 0xd3, 0x11, 0xb9, 0x0e, 0x82, 0xdb, 0x75, 0xaa, 0x9e, 0x82, 0x17, 0xb9, 0x26, 0x11, 0xfa, 0x03, 0xcb, 0x84, 0xc6, 0x11, 0x55, 0x11, 0x97, 0x29, 0x8b, 0x32, 0x74, 0x87, 0x5c, 0xb9, 0x46, 0x86, 0xe7, 0x58, 0xf0, 0xa1, 0xa9, 0x67, 0x5c, 0x0b, 0xc1, 0x57, 0x45, 0x1a, 0x76, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_344_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_344_sig[] = {
	0x47, 0xeb, 0x11, 0x8e, 0x0c, 0xc1, 0x22, 0x2c, 0xb8, 0xb2, 0xba, 0xb7, 0x27, 0x45, 0xa9, 0x32, 0xf0, 0x5c, 0xe9, 0x6e, 0x79, 0xf4, 0xe9, 0x8b, 0xe1, 0xe2, 0x86, 0x8a, 0x62, 0x85, 0x80, 0xa9, 0xad, 0xb0, 0x26, 0x04, 0x52, 0x5b, 0x1e, 0xe6, 0xb1, 0x35, 0xe1, 0xa9, 0xc7, 0x45, 0x02, 0x18, 0x24, 0x58, 0x2c, 0x52, 0x38, 0x5a, 0x81, 0x73, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_344 = {
	.name = "ecdsa_brainpoolp224r1_sha224_344",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_344_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_344_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_344_sig,
	.siglen = 56,
	.result = 1,
	.comment = "u1 == n - 1, tcId is 279 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 345 for ECDSA, tcId is 280 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_345_pubkey[] = {
	0xc6, 0x7b, 0x64, 0x29, 0x78, 0x53, 0x34, 0xa6, 0x08, 0xdd, 0xe9, 0x49, 0xa8, 0xab, 0xe6, 0x41, 0xdb, 0xd3, 0x60, 0x1e, 0xbc, 0xe1, 0xe6, 0x75, 0xfe, 0x71, 0xa8, 0xe5, 0x27, 0xd2, 0xe8, 0x72, 0x7d, 0xc4, 0xf6, 0x18, 0x49, 0x35, 0x50, 0xbb, 0x94, 0x01, 0x51, 0xbc, 0xa6, 0x82, 0x6f, 0x71, 0x4c, 0x5b, 0x31, 0x85, 0x40, 0x38, 0xf4, 0x4d, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_345_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_345_sig[] = {
	0x47, 0xeb, 0x11, 0x8e, 0x0c, 0xc1, 0x22, 0x2c, 0xb8, 0xb2, 0xba, 0xb7, 0x27, 0x45, 0xa9, 0x32, 0xf0, 0x5c, 0xe9, 0x6e, 0x79, 0xf4, 0xe9, 0x8b, 0xe1, 0xe2, 0x86, 0x8a, 0x47, 0xeb, 0x11, 0x8e, 0x0c, 0xc1, 0x22, 0x2c, 0xb8, 0xb2, 0xba, 0xb7, 0x27, 0x45, 0xa9, 0x32, 0xf0, 0x5c, 0xe9, 0x6e, 0x79, 0xf4, 0xe9, 0x8b, 0xe1, 0xe2, 0x86, 0x8a, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_345 = {
	.name = "ecdsa_brainpoolp224r1_sha224_345",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_345_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_345_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_345_sig,
	.siglen = 56,
	.result = 1,
	.comment = "u2 == 1, tcId is 280 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 346 for ECDSA, tcId is 281 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_346_pubkey[] = {
	0x1d, 0xcc, 0x7a, 0x5a, 0xd1, 0x11, 0xa3, 0x36, 0x27, 0xf9, 0x2d, 0xd8, 0x75, 0xba, 0x4a, 0x06, 0xf6, 0xa7, 0xc2, 0xbe, 0xfd, 0xd1, 0x05, 0x04, 0x88, 0xd0, 0x57, 0xa7, 0x34, 0x1c, 0xae, 0x0b, 0xe7, 0x2a, 0x99, 0x77, 0x6d, 0xb5, 0xbd, 0x79, 0xb4, 0x63, 0xe2, 0xd3, 0x88, 0x27, 0x64, 0xaf, 0x9c, 0x02, 0x45, 0xd0, 0x84, 0xa3, 0x34, 0x2d, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_346_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_346_sig[] = {
	0x47, 0xeb, 0x11, 0x8e, 0x0c, 0xc1, 0x22, 0x2c, 0xb8, 0xb2, 0xba, 0xb7, 0x27, 0x45, 0xa9, 0x32, 0xf0, 0x5c, 0xe9, 0x6e, 0x79, 0xf4, 0xe9, 0x8b, 0xe1, 0xe2, 0x86, 0x8a, 0x8f, 0xd6, 0x23, 0x1c, 0x19, 0x82, 0x44, 0x59, 0x71, 0x65, 0x75, 0x6e, 0x4e, 0x8b, 0x52, 0x65, 0xe0, 0xb9, 0xd2, 0xdc, 0xf3, 0xe9, 0xd3, 0x17, 0xc3, 0xc5, 0x0d, 0x15, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_346 = {
	.name = "ecdsa_brainpoolp224r1_sha224_346",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_346_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_346_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_346_sig,
	.siglen = 56,
	.result = 1,
	.comment = "u2 == n - 1, tcId is 281 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 347 for ECDSA, tcId is 282 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_347_pubkey[] = {
	0xbd, 0xf7, 0x08, 0xa0, 0x1c, 0x6a, 0x81, 0x47, 0x28, 0xd3, 0x94, 0xb7, 0xf2, 0x9b, 0xf6, 0x57, 0x97, 0x34, 0x86, 0x2d, 0x8a, 0xf8, 0xe6, 0xff, 0x78, 0x6f, 0xbe, 0x49, 0x90, 0x1c, 0xd4, 0x62, 0x94, 0x6e, 0x5e, 0x36, 0xcc, 0x97, 0xc9, 0x89, 0x6d, 0xf2, 0xe1, 0x81, 0x77, 0x45, 0x6d, 0x28, 0x2a, 0x7a, 0x26, 0xa3, 0x80, 0x84, 0xc0, 0x86, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_347_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_347_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xb6, 0xea, 0x09, 0xc6, 0xec, 0x5e, 0x04, 0x84, 0xb9, 0x4f, 0x25, 0xd8, 0x90, 0x14, 0x5b, 0x0a, 0xe3, 0xff, 0xbb, 0x98, 0xb7, 0x16, 0xad, 0xdd, 0x92, 0xde, 0xbd, 0xce, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_347 = {
	.name = "ecdsa_brainpoolp224r1_sha224_347",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_347_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_347_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_347_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u1, tcId is 282 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 348 for ECDSA, tcId is 283 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_348_pubkey[] = {
	0x0c, 0x53, 0x1f, 0xb3, 0xd9, 0x96, 0xfa, 0xa2, 0x24, 0x07, 0xdf, 0x13, 0x05, 0xff, 0x6a, 0xe0, 0xbf, 0xe9, 0x4e, 0x1c, 0x20, 0x22, 0xf4, 0x73, 0x0d, 0x0f, 0x8a, 0x4a, 0xbd, 0x80, 0x73, 0x95, 0x04, 0x59, 0x56, 0x2e, 0x53, 0x9a, 0xc0, 0x89, 0x54, 0x33, 0x75, 0x7e, 0x25, 0x20, 0x9b, 0x12, 0x53, 0x4f, 0xf3, 0x0f, 0xe3, 0xd3, 0x7c, 0x71, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_348_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_348_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x2f, 0x62, 0xa9, 0xcf, 0x48, 0xe3, 0xca, 0x60, 0x2e, 0xef, 0x4e, 0x33, 0xaf, 0xa4, 0x3f, 0x2d, 0xce, 0xb9, 0x22, 0xa4, 0x0a, 0x67, 0xde, 0x79, 0xf7, 0xb1, 0xae, 0x38, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_348 = {
	.name = "ecdsa_brainpoolp224r1_sha224_348",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_348_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_348_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_348_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u1, tcId is 283 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 349 for ECDSA, tcId is 284 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_349_pubkey[] = {
	0x67, 0x82, 0x95, 0x40, 0x82, 0x41, 0x8e, 0x00, 0x02, 0xa0, 0x81, 0x26, 0x72, 0xac, 0x21, 0x23, 0xb6, 0x33, 0x4b, 0x34, 0x13, 0x40, 0x55, 0x50, 0x96, 0xbc, 0xf6, 0xc6, 0x1f, 0x6f, 0xa1, 0xa8, 0xfe, 0xa6, 0x17, 0xd9, 0xdd, 0xa1, 0x44, 0x61, 0xd6, 0x3a, 0xa4, 0x48, 0xf2, 0x05, 0xa3, 0x9b, 0x25, 0x50, 0x1a, 0x6b, 0x1d, 0x42, 0xee, 0x5f, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_349_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_349_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x61, 0x8d, 0xfc, 0x54, 0x40, 0x8b, 0xec, 0x1c, 0xb3, 0x7c, 0x7e, 0xe5, 0x2b, 0x60, 0xad, 0xbc, 0x8d, 0x3a, 0x6c, 0x26, 0x45, 0x7c, 0x39, 0xd0, 0x13, 0xe8, 0x8e, 0x81, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_349 = {
	.name = "ecdsa_brainpoolp224r1_sha224_349",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_349_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_349_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_349_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u1, tcId is 284 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 350 for ECDSA, tcId is 285 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_350_pubkey[] = {
	0x5b, 0x5e, 0x6e, 0xab, 0xa7, 0x59, 0x7a, 0xe6, 0x41, 0x42, 0x0a, 0xce, 0x6a, 0xf2, 0x57, 0x58, 0x39, 0xf1, 0x61, 0xb2, 0x7b, 0x91, 0xb2, 0x70, 0xf1, 0x8b, 0xf7, 0xd0, 0x49, 0x6a, 0xb3, 0xc3, 0x07, 0x2f, 0xa6, 0xee, 0x55, 0x78, 0xfc, 0x81, 0x4f, 0x74, 0xd1, 0x48, 0xec, 0xbc, 0x2a, 0x98, 0xcf, 0xdc, 0x5d, 0x40, 0xec, 0x7e, 0x69, 0x80, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_350_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_350_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x01, 0x0d, 0xe5, 0x71, 0x24, 0xc0, 0x93, 0x0e, 0xf8, 0x00, 0xe7, 0x64, 0xb5, 0x58, 0x59, 0x27, 0x97, 0x7e, 0x2a, 0xd2, 0xd8, 0xb8, 0x2e, 0x7c, 0xb6, 0x48, 0xaf, 0x52, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_350 = {
	.name = "ecdsa_brainpoolp224r1_sha224_350",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_350_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_350_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_350_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u1, tcId is 285 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 351 for ECDSA, tcId is 286 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_351_pubkey[] = {
	0x8e, 0x66, 0x1a, 0x06, 0xad, 0x55, 0xb5, 0x22, 0x78, 0x01, 0xea, 0x43, 0x09, 0xa7, 0x2b, 0x9c, 0xd9, 0x49, 0x73, 0xbc, 0x87, 0x3c, 0x04, 0x05, 0xe1, 0x24, 0x7d, 0x1e, 0x64, 0x89, 0x8b, 0x82, 0x2c, 0x36, 0x3c, 0xac, 0x88, 0x21, 0x30, 0x2d, 0xe3, 0x8a, 0x91, 0x42, 0x68, 0xaa, 0xa6, 0x7d, 0xb2, 0x56, 0x18, 0x78, 0xf0, 0xf9, 0x0a, 0x02, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_351_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_351_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x03, 0x3e, 0xf5, 0x01, 0x0b, 0xec, 0xed, 0x04, 0xc4, 0x92, 0x88, 0x68, 0x51, 0x3e, 0xd1, 0x87, 0x8c, 0xe6, 0x77, 0xa6, 0xed, 0x81, 0x0e, 0x9b, 0x99, 0xdd, 0x97, 0x94, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_351 = {
	.name = "ecdsa_brainpoolp224r1_sha224_351",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_351_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_351_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_351_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u1, tcId is 286 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 352 for ECDSA, tcId is 287 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_352_pubkey[] = {
	0xb3, 0xd2, 0xb9, 0x3f, 0x14, 0x88, 0x65, 0x72, 0x62, 0x14, 0x0f, 0x96, 0xc1, 0x08, 0xaa, 0x04, 0x85, 0x93, 0x9b, 0xd9, 0x94, 0x40, 0x24, 0x0a, 0x7a, 0x7d, 0x54, 0xe3, 0x88, 0x96, 0x81, 0x74, 0xb0, 0x61, 0x85, 0x37, 0x39, 0xf8, 0xb0, 0x47, 0x1c, 0x76, 0x12, 0x65, 0x39, 0xdc, 0x57, 0xcc, 0x6d, 0x7c, 0x1f, 0x53, 0x9f, 0x68, 0x66, 0x74, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_352_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_352_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x06, 0x7d, 0xea, 0x02, 0x17, 0xd9, 0xda, 0x09, 0x89, 0x25, 0x10, 0xd0, 0xa2, 0x7d, 0xa3, 0x0f, 0x19, 0xcc, 0xef, 0x4d, 0xdb, 0x02, 0x1d, 0x37, 0x33, 0xbb, 0x2f, 0x28, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_352 = {
	.name = "ecdsa_brainpoolp224r1_sha224_352",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_352_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_352_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_352_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u1, tcId is 287 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 353 for ECDSA, tcId is 288 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_353_pubkey[] = {
	0xba, 0x83, 0x0d, 0xbf, 0x83, 0x07, 0x5c, 0xd1, 0x82, 0xbc, 0x93, 0x22, 0xc1, 0xf6, 0x29, 0x9a, 0x4c, 0xe3, 0xcf, 0x4d, 0xdd, 0xe0, 0xe6, 0xfc, 0xee, 0x50, 0xf0, 0xd6, 0x2b, 0x15, 0x3f, 0x6f, 0x37, 0x7a, 0x88, 0x80, 0x9c, 0x9d, 0xd5, 0x0d, 0x8d, 0x61, 0xeb, 0x67, 0x94, 0x51, 0x44, 0x48, 0x16, 0x57, 0x86, 0xa7, 0xc6, 0x55, 0x8d, 0xcc, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_353_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_353_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x45, 0x84, 0x7e, 0x02, 0xfd, 0x01, 0xa3, 0xcc, 0x9e, 0x06, 0x3f, 0x96, 0x1f, 0xb9, 0x20, 0xab, 0x32, 0x71, 0xec, 0x09, 0x99, 0x6f, 0x75, 0xbc, 0xa7, 0xfe, 0x6d, 0x3f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_353 = {
	.name = "ecdsa_brainpoolp224r1_sha224_353",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_353_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_353_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_353_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u1, tcId is 288 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 354 for ECDSA, tcId is 289 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_354_pubkey[] = {
	0x77, 0xf4, 0x02, 0x22, 0xe4, 0xa7, 0x9a, 0x0f, 0xa7, 0xe5, 0x10, 0x88, 0x7e, 0x69, 0xeb, 0xa3, 0x1f, 0x6d, 0xd7, 0x06, 0x71, 0x21, 0xda, 0xfe, 0x73, 0x9b, 0xbe, 0x13, 0xd0, 0xff, 0xab, 0x72, 0x22, 0xcf, 0x6d, 0x82, 0x7c, 0x51, 0xeb, 0x53, 0xab, 0xac, 0x50, 0x6b, 0xc0, 0xa5, 0xd7, 0xc1, 0xa5, 0xa7, 0xe1, 0x68, 0x3d, 0x49, 0xe4, 0x3e, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_354_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_354_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0b, 0x4c, 0xbe, 0x86, 0x6d, 0x19, 0x20, 0x63, 0x41, 0x38, 0xc8, 0x79, 0x8f, 0xcc, 0x41, 0x47, 0x94, 0x47, 0xe5, 0xae, 0x76, 0x07, 0x94, 0xe1, 0xe5, 0x79, 0x79, 0x28, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_354 = {
	.name = "ecdsa_brainpoolp224r1_sha224_354",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_354_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_354_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_354_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u1, tcId is 289 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 355 for ECDSA, tcId is 290 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_355_pubkey[] = {
	0x59, 0x7b, 0x5a, 0x3c, 0x10, 0x6b, 0x8c, 0x4e, 0x9a, 0x7e, 0x7a, 0x51, 0x7c, 0xd7, 0x40, 0xe7, 0x76, 0x67, 0xc8, 0xa2, 0xd0, 0x6c, 0x51, 0x0e, 0x5e, 0x3b, 0x72, 0x8d, 0x9c, 0xc2, 0x49, 0xe8, 0x27, 0xf5, 0xff, 0xf9, 0x02, 0x12, 0x2e, 0xb2, 0x6b, 0xad, 0xc4, 0xa7, 0xda, 0x65, 0x55, 0xb4, 0x89, 0xba, 0x98, 0x98, 0x2d, 0x38, 0x81, 0x25, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_355_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_355_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x20, 0xd7, 0x2a, 0xe3, 0x39, 0xe5, 0x62, 0x01, 0x70, 0xc9, 0x0a, 0x4c, 0xe5, 0xbc, 0xa0, 0x8d, 0xed, 0x17, 0x00, 0xb2, 0xb6, 0xc8, 0x0e, 0xc6, 0x12, 0xc8, 0xd5, 0xd1, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_355 = {
	.name = "ecdsa_brainpoolp224r1_sha224_355",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_355_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_355_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_355_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u1, tcId is 290 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 356 for ECDSA, tcId is 291 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_356_pubkey[] = {
	0x0f, 0x24, 0x53, 0xe7, 0x58, 0x5c, 0xb1, 0x39, 0x2f, 0xf4, 0xfa, 0x11, 0x86, 0x9f, 0x8c, 0x10, 0xb2, 0xf9, 0xcf, 0x4f, 0x2a, 0x18, 0xb8, 0x66, 0xe8, 0xf3, 0x7c, 0x2b, 0xd1, 0x56, 0x6e, 0xf0, 0x49, 0x28, 0x79, 0x75, 0x79, 0xd4, 0x0f, 0x33, 0x10, 0xeb, 0xaf, 0x47, 0x7a, 0x4e, 0x78, 0xa2, 0x35, 0x86, 0x19, 0x28, 0x32, 0x86, 0x34, 0xdf, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_356_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_356_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x9d, 0x23, 0x5a, 0xa9, 0xe9, 0xf9, 0xc6, 0x45, 0x3e, 0x39, 0xa7, 0x86, 0x13, 0x83, 0x6e, 0xa1, 0x4c, 0x2d, 0xdf, 0x31, 0xc9, 0x1b, 0x74, 0x7a, 0xef, 0x01, 0x0a, 0x89, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_356 = {
	.name = "ecdsa_brainpoolp224r1_sha224_356",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_356_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_356_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_356_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u1, tcId is 291 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 357 for ECDSA, tcId is 292 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_357_pubkey[] = {
	0x10, 0xcb, 0x3d, 0xbc, 0xe4, 0xda, 0x51, 0x8e, 0x04, 0xeb, 0x12, 0x5c, 0xf3, 0xb4, 0x4b, 0xef, 0x04, 0x51, 0xba, 0xd3, 0xe7, 0xcb, 0xba, 0xd5, 0x32, 0x8b, 0x85, 0xbb, 0x35, 0x86, 0x51, 0xb4, 0x78, 0xbc, 0xf2, 0x00, 0x68, 0x4f, 0xd3, 0x10, 0xe6, 0xd1, 0x4a, 0xcd, 0x23, 0xdc, 0x2a, 0x76, 0x04, 0x75, 0xdf, 0x0f, 0x5b, 0x8a, 0x75, 0x8c, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_357_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_357_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x9c, 0xa7, 0x98, 0x7f, 0x33, 0x67, 0xa9, 0x51, 0x6e, 0xca, 0x57, 0x85, 0x50, 0x98, 0xd4, 0xaa, 0xaf, 0x28, 0x94, 0x38, 0xd9, 0xad, 0x7b, 0x39, 0xdc, 0xc8, 0x11, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_357 = {
	.name = "ecdsa_brainpoolp224r1_sha224_357",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_357_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_357_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_357_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u1, tcId is 292 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 358 for ECDSA, tcId is 293 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_358_pubkey[] = {
	0x2c, 0x27, 0x73, 0x2a, 0xaa, 0xa3, 0xf8, 0xb1, 0x66, 0x64, 0xa4, 0x8a, 0x1d, 0xd0, 0x6f, 0xc0, 0xfe, 0x40, 0xf6, 0x57, 0x42, 0x75, 0x1e, 0x5c, 0x04, 0xb7, 0xef, 0xf5, 0x07, 0x80, 0x4b, 0x2d, 0xbe, 0xe7, 0x9f, 0xfe, 0x56, 0xdc, 0x4f, 0x4a, 0x60, 0x62, 0xce, 0xd6, 0xf3, 0x75, 0xb8, 0x0b, 0x5a, 0xd2, 0xcf, 0x3a, 0x29, 0x21, 0xb3, 0x95, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_358_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_358_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x72, 0x95, 0xbc, 0x38, 0xb7, 0x6b, 0xcc, 0xd7, 0x63, 0x5d, 0x65, 0x61, 0xd1, 0xf0, 0x53, 0xdd, 0x9b, 0x07, 0x94, 0x19, 0x24, 0x9f, 0x94, 0x36, 0x8c, 0x8d, 0x31, 0x33, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_358 = {
	.name = "ecdsa_brainpoolp224r1_sha224_358",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_358_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_358_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_358_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u2, tcId is 293 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 359 for ECDSA, tcId is 294 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_359_pubkey[] = {
	0x8c, 0xed, 0x55, 0x68, 0x77, 0xee, 0x15, 0xaf, 0x31, 0x4a, 0xed, 0x5d, 0xfc, 0x43, 0xa0, 0x0f, 0xbb, 0x76, 0x26, 0xfb, 0xdc, 0x7b, 0x81, 0xff, 0x7d, 0xbe, 0xa2, 0xf8, 0x98, 0xf5, 0xe2, 0x6f, 0x7f, 0xc3, 0x27, 0x6d, 0xa2, 0xa8, 0xe8, 0x69, 0xb0, 0xaf, 0xbc, 0x41, 0xef, 0x3b, 0x40, 0x32, 0x60, 0x80, 0xaa, 0x85, 0xce, 0x62, 0xc2, 0xab, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_359_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_359_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x93, 0x8f, 0x2d, 0xb2, 0xb7, 0x20, 0x61, 0xab, 0xd7, 0xeb, 0x6e, 0x5c, 0x8f, 0xe6, 0x85, 0x39, 0x1e, 0x96, 0x6e, 0xc0, 0xc7, 0x69, 0xd0, 0xc5, 0x38, 0xe0, 0x67, 0x8a, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_359 = {
	.name = "ecdsa_brainpoolp224r1_sha224_359",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_359_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_359_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_359_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u2, tcId is 294 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 360 for ECDSA, tcId is 295 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_360_pubkey[] = {
	0x42, 0xb1, 0x9b, 0x22, 0x50, 0x6c, 0x4f, 0xd8, 0x9f, 0xa2, 0x8c, 0x59, 0x09, 0xd9, 0x7f, 0x8f, 0xfe, 0xbd, 0xc8, 0x28, 0x04, 0xdc, 0xc7, 0xbf, 0x6a, 0x57, 0x0a, 0xe2, 0x1a, 0x97, 0x4e, 0xe0, 0x8b, 0x48, 0x4f, 0xa0, 0x5e, 0x1f, 0xbb, 0x89, 0xc4, 0x8c, 0x50, 0x75, 0x4b, 0xa1, 0xe4, 0x0a, 0x65, 0x8a, 0x5c, 0xed, 0x40, 0x9c, 0x63, 0x61, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_360_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_360_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x7f, 0x90, 0x7c, 0x8e, 0x32, 0xe6, 0x0e, 0x2b, 0xa4, 0x03, 0x3e, 0xe7, 0xd6, 0x5f, 0x3f, 0xe8, 0xfd, 0x23, 0x71, 0x9c, 0x7a, 0x9c, 0x6f, 0x5e, 0x52, 0xf1, 0x8c, 0x47, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_360 = {
	.name = "ecdsa_brainpoolp224r1_sha224_360",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_360_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_360_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_360_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u2, tcId is 295 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 361 for ECDSA, tcId is 296 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_361_pubkey[] = {
	0x20, 0x95, 0xe1, 0x21, 0x16, 0xce, 0xbd, 0xd4, 0xe8, 0xbc, 0x1c, 0xc1, 0x84, 0xb5, 0x38, 0xb1, 0x51, 0x5f, 0x78, 0x9e, 0x3b, 0xe4, 0xb0, 0x3a, 0x41, 0x83, 0xfa, 0xe5, 0xd0, 0x92, 0x6e, 0x44, 0x68, 0x75, 0xab, 0xdc, 0xd1, 0x2c, 0x82, 0x39, 0xe6, 0x07, 0x96, 0x1c, 0xad, 0xd0, 0x0a, 0x2e, 0x89, 0x9d, 0x82, 0x1d, 0xb1, 0x1d, 0x56, 0x79, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_361_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_361_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x34, 0xc3, 0x97, 0x8c, 0x3a, 0x1d, 0xac, 0x92, 0x1f, 0x62, 0x35, 0xc8, 0x2a, 0x02, 0xed, 0xb9, 0x34, 0x22, 0x85, 0x46, 0x94, 0x26, 0xbb, 0x10, 0xf8, 0x28, 0x97, 0xc4, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_361 = {
	.name = "ecdsa_brainpoolp224r1_sha224_361",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_361_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_361_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_361_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u2, tcId is 296 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 362 for ECDSA, tcId is 297 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_362_pubkey[] = {
	0x58, 0xf8, 0x2e, 0xb2, 0xca, 0x6e, 0x34, 0x74, 0xa9, 0x0e, 0x29, 0xac, 0x56, 0xdc, 0xb6, 0x3d, 0x88, 0xe6, 0x69, 0xe0, 0xa4, 0x02, 0x04, 0xe6, 0x20, 0x2a, 0xf7, 0xc5, 0xa0, 0xe8, 0x5e, 0x40, 0x39, 0xf3, 0x43, 0x25, 0x5b, 0x4f, 0xe4, 0xbd, 0xc1, 0x19, 0x1a, 0x78, 0x45, 0xbd, 0xd7, 0xeb, 0x90, 0x8e, 0xcd, 0x87, 0x79, 0xa2, 0x79, 0x63, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_362_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_362_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x97, 0x01, 0xd6, 0x52, 0x3d, 0x3d, 0x3f, 0x5b, 0x8a, 0xc8, 0x40, 0x26, 0x80, 0xb3, 0xca, 0xb8, 0x96, 0x6e, 0x26, 0x51, 0xcf, 0xc1, 0x73, 0x9f, 0xcd, 0x3c, 0x07, 0x49, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_362 = {
	.name = "ecdsa_brainpoolp224r1_sha224_362",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_362_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_362_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_362_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u2, tcId is 297 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 363 for ECDSA, tcId is 298 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_363_pubkey[] = {
	0x71, 0xf2, 0xc4, 0xa7, 0xc3, 0xf7, 0x13, 0x11, 0xa7, 0x93, 0x45, 0x8f, 0xf1, 0x22, 0x62, 0xa8, 0x63, 0x51, 0x8f, 0xb3, 0x0d, 0xbb, 0x7a, 0x80, 0x70, 0x10, 0x30, 0xb8, 0xb6, 0xb0, 0x84, 0x28, 0xfa, 0xbd, 0xb6, 0x9c, 0x8a, 0x8e, 0x9e, 0x32, 0x7d, 0xae, 0xd0, 0x79, 0x5f, 0xb8, 0x4e, 0x0d, 0x88, 0x17, 0x08, 0x60, 0x22, 0xd3, 0xb2, 0x3b, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_363_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_363_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x56, 0x42, 0x77, 0xfa, 0x54, 0x37, 0x18, 0x30, 0xeb, 0x78, 0x50, 0x27, 0x8b, 0x96, 0x99, 0xd8, 0x5b, 0xc5, 0x90, 0x58, 0x31, 0xa4, 0x2a, 0x9b, 0xf4, 0xd0, 0x7a, 0xf3, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_363 = {
	.name = "ecdsa_brainpoolp224r1_sha224_363",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_363_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_363_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_363_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u2, tcId is 298 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 364 for ECDSA, tcId is 299 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_364_pubkey[] = {
	0x3c, 0xfc, 0xf6, 0x4e, 0xec, 0xe9, 0x94, 0xc3, 0x5c, 0x56, 0xe9, 0x15, 0xe4, 0xed, 0x18, 0x83, 0xba, 0x6e, 0xc3, 0x4f, 0xe3, 0x96, 0xc1, 0x1a, 0xcd, 0x8f, 0x47, 0xd2, 0x63, 0xcd, 0xfb, 0xaa, 0x34, 0x40, 0x11, 0x00, 0xb5, 0xb1, 0x0a, 0xf7, 0x71, 0xbb, 0x46, 0xc0, 0xd5, 0x34, 0x46, 0xf7, 0xaa, 0x84, 0x79, 0x56, 0xc9, 0x36, 0x34, 0x94, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_364_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_364_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x77, 0x94, 0xfb, 0xde, 0xe6, 0x38, 0xf6, 0x57, 0xac, 0x1e, 0x4c, 0x65, 0x28, 0x4c, 0x14, 0x4b, 0x3e, 0xfa, 0x7b, 0xf4, 0x10, 0x9e, 0x6c, 0xca, 0x60, 0x5c, 0x4f, 0x4c, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_364 = {
	.name = "ecdsa_brainpoolp224r1_sha224_364",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_364_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_364_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_364_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u2, tcId is 299 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 365 for ECDSA, tcId is 300 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_365_pubkey[] = {
	0x4c, 0x40, 0x4d, 0xec, 0xbc, 0x06, 0x97, 0xb2, 0x07, 0xfa, 0x08, 0x98, 0x2e, 0xf0, 0xfe, 0xdb, 0x00, 0x1e, 0xeb, 0x43, 0xf3, 0x74, 0x04, 0xda, 0xb9, 0x7a, 0x9a, 0x77, 0x47, 0x19, 0x1b, 0xc2, 0x40, 0xdf, 0xd4, 0x40, 0x27, 0x4e, 0x06, 0x95, 0x56, 0x11, 0xf9, 0x92, 0x3f, 0xad, 0x69, 0x49, 0xb2, 0xcc, 0x15, 0x7a, 0x18, 0x5c, 0x82, 0x29, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_365_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_365_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xb5, 0x20, 0x0d, 0xa7, 0xa4, 0x58, 0x37, 0xf5, 0xb7, 0x1c, 0x47, 0xe1, 0xb9, 0x4c, 0x78, 0x62, 0xa1, 0xe4, 0xbe, 0xcb, 0xa3, 0x0a, 0x90, 0x8a, 0xda, 0x21, 0x94, 0x87, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_365 = {
	.name = "ecdsa_brainpoolp224r1_sha224_365",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_365_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_365_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_365_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u2, tcId is 300 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 366 for ECDSA, tcId is 301 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_366_pubkey[] = {
	0x7b, 0xe4, 0xb0, 0xea, 0x0b, 0x15, 0xb9, 0x6f, 0x91, 0x31, 0x2c, 0x15, 0xc8, 0x16, 0x29, 0xe4, 0x0c, 0x44, 0x18, 0xf7, 0x0b, 0x86, 0xc5, 0xbc, 0xdc, 0x25, 0x8f, 0xd9, 0x79, 0xcb, 0xef, 0x8e, 0xa2, 0xa7, 0x7c, 0xa0, 0x92, 0xdb, 0x0e, 0xb9, 0x54, 0xa9, 0xe3, 0x3e, 0x82, 0xb9, 0xc5, 0xf1, 0x10, 0xc8, 0xc9, 0x90, 0xb9, 0x23, 0x5a, 0x57, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_366_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_366_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x65, 0x2b, 0x78, 0x71, 0x6e, 0xd7, 0x99, 0xae, 0xc6, 0xba, 0xca, 0xc3, 0xa3, 0xe0, 0xa7, 0xbb, 0x36, 0x0f, 0x28, 0x32, 0x49, 0x3f, 0x28, 0x6d, 0x19, 0x1a, 0x62, 0x6c, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_366 = {
	.name = "ecdsa_brainpoolp224r1_sha224_366",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_366_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_366_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_366_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u2, tcId is 301 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 367 for ECDSA, tcId is 302 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_367_pubkey[] = {
	0x64, 0xa6, 0x4c, 0xff, 0xa5, 0x40, 0x66, 0x49, 0x92, 0x64, 0x99, 0x1e, 0x47, 0xa0, 0xf1, 0x4b, 0xca, 0x63, 0x19, 0xa1, 0xc2, 0x7e, 0x15, 0x08, 0xe2, 0x01, 0x6b, 0x56, 0xbd, 0xa7, 0xc1, 0x7a, 0x04, 0xd9, 0xcb, 0x88, 0xea, 0xdb, 0x72, 0x96, 0xcf, 0x87, 0xdf, 0xbf, 0xad, 0xfe, 0x65, 0x05, 0x68, 0x37, 0xa7, 0x97, 0xd6, 0x69, 0x97, 0xdd, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_367_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_367_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x97, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0xa2, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_367 = {
	.name = "ecdsa_brainpoolp224r1_sha224_367",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_367_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_367_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_367_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u2, tcId is 302 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 368 for ECDSA, tcId is 303 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_368_pubkey[] = {
	0x3d, 0x4c, 0x4e, 0x3c, 0x5b, 0xa7, 0xa5, 0x33, 0xc8, 0xa3, 0x38, 0x6d, 0x6f, 0xf7, 0x7a, 0x81, 0x35, 0x13, 0x46, 0xe1, 0x89, 0x4b, 0x25, 0x60, 0xb4, 0x06, 0xa6, 0x3e, 0xa3, 0x49, 0x77, 0x59, 0x46, 0x79, 0x9e, 0xeb, 0x27, 0x49, 0x26, 0xb4, 0xd9, 0x57, 0x32, 0x8f, 0x6c, 0x7d, 0x50, 0xf6, 0x76, 0x02, 0x91, 0xac, 0xda, 0xeb, 0x11, 0x4f, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_368_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_368_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xab, 0xa8, 0xd8, 0x9c, 0x2c, 0x94, 0xba, 0x58, 0xe7, 0x0d, 0xb7, 0x86, 0xa6, 0x18, 0x1d, 0xc0, 0xe7, 0x1d, 0x16, 0xf3, 0xf4, 0x3d, 0x96, 0x00, 0xfc, 0x4c, 0x8f, 0xf3, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_368 = {
	.name = "ecdsa_brainpoolp224r1_sha224_368",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_368_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_368_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_368_sig,
	.siglen = 56,
	.result = 1,
	.comment = "edge case for u2, tcId is 303 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 369 for ECDSA, tcId is 304 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_369_pubkey[] = {
	0x4d, 0xb8, 0xe8, 0xac, 0x43, 0xf2, 0x2d, 0xf7, 0x5c, 0x9c, 0x09, 0xfe, 0x19, 0x3b, 0x9c, 0xd8, 0x3d, 0x5c, 0x9b, 0x73, 0xf3, 0x7d, 0x14, 0x94, 0x76, 0x17, 0x24, 0xb0, 0xa7, 0x60, 0x82, 0xc3, 0x5d, 0xa8, 0x62, 0xa1, 0xe2, 0xe8, 0x62, 0x6f, 0xfa, 0x94, 0xed, 0x18, 0xfc, 0xb1, 0xd8, 0x97, 0xec, 0x7a, 0xb5, 0x2c, 0x32, 0x25, 0x53, 0xff, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_369_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_369_sig[] = {
	0x7a, 0xf2, 0x95, 0xe6, 0xe4, 0x78, 0x72, 0x52, 0xf3, 0x4c, 0x52, 0x7a, 0xf5, 0x62, 0xca, 0x27, 0x21, 0x4a, 0x66, 0xf6, 0xd6, 0xdb, 0x4f, 0xd2, 0xc1, 0x12, 0xb5, 0x64, 0xb1, 0xd0, 0x10, 0xf7, 0x40, 0x62, 0xee, 0xaa, 0xc0, 0xce, 0xcb, 0x2c, 0x3c, 0x2c, 0x4d, 0x28, 0x8a, 0x57, 0x6b, 0xf6, 0xf0, 0xa0, 0x03, 0x47, 0xc6, 0xa5, 0xb5, 0x62, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_369 = {
	.name = "ecdsa_brainpoolp224r1_sha224_369",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_369_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_369_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_369_sig,
	.siglen = 56,
	.result = 1,
	.comment = "point duplication during verification, tcId is 304 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 370 for ECDSA, tcId is 305 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_370_pubkey[] = {
	0x4d, 0xb8, 0xe8, 0xac, 0x43, 0xf2, 0x2d, 0xf7, 0x5c, 0x9c, 0x09, 0xfe, 0x19, 0x3b, 0x9c, 0xd8, 0x3d, 0x5c, 0x9b, 0x73, 0xf3, 0x7d, 0x14, 0x94, 0x76, 0x17, 0x24, 0xb0, 0x30, 0x60, 0xb1, 0xe6, 0xc8, 0x9b, 0x03, 0xe4, 0x47, 0x2f, 0xcd, 0xb5, 0x7b, 0x3c, 0xea, 0x6e, 0xb3, 0xed, 0x2e, 0xbf, 0xab, 0x5f, 0xd4, 0xc9, 0x4c, 0xa3, 0x6d, 0x00, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_370_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_370_sig[] = {
	0x7a, 0xf2, 0x95, 0xe6, 0xe4, 0x78, 0x72, 0x52, 0xf3, 0x4c, 0x52, 0x7a, 0xf5, 0x62, 0xca, 0x27, 0x21, 0x4a, 0x66, 0xf6, 0xd6, 0xdb, 0x4f, 0xd2, 0xc1, 0x12, 0xb5, 0x64, 0xb1, 0xd0, 0x10, 0xf7, 0x40, 0x62, 0xee, 0xaa, 0xc0, 0xce, 0xcb, 0x2c, 0x3c, 0x2c, 0x4d, 0x28, 0x8a, 0x57, 0x6b, 0xf6, 0xf0, 0xa0, 0x03, 0x47, 0xc6, 0xa5, 0xb5, 0x62, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_370 = {
	.name = "ecdsa_brainpoolp224r1_sha224_370",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_370_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_370_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_370_sig,
	.siglen = 56,
	.result = -1,
	.comment = "duplication bug, tcId is 305 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 371 for ECDSA, tcId is 306 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_371_pubkey[] = {
	0x2b, 0x92, 0x26, 0x82, 0x08, 0xd5, 0x22, 0x45, 0x0c, 0x42, 0xf3, 0xfc, 0xbd, 0xa4, 0x09, 0xc3, 0xac, 0xe2, 0xa5, 0xf8, 0x57, 0xea, 0x10, 0x61, 0x2c, 0x60, 0x93, 0xf8, 0x31, 0x5e, 0xb2, 0xd4, 0x48, 0x13, 0x4e, 0x71, 0x6b, 0x03, 0x20, 0x78, 0xb6, 0x83, 0x01, 0x62, 0x2e, 0x3c, 0x21, 0x86, 0xab, 0x58, 0x3d, 0x97, 0x6e, 0x76, 0x9f, 0xeb, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_371_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_371_sig[] = {
	0x47, 0xeb, 0x11, 0x8e, 0x0c, 0xc1, 0x22, 0x2c, 0xb8, 0xb2, 0xba, 0xb7, 0x27, 0x45, 0xa9, 0x32, 0xf0, 0x5c, 0xe9, 0x6e, 0x79, 0xf4, 0xe9, 0x8b, 0xe1, 0xe2, 0x86, 0x8a, 0x2b, 0x26, 0xa4, 0x22, 0x07, 0xa7, 0x14, 0x81, 0x3b, 0x9e, 0x70, 0x07, 0x7d, 0xf6, 0x98, 0xb8, 0x29, 0xd1, 0x58, 0xdb, 0xe2, 0xc6, 0x25, 0xba, 0x54, 0x54, 0xb7, 0x1f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_371 = {
	.name = "ecdsa_brainpoolp224r1_sha224_371",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_371_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_371_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_371_sig,
	.siglen = 56,
	.result = -1,
	.comment = "comparison with point at infinity , tcId is 306 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 372 for ECDSA, tcId is 307 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_372_pubkey[] = {
	0x4d, 0x4b, 0xd5, 0x69, 0x3d, 0x86, 0xdd, 0x9a, 0x60, 0x16, 0xba, 0x80, 0x6d, 0x80, 0x31, 0xf9, 0x4d, 0xc8, 0xe2, 0xd3, 0x3c, 0x6f, 0x58, 0x71, 0xa0, 0x0b, 0x64, 0x73, 0x2a, 0x46, 0x62, 0xf2, 0x95, 0x24, 0xec, 0xe7, 0x54, 0x82, 0x8b, 0x9d, 0x82, 0x9c, 0x0a, 0x07, 0x24, 0xd9, 0xbd, 0x9d, 0x28, 0x8d, 0x21, 0xf8, 0x7e, 0x3f, 0xb1, 0xfa, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_372_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_372_sig[] = {
	0x33, 0xb7, 0xe4, 0x98, 0xbc, 0xda, 0x1a, 0x33, 0xe6, 0x1a, 0x67, 0xaf, 0x56, 0xa3, 0x6d, 0x12, 0xdf, 0x70, 0x32, 0x25, 0x5d, 0xdf, 0x5e, 0x1e, 0xc6, 0x5a, 0x56, 0x69, 0x47, 0xeb, 0x11, 0x8e, 0x0c, 0xc1, 0x22, 0x2c, 0xb8, 0xb2, 0xba, 0xb7, 0x27, 0x45, 0xa9, 0x32, 0xf0, 0x5c, 0xe9, 0x6e, 0x79, 0xf4, 0xe9, 0x8b, 0xe1, 0xe2, 0x86, 0x8a, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_372 = {
	.name = "ecdsa_brainpoolp224r1_sha224_372",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_372_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_372_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_372_sig,
	.siglen = 56,
	.result = 1,
	.comment = "extreme value for k and edgecase s, tcId is 307 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 373 for ECDSA, tcId is 308 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_373_pubkey[] = {
	0xbe, 0x0e, 0xfb, 0x48, 0x41, 0xdf, 0x37, 0xab, 0xcd, 0xcf, 0x3f, 0x28, 0xdd, 0xb0, 0xd5, 0x75, 0x1a, 0x92, 0xa0, 0xfe, 0x7a, 0x3e, 0x88, 0xd1, 0xab, 0x02, 0x83, 0x2c, 0xbb, 0x53, 0xcc, 0xd6, 0x6b, 0x9c, 0x0e, 0x42, 0x43, 0x80, 0x69, 0x3d, 0x64, 0x16, 0xfc, 0x2e, 0x1a, 0x3c, 0x79, 0x3a, 0x35, 0x5f, 0x7d, 0x05, 0xf9, 0x63, 0xf4, 0x35, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_373_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_373_sig[] = {
	0x33, 0xb7, 0xe4, 0x98, 0xbc, 0xda, 0x1a, 0x33, 0xe6, 0x1a, 0x67, 0xaf, 0x56, 0xa3, 0x6d, 0x12, 0xdf, 0x70, 0x32, 0x25, 0x5d, 0xdf, 0x5e, 0x1e, 0xc6, 0x5a, 0x56, 0x69, 0xb8, 0xee, 0xbf, 0x6d, 0x45, 0x5e, 0x57, 0xe0, 0xb6, 0x5d, 0xe0, 0x20, 0x1b, 0xd7, 0xb3, 0x15, 0x45, 0x81, 0x33, 0xae, 0x5e, 0x2c, 0xa1, 0xb0, 0xd7, 0x21, 0xec, 0x3f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_373 = {
	.name = "ecdsa_brainpoolp224r1_sha224_373",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_373_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_373_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_373_sig,
	.siglen = 56,
	.result = 1,
	.comment = "extreme value for k and s^-1, tcId is 308 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 374 for ECDSA, tcId is 309 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_374_pubkey[] = {
	0xbc, 0x02, 0x72, 0xe3, 0x69, 0x3a, 0x05, 0xe7, 0x88, 0x39, 0x2c, 0x88, 0x0f, 0x9d, 0xe9, 0x5c, 0x72, 0xe2, 0x93, 0xfd, 0x1b, 0x13, 0xf1, 0xe2, 0x2a, 0x99, 0x07, 0xa3, 0x69, 0x95, 0x06, 0xe4, 0x59, 0x0f, 0xa9, 0x0c, 0x62, 0x57, 0xb1, 0xc4, 0xe3, 0x63, 0x2c, 0xcc, 0x48, 0x6c, 0xb8, 0x33, 0xcb, 0xbc, 0xbf, 0x21, 0xb4, 0xa2, 0x60, 0x41, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_374_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_374_sig[] = {
	0x33, 0xb7, 0xe4, 0x98, 0xbc, 0xda, 0x1a, 0x33, 0xe6, 0x1a, 0x67, 0xaf, 0x56, 0xa3, 0x6d, 0x12, 0xdf, 0x70, 0x32, 0x25, 0x5d, 0xdf, 0x5e, 0x1e, 0xc6, 0x5a, 0x56, 0x69, 0xac, 0x9a, 0x90, 0x88, 0x1e, 0x9c, 0x52, 0x04, 0xee, 0x79, 0xc0, 0x1d, 0xf7, 0xda, 0x62, 0xe0, 0xa7, 0x45, 0x63, 0x6f, 0x8b, 0x18, 0x96, 0xe9, 0x51, 0x52, 0xdc, 0x7f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_374 = {
	.name = "ecdsa_brainpoolp224r1_sha224_374",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_374_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_374_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_374_sig,
	.siglen = 56,
	.result = 1,
	.comment = "extreme value for k and s^-1, tcId is 309 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 375 for ECDSA, tcId is 310 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_375_pubkey[] = {
	0xa8, 0x3b, 0xc3, 0xe9, 0x04, 0x3c, 0xb9, 0x38, 0xda, 0xe1, 0x67, 0xbb, 0xea, 0x2f, 0x7d, 0x62, 0x34, 0x86, 0xf4, 0x03, 0x8d, 0xf4, 0x53, 0x12, 0xe8, 0x46, 0x7b, 0xda, 0x73, 0x63, 0xfa, 0x58, 0xaf, 0x36, 0x3a, 0x71, 0x83, 0x5d, 0xa0, 0x94, 0x13, 0xc8, 0x82, 0x27, 0x84, 0x9c, 0x6f, 0x0f, 0xfe, 0x8e, 0x4e, 0x40, 0xaf, 0xf5, 0x10, 0x23, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_375_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_375_sig[] = {
	0x33, 0xb7, 0xe4, 0x98, 0xbc, 0xda, 0x1a, 0x33, 0xe6, 0x1a, 0x67, 0xaf, 0x56, 0xa3, 0x6d, 0x12, 0xdf, 0x70, 0x32, 0x25, 0x5d, 0xdf, 0x5e, 0x1e, 0xc6, 0x5a, 0x56, 0x69, 0x2b, 0x26, 0xa4, 0x22, 0x07, 0xa7, 0x14, 0x81, 0x3b, 0x9e, 0x70, 0x07, 0x7d, 0xf6, 0x98, 0xb8, 0x29, 0xd1, 0x58, 0xdb, 0xe2, 0xc6, 0x25, 0xba, 0x54, 0x54, 0xb7, 0x20, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_375 = {
	.name = "ecdsa_brainpoolp224r1_sha224_375",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_375_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_375_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_375_sig,
	.siglen = 56,
	.result = 1,
	.comment = "extreme value for k and s^-1, tcId is 310 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 376 for ECDSA, tcId is 311 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_376_pubkey[] = {
	0x3b, 0xd0, 0x8a, 0x1c, 0x46, 0x63, 0x85, 0x64, 0x52, 0x1d, 0xed, 0x3f, 0xa7, 0x7c, 0xe9, 0xc9, 0x55, 0x38, 0xe4, 0x97, 0x03, 0xeb, 0xb9, 0xf8, 0xd3, 0x6b, 0xe6, 0xf7, 0x27, 0x6f, 0xfa, 0x12, 0x80, 0x51, 0x67, 0x1f, 0x7e, 0x4c, 0x63, 0xe9, 0xb8, 0x13, 0x2d, 0xe9, 0xf3, 0x38, 0x9c, 0xc5, 0x25, 0xd7, 0x26, 0x82, 0xb6, 0x01, 0x9e, 0xc3, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_376_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_376_sig[] = {
	0x33, 0xb7, 0xe4, 0x98, 0xbc, 0xda, 0x1a, 0x33, 0xe6, 0x1a, 0x67, 0xaf, 0x56, 0xa3, 0x6d, 0x12, 0xdf, 0x70, 0x32, 0x25, 0x5d, 0xdf, 0x5e, 0x1e, 0xc6, 0x5a, 0x56, 0x69, 0x1e, 0xd2, 0x75, 0x3c, 0xe0, 0xe5, 0x0e, 0xa5, 0x73, 0xba, 0x50, 0x05, 0x59, 0xf9, 0x48, 0x83, 0x8b, 0x95, 0x88, 0x9d, 0x0f, 0xb2, 0x1a, 0xf2, 0xce, 0x85, 0xa7, 0x60, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_376 = {
	.name = "ecdsa_brainpoolp224r1_sha224_376",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_376_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_376_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_376_sig,
	.siglen = 56,
	.result = 1,
	.comment = "extreme value for k and s^-1, tcId is 311 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 377 for ECDSA, tcId is 312 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_377_pubkey[] = {
	0xa3, 0xdb, 0x2b, 0x3e, 0x2c, 0x62, 0xc4, 0x2b, 0xf4, 0xfb, 0x0e, 0x11, 0xc2, 0x90, 0x8f, 0xd1, 0x7f, 0xe8, 0x3d, 0xa3, 0xac, 0x9c, 0x09, 0x80, 0x23, 0x4e, 0xfd, 0xbd, 0x3c, 0xbe, 0xec, 0x40, 0x27, 0xbd, 0x7c, 0x10, 0x9b, 0x27, 0xae, 0x2f, 0x7c, 0xf0, 0x4d, 0xc6, 0x5e, 0xea, 0xf1, 0x3f, 0xaa, 0x22, 0x4d, 0x32, 0xa2, 0x0f, 0x31, 0x63, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_377_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_377_sig[] = {
	0x33, 0xb7, 0xe4, 0x98, 0xbc, 0xda, 0x1a, 0x33, 0xe6, 0x1a, 0x67, 0xaf, 0x56, 0xa3, 0x6d, 0x12, 0xdf, 0x70, 0x32, 0x25, 0x5d, 0xdf, 0x5e, 0x1e, 0xc6, 0x5a, 0x56, 0x69, 0x58, 0xe3, 0x75, 0x18, 0xc6, 0xe4, 0x7a, 0x84, 0xde, 0x10, 0xcc, 0xb2, 0x54, 0xc0, 0x36, 0x93, 0x27, 0x11, 0x45, 0xf1, 0x3e, 0x00, 0xa9, 0x12, 0x37, 0xa4, 0xa5, 0x47, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_377 = {
	.name = "ecdsa_brainpoolp224r1_sha224_377",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_377_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_377_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_377_sig,
	.siglen = 56,
	.result = 1,
	.comment = "extreme value for k, tcId is 312 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 378 for ECDSA, tcId is 313 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_378_pubkey[] = {
	0x60, 0x6c, 0xe6, 0xf8, 0xc7, 0x7a, 0xc1, 0x7d, 0x5b, 0x75, 0x15, 0xd5, 0x85, 0x1e, 0xed, 0x15, 0x5e, 0xa1, 0x20, 0xcd, 0x07, 0xca, 0x42, 0x77, 0xb3, 0x5b, 0x8d, 0x36, 0x5f, 0x71, 0x6b, 0x62, 0xae, 0xe9, 0xa8, 0x1a, 0x01, 0x1b, 0xd1, 0xd2, 0xbc, 0xea, 0xf3, 0x7d, 0x5f, 0x3a, 0x61, 0xe5, 0xf7, 0x30, 0x7e, 0x0b, 0xb9, 0xc8, 0x92, 0xc8, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_378_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_378_sig[] = {
	0x0d, 0x90, 0x29, 0xad, 0x2c, 0x7e, 0x5c, 0xf4, 0x34, 0x08, 0x23, 0xb2, 0xa8, 0x7d, 0xc6, 0x8c, 0x9e, 0x4c, 0xe3, 0x17, 0x4c, 0x1e, 0x6e, 0xfd, 0xee, 0x12, 0xc0, 0x7d, 0x47, 0xeb, 0x11, 0x8e, 0x0c, 0xc1, 0x22, 0x2c, 0xb8, 0xb2, 0xba, 0xb7, 0x27, 0x45, 0xa9, 0x32, 0xf0, 0x5c, 0xe9, 0x6e, 0x79, 0xf4, 0xe9, 0x8b, 0xe1, 0xe2, 0x86, 0x8a, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_378 = {
	.name = "ecdsa_brainpoolp224r1_sha224_378",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_378_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_378_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_378_sig,
	.siglen = 56,
	.result = 1,
	.comment = "extreme value for k and edgecase s, tcId is 313 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 379 for ECDSA, tcId is 314 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_379_pubkey[] = {
	0x2a, 0xff, 0xbb, 0x82, 0x69, 0xcb, 0x78, 0x83, 0xda, 0xda, 0x33, 0x50, 0x39, 0x45, 0x79, 0x91, 0x2e, 0xf7, 0x56, 0xa8, 0xdf, 0x6b, 0xdd, 0x7d, 0xa3, 0x5d, 0x39, 0x8e, 0x90, 0x21, 0x3d, 0x93, 0x82, 0xb3, 0xd5, 0xfb, 0x9d, 0xde, 0x82, 0x72, 0x4d, 0x38, 0xe5, 0x67, 0x8c, 0x17, 0xe6, 0x10, 0xf4, 0x17, 0xcf, 0xe6, 0xf7, 0xef, 0xcd, 0x91, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_379_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_379_sig[] = {
	0x0d, 0x90, 0x29, 0xad, 0x2c, 0x7e, 0x5c, 0xf4, 0x34, 0x08, 0x23, 0xb2, 0xa8, 0x7d, 0xc6, 0x8c, 0x9e, 0x4c, 0xe3, 0x17, 0x4c, 0x1e, 0x6e, 0xfd, 0xee, 0x12, 0xc0, 0x7d, 0xb8, 0xee, 0xbf, 0x6d, 0x45, 0x5e, 0x57, 0xe0, 0xb6, 0x5d, 0xe0, 0x20, 0x1b, 0xd7, 0xb3, 0x15, 0x45, 0x81, 0x33, 0xae, 0x5e, 0x2c, 0xa1, 0xb0, 0xd7, 0x21, 0xec, 0x3f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_379 = {
	.name = "ecdsa_brainpoolp224r1_sha224_379",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_379_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_379_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_379_sig,
	.siglen = 56,
	.result = 1,
	.comment = "extreme value for k and s^-1, tcId is 314 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 380 for ECDSA, tcId is 315 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_380_pubkey[] = {
	0x19, 0xcd, 0xd4, 0x4e, 0x2a, 0x33, 0x11, 0x3a, 0x88, 0x45, 0x58, 0xe7, 0xee, 0x0e, 0xfb, 0x41, 0xba, 0xfe, 0x1a, 0xdc, 0xdc, 0xf9, 0x5d, 0xf6, 0xde, 0x6a, 0x25, 0x11, 0x5f, 0x42, 0x8e, 0xe9, 0x98, 0xa3, 0x48, 0x56, 0xf2, 0xac, 0x3f, 0x6f, 0x39, 0xc7, 0x23, 0x7b, 0xf1, 0xf9, 0xde, 0x23, 0x21, 0x75, 0xd7, 0x47, 0xb5, 0xcd, 0x97, 0xfe, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_380_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_380_sig[] = {
	0x0d, 0x90, 0x29, 0xad, 0x2c, 0x7e, 0x5c, 0xf4, 0x34, 0x08, 0x23, 0xb2, 0xa8, 0x7d, 0xc6, 0x8c, 0x9e, 0x4c, 0xe3, 0x17, 0x4c, 0x1e, 0x6e, 0xfd, 0xee, 0x12, 0xc0, 0x7d, 0xac, 0x9a, 0x90, 0x88, 0x1e, 0x9c, 0x52, 0x04, 0xee, 0x79, 0xc0, 0x1d, 0xf7, 0xda, 0x62, 0xe0, 0xa7, 0x45, 0x63, 0x6f, 0x8b, 0x18, 0x96, 0xe9, 0x51, 0x52, 0xdc, 0x7f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_380 = {
	.name = "ecdsa_brainpoolp224r1_sha224_380",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_380_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_380_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_380_sig,
	.siglen = 56,
	.result = 1,
	.comment = "extreme value for k and s^-1, tcId is 315 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 381 for ECDSA, tcId is 316 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_381_pubkey[] = {
	0xb7, 0x2f, 0x7c, 0x1a, 0x3c, 0x85, 0x62, 0xcb, 0x8d, 0xe9, 0x92, 0x5e, 0xec, 0x04, 0x1c, 0xcc, 0x26, 0x36, 0x49, 0xc6, 0x52, 0x47, 0x62, 0xb9, 0xf4, 0x58, 0x5e, 0xe3, 0x9d, 0xf7, 0x56, 0xda, 0x08, 0xd1, 0x27, 0x4a, 0xd7, 0x2d, 0x8c, 0xac, 0x29, 0x3a, 0xa6, 0x0d, 0x15, 0x0c, 0x77, 0x13, 0x1f, 0x9f, 0xa2, 0x8c, 0xcd, 0xff, 0xdf, 0xa0, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_381_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_381_sig[] = {
	0x0d, 0x90, 0x29, 0xad, 0x2c, 0x7e, 0x5c, 0xf4, 0x34, 0x08, 0x23, 0xb2, 0xa8, 0x7d, 0xc6, 0x8c, 0x9e, 0x4c, 0xe3, 0x17, 0x4c, 0x1e, 0x6e, 0xfd, 0xee, 0x12, 0xc0, 0x7d, 0x2b, 0x26, 0xa4, 0x22, 0x07, 0xa7, 0x14, 0x81, 0x3b, 0x9e, 0x70, 0x07, 0x7d, 0xf6, 0x98, 0xb8, 0x29, 0xd1, 0x58, 0xdb, 0xe2, 0xc6, 0x25, 0xba, 0x54, 0x54, 0xb7, 0x20, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_381 = {
	.name = "ecdsa_brainpoolp224r1_sha224_381",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_381_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_381_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_381_sig,
	.siglen = 56,
	.result = 1,
	.comment = "extreme value for k and s^-1, tcId is 316 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 382 for ECDSA, tcId is 317 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_382_pubkey[] = {
	0x9d, 0x37, 0x03, 0xb3, 0x20, 0x5b, 0x12, 0x3c, 0x90, 0x3a, 0x04, 0x46, 0x97, 0x32, 0x47, 0xc1, 0x6a, 0x88, 0xd1, 0x03, 0xfe, 0xa9, 0xd0, 0x4d, 0xd0, 0x2a, 0x70, 0x2b, 0x65, 0x18, 0x6b, 0x77, 0x7b, 0x57, 0xea, 0xde, 0xe8, 0x15, 0x4c, 0x02, 0xfc, 0xe0, 0xe9, 0x5c, 0x3f, 0x06, 0x14, 0x68, 0x49, 0x9b, 0xac, 0x3d, 0xc6, 0x02, 0x9e, 0x8c, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_382_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_382_sig[] = {
	0x0d, 0x90, 0x29, 0xad, 0x2c, 0x7e, 0x5c, 0xf4, 0x34, 0x08, 0x23, 0xb2, 0xa8, 0x7d, 0xc6, 0x8c, 0x9e, 0x4c, 0xe3, 0x17, 0x4c, 0x1e, 0x6e, 0xfd, 0xee, 0x12, 0xc0, 0x7d, 0x1e, 0xd2, 0x75, 0x3c, 0xe0, 0xe5, 0x0e, 0xa5, 0x73, 0xba, 0x50, 0x05, 0x59, 0xf9, 0x48, 0x83, 0x8b, 0x95, 0x88, 0x9d, 0x0f, 0xb2, 0x1a, 0xf2, 0xce, 0x85, 0xa7, 0x60, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_382 = {
	.name = "ecdsa_brainpoolp224r1_sha224_382",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_382_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_382_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_382_sig,
	.siglen = 56,
	.result = 1,
	.comment = "extreme value for k and s^-1, tcId is 317 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 383 for ECDSA, tcId is 318 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_383_pubkey[] = {
	0x3e, 0xa5, 0x72, 0x50, 0x5a, 0x48, 0xb1, 0xbe, 0xd0, 0x85, 0x95, 0x3d, 0xa7, 0xd4, 0xc9, 0x63, 0xc2, 0xc5, 0xb6, 0xad, 0x99, 0x77, 0x9d, 0x9d, 0x54, 0xba, 0x40, 0x12, 0x94, 0x47, 0x00, 0x74, 0xe0, 0x25, 0x2d, 0xa1, 0x59, 0xa0, 0xc0, 0xd0, 0xb2, 0xf8, 0xd4, 0xc2, 0x42, 0xcb, 0x94, 0xba, 0xb2, 0xc2, 0x02, 0x0c, 0x4b, 0x2d, 0xf4, 0x99, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_383_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_383_sig[] = {
	0x0d, 0x90, 0x29, 0xad, 0x2c, 0x7e, 0x5c, 0xf4, 0x34, 0x08, 0x23, 0xb2, 0xa8, 0x7d, 0xc6, 0x8c, 0x9e, 0x4c, 0xe3, 0x17, 0x4c, 0x1e, 0x6e, 0xfd, 0xee, 0x12, 0xc0, 0x7d, 0x58, 0xe3, 0x75, 0x18, 0xc6, 0xe4, 0x7a, 0x84, 0xde, 0x10, 0xcc, 0xb2, 0x54, 0xc0, 0x36, 0x93, 0x27, 0x11, 0x45, 0xf1, 0x3e, 0x00, 0xa9, 0x12, 0x37, 0xa4, 0xa5, 0x47, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_383 = {
	.name = "ecdsa_brainpoolp224r1_sha224_383",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_383_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_383_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_383_sig,
	.siglen = 56,
	.result = 1,
	.comment = "extreme value for k, tcId is 318 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 384 for ECDSA, tcId is 319 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_384_pubkey[] = {
	0x0d, 0x90, 0x29, 0xad, 0x2c, 0x7e, 0x5c, 0xf4, 0x34, 0x08, 0x23, 0xb2, 0xa8, 0x7d, 0xc6, 0x8c, 0x9e, 0x4c, 0xe3, 0x17, 0x4c, 0x1e, 0x6e, 0xfd, 0xee, 0x12, 0xc0, 0x7d, 0x58, 0xaa, 0x56, 0xf7, 0x72, 0xc0, 0x72, 0x6f, 0x24, 0xc6, 0xb8, 0x9e, 0x4e, 0xcd, 0xac, 0x24, 0x35, 0x4b, 0x9e, 0x99, 0xca, 0xa3, 0xf6, 0xd3, 0x76, 0x14, 0x02, 0xcd, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_384_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_384_sig[] = {
	0x75, 0x3b, 0xb4, 0x00, 0x78, 0x93, 0x40, 0x81, 0xd7, 0xbd, 0x11, 0x3e, 0xc4, 0x9b, 0x19, 0xef, 0x09, 0xd1, 0xba, 0x33, 0x49, 0x86, 0x90, 0x51, 0x6d, 0x4d, 0x12, 0x2c, 0x1e, 0xd2, 0x75, 0x3c, 0xe0, 0xe5, 0x0e, 0xa5, 0x73, 0xba, 0x50, 0x05, 0x59, 0xf9, 0x48, 0x83, 0x8b, 0x95, 0x88, 0x9d, 0x0f, 0xb2, 0x1a, 0xf2, 0xce, 0x85, 0xa7, 0x5f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_384 = {
	.name = "ecdsa_brainpoolp224r1_sha224_384",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_384_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_384_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_384_sig,
	.siglen = 56,
	.result = -1,
	.comment = "testing point duplication, tcId is 319 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 385 for ECDSA, tcId is 320 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_385_pubkey[] = {
	0x0d, 0x90, 0x29, 0xad, 0x2c, 0x7e, 0x5c, 0xf4, 0x34, 0x08, 0x23, 0xb2, 0xa8, 0x7d, 0xc6, 0x8c, 0x9e, 0x4c, 0xe3, 0x17, 0x4c, 0x1e, 0x6e, 0xfd, 0xee, 0x12, 0xc0, 0x7d, 0x58, 0xaa, 0x56, 0xf7, 0x72, 0xc0, 0x72, 0x6f, 0x24, 0xc6, 0xb8, 0x9e, 0x4e, 0xcd, 0xac, 0x24, 0x35, 0x4b, 0x9e, 0x99, 0xca, 0xa3, 0xf6, 0xd3, 0x76, 0x14, 0x02, 0xcd, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_385_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_385_sig[] = {
	0x62, 0x85, 0x80, 0xa9, 0xad, 0xb0, 0x26, 0x04, 0x52, 0x5b, 0x1e, 0xe6, 0xb1, 0x35, 0xe1, 0xa9, 0xc7, 0x45, 0x02, 0x18, 0x24, 0x58, 0x2c, 0x52, 0x38, 0x5a, 0x81, 0x73, 0x1e, 0xd2, 0x75, 0x3c, 0xe0, 0xe5, 0x0e, 0xa5, 0x73, 0xba, 0x50, 0x05, 0x59, 0xf9, 0x48, 0x83, 0x8b, 0x95, 0x88, 0x9d, 0x0f, 0xb2, 0x1a, 0xf2, 0xce, 0x85, 0xa7, 0x5f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_385 = {
	.name = "ecdsa_brainpoolp224r1_sha224_385",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_385_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_385_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_385_sig,
	.siglen = 56,
	.result = -1,
	.comment = "testing point duplication, tcId is 320 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 386 for ECDSA, tcId is 321 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_386_pubkey[] = {
	0x0d, 0x90, 0x29, 0xad, 0x2c, 0x7e, 0x5c, 0xf4, 0x34, 0x08, 0x23, 0xb2, 0xa8, 0x7d, 0xc6, 0x8c, 0x9e, 0x4c, 0xe3, 0x17, 0x4c, 0x1e, 0x6e, 0xfd, 0xee, 0x12, 0xc0, 0x7d, 0x7f, 0x16, 0xdd, 0xb2, 0xb3, 0x82, 0xf4, 0x17, 0x05, 0x51, 0x77, 0x87, 0x27, 0x04, 0x2b, 0x63, 0x7b, 0x53, 0x68, 0xbd, 0xcd, 0x36, 0x93, 0x22, 0x08, 0xb4, 0xbe, 0x32, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_386_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_386_sig[] = {
	0x75, 0x3b, 0xb4, 0x00, 0x78, 0x93, 0x40, 0x81, 0xd7, 0xbd, 0x11, 0x3e, 0xc4, 0x9b, 0x19, 0xef, 0x09, 0xd1, 0xba, 0x33, 0x49, 0x86, 0x90, 0x51, 0x6d, 0x4d, 0x12, 0x2c, 0x1e, 0xd2, 0x75, 0x3c, 0xe0, 0xe5, 0x0e, 0xa5, 0x73, 0xba, 0x50, 0x05, 0x59, 0xf9, 0x48, 0x83, 0x8b, 0x95, 0x88, 0x9d, 0x0f, 0xb2, 0x1a, 0xf2, 0xce, 0x85, 0xa7, 0x5f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_386 = {
	.name = "ecdsa_brainpoolp224r1_sha224_386",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_386_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_386_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_386_sig,
	.siglen = 56,
	.result = -1,
	.comment = "testing point duplication, tcId is 321 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 387 for ECDSA, tcId is 322 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_387_pubkey[] = {
	0x0d, 0x90, 0x29, 0xad, 0x2c, 0x7e, 0x5c, 0xf4, 0x34, 0x08, 0x23, 0xb2, 0xa8, 0x7d, 0xc6, 0x8c, 0x9e, 0x4c, 0xe3, 0x17, 0x4c, 0x1e, 0x6e, 0xfd, 0xee, 0x12, 0xc0, 0x7d, 0x7f, 0x16, 0xdd, 0xb2, 0xb3, 0x82, 0xf4, 0x17, 0x05, 0x51, 0x77, 0x87, 0x27, 0x04, 0x2b, 0x63, 0x7b, 0x53, 0x68, 0xbd, 0xcd, 0x36, 0x93, 0x22, 0x08, 0xb4, 0xbe, 0x32, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_387_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_387_sig[] = {
	0x62, 0x85, 0x80, 0xa9, 0xad, 0xb0, 0x26, 0x04, 0x52, 0x5b, 0x1e, 0xe6, 0xb1, 0x35, 0xe1, 0xa9, 0xc7, 0x45, 0x02, 0x18, 0x24, 0x58, 0x2c, 0x52, 0x38, 0x5a, 0x81, 0x73, 0x1e, 0xd2, 0x75, 0x3c, 0xe0, 0xe5, 0x0e, 0xa5, 0x73, 0xba, 0x50, 0x05, 0x59, 0xf9, 0x48, 0x83, 0x8b, 0x95, 0x88, 0x9d, 0x0f, 0xb2, 0x1a, 0xf2, 0xce, 0x85, 0xa7, 0x5f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_387 = {
	.name = "ecdsa_brainpoolp224r1_sha224_387",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_387_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_387_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_387_sig,
	.siglen = 56,
	.result = -1,
	.comment = "testing point duplication, tcId is 322 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 388 for ECDSA, tcId is 323 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_388_pubkey[] = {
	0xb5, 0x54, 0xfc, 0x25, 0xe9, 0xf0, 0x98, 0xea, 0xf1, 0x46, 0x6c, 0x35, 0x32, 0x8c, 0x97, 0x30, 0x5d, 0x0d, 0x4a, 0xa0, 0xe4, 0x46, 0x2e, 0x8b, 0xaf, 0x7a, 0x8e, 0x7e, 0xd0, 0x8f, 0xc4, 0x0e, 0xb0, 0x1d, 0xc8, 0x55, 0x57, 0x7b, 0xae, 0xa9, 0xe3, 0x07, 0x07, 0x70, 0x61, 0x6f, 0x57, 0xb1, 0x7e, 0xa9, 0x85, 0x4c, 0xad, 0x93, 0x88, 0x1a, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_388_sig[] = {
	0xb9, 0x82, 0xbe, 0xa8, 0x0d, 0x10, 0x81, 0x6b, 0xb4, 0x50, 0xa3, 0xfa, 0xaa, 0xed, 0x4e, 0xd5, 0x4f, 0xb1, 0x97, 0xb3, 0xbf, 0xf9, 0x5a, 0xf2, 0x5d, 0x7d, 0x37, 0x86, 0x9e, 0x6e, 0xa2, 0xe5, 0x87, 0x13, 0xf1, 0x30, 0x4d, 0x29, 0xde, 0xbf, 0x85, 0x59, 0xa7, 0x4a, 0x89, 0xe0, 0x18, 0xba, 0xe2, 0x8b, 0x05, 0x55, 0x6e, 0x54, 0x82, 0xa1, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_388 = {
	.name = "ecdsa_brainpoolp224r1_sha224_388",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_388_pubkey,
	.pubkeylen = 56,
	.msg = (const unsigned char*)"",
	.msglen = 0,
	.sig = ecdsa_brainpoolp224r1_sha224_388_sig,
	.siglen = 56,
	.result = 1,
	.comment = "pseudorandom signature, tcId is 323 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 389 for ECDSA, tcId is 324 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_389_pubkey[] = {
	0xb5, 0x54, 0xfc, 0x25, 0xe9, 0xf0, 0x98, 0xea, 0xf1, 0x46, 0x6c, 0x35, 0x32, 0x8c, 0x97, 0x30, 0x5d, 0x0d, 0x4a, 0xa0, 0xe4, 0x46, 0x2e, 0x8b, 0xaf, 0x7a, 0x8e, 0x7e, 0xd0, 0x8f, 0xc4, 0x0e, 0xb0, 0x1d, 0xc8, 0x55, 0x57, 0x7b, 0xae, 0xa9, 0xe3, 0x07, 0x07, 0x70, 0x61, 0x6f, 0x57, 0xb1, 0x7e, 0xa9, 0x85, 0x4c, 0xad, 0x93, 0x88, 0x1a, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_389_msg[] = {
	0x4d, 0x73, 0x67, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_389_sig[] = {
	0x4d, 0xab, 0xc5, 0xfe, 0x96, 0x2b, 0x5f, 0x8a, 0x66, 0x81, 0xe9, 0x4a, 0x21, 0x65, 0xd9, 0xb6, 0xbe, 0x19, 0x40, 0xf2, 0x0e, 0x27, 0xce, 0xb7, 0x3f, 0xc4, 0xea, 0x7d, 0x74, 0x6e, 0x9b, 0xba, 0x7e, 0xfb, 0x90, 0xfc, 0xec, 0xc2, 0x63, 0xc2, 0x29, 0xa1, 0x6d, 0x80, 0x9d, 0x35, 0x47, 0xc2, 0x8a, 0x26, 0xcd, 0x71, 0xa5, 0x2a, 0xbd, 0xc5, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_389 = {
	.name = "ecdsa_brainpoolp224r1_sha224_389",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_389_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_389_msg,
	.msglen = 3,
	.sig = ecdsa_brainpoolp224r1_sha224_389_sig,
	.siglen = 56,
	.result = 1,
	.comment = "pseudorandom signature, tcId is 324 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 390 for ECDSA, tcId is 325 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_390_pubkey[] = {
	0xb5, 0x54, 0xfc, 0x25, 0xe9, 0xf0, 0x98, 0xea, 0xf1, 0x46, 0x6c, 0x35, 0x32, 0x8c, 0x97, 0x30, 0x5d, 0x0d, 0x4a, 0xa0, 0xe4, 0x46, 0x2e, 0x8b, 0xaf, 0x7a, 0x8e, 0x7e, 0xd0, 0x8f, 0xc4, 0x0e, 0xb0, 0x1d, 0xc8, 0x55, 0x57, 0x7b, 0xae, 0xa9, 0xe3, 0x07, 0x07, 0x70, 0x61, 0x6f, 0x57, 0xb1, 0x7e, 0xa9, 0x85, 0x4c, 0xad, 0x93, 0x88, 0x1a, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_390_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_390_sig[] = {
	0x95, 0xb1, 0x1e, 0x32, 0x00, 0x07, 0xa2, 0xe0, 0xf8, 0xce, 0x00, 0xf9, 0x05, 0x8c, 0xa9, 0xb9, 0x19, 0xe8, 0xd6, 0xaa, 0xd5, 0x44, 0xa8, 0xf9, 0x80, 0x8b, 0x44, 0xa1, 0x15, 0xa9, 0x62, 0x01, 0x9c, 0x85, 0xa5, 0xb1, 0xfa, 0x74, 0x74, 0x16, 0x2d, 0x03, 0xcd, 0x0e, 0x52, 0x8e, 0x8b, 0x93, 0xbc, 0xc8, 0x49, 0x20, 0xaf, 0x57, 0x9f, 0x61, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_390 = {
	.name = "ecdsa_brainpoolp224r1_sha224_390",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_390_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_390_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp224r1_sha224_390_sig,
	.siglen = 56,
	.result = 1,
	.comment = "pseudorandom signature, tcId is 325 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 391 for ECDSA, tcId is 326 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_391_pubkey[] = {
	0xb5, 0x54, 0xfc, 0x25, 0xe9, 0xf0, 0x98, 0xea, 0xf1, 0x46, 0x6c, 0x35, 0x32, 0x8c, 0x97, 0x30, 0x5d, 0x0d, 0x4a, 0xa0, 0xe4, 0x46, 0x2e, 0x8b, 0xaf, 0x7a, 0x8e, 0x7e, 0xd0, 0x8f, 0xc4, 0x0e, 0xb0, 0x1d, 0xc8, 0x55, 0x57, 0x7b, 0xae, 0xa9, 0xe3, 0x07, 0x07, 0x70, 0x61, 0x6f, 0x57, 0xb1, 0x7e, 0xa9, 0x85, 0x4c, 0xad, 0x93, 0x88, 0x1a, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_391_msg[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_391_sig[] = {
	0x9e, 0x4d, 0xab, 0x9e, 0x0b, 0x00, 0x97, 0xe3, 0x65, 0x78, 0x3f, 0xc0, 0x5f, 0x01, 0x0c, 0x16, 0x0d, 0x36, 0x1d, 0xf7, 0x92, 0x5b, 0x0d, 0xdb, 0xdf, 0xec, 0xe8, 0x8b, 0x84, 0x06, 0xa3, 0x65, 0xf0, 0x78, 0xf0, 0x31, 0xe6, 0xfa, 0xd6, 0x51, 0x1d, 0x69, 0xf8, 0xa6, 0x54, 0x83, 0xc1, 0x9a, 0x5a, 0x80, 0x0c, 0x39, 0x49, 0x0f, 0x75, 0x10, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_391 = {
	.name = "ecdsa_brainpoolp224r1_sha224_391",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_391_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_391_msg,
	.msglen = 20,
	.sig = ecdsa_brainpoolp224r1_sha224_391_sig,
	.siglen = 56,
	.result = 1,
	.comment = "pseudorandom signature, tcId is 326 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 392 for ECDSA, tcId is 327 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_392_pubkey[] = {
	0x80, 0x2a, 0x0f, 0x51, 0x20, 0x4e, 0xf6, 0xa8, 0x29, 0x21, 0x1b, 0xc0, 0x74, 0x08, 0x87, 0x46, 0x1e, 0xe4, 0xab, 0xa7, 0x36, 0xe9, 0xca, 0xee, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xb9, 0x31, 0xe0, 0x63, 0x00, 0x45, 0x13, 0x62, 0xd4, 0x44, 0x10, 0x6e, 0xeb, 0x5d, 0xab, 0xdd, 0xca, 0x65, 0x0f, 0xec, 0x4b, 0xe5, 0x5f, 0xc5, 0x45, 0xf7, 0xc8, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_392_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_392_sig[] = {
	0x0c, 0x93, 0xfd, 0x7f, 0x6d, 0xd0, 0xb6, 0x97, 0xd5, 0xc2, 0x87, 0xee, 0x61, 0xae, 0xe4, 0xdc, 0xbe, 0xdc, 0xc2, 0x08, 0x85, 0xc1, 0xe6, 0x21, 0x5b, 0x8b, 0x36, 0x08, 0x3b, 0xc7, 0xa1, 0xbe, 0xcc, 0xf1, 0xa8, 0xe8, 0x3a, 0xf2, 0xf5, 0x16, 0x2f, 0xc5, 0x39, 0xa1, 0xd0, 0x62, 0xbd, 0x63, 0x9a, 0x2f, 0xbe, 0xc5, 0x12, 0x90, 0x7a, 0x27, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_392 = {
	.name = "ecdsa_brainpoolp224r1_sha224_392",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_392_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_392_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_392_sig,
	.siglen = 56,
	.result = 1,
	.comment = "x-coordinate of the public key has many trailing 0's, tcId is 327 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 393 for ECDSA, tcId is 328 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_393_pubkey[] = {
	0x80, 0x2a, 0x0f, 0x51, 0x20, 0x4e, 0xf6, 0xa8, 0x29, 0x21, 0x1b, 0xc0, 0x74, 0x08, 0x87, 0x46, 0x1e, 0xe4, 0xab, 0xa7, 0x36, 0xe9, 0xca, 0xee, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xb9, 0x31, 0xe0, 0x63, 0x00, 0x45, 0x13, 0x62, 0xd4, 0x44, 0x10, 0x6e, 0xeb, 0x5d, 0xab, 0xdd, 0xca, 0x65, 0x0f, 0xec, 0x4b, 0xe5, 0x5f, 0xc5, 0x45, 0xf7, 0xc8, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_393_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_393_sig[] = {
	0x9e, 0x0b, 0x62, 0x0a, 0x2f, 0x31, 0x3a, 0xda, 0x75, 0x64, 0x63, 0xa2, 0x29, 0x88, 0xaf, 0xb6, 0x57, 0x1b, 0x3b, 0x03, 0x0a, 0x42, 0x85, 0xb1, 0x85, 0xe1, 0xcc, 0x80, 0xc3, 0xeb, 0xa0, 0x4c, 0x42, 0xe6, 0x4d, 0x40, 0x28, 0xac, 0xab, 0xcd, 0xcb, 0x7b, 0x2e, 0xed, 0x1b, 0x3c, 0xfb, 0x56, 0x0b, 0x8d, 0x7d, 0x14, 0xfb, 0x26, 0xac, 0xa3, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_393 = {
	.name = "ecdsa_brainpoolp224r1_sha224_393",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_393_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_393_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_393_sig,
	.siglen = 56,
	.result = 1,
	.comment = "x-coordinate of the public key has many trailing 0's, tcId is 328 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 394 for ECDSA, tcId is 329 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_394_pubkey[] = {
	0x80, 0x2a, 0x0f, 0x51, 0x20, 0x4e, 0xf6, 0xa8, 0x29, 0x21, 0x1b, 0xc0, 0x74, 0x08, 0x87, 0x46, 0x1e, 0xe4, 0xab, 0xa7, 0x36, 0xe9, 0xca, 0xee, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xb9, 0x31, 0xe0, 0x63, 0x00, 0x45, 0x13, 0x62, 0xd4, 0x44, 0x10, 0x6e, 0xeb, 0x5d, 0xab, 0xdd, 0xca, 0x65, 0x0f, 0xec, 0x4b, 0xe5, 0x5f, 0xc5, 0x45, 0xf7, 0xc8, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_394_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_394_sig[] = {
	0xa3, 0x06, 0xf5, 0x00, 0xda, 0x4f, 0x0a, 0x30, 0x94, 0x64, 0x79, 0x93, 0x6a, 0xaf, 0x9c, 0x63, 0x76, 0x76, 0xb0, 0xf0, 0x2d, 0x20, 0xae, 0x0d, 0x98, 0x1c, 0x25, 0xeb, 0x01, 0x56, 0x47, 0xf2, 0x50, 0x0b, 0xcb, 0xe3, 0x20, 0x4b, 0xdb, 0x80, 0x49, 0x72, 0xb8, 0x41, 0x89, 0x0b, 0x4e, 0x53, 0x19, 0x6c, 0xd8, 0xb1, 0x88, 0x99, 0x31, 0x51, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_394 = {
	.name = "ecdsa_brainpoolp224r1_sha224_394",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_394_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_394_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_394_sig,
	.siglen = 56,
	.result = 1,
	.comment = "x-coordinate of the public key has many trailing 0's, tcId is 329 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 395 for ECDSA, tcId is 330 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_395_pubkey[] = {
	0xcb, 0x32, 0x0c, 0x84, 0xf2, 0x6c, 0x00, 0xa1, 0xb4, 0xad, 0x71, 0x46, 0x91, 0x4c, 0xae, 0x12, 0x65, 0x29, 0x16, 0x5d, 0xe7, 0x36, 0x3d, 0x8a, 0xef, 0x9a, 0xbd, 0x05, 0xa3, 0x97, 0xd4, 0x6b, 0x87, 0x28, 0x31, 0x76, 0xb7, 0xf6, 0x9d, 0xa1, 0xf9, 0x46, 0x15, 0xca, 0x44, 0x31, 0xfc, 0x47, 0xb2, 0xa0, 0xe6, 0x0c, 0x00, 0x00, 0x00, 0x00, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_395_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_395_sig[] = {
	0x04, 0xf0, 0x0d, 0xd4, 0x4f, 0xdd, 0x8a, 0xe6, 0xb0, 0x8b, 0x86, 0xcc, 0xbd, 0xd7, 0xd6, 0x15, 0xaa, 0x9e, 0x49, 0x8a, 0x89, 0xb3, 0x50, 0x94, 0xc8, 0xa9, 0xa6, 0xfe, 0x49, 0x61, 0x7a, 0x16, 0x17, 0xc5, 0x6c, 0xe9, 0x0d, 0x41, 0xc5, 0x3e, 0xef, 0x4e, 0x62, 0x8f, 0x24, 0xc0, 0x47, 0xa0, 0x6e, 0x02, 0xc1, 0xf9, 0x21, 0x23, 0x44, 0x1f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_395 = {
	.name = "ecdsa_brainpoolp224r1_sha224_395",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_395_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_395_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_395_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key has many trailing 0's, tcId is 330 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 396 for ECDSA, tcId is 331 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_396_pubkey[] = {
	0xcb, 0x32, 0x0c, 0x84, 0xf2, 0x6c, 0x00, 0xa1, 0xb4, 0xad, 0x71, 0x46, 0x91, 0x4c, 0xae, 0x12, 0x65, 0x29, 0x16, 0x5d, 0xe7, 0x36, 0x3d, 0x8a, 0xef, 0x9a, 0xbd, 0x05, 0xa3, 0x97, 0xd4, 0x6b, 0x87, 0x28, 0x31, 0x76, 0xb7, 0xf6, 0x9d, 0xa1, 0xf9, 0x46, 0x15, 0xca, 0x44, 0x31, 0xfc, 0x47, 0xb2, 0xa0, 0xe6, 0x0c, 0x00, 0x00, 0x00, 0x00, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_396_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_396_sig[] = {
	0x12, 0x86, 0xf6, 0xa7, 0x37, 0x5b, 0xf6, 0x80, 0x51, 0xe3, 0x1b, 0x2e, 0x32, 0xb5, 0xf6, 0xc0, 0x98, 0x8c, 0x91, 0x89, 0x79, 0x92, 0x56, 0xe7, 0xce, 0x64, 0xe2, 0x91, 0x52, 0xd3, 0xc1, 0xf9, 0xe7, 0x77, 0xf2, 0x3c, 0x17, 0xcb, 0xc8, 0x32, 0xd0, 0xe5, 0xa8, 0x4b, 0xb6, 0x8b, 0x13, 0xde, 0xbf, 0x39, 0x38, 0x78, 0xd1, 0xa0, 0x64, 0x98, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_396 = {
	.name = "ecdsa_brainpoolp224r1_sha224_396",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_396_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_396_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_396_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key has many trailing 0's, tcId is 331 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 397 for ECDSA, tcId is 332 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_397_pubkey[] = {
	0xcb, 0x32, 0x0c, 0x84, 0xf2, 0x6c, 0x00, 0xa1, 0xb4, 0xad, 0x71, 0x46, 0x91, 0x4c, 0xae, 0x12, 0x65, 0x29, 0x16, 0x5d, 0xe7, 0x36, 0x3d, 0x8a, 0xef, 0x9a, 0xbd, 0x05, 0xa3, 0x97, 0xd4, 0x6b, 0x87, 0x28, 0x31, 0x76, 0xb7, 0xf6, 0x9d, 0xa1, 0xf9, 0x46, 0x15, 0xca, 0x44, 0x31, 0xfc, 0x47, 0xb2, 0xa0, 0xe6, 0x0c, 0x00, 0x00, 0x00, 0x00, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_397_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_397_sig[] = {
	0x58, 0x28, 0x25, 0xdf, 0x23, 0x68, 0xdc, 0xb9, 0x2f, 0xbb, 0xa3, 0xfa, 0x64, 0x54, 0xd1, 0x49, 0xd3, 0xb8, 0x60, 0xe3, 0xff, 0x32, 0x6a, 0xfe, 0x36, 0x21, 0x58, 0x13, 0x49, 0x33, 0x4f, 0xc6, 0xa7, 0x04, 0x18, 0xdb, 0xc4, 0x54, 0xda, 0x6a, 0x99, 0x7b, 0xc8, 0x37, 0x62, 0x70, 0xc3, 0xa3, 0x88, 0x63, 0xad, 0xb2, 0xaa, 0x70, 0xbb, 0x0f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_397 = {
	.name = "ecdsa_brainpoolp224r1_sha224_397",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_397_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_397_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_397_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key has many trailing 0's, tcId is 332 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 398 for ECDSA, tcId is 333 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_398_pubkey[] = {
	0x00, 0x00, 0x00, 0x00, 0x81, 0xdf, 0x97, 0x17, 0x44, 0xa2, 0x5a, 0xc9, 0x94, 0x72, 0xc3, 0xff, 0x5a, 0x8f, 0xc4, 0x9b, 0x86, 0xfc, 0x9f, 0xb5, 0x70, 0x44, 0x8f, 0xf9, 0x77, 0xf2, 0xd0, 0x7c, 0x1c, 0x92, 0x96, 0xb2, 0xf7, 0x74, 0x78, 0xd1, 0x3d, 0x5a, 0xb1, 0xc6, 0x39, 0x93, 0x96, 0x2f, 0x2d, 0xd0, 0x8e, 0xe7, 0xc3, 0x13, 0xde, 0xce, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_398_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_398_sig[] = {
	0x5a, 0x11, 0x71, 0x8c, 0x90, 0xa0, 0x24, 0x59, 0x80, 0x0f, 0x10, 0x9e, 0x4e, 0x84, 0x0c, 0xc2, 0x61, 0xd7, 0x82, 0xd6, 0x4e, 0x1c, 0x8a, 0x47, 0x12, 0xdd, 0x90, 0x81, 0xd2, 0x83, 0xb1, 0xc1, 0xe1, 0x10, 0xa4, 0x62, 0x0a, 0x69, 0x6f, 0xdf, 0x74, 0xa9, 0xc7, 0x79, 0x23, 0x52, 0x13, 0x9d, 0x54, 0xcc, 0xed, 0x8c, 0x97, 0x3d, 0x9e, 0x7e, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_398 = {
	.name = "ecdsa_brainpoolp224r1_sha224_398",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_398_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_398_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_398_sig,
	.siglen = 56,
	.result = 1,
	.comment = "x-coordinate of the public key is small, tcId is 333 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 399 for ECDSA, tcId is 334 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_399_pubkey[] = {
	0x00, 0x00, 0x00, 0x00, 0x81, 0xdf, 0x97, 0x17, 0x44, 0xa2, 0x5a, 0xc9, 0x94, 0x72, 0xc3, 0xff, 0x5a, 0x8f, 0xc4, 0x9b, 0x86, 0xfc, 0x9f, 0xb5, 0x70, 0x44, 0x8f, 0xf9, 0x77, 0xf2, 0xd0, 0x7c, 0x1c, 0x92, 0x96, 0xb2, 0xf7, 0x74, 0x78, 0xd1, 0x3d, 0x5a, 0xb1, 0xc6, 0x39, 0x93, 0x96, 0x2f, 0x2d, 0xd0, 0x8e, 0xe7, 0xc3, 0x13, 0xde, 0xce, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_399_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_399_sig[] = {
	0xd5, 0x77, 0xf2, 0x3e, 0x59, 0x24, 0x14, 0xe3, 0x51, 0xb3, 0x92, 0x8a, 0x59, 0x3c, 0x5d, 0x2f, 0x89, 0xf0, 0xc7, 0x2d, 0xf5, 0x13, 0xbf, 0xbc, 0x65, 0x35, 0xba, 0xbb, 0x1b, 0xb0, 0x9d, 0xd2, 0x35, 0x12, 0x4a, 0x14, 0xe0, 0x24, 0x69, 0x46, 0xf2, 0x80, 0x45, 0x0f, 0x15, 0x57, 0x69, 0x12, 0xae, 0xb7, 0x35, 0xb7, 0x3c, 0xe8, 0x28, 0xbc, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_399 = {
	.name = "ecdsa_brainpoolp224r1_sha224_399",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_399_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_399_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_399_sig,
	.siglen = 56,
	.result = 1,
	.comment = "x-coordinate of the public key is small, tcId is 334 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 400 for ECDSA, tcId is 335 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_400_pubkey[] = {
	0x00, 0x00, 0x00, 0x00, 0x81, 0xdf, 0x97, 0x17, 0x44, 0xa2, 0x5a, 0xc9, 0x94, 0x72, 0xc3, 0xff, 0x5a, 0x8f, 0xc4, 0x9b, 0x86, 0xfc, 0x9f, 0xb5, 0x70, 0x44, 0x8f, 0xf9, 0x77, 0xf2, 0xd0, 0x7c, 0x1c, 0x92, 0x96, 0xb2, 0xf7, 0x74, 0x78, 0xd1, 0x3d, 0x5a, 0xb1, 0xc6, 0x39, 0x93, 0x96, 0x2f, 0x2d, 0xd0, 0x8e, 0xe7, 0xc3, 0x13, 0xde, 0xce, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_400_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_400_sig[] = {
	0xaf, 0x8f, 0x83, 0x6e, 0x63, 0x99, 0x5d, 0xc7, 0x15, 0xa4, 0xd3, 0xc6, 0x84, 0x2c, 0x4e, 0x6c, 0x6c, 0xf4, 0x58, 0x6d, 0xf7, 0x6e, 0x46, 0x59, 0xd8, 0x09, 0xee, 0xc9, 0x85, 0xbe, 0xfd, 0x0b, 0x1b, 0xb8, 0xae, 0x18, 0x2c, 0x05, 0xd0, 0x71, 0xda, 0xd1, 0x80, 0x22, 0x4d, 0x22, 0x53, 0x3d, 0xce, 0x73, 0x7d, 0x4d, 0xda, 0x74, 0xd5, 0xd1, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_400 = {
	.name = "ecdsa_brainpoolp224r1_sha224_400",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_400_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_400_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_400_sig,
	.siglen = 56,
	.result = 1,
	.comment = "x-coordinate of the public key is small, tcId is 335 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 401 for ECDSA, tcId is 336 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_401_pubkey[] = {
	0x0d, 0x28, 0xb4, 0xf7, 0xfe, 0x1f, 0x6c, 0x6f, 0xa6, 0xa7, 0x7d, 0x11, 0xe4, 0x3b, 0xd3, 0xe9, 0x27, 0x17, 0x58, 0xdf, 0x34, 0xc6, 0x5f, 0xa5, 0x77, 0xa6, 0xdd, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x28, 0x01, 0xd4, 0x83, 0x82, 0x86, 0x16, 0x84, 0xb8, 0xd2, 0xcb, 0xd7, 0xe5, 0x98, 0x9a, 0x0d, 0x7c, 0x15, 0xa7, 0xe8, 0x19, 0xb5, 0x73, 0xaa, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_401_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_401_sig[] = {
	0x15, 0x6a, 0xa7, 0x86, 0x92, 0xc7, 0x8e, 0x97, 0x69, 0xab, 0xa7, 0x28, 0xc9, 0xee, 0xa7, 0x88, 0x35, 0xb5, 0x50, 0x00, 0x90, 0x1b, 0xa5, 0x07, 0x94, 0xa3, 0x3e, 0xfc, 0xb9, 0x78, 0x5d, 0xf4, 0x0a, 0x22, 0x13, 0x37, 0x74, 0x81, 0x31, 0x1b, 0x1a, 0x81, 0xd3, 0x10, 0xe7, 0x63, 0x41, 0x92, 0x7b, 0x8f, 0xba, 0x0d, 0x6e, 0x3e, 0xc7, 0xad, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_401 = {
	.name = "ecdsa_brainpoolp224r1_sha224_401",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_401_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_401_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_401_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key is small, tcId is 336 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 402 for ECDSA, tcId is 337 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_402_pubkey[] = {
	0x0d, 0x28, 0xb4, 0xf7, 0xfe, 0x1f, 0x6c, 0x6f, 0xa6, 0xa7, 0x7d, 0x11, 0xe4, 0x3b, 0xd3, 0xe9, 0x27, 0x17, 0x58, 0xdf, 0x34, 0xc6, 0x5f, 0xa5, 0x77, 0xa6, 0xdd, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x28, 0x01, 0xd4, 0x83, 0x82, 0x86, 0x16, 0x84, 0xb8, 0xd2, 0xcb, 0xd7, 0xe5, 0x98, 0x9a, 0x0d, 0x7c, 0x15, 0xa7, 0xe8, 0x19, 0xb5, 0x73, 0xaa, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_402_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_402_sig[] = {
	0x92, 0x74, 0xd4, 0x6a, 0x7f, 0xfa, 0x12, 0x99, 0xa3, 0x72, 0xe8, 0x21, 0xbd, 0x89, 0x72, 0x8d, 0xe8, 0x3e, 0xf8, 0x7c, 0x46, 0xaf, 0x67, 0x04, 0x3a, 0x63, 0x4b, 0x02, 0x19, 0xe4, 0xbb, 0xec, 0x8b, 0x03, 0xfa, 0x77, 0x2a, 0x36, 0x22, 0xbf, 0x48, 0x93, 0xe5, 0x81, 0xef, 0xad, 0xf9, 0xd2, 0x0b, 0xd6, 0x08, 0x06, 0xd8, 0x26, 0x76, 0xb6, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_402 = {
	.name = "ecdsa_brainpoolp224r1_sha224_402",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_402_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_402_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_402_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key is small, tcId is 337 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 403 for ECDSA, tcId is 338 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_403_pubkey[] = {
	0x0d, 0x28, 0xb4, 0xf7, 0xfe, 0x1f, 0x6c, 0x6f, 0xa6, 0xa7, 0x7d, 0x11, 0xe4, 0x3b, 0xd3, 0xe9, 0x27, 0x17, 0x58, 0xdf, 0x34, 0xc6, 0x5f, 0xa5, 0x77, 0xa6, 0xdd, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x28, 0x01, 0xd4, 0x83, 0x82, 0x86, 0x16, 0x84, 0xb8, 0xd2, 0xcb, 0xd7, 0xe5, 0x98, 0x9a, 0x0d, 0x7c, 0x15, 0xa7, 0xe8, 0x19, 0xb5, 0x73, 0xaa, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_403_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_403_sig[] = {
	0xcf, 0x6a, 0x9c, 0xba, 0x28, 0x5e, 0x56, 0x49, 0x3c, 0xbb, 0x46, 0x2b, 0x7b, 0x16, 0x12, 0x8a, 0x0c, 0xf1, 0xc7, 0x05, 0x84, 0x47, 0x94, 0x5d, 0xae, 0xf3, 0x41, 0x49, 0x29, 0xa6, 0x87, 0x83, 0x9e, 0x8e, 0xe0, 0x3c, 0x53, 0x72, 0xa1, 0x13, 0x73, 0x3c, 0x08, 0x1f, 0x41, 0x3d, 0x1f, 0x94, 0x05, 0xdd, 0xfe, 0x47, 0xe1, 0x8f, 0xcc, 0x54, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_403 = {
	.name = "ecdsa_brainpoolp224r1_sha224_403",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_403_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_403_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_403_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key is small, tcId is 338 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 404 for ECDSA, tcId is 339 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_404_pubkey[] = {
	0x0d, 0x28, 0xb4, 0xf7, 0xfe, 0x1f, 0x6c, 0x6f, 0xa6, 0xa7, 0x7d, 0x11, 0xe4, 0x3b, 0xd3, 0xe9, 0x27, 0x17, 0x58, 0xdf, 0x34, 0xc6, 0x5f, 0xa5, 0x77, 0xa6, 0xdd, 0x3b, 0xd7, 0xc1, 0x34, 0xa9, 0xfe, 0x41, 0x92, 0x02, 0xa7, 0x92, 0x19, 0xa0, 0xbc, 0xff, 0x0b, 0xaf, 0xcb, 0x06, 0x6d, 0x4a, 0x1b, 0xc4, 0xe2, 0x0d, 0x65, 0x13, 0x4d, 0x55, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_404_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_404_sig[] = {
	0x59, 0x2e, 0x54, 0xa0, 0xea, 0x95, 0x0a, 0xc7, 0xcd, 0x83, 0x0f, 0x56, 0xc7, 0x95, 0x4a, 0x76, 0x9f, 0x81, 0xaa, 0x55, 0xe8, 0xe1, 0x01, 0xbe, 0xe1, 0x9b, 0x3b, 0x27, 0x48, 0x37, 0x5f, 0xdd, 0x4d, 0x90, 0x14, 0xc9, 0xb6, 0x0b, 0x63, 0xc7, 0x0b, 0xfe, 0x98, 0xc8, 0x44, 0xbe, 0x66, 0x8f, 0x2d, 0x3a, 0x2e, 0x25, 0x92, 0x62, 0xb9, 0x45, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_404 = {
	.name = "ecdsa_brainpoolp224r1_sha224_404",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_404_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_404_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_404_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key is large, tcId is 339 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 405 for ECDSA, tcId is 340 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_405_pubkey[] = {
	0x0d, 0x28, 0xb4, 0xf7, 0xfe, 0x1f, 0x6c, 0x6f, 0xa6, 0xa7, 0x7d, 0x11, 0xe4, 0x3b, 0xd3, 0xe9, 0x27, 0x17, 0x58, 0xdf, 0x34, 0xc6, 0x5f, 0xa5, 0x77, 0xa6, 0xdd, 0x3b, 0xd7, 0xc1, 0x34, 0xa9, 0xfe, 0x41, 0x92, 0x02, 0xa7, 0x92, 0x19, 0xa0, 0xbc, 0xff, 0x0b, 0xaf, 0xcb, 0x06, 0x6d, 0x4a, 0x1b, 0xc4, 0xe2, 0x0d, 0x65, 0x13, 0x4d, 0x55, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_405_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_405_sig[] = {
	0x1e, 0xc0, 0xef, 0x4d, 0x5b, 0xed, 0xaf, 0xe5, 0x08, 0x1f, 0x7a, 0xda, 0xe3, 0x2d, 0xb4, 0xd0, 0xaa, 0x94, 0x6f, 0x13, 0x0a, 0xce, 0xda, 0xba, 0xe2, 0x6d, 0x90, 0xdc, 0x62, 0x7e, 0x81, 0xd7, 0xeb, 0x35, 0x8f, 0x59, 0xe8, 0xa8, 0x63, 0x05, 0x27, 0xd4, 0xe8, 0x94, 0x6d, 0x1c, 0xad, 0x21, 0x96, 0x76, 0x18, 0x36, 0xd9, 0x7d, 0x95, 0x3c, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_405 = {
	.name = "ecdsa_brainpoolp224r1_sha224_405",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_405_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_405_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_405_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key is large, tcId is 340 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 406 for ECDSA, tcId is 341 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_406_pubkey[] = {
	0x0d, 0x28, 0xb4, 0xf7, 0xfe, 0x1f, 0x6c, 0x6f, 0xa6, 0xa7, 0x7d, 0x11, 0xe4, 0x3b, 0xd3, 0xe9, 0x27, 0x17, 0x58, 0xdf, 0x34, 0xc6, 0x5f, 0xa5, 0x77, 0xa6, 0xdd, 0x3b, 0xd7, 0xc1, 0x34, 0xa9, 0xfe, 0x41, 0x92, 0x02, 0xa7, 0x92, 0x19, 0xa0, 0xbc, 0xff, 0x0b, 0xaf, 0xcb, 0x06, 0x6d, 0x4a, 0x1b, 0xc4, 0xe2, 0x0d, 0x65, 0x13, 0x4d, 0x55, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_406_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_406_sig[] = {
	0x5f, 0xaf, 0x03, 0x5e, 0xd5, 0x77, 0x4e, 0xeb, 0x0a, 0xdc, 0x18, 0x7f, 0xf4, 0x85, 0xa8, 0x46, 0xaa, 0x2a, 0xbc, 0xf1, 0xe7, 0xf8, 0x59, 0xb1, 0xb9, 0x10, 0xf2, 0x5c, 0x8b, 0xf1, 0x2a, 0x1c, 0x00, 0xb1, 0x8f, 0x66, 0xc2, 0x28, 0x35, 0x2d, 0xe4, 0x9c, 0xc4, 0xfb, 0x82, 0x7a, 0x09, 0xfc, 0x86, 0xf7, 0x22, 0xce, 0x56, 0x1b, 0xa5, 0xfa, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_406 = {
	.name = "ecdsa_brainpoolp224r1_sha224_406",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_406_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_406_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_406_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key is large, tcId is 341 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 407 for ECDSA, tcId is 342 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_407_pubkey[] = {
	0x51, 0x2e, 0x58, 0x17, 0x31, 0xc9, 0xc4, 0x60, 0xbb, 0x70, 0x5b, 0x60, 0xda, 0x97, 0x6c, 0xcb, 0x1b, 0x0e, 0xf4, 0x21, 0x78, 0x51, 0x06, 0xba, 0x2c, 0xcd, 0xd2, 0x38, 0x0f, 0x21, 0xd5, 0xba, 0xcd, 0xf8, 0x1c, 0x0c, 0xb7, 0x8f, 0xa1, 0x51, 0x23, 0x7d, 0xb3, 0x13, 0x0a, 0xd4, 0xde, 0xf3, 0x73, 0xf3, 0xe5, 0x23, 0x39, 0x8c, 0x2c, 0xf7, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_407_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_407_sig[] = {
	0x52, 0xb2, 0xd3, 0x69, 0xf1, 0x8d, 0xf5, 0x63, 0x72, 0xaf, 0xe7, 0xfe, 0xb3, 0x84, 0x13, 0xf2, 0x32, 0xb4, 0xfb, 0x9c, 0xa1, 0x6c, 0x6f, 0x6f, 0xed, 0xc6, 0x41, 0x89, 0xc1, 0xb1, 0x9f, 0x13, 0x77, 0x73, 0xef, 0x32, 0x01, 0xcd, 0x34, 0x1c, 0x38, 0x1e, 0x4f, 0x94, 0x49, 0xcc, 0x0e, 0x6c, 0x68, 0x8a, 0x35, 0x1d, 0x7a, 0x60, 0x70, 0xb2, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_407 = {
	.name = "ecdsa_brainpoolp224r1_sha224_407",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_407_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_407_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_407_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key has many trailing 1's on brainpoolP224t1, tcId is 342 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 408 for ECDSA, tcId is 343 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_408_pubkey[] = {
	0x51, 0x2e, 0x58, 0x17, 0x31, 0xc9, 0xc4, 0x60, 0xbb, 0x70, 0x5b, 0x60, 0xda, 0x97, 0x6c, 0xcb, 0x1b, 0x0e, 0xf4, 0x21, 0x78, 0x51, 0x06, 0xba, 0x2c, 0xcd, 0xd2, 0x38, 0x0f, 0x21, 0xd5, 0xba, 0xcd, 0xf8, 0x1c, 0x0c, 0xb7, 0x8f, 0xa1, 0x51, 0x23, 0x7d, 0xb3, 0x13, 0x0a, 0xd4, 0xde, 0xf3, 0x73, 0xf3, 0xe5, 0x23, 0x39, 0x8c, 0x2c, 0xf7, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_408_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_408_sig[] = {
	0x5b, 0x88, 0x9d, 0x28, 0x8a, 0xaa, 0x81, 0x67, 0x4d, 0x32, 0x00, 0x6e, 0x81, 0x27, 0x9c, 0x57, 0xed, 0x56, 0xa0, 0x35, 0xc8, 0x78, 0xd3, 0xe2, 0xb6, 0x87, 0xbe, 0xc3, 0x0d, 0xa6, 0x21, 0xd5, 0xfa, 0x98, 0x13, 0x26, 0x3c, 0x7f, 0x58, 0xf8, 0xe0, 0x15, 0x5d, 0x6f, 0x0c, 0x33, 0x0a, 0x56, 0xc5, 0x94, 0xde, 0xfc, 0x2e, 0xbd, 0xf0, 0xa0, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_408 = {
	.name = "ecdsa_brainpoolp224r1_sha224_408",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_408_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_408_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_408_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key has many trailing 1's on brainpoolP224t1, tcId is 343 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 409 for ECDSA, tcId is 344 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_409_pubkey[] = {
	0x51, 0x2e, 0x58, 0x17, 0x31, 0xc9, 0xc4, 0x60, 0xbb, 0x70, 0x5b, 0x60, 0xda, 0x97, 0x6c, 0xcb, 0x1b, 0x0e, 0xf4, 0x21, 0x78, 0x51, 0x06, 0xba, 0x2c, 0xcd, 0xd2, 0x38, 0x0f, 0x21, 0xd5, 0xba, 0xcd, 0xf8, 0x1c, 0x0c, 0xb7, 0x8f, 0xa1, 0x51, 0x23, 0x7d, 0xb3, 0x13, 0x0a, 0xd4, 0xde, 0xf3, 0x73, 0xf3, 0xe5, 0x23, 0x39, 0x8c, 0x2c, 0xf7, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_409_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_409_sig[] = {
	0xb6, 0xf8, 0xa8, 0x01, 0x87, 0x18, 0x0a, 0xad, 0x8a, 0x5c, 0x89, 0x6b, 0xe2, 0x14, 0x31, 0x46, 0x01, 0xa1, 0x58, 0x5f, 0x2c, 0xcb, 0x28, 0xbc, 0x7e, 0x8e, 0x8f, 0x01, 0xa9, 0x0c, 0x68, 0xc1, 0x4a, 0x67, 0xf5, 0xd5, 0x9c, 0xec, 0x70, 0xdc, 0x0f, 0x47, 0x3b, 0x5c, 0x14, 0x01, 0x3b, 0x05, 0x6d, 0x12, 0xcb, 0xc0, 0xf7, 0x15, 0x3b, 0x1d, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_409 = {
	.name = "ecdsa_brainpoolp224r1_sha224_409",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_409_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_409_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_409_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key has many trailing 1's on brainpoolP224t1, tcId is 344 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 410 for ECDSA, tcId is 345 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_410_pubkey[] = {
	0xac, 0x55, 0xd1, 0xb3, 0xfe, 0xd4, 0xae, 0xe0, 0x3f, 0xa3, 0x61, 0x5d, 0x22, 0x5a, 0x9c, 0xba, 0x5c, 0x02, 0x84, 0x41, 0x6f, 0xba, 0xf9, 0xa7, 0x61, 0x35, 0xf7, 0x62, 0x17, 0xa8, 0x88, 0x39, 0x5b, 0xce, 0xd3, 0x49, 0x77, 0xa8, 0x48, 0x23, 0x70, 0xd5, 0x6e, 0xbc, 0x62, 0xaa, 0x1c, 0xa8, 0x1b, 0xc3, 0x30, 0xf4, 0x9d, 0x4a, 0x14, 0x1d, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_410_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_410_sig[] = {
	0x16, 0xd4, 0xa8, 0x50, 0x9c, 0x9b, 0xce, 0x2c, 0x73, 0xf8, 0xdb, 0x4b, 0x73, 0x25, 0x7c, 0x7e, 0x33, 0xf4, 0x17, 0x26, 0xc2, 0x5c, 0x4c, 0x64, 0x54, 0x6b, 0x1d, 0xcc, 0x79, 0xba, 0x35, 0xa9, 0x6d, 0x23, 0x45, 0xad, 0x19, 0x4f, 0x39, 0x10, 0x91, 0x20, 0x9d, 0xfc, 0xce, 0xd7, 0x99, 0x17, 0xe0, 0x4d, 0xf3, 0xb6, 0x5f, 0x44, 0xd1, 0xeb, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_410 = {
	.name = "ecdsa_brainpoolp224r1_sha224_410",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_410_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_410_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_410_sig,
	.siglen = 56,
	.result = 1,
	.comment = "x-coordinate of the public key is small on brainpoolP224t1, tcId is 345 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 411 for ECDSA, tcId is 346 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_411_pubkey[] = {
	0xac, 0x55, 0xd1, 0xb3, 0xfe, 0xd4, 0xae, 0xe0, 0x3f, 0xa3, 0x61, 0x5d, 0x22, 0x5a, 0x9c, 0xba, 0x5c, 0x02, 0x84, 0x41, 0x6f, 0xba, 0xf9, 0xa7, 0x61, 0x35, 0xf7, 0x62, 0x17, 0xa8, 0x88, 0x39, 0x5b, 0xce, 0xd3, 0x49, 0x77, 0xa8, 0x48, 0x23, 0x70, 0xd5, 0x6e, 0xbc, 0x62, 0xaa, 0x1c, 0xa8, 0x1b, 0xc3, 0x30, 0xf4, 0x9d, 0x4a, 0x14, 0x1d, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_411_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_411_sig[] = {
	0x5d, 0xa1, 0x56, 0x97, 0xbb, 0xe4, 0xeb, 0xa7, 0x70, 0x7e, 0x34, 0x9f, 0xf3, 0x23, 0x9d, 0x50, 0x84, 0x55, 0x37, 0x81, 0x13, 0xd2, 0x4e, 0x7e, 0x1d, 0x7a, 0x02, 0x0c, 0x45, 0xbe, 0x44, 0xa5, 0x70, 0xfb, 0x53, 0x0c, 0x49, 0xd7, 0x59, 0x71, 0x2c, 0x10, 0x04, 0x13, 0x45, 0xf7, 0xc0, 0x89, 0x0a, 0x79, 0x46, 0xd9, 0x1d, 0x32, 0xba, 0xc6, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_411 = {
	.name = "ecdsa_brainpoolp224r1_sha224_411",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_411_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_411_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_411_sig,
	.siglen = 56,
	.result = 1,
	.comment = "x-coordinate of the public key is small on brainpoolP224t1, tcId is 346 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 412 for ECDSA, tcId is 347 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_412_pubkey[] = {
	0xac, 0x55, 0xd1, 0xb3, 0xfe, 0xd4, 0xae, 0xe0, 0x3f, 0xa3, 0x61, 0x5d, 0x22, 0x5a, 0x9c, 0xba, 0x5c, 0x02, 0x84, 0x41, 0x6f, 0xba, 0xf9, 0xa7, 0x61, 0x35, 0xf7, 0x62, 0x17, 0xa8, 0x88, 0x39, 0x5b, 0xce, 0xd3, 0x49, 0x77, 0xa8, 0x48, 0x23, 0x70, 0xd5, 0x6e, 0xbc, 0x62, 0xaa, 0x1c, 0xa8, 0x1b, 0xc3, 0x30, 0xf4, 0x9d, 0x4a, 0x14, 0x1d, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_412_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_412_sig[] = {
	0xc1, 0xf8, 0xd4, 0x34, 0x79, 0xc4, 0xf2, 0x9b, 0x19, 0xb9, 0xb2, 0xc7, 0xb5, 0x74, 0x70, 0x10, 0x49, 0x14, 0x40, 0x74, 0x6c, 0xc8, 0x00, 0xd5, 0xbe, 0x89, 0xb0, 0x11, 0x81, 0x54, 0x34, 0x8b, 0x7c, 0x37, 0xf0, 0x50, 0x4d, 0xca, 0x2b, 0x11, 0x59, 0x41, 0xf7, 0xba, 0x58, 0x57, 0x32, 0x1e, 0xae, 0x8f, 0x64, 0x17, 0x5b, 0xe9, 0xcb, 0xb9, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_412 = {
	.name = "ecdsa_brainpoolp224r1_sha224_412",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_412_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_412_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_412_sig,
	.siglen = 56,
	.result = 1,
	.comment = "x-coordinate of the public key is small on brainpoolP224t1, tcId is 347 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 413 for ECDSA, tcId is 348 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_413_pubkey[] = {
	0x8b, 0x31, 0x9f, 0x2e, 0xd0, 0x74, 0xa2, 0x0e, 0xc4, 0x2d, 0x86, 0x9c, 0x7f, 0x99, 0xbd, 0x91, 0x46, 0xed, 0x82, 0x63, 0x29, 0x7b, 0xfe, 0x00, 0x4f, 0x27, 0xc5, 0x9b, 0x12, 0x0f, 0x96, 0x34, 0x3d, 0xeb, 0x80, 0x09, 0x3e, 0xcb, 0x76, 0x95, 0xc2, 0xd2, 0xa5, 0xbe, 0x99, 0x37, 0xa2, 0x58, 0x72, 0x3d, 0x78, 0xed, 0x00, 0xaa, 0x1e, 0xdf, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_413_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_413_sig[] = {
	0x87, 0x15, 0x81, 0xb5, 0x00, 0x92, 0x57, 0x82, 0x11, 0x16, 0x0e, 0x47, 0x0d, 0xdd, 0xaa, 0x64, 0x0d, 0x5a, 0x2d, 0x9e, 0x22, 0x4f, 0xaf, 0xca, 0x87, 0x91, 0x06, 0xd4, 0xbe, 0x70, 0xfd, 0x5c, 0x75, 0x91, 0xa3, 0x13, 0x0f, 0x5c, 0x2a, 0xf5, 0x36, 0xff, 0xff, 0x8e, 0x72, 0xc1, 0x62, 0x51, 0x74, 0x4c, 0x97, 0x96, 0x8f, 0x92, 0x17, 0x28, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_413 = {
	.name = "ecdsa_brainpoolp224r1_sha224_413",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_413_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_413_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_413_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key is small on brainpoolP224t1, tcId is 348 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 414 for ECDSA, tcId is 349 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_414_pubkey[] = {
	0x8b, 0x31, 0x9f, 0x2e, 0xd0, 0x74, 0xa2, 0x0e, 0xc4, 0x2d, 0x86, 0x9c, 0x7f, 0x99, 0xbd, 0x91, 0x46, 0xed, 0x82, 0x63, 0x29, 0x7b, 0xfe, 0x00, 0x4f, 0x27, 0xc5, 0x9b, 0x12, 0x0f, 0x96, 0x34, 0x3d, 0xeb, 0x80, 0x09, 0x3e, 0xcb, 0x76, 0x95, 0xc2, 0xd2, 0xa5, 0xbe, 0x99, 0x37, 0xa2, 0x58, 0x72, 0x3d, 0x78, 0xed, 0x00, 0xaa, 0x1e, 0xdf, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_414_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_414_sig[] = {
	0xa9, 0x87, 0x35, 0xe5, 0x65, 0x90, 0x22, 0xb0, 0x27, 0x4a, 0xe6, 0xf7, 0xbc, 0xb1, 0x64, 0x6e, 0x9e, 0x6b, 0x4b, 0x88, 0x40, 0x8d, 0xb3, 0xf9, 0x26, 0xec, 0xcc, 0x89, 0xa9, 0x23, 0xff, 0x5e, 0x15, 0xe0, 0xd7, 0x64, 0xcd, 0x5c, 0xef, 0xff, 0xc5, 0xc4, 0x0c, 0x08, 0x2c, 0x6e, 0xb7, 0x72, 0xdb, 0x76, 0x62, 0xfb, 0x1b, 0x82, 0xd5, 0x25, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_414 = {
	.name = "ecdsa_brainpoolp224r1_sha224_414",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_414_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_414_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_414_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key is small on brainpoolP224t1, tcId is 349 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 415 for ECDSA, tcId is 350 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_415_pubkey[] = {
	0x8b, 0x31, 0x9f, 0x2e, 0xd0, 0x74, 0xa2, 0x0e, 0xc4, 0x2d, 0x86, 0x9c, 0x7f, 0x99, 0xbd, 0x91, 0x46, 0xed, 0x82, 0x63, 0x29, 0x7b, 0xfe, 0x00, 0x4f, 0x27, 0xc5, 0x9b, 0x12, 0x0f, 0x96, 0x34, 0x3d, 0xeb, 0x80, 0x09, 0x3e, 0xcb, 0x76, 0x95, 0xc2, 0xd2, 0xa5, 0xbe, 0x99, 0x37, 0xa2, 0x58, 0x72, 0x3d, 0x78, 0xed, 0x00, 0xaa, 0x1e, 0xdf, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_415_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_415_sig[] = {
	0xa9, 0x6b, 0x5c, 0x24, 0xe3, 0x3d, 0x59, 0x00, 0x4c, 0xf3, 0x1a, 0xae, 0xf4, 0x4a, 0xe4, 0xc7, 0x57, 0x9e, 0x0b, 0x5b, 0x21, 0x9a, 0xb2, 0x5d, 0x7f, 0x1c, 0x69, 0x0a, 0x88, 0xc0, 0x13, 0x78, 0x84, 0x7c, 0x38, 0x41, 0xf4, 0x9e, 0xc1, 0x48, 0x40, 0xe2, 0xd0, 0x23, 0xd7, 0xb9, 0x12, 0xb5, 0x03, 0xf2, 0xd9, 0x8a, 0x92, 0x3b, 0xe8, 0xc9, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_415 = {
	.name = "ecdsa_brainpoolp224r1_sha224_415",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_415_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_415_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_415_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key is small on brainpoolP224t1, tcId is 350 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 416 for ECDSA, tcId is 351 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_416_pubkey[] = {
	0x8b, 0x31, 0x9f, 0x2e, 0xd0, 0x74, 0xa2, 0x0e, 0xc4, 0x2d, 0x86, 0x9c, 0x7f, 0x99, 0xbd, 0x91, 0x46, 0xed, 0x82, 0x63, 0x29, 0x7b, 0xfe, 0x00, 0x4f, 0x27, 0xc5, 0x9b, 0xc5, 0xb1, 0x9e, 0x75, 0xe8, 0x57, 0xe6, 0x7c, 0xeb, 0x4c, 0xb9, 0x8f, 0xb2, 0xff, 0x31, 0xc9, 0x17, 0x67, 0x64, 0xff, 0x25, 0x9d, 0x11, 0x08, 0x7e, 0x1e, 0xa2, 0x20, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_416_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_416_sig[] = {
	0x6b, 0x57, 0xb7, 0x3a, 0xb7, 0xc3, 0x9b, 0x56, 0x98, 0x54, 0x9d, 0xd5, 0xcd, 0xd4, 0xdf, 0x73, 0x98, 0x18, 0x1b, 0x55, 0x6e, 0x7c, 0x72, 0x83, 0x37, 0x5e, 0x3f, 0x86, 0x9f, 0x59, 0xd1, 0x86, 0x3d, 0x6f, 0xd6, 0x01, 0x32, 0x47, 0xd4, 0xe6, 0x78, 0xa1, 0xc4, 0xfc, 0x1d, 0x89, 0x6d, 0xc6, 0x61, 0xfa, 0x31, 0xfb, 0x73, 0xc3, 0x3f, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_416 = {
	.name = "ecdsa_brainpoolp224r1_sha224_416",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_416_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_416_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_416_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key is large on brainpoolP224t1, tcId is 351 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 417 for ECDSA, tcId is 352 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_417_pubkey[] = {
	0x8b, 0x31, 0x9f, 0x2e, 0xd0, 0x74, 0xa2, 0x0e, 0xc4, 0x2d, 0x86, 0x9c, 0x7f, 0x99, 0xbd, 0x91, 0x46, 0xed, 0x82, 0x63, 0x29, 0x7b, 0xfe, 0x00, 0x4f, 0x27, 0xc5, 0x9b, 0xc5, 0xb1, 0x9e, 0x75, 0xe8, 0x57, 0xe6, 0x7c, 0xeb, 0x4c, 0xb9, 0x8f, 0xb2, 0xff, 0x31, 0xc9, 0x17, 0x67, 0x64, 0xff, 0x25, 0x9d, 0x11, 0x08, 0x7e, 0x1e, 0xa2, 0x20, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_417_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_417_sig[] = {
	0x2f, 0x85, 0xaf, 0x7e, 0x53, 0x5f, 0x66, 0xcf, 0xc9, 0xa9, 0xda, 0xb7, 0xbe, 0x78, 0x16, 0x31, 0xdd, 0x62, 0x2b, 0xe4, 0x35, 0xd7, 0x64, 0x2b, 0x5b, 0x51, 0xfc, 0xc7, 0x61, 0x93, 0x01, 0xc2, 0x1c, 0x93, 0x42, 0x55, 0xdf, 0x93, 0xee, 0xdd, 0x5b, 0x45, 0x9c, 0x8d, 0xd2, 0x80, 0xfd, 0xd0, 0x7e, 0xe6, 0x56, 0xa7, 0x14, 0x7d, 0x4d, 0x69, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_417 = {
	.name = "ecdsa_brainpoolp224r1_sha224_417",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_417_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_417_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_417_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key is large on brainpoolP224t1, tcId is 352 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 418 for ECDSA, tcId is 353 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_418_pubkey[] = {
	0x8b, 0x31, 0x9f, 0x2e, 0xd0, 0x74, 0xa2, 0x0e, 0xc4, 0x2d, 0x86, 0x9c, 0x7f, 0x99, 0xbd, 0x91, 0x46, 0xed, 0x82, 0x63, 0x29, 0x7b, 0xfe, 0x00, 0x4f, 0x27, 0xc5, 0x9b, 0xc5, 0xb1, 0x9e, 0x75, 0xe8, 0x57, 0xe6, 0x7c, 0xeb, 0x4c, 0xb9, 0x8f, 0xb2, 0xff, 0x31, 0xc9, 0x17, 0x67, 0x64, 0xff, 0x25, 0x9d, 0x11, 0x08, 0x7e, 0x1e, 0xa2, 0x20, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_418_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_418_sig[] = {
	0x98, 0xa8, 0xa9, 0x8f, 0xcc, 0x82, 0xf8, 0x04, 0xa8, 0x23, 0xcc, 0x91, 0x07, 0x24, 0x37, 0xcf, 0xd8, 0x83, 0x22, 0xb8, 0x67, 0x16, 0x86, 0x51, 0x7f, 0x19, 0x78, 0xab, 0x6a, 0xc3, 0xe8, 0x37, 0x76, 0x68, 0x5b, 0xce, 0xce, 0xfe, 0xba, 0xe4, 0x73, 0xac, 0x07, 0xc7, 0x71, 0xe8, 0x3b, 0x0c, 0x5a, 0x55, 0x7e, 0xfe, 0x83, 0x50, 0x20, 0x36, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_418 = {
	.name = "ecdsa_brainpoolp224r1_sha224_418",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_418_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_418_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_418_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key is large on brainpoolP224t1, tcId is 353 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 419 for ECDSA, tcId is 354 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_419_pubkey[] = {
	0xc5, 0xdc, 0x51, 0x35, 0xf0, 0x50, 0xa9, 0x6b, 0xbb, 0x0d, 0x21, 0x88, 0x51, 0x95, 0xb4, 0x9a, 0x57, 0x4d, 0x51, 0x98, 0xba, 0xac, 0x4b, 0x46, 0x02, 0xb2, 0x1b, 0xc8, 0xb5, 0xf3, 0x8b, 0x7f, 0xe6, 0x61, 0x00, 0x3f, 0xae, 0xe1, 0xb7, 0xaf, 0x67, 0x0e, 0x16, 0x5b, 0xfa, 0xb7, 0x0b, 0x01, 0x89, 0x65, 0xe8, 0x33, 0x29, 0xd4, 0x05, 0xbc, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_419_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_419_sig[] = {
	0x69, 0x9c, 0x40, 0xb7, 0x35, 0x23, 0x6b, 0xd9, 0x23, 0x97, 0x70, 0xa5, 0xde, 0x2c, 0x1a, 0x75, 0x54, 0x63, 0x1e, 0x6b, 0xa6, 0xef, 0x51, 0x2f, 0x85, 0x53, 0xd0, 0x2f, 0x0b, 0xca, 0x9c, 0x51, 0x6c, 0xa4, 0x05, 0xff, 0xc9, 0xae, 0x2d, 0xce, 0xe1, 0x2a, 0xd7, 0xd9, 0x6b, 0x58, 0x6b, 0xfd, 0xc8, 0x18, 0xa3, 0xd4, 0x5d, 0xcf, 0xcf, 0x26, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_419 = {
	.name = "ecdsa_brainpoolp224r1_sha224_419",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_419_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_419_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_419_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key has many trailing 0's on brainpoolP224t1, tcId is 354 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 420 for ECDSA, tcId is 355 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_420_pubkey[] = {
	0xc5, 0xdc, 0x51, 0x35, 0xf0, 0x50, 0xa9, 0x6b, 0xbb, 0x0d, 0x21, 0x88, 0x51, 0x95, 0xb4, 0x9a, 0x57, 0x4d, 0x51, 0x98, 0xba, 0xac, 0x4b, 0x46, 0x02, 0xb2, 0x1b, 0xc8, 0xb5, 0xf3, 0x8b, 0x7f, 0xe6, 0x61, 0x00, 0x3f, 0xae, 0xe1, 0xb7, 0xaf, 0x67, 0x0e, 0x16, 0x5b, 0xfa, 0xb7, 0x0b, 0x01, 0x89, 0x65, 0xe8, 0x33, 0x29, 0xd4, 0x05, 0xbc, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_420_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_420_sig[] = {
	0x76, 0x8a, 0x81, 0x9d, 0x39, 0x43, 0xfc, 0x30, 0x78, 0x1a, 0xae, 0xf2, 0x8f, 0xa1, 0x20, 0x18, 0x4c, 0x72, 0x12, 0xd0, 0x91, 0x1f, 0xe0, 0x3d, 0xfc, 0x8c, 0x62, 0x60, 0x51, 0xb3, 0xdb, 0x0e, 0x1c, 0x3e, 0x93, 0x91, 0x49, 0xcc, 0xbf, 0x9d, 0x46, 0x19, 0xbb, 0xbf, 0xf0, 0xe2, 0xe1, 0x74, 0x11, 0x0f, 0x6e, 0xce, 0x43, 0x13, 0xb4, 0xca, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_420 = {
	.name = "ecdsa_brainpoolp224r1_sha224_420",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_420_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_420_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_420_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key has many trailing 0's on brainpoolP224t1, tcId is 355 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 421 for ECDSA, tcId is 356 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_421_pubkey[] = {
	0xc5, 0xdc, 0x51, 0x35, 0xf0, 0x50, 0xa9, 0x6b, 0xbb, 0x0d, 0x21, 0x88, 0x51, 0x95, 0xb4, 0x9a, 0x57, 0x4d, 0x51, 0x98, 0xba, 0xac, 0x4b, 0x46, 0x02, 0xb2, 0x1b, 0xc8, 0xb5, 0xf3, 0x8b, 0x7f, 0xe6, 0x61, 0x00, 0x3f, 0xae, 0xe1, 0xb7, 0xaf, 0x67, 0x0e, 0x16, 0x5b, 0xfa, 0xb7, 0x0b, 0x01, 0x89, 0x65, 0xe8, 0x33, 0x29, 0xd4, 0x05, 0xbc, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_421_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_421_sig[] = {
	0x58, 0xfc, 0xc0, 0xff, 0xb1, 0x25, 0xc2, 0x3c, 0x43, 0x57, 0x35, 0xb7, 0xc3, 0x90, 0x69, 0x20, 0x37, 0xc0, 0x3a, 0x67, 0x65, 0xef, 0x7b, 0x53, 0x65, 0xa1, 0x7d, 0xd4, 0x95, 0x18, 0xd2, 0x9d, 0x78, 0xed, 0xa9, 0xcb, 0x25, 0x03, 0xfd, 0xe3, 0x8d, 0x3b, 0x73, 0xd6, 0xfb, 0x90, 0xa0, 0xd4, 0x0a, 0x23, 0xf0, 0xec, 0x26, 0x16, 0x69, 0x69, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_421 = {
	.name = "ecdsa_brainpoolp224r1_sha224_421",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_421_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_421_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_421_sig,
	.siglen = 56,
	.result = 1,
	.comment = "y-coordinate of the public key has many trailing 0's on brainpoolP224t1, tcId is 356 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 422 for ECDSA, tcId is 357 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_422_pubkey[] = {
	0xc1, 0xb5, 0x6a, 0x1a, 0xd1, 0x54, 0xe1, 0x15, 0x56, 0xb7, 0x23, 0xfc, 0x74, 0x93, 0xf3, 0x6e, 0x66, 0x50, 0x9d, 0x8f, 0x68, 0xfa, 0xd0, 0xe6, 0x2c, 0x40, 0xf0, 0x85, 0x9b, 0x04, 0x78, 0x0a, 0x85, 0xe6, 0x9a, 0xbf, 0x98, 0xde, 0xf3, 0x33, 0x5c, 0xe6, 0x43, 0xcd, 0x35, 0x54, 0x16, 0x7a, 0x8b, 0x50, 0xd5, 0x96, 0xb9, 0x53, 0x88, 0x95, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_422_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_422_sig[] = {
	0xd1, 0x93, 0xee, 0x0a, 0x3d, 0x42, 0xa2, 0x3a, 0xf0, 0x18, 0xab, 0x90, 0x89, 0x6b, 0x35, 0xd5, 0xc2, 0x50, 0x18, 0x7b, 0xf9, 0xfb, 0x1c, 0xca, 0xc3, 0x64, 0x74, 0x8c, 0xa0, 0x92, 0x2a, 0xcc, 0xc7, 0x56, 0x2d, 0x01, 0x71, 0x09, 0xe9, 0x1d, 0x2f, 0x83, 0xe4, 0x8b, 0xfa, 0x3c, 0x1f, 0xa2, 0xee, 0x04, 0xd8, 0x46, 0x9b, 0xe9, 0x40, 0x33, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_422 = {
	.name = "ecdsa_brainpoolp224r1_sha224_422",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_422_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_422_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_422_sig,
	.siglen = 56,
	.result = 1,
	.comment = "x-coordinate of the public key has many trailing 1's on brainpoolP224t1, tcId is 357 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 423 for ECDSA, tcId is 358 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_423_pubkey[] = {
	0xc1, 0xb5, 0x6a, 0x1a, 0xd1, 0x54, 0xe1, 0x15, 0x56, 0xb7, 0x23, 0xfc, 0x74, 0x93, 0xf3, 0x6e, 0x66, 0x50, 0x9d, 0x8f, 0x68, 0xfa, 0xd0, 0xe6, 0x2c, 0x40, 0xf0, 0x85, 0x9b, 0x04, 0x78, 0x0a, 0x85, 0xe6, 0x9a, 0xbf, 0x98, 0xde, 0xf3, 0x33, 0x5c, 0xe6, 0x43, 0xcd, 0x35, 0x54, 0x16, 0x7a, 0x8b, 0x50, 0xd5, 0x96, 0xb9, 0x53, 0x88, 0x95, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_423_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_423_sig[] = {
	0x09, 0x74, 0x52, 0x1d, 0x7c, 0xe7, 0x53, 0xde, 0xa5, 0xd1, 0x15, 0x6f, 0xb4, 0xd9, 0x92, 0xcc, 0x61, 0x40, 0x79, 0xeb, 0x86, 0x77, 0xab, 0x36, 0xa4, 0x07, 0x8a, 0x4f, 0x83, 0x74, 0xdf, 0xba, 0xe8, 0xd0, 0x42, 0x9a, 0x6f, 0xba, 0x60, 0xfb, 0xb5, 0xd2, 0xfd, 0x55, 0x98, 0x56, 0xa5, 0xd7, 0x39, 0xf3, 0x9a, 0xa2, 0xbf, 0x1d, 0xa1, 0xc9, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_423 = {
	.name = "ecdsa_brainpoolp224r1_sha224_423",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_423_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_423_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_423_sig,
	.siglen = 56,
	.result = 1,
	.comment = "x-coordinate of the public key has many trailing 1's on brainpoolP224t1, tcId is 358 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 424 for ECDSA, tcId is 359 in file ecdsa_brainpoolP224r1_sha224_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224)
static const unsigned char ecdsa_brainpoolp224r1_sha224_424_pubkey[] = {
	0xc1, 0xb5, 0x6a, 0x1a, 0xd1, 0x54, 0xe1, 0x15, 0x56, 0xb7, 0x23, 0xfc, 0x74, 0x93, 0xf3, 0x6e, 0x66, 0x50, 0x9d, 0x8f, 0x68, 0xfa, 0xd0, 0xe6, 0x2c, 0x40, 0xf0, 0x85, 0x9b, 0x04, 0x78, 0x0a, 0x85, 0xe6, 0x9a, 0xbf, 0x98, 0xde, 0xf3, 0x33, 0x5c, 0xe6, 0x43, 0xcd, 0x35, 0x54, 0x16, 0x7a, 0x8b, 0x50, 0xd5, 0x96, 0xb9, 0x53, 0x88, 0x95, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_424_msg[] = {
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 
};
static const unsigned char ecdsa_brainpoolp224r1_sha224_424_sig[] = {
	0x62, 0x5f, 0x47, 0x3c, 0xa2, 0xd1, 0x5b, 0xb7, 0xf1, 0x2d, 0xa1, 0x23, 0x5f, 0x90, 0xad, 0xcb, 0x69, 0xed, 0x48, 0x18, 0x74, 0x6c, 0xae, 0x2e, 0x2d, 0xb2, 0x6f, 0xe6, 0x4a, 0xb8, 0x17, 0xf6, 0xf1, 0xb9, 0xc8, 0xc4, 0x9f, 0x68, 0x1b, 0xed, 0x15, 0x68, 0x34, 0x6f, 0x53, 0xec, 0xbf, 0xac, 0xfd, 0x52, 0xd4, 0x5e, 0x27, 0xab, 0xcb, 0xb0, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp224r1_sha224_424 = {
	.name = "ecdsa_brainpoolp224r1_sha224_424",
	.sig_alg = ECDSA,
	.hash = SHA224,
	.curve =  &brainpoolp224r1_str_params,
	.pubkey = ecdsa_brainpoolp224r1_sha224_424_pubkey,
	.pubkeylen = 56,
	.msg = ecdsa_brainpoolp224r1_sha224_424_msg,
	.msglen = 7,
	.sig = ecdsa_brainpoolp224r1_sha224_424_sig,
	.siglen = 56,
	.result = 1,
	.comment = "x-coordinate of the public key has many trailing 1's on brainpoolP224t1, tcId is 359 in file ecdsa_brainpoolP224r1_sha224_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP224R1) && defined(WITH_HASH_SHA224) */
/* Test 425 for ECDSA, tcId is 1 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_425_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_425_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_425_sig[] = {
	0x0a, 0x5f, 0x8c, 0x70, 0xba, 0x2d, 0x08, 0x42, 0xd5, 0xd0, 0xf8, 0x41, 0xf1, 0x60, 0xad, 0x15, 0x19, 0x57, 0x69, 0xa8, 0x15, 0x9b, 0xfe, 0x69, 0x26, 0x34, 0xd7, 0x3d, 0x46, 0x9d, 0x11, 0x1f, 0x42, 0x6e, 0x85, 0x7a, 0xad, 0x3f, 0xf7, 0xaa, 0x96, 0xe4, 0xd2, 0x00, 0xc0, 0x3b, 0x45, 0xf1, 0x84, 0x6a, 0x36, 0xd0, 0x89, 0xee, 0x39, 0x17, 0x76, 0x8c, 0xa1, 0xa0, 0xd6, 0xd4, 0xda, 0x6e, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_425 = {
	.name = "ecdsa_brainpoolp256r1_sha256_425",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_425_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_425_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_425_sig,
	.siglen = 64,
	.result = 1,
	.comment = "signature malleability, tcId is 1 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 426 for ECDSA, tcId is 2 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_426_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_426_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_426_sig[] = {
	0xb4, 0x5a, 0xe4, 0x4c, 0x5c, 0x1b, 0xb1, 0xff, 0x14, 0x37, 0x02, 0xd2, 0x8e, 0xe4, 0x3a, 0x86, 0xa5, 0x90, 0xe4, 0x4b, 0xca, 0xfd, 0xa5, 0x60, 0xb6, 0x52, 0xe5, 0xbf, 0xdd, 0xe5, 0x67, 0xc6, 0x67, 0x8c, 0xd2, 0x60, 0xf4, 0xae, 0xb2, 0x11, 0xa7, 0x81, 0x38, 0x8f, 0xdd, 0x48, 0x47, 0x80, 0x07, 0xcf, 0x43, 0xd3, 0x2b, 0x73, 0x6d, 0xe0, 0x19, 0x91, 0x6c, 0xe1, 0xc0, 0x73, 0x7c, 0x39, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_426 = {
	.name = "ecdsa_brainpoolp256r1_sha256_426",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_426_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_426_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_426_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Modified r or s, e.g. by adding or subtracting the order of the group, tcId is 2 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 427 for ECDSA, tcId is 3 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_427_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_427_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_427_sig[] = {
	0x9f, 0x9b, 0xcb, 0x6a, 0xe7, 0xc1, 0xa1, 0x79, 0x68, 0x95, 0x12, 0x4e, 0xac, 0x22, 0xe0, 0x5c, 0x72, 0xe2, 0x10, 0xfb, 0x9f, 0xc5, 0xa8, 0x8e, 0x69, 0xe9, 0x37, 0x45, 0x50, 0xab, 0x45, 0x88, 0x67, 0x8c, 0xd2, 0x60, 0xf4, 0xae, 0xb2, 0x11, 0xa7, 0x81, 0x38, 0x8f, 0xdd, 0x48, 0x47, 0x80, 0x07, 0xcf, 0x43, 0xd3, 0x2b, 0x73, 0x6d, 0xe0, 0x19, 0x91, 0x6c, 0xe1, 0xc0, 0x73, 0x7c, 0x39, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_427 = {
	.name = "ecdsa_brainpoolp256r1_sha256_427",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_427_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_427_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_427_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Modified r or s, e.g. by adding or subtracting the order of the group, tcId is 3 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 428 for ECDSA, tcId is 4 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_428_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_428_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_428_sig[] = {
	0x01, 0x0a, 0x5f, 0x8c, 0x70, 0xba, 0x2d, 0x08, 0x42, 0xd5, 0xd0, 0xf8, 0x41, 0xf1, 0x60, 0xad, 0x15, 0x19, 0x57, 0x69, 0xa8, 0x15, 0x9b, 0xfe, 0x69, 0x26, 0x34, 0xd7, 0x3d, 0x46, 0x9d, 0x11, 0x1f, 0x00, 0x67, 0x8c, 0xd2, 0x60, 0xf4, 0xae, 0xb2, 0x11, 0xa7, 0x81, 0x38, 0x8f, 0xdd, 0x48, 0x47, 0x80, 0x07, 0xcf, 0x43, 0xd3, 0x2b, 0x73, 0x6d, 0xe0, 0x19, 0x91, 0x6c, 0xe1, 0xc0, 0x73, 0x7c, 0x39, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_428 = {
	.name = "ecdsa_brainpoolp256r1_sha256_428",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_428_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_428_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_428_sig,
	.siglen = 66,
	.result = -1,
	.comment = "Modified r or s, e.g. by adding or subtracting the order of the group, tcId is 4 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 429 for ECDSA, tcId is 5 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_429_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_429_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_429_sig[] = {
	0xf5, 0xa0, 0x73, 0x8f, 0x45, 0xd2, 0xf7, 0xbd, 0x2a, 0x2f, 0x07, 0xbe, 0x0e, 0x9f, 0x52, 0xea, 0xe6, 0xa8, 0x96, 0x57, 0xea, 0x64, 0x01, 0x96, 0xd9, 0xcb, 0x28, 0xc2, 0xb9, 0x62, 0xee, 0xe1, 0x67, 0x8c, 0xd2, 0x60, 0xf4, 0xae, 0xb2, 0x11, 0xa7, 0x81, 0x38, 0x8f, 0xdd, 0x48, 0x47, 0x80, 0x07, 0xcf, 0x43, 0xd3, 0x2b, 0x73, 0x6d, 0xe0, 0x19, 0x91, 0x6c, 0xe1, 0xc0, 0x73, 0x7c, 0x39, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_429 = {
	.name = "ecdsa_brainpoolp256r1_sha256_429",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_429_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_429_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_429_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Modified r or s, e.g. by adding or subtracting the order of the group, tcId is 5 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 430 for ECDSA, tcId is 6 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_430_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_430_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_430_sig[] = {
	0x00, 0x0a, 0x5f, 0x8c, 0x70, 0xba, 0x2d, 0x08, 0x42, 0xd5, 0xd0, 0xf8, 0x41, 0xf1, 0x60, 0xad, 0x15, 0x19, 0x57, 0x69, 0xa8, 0x15, 0x9b, 0xfe, 0x69, 0x26, 0x34, 0xd7, 0x3d, 0x46, 0x9d, 0x11, 0x1f, 0x01, 0x11, 0x88, 0x2a, 0x3c, 0x96, 0x9d, 0x5b, 0xcd, 0xe5, 0xe7, 0x43, 0x20, 0x7a, 0xcb, 0xd4, 0xf1, 0x94, 0x08, 0xbe, 0x76, 0xe0, 0xd5, 0x14, 0xd7, 0xa9, 0xaf, 0x7b, 0x64, 0x57, 0xbb, 0xd2, 0xe0, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_430 = {
	.name = "ecdsa_brainpoolp256r1_sha256_430",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_430_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_430_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_430_sig,
	.siglen = 66,
	.result = -1,
	.comment = "Modified r or s, e.g. by adding or subtracting the order of the group, tcId is 6 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 431 for ECDSA, tcId is 7 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_431_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_431_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_431_sig[] = {
	0x00, 0x0a, 0x5f, 0x8c, 0x70, 0xba, 0x2d, 0x08, 0x42, 0xd5, 0xd0, 0xf8, 0x41, 0xf1, 0x60, 0xad, 0x15, 0x19, 0x57, 0x69, 0xa8, 0x15, 0x9b, 0xfe, 0x69, 0x26, 0x34, 0xd7, 0x3d, 0x46, 0x9d, 0x11, 0x1f, 0x01, 0x67, 0x8c, 0xd2, 0x60, 0xf4, 0xae, 0xb2, 0x11, 0xa7, 0x81, 0x38, 0x8f, 0xdd, 0x48, 0x47, 0x80, 0x07, 0xcf, 0x43, 0xd3, 0x2b, 0x73, 0x6d, 0xe0, 0x19, 0x91, 0x6c, 0xe1, 0xc0, 0x73, 0x7c, 0x39, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_431 = {
	.name = "ecdsa_brainpoolp256r1_sha256_431",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_431_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_431_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_431_sig,
	.siglen = 66,
	.result = -1,
	.comment = "Modified r or s, e.g. by adding or subtracting the order of the group, tcId is 7 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 432 for ECDSA, tcId is 8 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_432_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_432_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_432_sig[] = {
	0x0a, 0x5f, 0x8c, 0x70, 0xba, 0x2d, 0x08, 0x42, 0xd5, 0xd0, 0xf8, 0x41, 0xf1, 0x60, 0xad, 0x15, 0x19, 0x57, 0x69, 0xa8, 0x15, 0x9b, 0xfe, 0x69, 0x26, 0x34, 0xd7, 0x3d, 0x46, 0x9d, 0x11, 0x1f, 0x98, 0x73, 0x2d, 0x9f, 0x0b, 0x51, 0x4d, 0xee, 0x58, 0x7e, 0xc7, 0x70, 0x22, 0xb7, 0xb8, 0x7f, 0xf8, 0x30, 0xbc, 0x2c, 0xd4, 0x8c, 0x92, 0x1f, 0xe6, 0x6e, 0x93, 0x1e, 0x3f, 0x8c, 0x83, 0xc7, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_432 = {
	.name = "ecdsa_brainpoolp256r1_sha256_432",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_432_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_432_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_432_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Modified r or s, e.g. by adding or subtracting the order of the group, tcId is 8 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 433 for ECDSA, tcId is 9 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_433_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_433_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_433_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_433 = {
	.name = "ecdsa_brainpoolp256r1_sha256_433",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_433_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_433_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_433_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 9 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 434 for ECDSA, tcId is 10 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_434_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_434_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_434_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_434 = {
	.name = "ecdsa_brainpoolp256r1_sha256_434",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_434_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_434_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_434_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 10 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 435 for ECDSA, tcId is 11 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_435_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_435_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_435_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa7, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_435 = {
	.name = "ecdsa_brainpoolp256r1_sha256_435",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_435_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_435_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_435_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 11 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 436 for ECDSA, tcId is 12 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_436_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_436_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_436_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa6, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_436 = {
	.name = "ecdsa_brainpoolp256r1_sha256_436",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_436_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_436_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_436_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 12 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 437 for ECDSA, tcId is 13 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_437_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_437_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_437_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa8, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_437 = {
	.name = "ecdsa_brainpoolp256r1_sha256_437",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_437_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_437_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_437_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 13 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 438 for ECDSA, tcId is 14 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_438_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_438_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_438_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x77, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_438 = {
	.name = "ecdsa_brainpoolp256r1_sha256_438",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_438_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_438_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_438_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 14 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 439 for ECDSA, tcId is 15 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_439_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_439_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_439_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x78, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_439 = {
	.name = "ecdsa_brainpoolp256r1_sha256_439",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_439_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_439_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_439_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 15 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 440 for ECDSA, tcId is 16 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_440_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_440_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_440_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_440 = {
	.name = "ecdsa_brainpoolp256r1_sha256_440",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_440_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_440_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_440_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 16 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 441 for ECDSA, tcId is 17 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_441_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_441_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_441_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_441 = {
	.name = "ecdsa_brainpoolp256r1_sha256_441",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_441_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_441_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_441_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 17 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 442 for ECDSA, tcId is 18 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_442_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_442_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_442_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa7, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_442 = {
	.name = "ecdsa_brainpoolp256r1_sha256_442",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_442_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_442_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_442_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 18 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 443 for ECDSA, tcId is 19 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_443_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_443_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_443_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa6, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_443 = {
	.name = "ecdsa_brainpoolp256r1_sha256_443",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_443_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_443_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_443_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 19 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 444 for ECDSA, tcId is 20 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_444_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_444_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_444_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa8, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_444 = {
	.name = "ecdsa_brainpoolp256r1_sha256_444",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_444_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_444_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_444_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 20 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 445 for ECDSA, tcId is 21 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_445_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_445_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_445_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x77, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_445 = {
	.name = "ecdsa_brainpoolp256r1_sha256_445",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_445_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_445_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_445_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 21 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 446 for ECDSA, tcId is 22 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_446_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_446_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_446_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x78, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_446 = {
	.name = "ecdsa_brainpoolp256r1_sha256_446",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_446_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_446_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_446_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 22 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 447 for ECDSA, tcId is 23 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_447_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_447_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_447_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_447 = {
	.name = "ecdsa_brainpoolp256r1_sha256_447",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_447_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_447_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_447_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 23 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 448 for ECDSA, tcId is 24 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_448_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_448_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_448_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_448 = {
	.name = "ecdsa_brainpoolp256r1_sha256_448",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_448_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_448_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_448_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 24 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 449 for ECDSA, tcId is 25 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_449_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_449_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_449_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa7, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa7, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_449 = {
	.name = "ecdsa_brainpoolp256r1_sha256_449",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_449_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_449_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_449_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 25 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 450 for ECDSA, tcId is 26 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_450_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_450_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_450_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa7, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa6, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_450 = {
	.name = "ecdsa_brainpoolp256r1_sha256_450",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_450_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_450_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_450_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 26 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 451 for ECDSA, tcId is 27 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_451_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_451_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_451_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa7, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa8, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_451 = {
	.name = "ecdsa_brainpoolp256r1_sha256_451",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_451_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_451_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_451_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 27 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 452 for ECDSA, tcId is 28 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_452_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_452_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_452_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa7, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x77, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_452 = {
	.name = "ecdsa_brainpoolp256r1_sha256_452",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_452_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_452_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_452_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 28 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 453 for ECDSA, tcId is 29 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_453_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_453_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_453_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa7, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x78, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_453 = {
	.name = "ecdsa_brainpoolp256r1_sha256_453",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_453_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_453_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_453_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 29 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 454 for ECDSA, tcId is 30 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_454_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_454_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_454_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_454 = {
	.name = "ecdsa_brainpoolp256r1_sha256_454",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_454_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_454_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_454_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 30 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 455 for ECDSA, tcId is 31 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_455_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_455_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_455_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_455 = {
	.name = "ecdsa_brainpoolp256r1_sha256_455",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_455_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_455_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_455_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 31 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 456 for ECDSA, tcId is 32 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_456_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_456_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_456_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa6, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa7, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_456 = {
	.name = "ecdsa_brainpoolp256r1_sha256_456",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_456_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_456_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_456_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 32 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 457 for ECDSA, tcId is 33 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_457_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_457_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_457_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa6, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa6, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_457 = {
	.name = "ecdsa_brainpoolp256r1_sha256_457",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_457_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_457_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_457_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 33 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 458 for ECDSA, tcId is 34 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_458_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_458_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_458_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa6, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa8, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_458 = {
	.name = "ecdsa_brainpoolp256r1_sha256_458",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_458_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_458_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_458_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 34 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 459 for ECDSA, tcId is 35 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_459_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_459_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_459_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa6, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x77, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_459 = {
	.name = "ecdsa_brainpoolp256r1_sha256_459",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_459_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_459_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_459_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 35 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 460 for ECDSA, tcId is 36 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_460_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_460_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_460_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa6, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x78, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_460 = {
	.name = "ecdsa_brainpoolp256r1_sha256_460",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_460_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_460_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_460_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 36 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 461 for ECDSA, tcId is 37 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_461_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_461_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_461_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_461 = {
	.name = "ecdsa_brainpoolp256r1_sha256_461",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_461_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_461_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_461_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 37 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 462 for ECDSA, tcId is 38 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_462_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_462_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_462_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_462 = {
	.name = "ecdsa_brainpoolp256r1_sha256_462",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_462_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_462_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_462_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 38 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 463 for ECDSA, tcId is 39 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_463_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_463_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_463_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa8, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa7, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_463 = {
	.name = "ecdsa_brainpoolp256r1_sha256_463",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_463_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_463_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_463_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 39 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 464 for ECDSA, tcId is 40 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_464_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_464_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_464_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa8, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa6, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_464 = {
	.name = "ecdsa_brainpoolp256r1_sha256_464",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_464_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_464_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_464_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 40 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 465 for ECDSA, tcId is 41 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_465_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_465_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_465_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa8, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa8, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_465 = {
	.name = "ecdsa_brainpoolp256r1_sha256_465",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_465_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_465_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_465_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 41 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 466 for ECDSA, tcId is 42 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_466_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_466_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_466_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa8, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x77, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_466 = {
	.name = "ecdsa_brainpoolp256r1_sha256_466",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_466_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_466_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_466_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 42 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 467 for ECDSA, tcId is 43 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_467_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_467_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_467_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa8, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x78, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_467 = {
	.name = "ecdsa_brainpoolp256r1_sha256_467",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_467_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_467_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_467_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 43 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 468 for ECDSA, tcId is 44 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_468_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_468_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_468_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_468 = {
	.name = "ecdsa_brainpoolp256r1_sha256_468",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_468_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_468_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_468_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 44 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 469 for ECDSA, tcId is 45 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_469_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_469_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_469_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_469 = {
	.name = "ecdsa_brainpoolp256r1_sha256_469",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_469_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_469_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_469_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 45 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 470 for ECDSA, tcId is 46 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_470_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_470_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_470_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x77, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa7, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_470 = {
	.name = "ecdsa_brainpoolp256r1_sha256_470",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_470_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_470_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_470_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 46 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 471 for ECDSA, tcId is 47 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_471_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_471_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_471_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x77, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa6, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_471 = {
	.name = "ecdsa_brainpoolp256r1_sha256_471",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_471_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_471_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_471_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 47 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 472 for ECDSA, tcId is 48 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_472_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_472_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_472_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x77, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa8, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_472 = {
	.name = "ecdsa_brainpoolp256r1_sha256_472",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_472_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_472_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_472_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 48 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 473 for ECDSA, tcId is 49 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_473_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_473_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_473_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x77, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x77, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_473 = {
	.name = "ecdsa_brainpoolp256r1_sha256_473",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_473_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_473_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_473_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 49 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 474 for ECDSA, tcId is 50 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_474_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_474_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_474_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x77, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x78, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_474 = {
	.name = "ecdsa_brainpoolp256r1_sha256_474",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_474_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_474_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_474_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 50 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 475 for ECDSA, tcId is 51 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_475_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_475_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_475_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_475 = {
	.name = "ecdsa_brainpoolp256r1_sha256_475",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_475_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_475_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_475_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 51 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 476 for ECDSA, tcId is 52 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_476_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_476_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_476_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_476 = {
	.name = "ecdsa_brainpoolp256r1_sha256_476",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_476_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_476_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_476_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 52 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 477 for ECDSA, tcId is 53 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_477_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_477_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_477_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x78, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa7, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_477 = {
	.name = "ecdsa_brainpoolp256r1_sha256_477",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_477_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_477_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_477_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 53 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 478 for ECDSA, tcId is 54 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_478_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_478_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_478_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x78, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa6, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_478 = {
	.name = "ecdsa_brainpoolp256r1_sha256_478",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_478_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_478_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_478_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 54 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 479 for ECDSA, tcId is 55 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_479_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_479_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_479_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x78, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa8, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_479 = {
	.name = "ecdsa_brainpoolp256r1_sha256_479",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_479_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_479_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_479_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 55 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 480 for ECDSA, tcId is 56 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_480_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_480_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_480_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x78, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x77, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_480 = {
	.name = "ecdsa_brainpoolp256r1_sha256_480",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_480_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_480_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_480_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 56 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 481 for ECDSA, tcId is 57 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_481_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_481_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_481_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x78, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x78, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_481 = {
	.name = "ecdsa_brainpoolp256r1_sha256_481",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_481_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_481_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_481_sig,
	.siglen = 64,
	.result = -1,
	.comment = "Signature with special case values for r and s, tcId is 57 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 482 for ECDSA, tcId is 58 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_482_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_482_msg[] = {
	0x36, 0x38, 0x39, 0x34, 0x34, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_482_sig[] = {
	0x0c, 0x93, 0x9a, 0x92, 0x48, 0x6c, 0x6d, 0x0d, 0x61, 0x95, 0x10, 0xb4, 0xa9, 0x41, 0x62, 0xb9, 0x22, 0x1b, 0xe2, 0xeb, 0x15, 0xfa, 0xf8, 0x78, 0xbf, 0xf7, 0x5e, 0x6c, 0xdf, 0x4e, 0x37, 0x07, 0x39, 0x77, 0x61, 0x9b, 0x43, 0xe6, 0xb4, 0xea, 0x18, 0x70, 0xd8, 0x61, 0x20, 0x64, 0x83, 0xb3, 0x06, 0x56, 0x0e, 0x3c, 0x4a, 0x3e, 0xf8, 0x2b, 0x11, 0xa8, 0x02, 0xff, 0x88, 0x92, 0xdc, 0x1d, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_482 = {
	.name = "ecdsa_brainpoolp256r1_sha256_482",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_482_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_482_msg,
	.msglen = 5,
	.sig = ecdsa_brainpoolp256r1_sha256_482_sig,
	.siglen = 64,
	.result = 1,
	.comment = "Edge case for Shamir multiplication, tcId is 58 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 483 for ECDSA, tcId is 59 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_483_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_483_msg[] = {
	0x34, 0x32, 0x36, 0x34, 0x37, 0x39, 0x37, 0x32, 0x34, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_483_sig[] = {
	0x55, 0x83, 0xdd, 0x48, 0x09, 0x64, 0xbd, 0x23, 0x32, 0x88, 0x5f, 0xbb, 0x50, 0xb7, 0x47, 0x5e, 0xbd, 0x42, 0x83, 0x99, 0xe7, 0x16, 0x6f, 0xd9, 0xbd, 0x52, 0x96, 0x11, 0x53, 0x4b, 0x9f, 0x34, 0x0e, 0xd0, 0x35, 0xa0, 0x2c, 0x4b, 0x66, 0x5c, 0xac, 0xb7, 0x0d, 0xe8, 0xe8, 0x22, 0xfa, 0xcd, 0x71, 0x64, 0x5a, 0x15, 0xf9, 0x3f, 0xee, 0x66, 0x13, 0x24, 0xf8, 0x50, 0xb8, 0x47, 0xb5, 0x1d, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_483 = {
	.name = "ecdsa_brainpoolp256r1_sha256_483",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_483_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_483_msg,
	.msglen = 9,
	.sig = ecdsa_brainpoolp256r1_sha256_483_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 59 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 484 for ECDSA, tcId is 60 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_484_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_484_msg[] = {
	0x37, 0x31, 0x33, 0x38, 0x36, 0x38, 0x34, 0x38, 0x39, 0x31, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_484_sig[] = {
	0x30, 0x0e, 0x26, 0x02, 0x7c, 0xe7, 0xd3, 0xf2, 0x1c, 0x85, 0x71, 0xdc, 0x69, 0x0b, 0x1b, 0xb9, 0x90, 0xe8, 0xfc, 0x49, 0xad, 0x3e, 0x95, 0x37, 0x4b, 0xd5, 0x43, 0xb2, 0xe2, 0x2b, 0xad, 0xc6, 0x22, 0xbc, 0x8f, 0x24, 0x45, 0xcd, 0x49, 0x56, 0xbc, 0x0d, 0xb5, 0x53, 0x96, 0x6a, 0x07, 0x18, 0xae, 0xb5, 0xea, 0xd6, 0x5b, 0xc6, 0x6d, 0xdb, 0x21, 0xfe, 0xa0, 0xe5, 0x71, 0xa8, 0x7e, 0xe1, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_484 = {
	.name = "ecdsa_brainpoolp256r1_sha256_484",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_484_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_484_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_484_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 60 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 485 for ECDSA, tcId is 61 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_485_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_485_msg[] = {
	0x31, 0x30, 0x33, 0x35, 0x39, 0x33, 0x33, 0x31, 0x36, 0x36, 0x38, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_485_sig[] = {
	0x29, 0x07, 0xcb, 0x01, 0xa8, 0x2a, 0x88, 0x04, 0x66, 0x40, 0xa5, 0x23, 0xf9, 0xb9, 0x85, 0x4d, 0x95, 0xb7, 0xec, 0x2d, 0xdd, 0x67, 0xc2, 0x07, 0x23, 0xd0, 0x58, 0x29, 0xe8, 0x43, 0x8a, 0x77, 0x38, 0xca, 0x08, 0xe5, 0x86, 0x23, 0x56, 0x0f, 0x72, 0x4a, 0x3e, 0x3f, 0x9b, 0xa0, 0xe9, 0xec, 0x79, 0x74, 0x97, 0x6d, 0xd3, 0x4e, 0x69, 0x40, 0xc0, 0xfe, 0x61, 0x68, 0xd5, 0x40, 0xe3, 0x9b, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_485 = {
	.name = "ecdsa_brainpoolp256r1_sha256_485",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_485_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_485_msg,
	.msglen = 11,
	.sig = ecdsa_brainpoolp256r1_sha256_485_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 61 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 486 for ECDSA, tcId is 62 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_486_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_486_msg[] = {
	0x33, 0x39, 0x34, 0x39, 0x34, 0x30, 0x31, 0x32, 0x31, 0x35, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_486_sig[] = {
	0x0c, 0x35, 0x84, 0x0f, 0x7b, 0x73, 0x19, 0xf1, 0x9f, 0xd7, 0x2f, 0x29, 0xfe, 0xa4, 0xcf, 0x93, 0x7a, 0xba, 0x2c, 0x3f, 0xe1, 0xdc, 0x01, 0xae, 0xc6, 0x3c, 0x21, 0x09, 0x4c, 0x5d, 0x35, 0x48, 0x7b, 0xf6, 0x99, 0x86, 0x8c, 0x2b, 0x69, 0x45, 0x47, 0xae, 0xbe, 0x9b, 0x98, 0xc0, 0x1c, 0x5e, 0xfb, 0xe9, 0x82, 0xa8, 0x41, 0x50, 0x39, 0x08, 0x94, 0x56, 0x3d, 0x4e, 0x2c, 0xb2, 0x40, 0xb6, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_486 = {
	.name = "ecdsa_brainpoolp256r1_sha256_486",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_486_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_486_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_486_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 62 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 487 for ECDSA, tcId is 63 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_487_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_487_msg[] = {
	0x31, 0x33, 0x34, 0x34, 0x32, 0x39, 0x33, 0x30, 0x37, 0x39, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_487_sig[] = {
	0x42, 0x72, 0xff, 0x20, 0xb8, 0xc3, 0xd1, 0x9e, 0x8c, 0x84, 0x14, 0x1f, 0xbe, 0x4d, 0x16, 0x81, 0xfa, 0x71, 0xb5, 0x1f, 0x6c, 0x10, 0x36, 0x0d, 0xb7, 0xaf, 0xfa, 0xc9, 0x89, 0x27, 0x4d, 0x23, 0x67, 0x72, 0xff, 0x76, 0x8e, 0xe6, 0xa3, 0xed, 0xaf, 0x0d, 0xbd, 0xd7, 0xb5, 0xc6, 0x96, 0x2c, 0x2a, 0xcc, 0x8c, 0xb1, 0x4e, 0x63, 0x47, 0x63, 0x1e, 0x25, 0x94, 0x01, 0x89, 0x72, 0x94, 0x68, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_487 = {
	.name = "ecdsa_brainpoolp256r1_sha256_487",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_487_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_487_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_487_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 63 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 488 for ECDSA, tcId is 64 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_488_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_488_msg[] = {
	0x33, 0x37, 0x30, 0x36, 0x32, 0x31, 0x31, 0x37, 0x31, 0x32, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_488_sig[] = {
	0x0a, 0x1e, 0x07, 0x2c, 0x48, 0xa6, 0x2a, 0x58, 0x3b, 0xf9, 0x4f, 0xe6, 0x38, 0x09, 0xe9, 0x5f, 0x32, 0x02, 0x17, 0x6b, 0xfa, 0x6d, 0x28, 0xde, 0x8f, 0x75, 0xa4, 0xa3, 0x25, 0x6c, 0xa2, 0x1f, 0x95, 0x14, 0xa6, 0xe5, 0xb2, 0x35, 0xc2, 0x91, 0x52, 0x56, 0x1c, 0xc9, 0x49, 0x2c, 0xf4, 0x74, 0x77, 0xa0, 0xfe, 0x23, 0xf5, 0x60, 0x40, 0xd7, 0x20, 0x6b, 0xfb, 0x4e, 0xb3, 0xe1, 0x87, 0x98, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_488 = {
	.name = "ecdsa_brainpoolp256r1_sha256_488",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_488_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_488_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_488_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 64 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 489 for ECDSA, tcId is 65 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_489_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_489_msg[] = {
	0x33, 0x34, 0x33, 0x36, 0x38, 0x38, 0x37, 0x31, 0x32, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_489_sig[] = {
	0x02, 0xbc, 0xbd, 0x38, 0xa3, 0xe3, 0x11, 0x34, 0x45, 0xad, 0x2e, 0xe4, 0x2f, 0xae, 0xae, 0xe9, 0xfe, 0xd0, 0x02, 0x77, 0xe0, 0xb1, 0x55, 0x21, 0x32, 0x9f, 0x4c, 0x27, 0xc9, 0x63, 0xaf, 0x01, 0x06, 0xcf, 0x39, 0x9d, 0xeb, 0x1f, 0x6f, 0xd6, 0x92, 0x07, 0x5d, 0x23, 0x62, 0x72, 0xb9, 0x9c, 0x33, 0x36, 0xae, 0xa2, 0xcf, 0xac, 0x34, 0xd9, 0x04, 0x64, 0x6c, 0xc1, 0xda, 0xf5, 0x4d, 0xe6, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_489 = {
	.name = "ecdsa_brainpoolp256r1_sha256_489",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_489_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_489_msg,
	.msglen = 9,
	.sig = ecdsa_brainpoolp256r1_sha256_489_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 65 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 490 for ECDSA, tcId is 66 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_490_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_490_msg[] = {
	0x31, 0x33, 0x35, 0x31, 0x35, 0x33, 0x30, 0x33, 0x37, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_490_sig[] = {
	0x62, 0xf3, 0xa6, 0xa9, 0xc9, 0xf4, 0x57, 0x21, 0x1b, 0x46, 0xb1, 0xca, 0x3a, 0x78, 0x2f, 0x11, 0xf4, 0x4c, 0xb9, 0x36, 0x0b, 0xb3, 0x07, 0x02, 0xe6, 0x71, 0x36, 0x03, 0x6c, 0xcb, 0xa3, 0x9e, 0x22, 0xf0, 0x2e, 0x5f, 0x64, 0x7c, 0xeb, 0x3d, 0x0c, 0x49, 0xf2, 0xe7, 0xac, 0x9b, 0xbb, 0x31, 0xb7, 0xe3, 0xae, 0x29, 0xa5, 0xed, 0x67, 0x0c, 0x96, 0xca, 0xd6, 0xd0, 0xf4, 0x5d, 0xf3, 0x89, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_490 = {
	.name = "ecdsa_brainpoolp256r1_sha256_490",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_490_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_490_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_490_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 66 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 491 for ECDSA, tcId is 67 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_491_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_491_msg[] = {
	0x36, 0x35, 0x35, 0x33, 0x32, 0x30, 0x33, 0x31, 0x32, 0x36, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_491_sig[] = {
	0x23, 0xd6, 0x79, 0xae, 0xd9, 0x06, 0x6b, 0x61, 0x18, 0x20, 0xa8, 0xe0, 0x2b, 0x3d, 0xaa, 0x92, 0x2b, 0x10, 0xd5, 0x59, 0x6c, 0x8c, 0xeb, 0x7b, 0xd4, 0xe4, 0xfc, 0xd6, 0xe5, 0xe1, 0xdc, 0xa7, 0x96, 0x26, 0xe1, 0xd2, 0x20, 0x5d, 0x60, 0xe3, 0x9b, 0x63, 0x38, 0x52, 0xf6, 0x23, 0xf0, 0xf8, 0xb3, 0x5e, 0x44, 0x79, 0x7e, 0x08, 0xc6, 0xfa, 0xd1, 0x96, 0xc3, 0x3b, 0xe6, 0x9b, 0x5a, 0xc7, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_491 = {
	.name = "ecdsa_brainpoolp256r1_sha256_491",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_491_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_491_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_491_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 67 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 492 for ECDSA, tcId is 68 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_492_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_492_msg[] = {
	0x31, 0x35, 0x36, 0x34, 0x33, 0x34, 0x36, 0x36, 0x30, 0x33, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_492_sig[] = {
	0x0e, 0x4c, 0x5c, 0x07, 0x7f, 0x14, 0xa4, 0xdb, 0x19, 0x76, 0x54, 0xf8, 0x08, 0x1f, 0x10, 0xac, 0x22, 0x29, 0xe6, 0xf2, 0x08, 0x44, 0x05, 0xae, 0xa5, 0x25, 0x67, 0x9e, 0x59, 0x25, 0x39, 0xa9, 0x13, 0x55, 0xd4, 0x36, 0x67, 0x40, 0x2b, 0x9f, 0x01, 0x95, 0x91, 0x40, 0xc4, 0x14, 0xf1, 0x8d, 0x90, 0x8e, 0x25, 0x59, 0xe5, 0x7a, 0xdf, 0x35, 0xce, 0x79, 0x4d, 0xbc, 0x8e, 0x22, 0x20, 0x06, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_492 = {
	.name = "ecdsa_brainpoolp256r1_sha256_492",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_492_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_492_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_492_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 68 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 493 for ECDSA, tcId is 69 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_493_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_493_msg[] = {
	0x34, 0x34, 0x32, 0x39, 0x35, 0x33, 0x39, 0x31, 0x31, 0x37, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_493_sig[] = {
	0x32, 0x46, 0xb3, 0x39, 0x54, 0xcf, 0x1d, 0xd4, 0xa2, 0x16, 0x21, 0x8d, 0x49, 0xb1, 0x4e, 0x39, 0xdb, 0x82, 0x00, 0x4b, 0xa0, 0x55, 0x6f, 0xb5, 0x91, 0x35, 0x7a, 0xff, 0x76, 0xa1, 0xea, 0x63, 0x5b, 0x5f, 0xcb, 0x72, 0x6e, 0xbf, 0x18, 0xc9, 0x15, 0x1a, 0x26, 0xa5, 0xb0, 0x80, 0x0c, 0xbf, 0x95, 0xb5, 0xed, 0xc0, 0x84, 0xb4, 0x2d, 0xc6, 0xdc, 0x7f, 0xbb, 0x9a, 0x0a, 0xed, 0x84, 0x25, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_493 = {
	.name = "ecdsa_brainpoolp256r1_sha256_493",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_493_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_493_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_493_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 69 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 494 for ECDSA, tcId is 70 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_494_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_494_msg[] = {
	0x31, 0x30, 0x39, 0x35, 0x33, 0x32, 0x36, 0x31, 0x33, 0x35, 0x31, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_494_sig[] = {
	0x36, 0x1a, 0x8d, 0xef, 0x87, 0x40, 0x57, 0xc7, 0x15, 0x42, 0x38, 0x43, 0xbd, 0x7b, 0xf0, 0x77, 0x5b, 0xa6, 0x36, 0x6f, 0xa4, 0x8c, 0xa8, 0x3e, 0x1c, 0xdc, 0xe2, 0x06, 0xbf, 0x94, 0xc2, 0xbf, 0x36, 0x5e, 0x97, 0x49, 0x3d, 0x33, 0x82, 0x68, 0x1f, 0x1d, 0x94, 0x65, 0x7e, 0x98, 0x88, 0x24, 0x5c, 0x9b, 0x07, 0x62, 0xee, 0x7f, 0x4c, 0xa0, 0x2e, 0x73, 0x8a, 0xfd, 0xbb, 0xa2, 0x74, 0xd6, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_494 = {
	.name = "ecdsa_brainpoolp256r1_sha256_494",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_494_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_494_msg,
	.msglen = 11,
	.sig = ecdsa_brainpoolp256r1_sha256_494_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 70 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 495 for ECDSA, tcId is 71 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_495_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_495_msg[] = {
	0x35, 0x39, 0x38, 0x37, 0x33, 0x35, 0x30, 0x30, 0x34, 0x31, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_495_sig[] = {
	0x2c, 0x5f, 0x51, 0xbc, 0x91, 0x96, 0x9f, 0xd5, 0xb8, 0x04, 0xe7, 0x51, 0x32, 0x3f, 0xc8, 0x02, 0x94, 0xb0, 0xb5, 0xb1, 0xe2, 0x0e, 0x19, 0x5e, 0xc9, 0xbd, 0xc6, 0xa7, 0x80, 0x6d, 0xa1, 0x3f, 0x4c, 0x24, 0x6c, 0x94, 0x9b, 0xce, 0x43, 0xd3, 0x03, 0x20, 0x1f, 0xa0, 0xd9, 0x89, 0xe7, 0x06, 0x74, 0x76, 0x65, 0x55, 0xe8, 0xd3, 0xa9, 0x9c, 0x26, 0xba, 0xbb, 0x65, 0x8d, 0x1f, 0x7d, 0xb8, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_495 = {
	.name = "ecdsa_brainpoolp256r1_sha256_495",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_495_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_495_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_495_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 71 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 496 for ECDSA, tcId is 72 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_496_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_496_msg[] = {
	0x33, 0x34, 0x36, 0x33, 0x30, 0x30, 0x36, 0x38, 0x37, 0x38, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_496_sig[] = {
	0xa9, 0xe3, 0xf1, 0xe8, 0x31, 0x08, 0xbe, 0x78, 0x66, 0x8d, 0x4b, 0xac, 0x7f, 0xfb, 0x29, 0x18, 0xd3, 0x81, 0x00, 0xba, 0x01, 0xf3, 0x7d, 0xe5, 0xb9, 0x23, 0xee, 0xca, 0x07, 0xcc, 0x05, 0xe3, 0x3f, 0x0d, 0x81, 0xbc, 0xc0, 0x88, 0x02, 0xa4, 0x35, 0x59, 0x97, 0x59, 0xf5, 0x1c, 0x89, 0xf8, 0x16, 0x74, 0x27, 0x10, 0x88, 0x5b, 0x41, 0x37, 0x75, 0x81, 0x30, 0xe8, 0xac, 0xf7, 0x07, 0xd4, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_496 = {
	.name = "ecdsa_brainpoolp256r1_sha256_496",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_496_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_496_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_496_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 72 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 497 for ECDSA, tcId is 73 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_497_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_497_msg[] = {
	0x39, 0x38, 0x31, 0x37, 0x33, 0x32, 0x30, 0x32, 0x38, 0x37, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_497_sig[] = {
	0x95, 0x9e, 0x98, 0x11, 0xbb, 0x18, 0xb4, 0x86, 0x5f, 0xde, 0x6d, 0x5f, 0x9c, 0x24, 0x6d, 0x67, 0xe4, 0x8d, 0x7a, 0x5c, 0x7c, 0xe4, 0x6d, 0x7a, 0xfb, 0x6f, 0x5e, 0xc0, 0xb2, 0x6d, 0x50, 0x60, 0x00, 0x91, 0xa0, 0x97, 0x61, 0x8f, 0x25, 0x17, 0xad, 0x6d, 0xcf, 0x49, 0xbc, 0xc2, 0x08, 0xe9, 0x4c, 0xb8, 0x1a, 0xf8, 0x7f, 0x65, 0xb7, 0x88, 0x05, 0x80, 0xf9, 0x98, 0x58, 0xa9, 0xa9, 0x15, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_497 = {
	.name = "ecdsa_brainpoolp256r1_sha256_497",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_497_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_497_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_497_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 73 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 498 for ECDSA, tcId is 74 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_498_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_498_msg[] = {
	0x33, 0x32, 0x32, 0x32, 0x30, 0x34, 0x31, 0x30, 0x34, 0x36, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_498_sig[] = {
	0x4f, 0x92, 0x31, 0xb1, 0xcb, 0xae, 0xa1, 0x83, 0xed, 0x9d, 0x85, 0x91, 0xae, 0x3e, 0x9f, 0x04, 0x39, 0x20, 0x1e, 0x10, 0x67, 0xff, 0x00, 0x53, 0x5a, 0x41, 0x53, 0x96, 0xb7, 0x78, 0x11, 0xd6, 0x98, 0x51, 0xc7, 0x99, 0xa3, 0x11, 0xab, 0xae, 0xfa, 0x08, 0xc4, 0x12, 0xf6, 0xf6, 0x79, 0xa0, 0x00, 0xa6, 0xed, 0xaa, 0x00, 0x5d, 0x05, 0xf5, 0x50, 0xa6, 0x2f, 0xf9, 0xa6, 0xa1, 0xa5, 0x07, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_498 = {
	.name = "ecdsa_brainpoolp256r1_sha256_498",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_498_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_498_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_498_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 74 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 499 for ECDSA, tcId is 75 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_499_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_499_msg[] = {
	0x36, 0x36, 0x36, 0x36, 0x33, 0x30, 0x37, 0x31, 0x30, 0x34, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_499_sig[] = {
	0x54, 0x79, 0xac, 0xb7, 0x6c, 0x38, 0xd4, 0x7f, 0x21, 0x94, 0x08, 0x55, 0xf1, 0x80, 0x09, 0x78, 0xa5, 0x2f, 0xb1, 0x0b, 0x7c, 0xc9, 0xb0, 0x7c, 0xaf, 0x88, 0xaf, 0x67, 0xf2, 0x69, 0x71, 0x43, 0x24, 0x4f, 0x3c, 0xdd, 0x68, 0x35, 0x55, 0xb8, 0x8a, 0x45, 0xe9, 0x75, 0x07, 0x37, 0x35, 0xd3, 0x87, 0x13, 0xda, 0x4b, 0xde, 0xa3, 0x40, 0xb5, 0xfb, 0x87, 0xd3, 0xc4, 0x43, 0xad, 0xb0, 0xee, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_499 = {
	.name = "ecdsa_brainpoolp256r1_sha256_499",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_499_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_499_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_499_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 75 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 500 for ECDSA, tcId is 76 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_500_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_500_msg[] = {
	0x31, 0x30, 0x33, 0x35, 0x39, 0x35, 0x31, 0x38, 0x39, 0x38, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_500_sig[] = {
	0x14, 0x99, 0x01, 0x49, 0xd3, 0xa8, 0xf3, 0xc9, 0x6e, 0x9c, 0x62, 0x95, 0x2f, 0x90, 0xef, 0x21, 0xcb, 0xcc, 0x0d, 0x03, 0xda, 0x80, 0x2f, 0x72, 0x43, 0x2a, 0x04, 0x1d, 0xa5, 0x4d, 0xb5, 0xbe, 0x87, 0x42, 0x7b, 0x96, 0xd2, 0x84, 0x99, 0x70, 0x7a, 0x67, 0x88, 0x70, 0x5c, 0xd8, 0xa5, 0xee, 0x9f, 0xd4, 0x2e, 0x2d, 0x1f, 0x12, 0x73, 0x75, 0x23, 0x37, 0xef, 0xcd, 0x06, 0xaa, 0x88, 0xa9, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_500 = {
	.name = "ecdsa_brainpoolp256r1_sha256_500",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_500_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_500_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_500_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 76 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 501 for ECDSA, tcId is 77 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_501_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_501_msg[] = {
	0x31, 0x38, 0x34, 0x36, 0x35, 0x39, 0x37, 0x31, 0x39, 0x35, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_501_sig[] = {
	0x5b, 0xb2, 0x44, 0xb5, 0x11, 0xa9, 0x82, 0x8f, 0xbe, 0x7a, 0x04, 0x1a, 0xf3, 0x41, 0xa9, 0x3b, 0x24, 0x2b, 0x51, 0x33, 0x10, 0xde, 0x9f, 0x4b, 0xc3, 0x66, 0xe1, 0x8b, 0x93, 0xa3, 0xce, 0x34, 0x97, 0x8b, 0xe5, 0xd5, 0x8c, 0xe7, 0x0c, 0x92, 0xde, 0xa7, 0x5c, 0xe2, 0xf8, 0xe8, 0x8f, 0x09, 0x3f, 0x5e, 0x46, 0x75, 0xe7, 0x50, 0xfd, 0x08, 0x87, 0x77, 0xa7, 0x41, 0x15, 0x26, 0xc1, 0xf7, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_501 = {
	.name = "ecdsa_brainpoolp256r1_sha256_501",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_501_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_501_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_501_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 77 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 502 for ECDSA, tcId is 78 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_502_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_502_msg[] = {
	0x33, 0x31, 0x33, 0x36, 0x30, 0x34, 0x36, 0x31, 0x38, 0x39, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_502_sig[] = {
	0x07, 0x0e, 0x64, 0xf4, 0xd1, 0x9f, 0x9f, 0xd9, 0xa8, 0xd3, 0xf0, 0xa6, 0x4f, 0x95, 0x1c, 0x41, 0xdb, 0x2f, 0x0e, 0x13, 0x49, 0x0e, 0x7a, 0xc0, 0xb3, 0xf6, 0x06, 0x6b, 0xc1, 0xe5, 0x40, 0xa7, 0x83, 0x5b, 0x25, 0x02, 0x9a, 0x2c, 0xed, 0x8d, 0xf5, 0x7b, 0x03, 0x43, 0xa2, 0xc7, 0x18, 0xdb, 0x72, 0xc2, 0xd3, 0x1f, 0x7e, 0xf6, 0x6b, 0x23, 0x0c, 0x97, 0xd2, 0x02, 0x81, 0xd4, 0x9a, 0x33, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_502 = {
	.name = "ecdsa_brainpoolp256r1_sha256_502",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_502_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_502_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_502_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 78 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 503 for ECDSA, tcId is 79 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_503_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_503_msg[] = {
	0x32, 0x36, 0x36, 0x33, 0x37, 0x38, 0x34, 0x32, 0x35, 0x34, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_503_sig[] = {
	0x2b, 0x5a, 0x6d, 0xc1, 0x4e, 0x98, 0xd2, 0xe6, 0xc0, 0xb6, 0x27, 0x56, 0x8a, 0x74, 0x8b, 0xda, 0x04, 0xc0, 0x95, 0x00, 0xbc, 0x63, 0xbd, 0x74, 0x4f, 0x5d, 0xee, 0x96, 0x7d, 0xb0, 0xf0, 0xb1, 0x34, 0x52, 0xb1, 0x3e, 0xf8, 0xdc, 0x01, 0xa0, 0xb7, 0x85, 0xfb, 0xb4, 0xfc, 0xd0, 0x57, 0xa5, 0x88, 0x0c, 0x41, 0x84, 0x27, 0x28, 0x3a, 0xbc, 0x7a, 0xa7, 0xfa, 0x07, 0xd5, 0x07, 0xee, 0xd0, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_503 = {
	.name = "ecdsa_brainpoolp256r1_sha256_503",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_503_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_503_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_503_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 79 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 504 for ECDSA, tcId is 80 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_504_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_504_msg[] = {
	0x31, 0x36, 0x35, 0x32, 0x31, 0x30, 0x30, 0x35, 0x32, 0x34, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_504_sig[] = {
	0x1d, 0x91, 0xbd, 0xa9, 0x0d, 0x08, 0x31, 0xbe, 0x05, 0x8f, 0x61, 0x0f, 0xe3, 0xe6, 0x45, 0x17, 0x91, 0xe0, 0x96, 0x89, 0xc5, 0x2b, 0xd4, 0x66, 0xef, 0x74, 0xdd, 0x85, 0xb3, 0xcb, 0xd1, 0x21, 0x4b, 0xa3, 0x7a, 0x93, 0x41, 0xe5, 0x92, 0x3e, 0xa9, 0x3e, 0x35, 0x73, 0x44, 0xfe, 0x7b, 0x73, 0x44, 0x6e, 0x20, 0x7a, 0x7e, 0x44, 0x96, 0x07, 0xb1, 0x48, 0x2c, 0x51, 0x0e, 0x93, 0xb6, 0x30, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_504 = {
	.name = "ecdsa_brainpoolp256r1_sha256_504",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_504_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_504_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_504_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 80 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 505 for ECDSA, tcId is 81 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_505_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_505_msg[] = {
	0x35, 0x37, 0x34, 0x38, 0x30, 0x38, 0x31, 0x36, 0x39, 0x36, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_505_sig[] = {
	0x6a, 0x32, 0xe1, 0x62, 0x5c, 0x1e, 0xb7, 0xd4, 0x0b, 0x31, 0x45, 0xf8, 0x94, 0xc7, 0x13, 0x8d, 0x62, 0x32, 0xa6, 0x11, 0x6d, 0x50, 0xf1, 0x27, 0x0a, 0x0e, 0x97, 0x1e, 0x2b, 0x7a, 0x8e, 0x75, 0x61, 0xb6, 0xaa, 0xe5, 0x68, 0x19, 0x27, 0x28, 0x13, 0x31, 0x9f, 0x7c, 0x21, 0x4f, 0x83, 0xce, 0x5f, 0xcc, 0xdb, 0x58, 0x87, 0x8d, 0x59, 0x2a, 0xb0, 0xf4, 0x47, 0x9a, 0x52, 0xd9, 0x70, 0xe1, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_505 = {
	.name = "ecdsa_brainpoolp256r1_sha256_505",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_505_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_505_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_505_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 81 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 506 for ECDSA, tcId is 82 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_506_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_506_msg[] = {
	0x36, 0x33, 0x34, 0x33, 0x39, 0x31, 0x33, 0x34, 0x36, 0x38, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_506_sig[] = {
	0x5b, 0x75, 0x26, 0xf0, 0x9d, 0xab, 0x24, 0x85, 0x51, 0xed, 0x8b, 0x12, 0x29, 0xc2, 0x44, 0x7a, 0x45, 0x21, 0xd2, 0xd6, 0xe2, 0x29, 0x02, 0xac, 0xbc, 0x17, 0x6c, 0x50, 0x1f, 0x5f, 0x5f, 0x7e, 0x31, 0x86, 0x55, 0x2f, 0x70, 0x0d, 0x9e, 0x6b, 0x55, 0x1c, 0x89, 0x3e, 0xd2, 0xae, 0xd9, 0x55, 0x6b, 0x3f, 0x0a, 0xc2, 0xa5, 0xe2, 0x77, 0x2f, 0x8f, 0xb1, 0xa1, 0x84, 0x94, 0x92, 0x62, 0xcb, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_506 = {
	.name = "ecdsa_brainpoolp256r1_sha256_506",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_506_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_506_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_506_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 82 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 507 for ECDSA, tcId is 83 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_507_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_507_msg[] = {
	0x31, 0x35, 0x34, 0x31, 0x31, 0x30, 0x33, 0x35, 0x39, 0x38, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_507_sig[] = {
	0x30, 0xd0, 0xff, 0xa9, 0xc2, 0xbe, 0x04, 0x2c, 0xcd, 0x2c, 0x9a, 0xdb, 0xcb, 0xbb, 0xa2, 0x2c, 0xc0, 0x44, 0xd6, 0x9a, 0xbf, 0x37, 0xef, 0xf2, 0xbc, 0xab, 0x91, 0xd4, 0x5b, 0xe9, 0xb0, 0xbd, 0x48, 0x2d, 0xd7, 0x2a, 0xa3, 0xb3, 0xf3, 0xf2, 0xe6, 0xdd, 0x4a, 0x07, 0x5f, 0xa9, 0x62, 0xb8, 0xf6, 0xfc, 0x25, 0xe9, 0xd3, 0x2d, 0x0d, 0xcc, 0xbd, 0x80, 0x83, 0x1a, 0xcf, 0x75, 0x95, 0xe0, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_507 = {
	.name = "ecdsa_brainpoolp256r1_sha256_507",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_507_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_507_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_507_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 83 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 508 for ECDSA, tcId is 84 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_508_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_508_msg[] = {
	0x31, 0x30, 0x34, 0x37, 0x38, 0x35, 0x38, 0x30, 0x31, 0x32, 0x38, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_508_sig[] = {
	0x20, 0x0d, 0x3b, 0x5f, 0x91, 0x58, 0x63, 0xad, 0xa8, 0xc8, 0x4e, 0xf5, 0xeb, 0x50, 0xec, 0xf0, 0xab, 0x43, 0xe2, 0xba, 0xc1, 0x0a, 0x4c, 0x42, 0xcf, 0x37, 0x19, 0x12, 0x1a, 0x8d, 0x37, 0xcd, 0x9d, 0x13, 0x7e, 0x11, 0xa0, 0x50, 0xbf, 0xbb, 0xa7, 0x46, 0xc1, 0x9a, 0xd5, 0xf7, 0x19, 0x5c, 0x86, 0xf2, 0x41, 0x15, 0xd1, 0xfa, 0xdf, 0xb1, 0x9a, 0xd2, 0xcb, 0x56, 0x24, 0x12, 0x6c, 0xda, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_508 = {
	.name = "ecdsa_brainpoolp256r1_sha256_508",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_508_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_508_msg,
	.msglen = 11,
	.sig = ecdsa_brainpoolp256r1_sha256_508_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 84 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 509 for ECDSA, tcId is 85 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_509_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_509_msg[] = {
	0x31, 0x30, 0x35, 0x33, 0x36, 0x32, 0x38, 0x35, 0x35, 0x36, 0x38, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_509_sig[] = {
	0x4a, 0xc5, 0x54, 0x70, 0x78, 0x90, 0x95, 0xe9, 0xe2, 0x50, 0x33, 0x2f, 0x37, 0x90, 0xf8, 0x65, 0xfb, 0xcc, 0x58, 0x93, 0x45, 0x88, 0xc7, 0x74, 0xba, 0xbf, 0x22, 0xde, 0x6a, 0x8a, 0x69, 0x58, 0x2c, 0xfe, 0xfb, 0x0e, 0x2b, 0xe0, 0x54, 0x2c, 0x97, 0xeb, 0x61, 0x91, 0x4f, 0x23, 0xfb, 0x37, 0xb5, 0x8f, 0xb1, 0x7d, 0x0d, 0x6b, 0x76, 0x6a, 0x8f, 0x63, 0xc8, 0xd0, 0xdc, 0x79, 0xe5, 0x2b, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_509 = {
	.name = "ecdsa_brainpoolp256r1_sha256_509",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_509_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_509_msg,
	.msglen = 11,
	.sig = ecdsa_brainpoolp256r1_sha256_509_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 85 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 510 for ECDSA, tcId is 86 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_510_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_510_msg[] = {
	0x39, 0x35, 0x33, 0x39, 0x30, 0x34, 0x31, 0x30, 0x35, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_510_sig[] = {
	0x90, 0x8c, 0x1e, 0x6d, 0xa6, 0x25, 0x87, 0x9f, 0xc1, 0x16, 0xdd, 0xb6, 0x51, 0x73, 0xb9, 0x35, 0x5f, 0xa8, 0xeb, 0x03, 0x80, 0x63, 0xde, 0x2c, 0xec, 0x19, 0x34, 0xe8, 0xfb, 0x2b, 0xfc, 0x27, 0x6e, 0x08, 0x4f, 0xf7, 0xc0, 0x43, 0xed, 0xfb, 0x16, 0x1a, 0xea, 0x26, 0x05, 0xa1, 0x11, 0xcf, 0x43, 0xd5, 0x83, 0x88, 0xe0, 0x61, 0xe8, 0x01, 0x9e, 0x99, 0x52, 0x63, 0x76, 0xe4, 0xc7, 0x1e, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_510 = {
	.name = "ecdsa_brainpoolp256r1_sha256_510",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_510_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_510_msg,
	.msglen = 9,
	.sig = ecdsa_brainpoolp256r1_sha256_510_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 86 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 511 for ECDSA, tcId is 87 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_511_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_511_msg[] = {
	0x39, 0x37, 0x38, 0x38, 0x34, 0x38, 0x30, 0x33, 0x39, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_511_sig[] = {
	0x97, 0x32, 0x8e, 0x10, 0x50, 0xfc, 0x2d, 0x44, 0xec, 0x89, 0x83, 0x6a, 0x7e, 0xaa, 0xe3, 0x60, 0xd6, 0xf9, 0xd9, 0x96, 0x85, 0x5e, 0x8b, 0x14, 0x4d, 0x0c, 0x27, 0x3c, 0x48, 0x66, 0xd7, 0xfe, 0x39, 0x19, 0xd7, 0xce, 0xd9, 0xf3, 0xe3, 0x28, 0x49, 0x78, 0x54, 0x63, 0x94, 0xfb, 0xb2, 0x77, 0xf8, 0x4d, 0x26, 0x59, 0x8d, 0xbe, 0x83, 0xda, 0x4b, 0xa7, 0xc1, 0xde, 0x37, 0x2b, 0x33, 0x40, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_511 = {
	.name = "ecdsa_brainpoolp256r1_sha256_511",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_511_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_511_msg,
	.msglen = 9,
	.sig = ecdsa_brainpoolp256r1_sha256_511_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 87 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 512 for ECDSA, tcId is 88 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_512_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_512_msg[] = {
	0x33, 0x36, 0x31, 0x30, 0x36, 0x37, 0x32, 0x34, 0x34, 0x32, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_512_sig[] = {
	0x98, 0x81, 0xe8, 0xf7, 0x5d, 0xb8, 0x16, 0x3d, 0x2b, 0xe1, 0xfc, 0x11, 0x49, 0x19, 0x26, 0xc4, 0x12, 0x53, 0x74, 0x44, 0x0d, 0xa9, 0x47, 0x50, 0xa1, 0x9e, 0xca, 0xf8, 0xa8, 0x3b, 0x71, 0xfc, 0x4a, 0x9a, 0x19, 0x1a, 0x9d, 0xa8, 0xfa, 0x3d, 0x56, 0x41, 0xcb, 0xb5, 0xa8, 0x8c, 0xac, 0x5b, 0x37, 0x80, 0xfb, 0xbe, 0xf8, 0xef, 0x1a, 0x44, 0x57, 0x82, 0x39, 0x49, 0x25, 0xef, 0xc5, 0xb1, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_512 = {
	.name = "ecdsa_brainpoolp256r1_sha256_512",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_512_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_512_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_512_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 88 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 513 for ECDSA, tcId is 89 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_513_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_513_msg[] = {
	0x31, 0x30, 0x35, 0x34, 0x32, 0x34, 0x30, 0x37, 0x30, 0x35, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_513_sig[] = {
	0x70, 0xcb, 0x8b, 0xc7, 0xd5, 0xc3, 0x72, 0xc7, 0x3c, 0xf3, 0x6f, 0xe6, 0x9a, 0xa1, 0xa5, 0x09, 0xfe, 0x0c, 0xf2, 0xbe, 0x64, 0x2e, 0x08, 0x5a, 0xc9, 0x79, 0xd6, 0xee, 0xfd, 0xda, 0xa9, 0xe1, 0x50, 0x04, 0x02, 0xf4, 0x96, 0xdc, 0x8d, 0x90, 0x4c, 0x70, 0x96, 0x95, 0xff, 0x02, 0x71, 0x4e, 0x60, 0x7c, 0x4b, 0xee, 0x9d, 0x06, 0x4c, 0xd4, 0x65, 0x4b, 0x6c, 0x46, 0x6f, 0x40, 0x10, 0xe8, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_513 = {
	.name = "ecdsa_brainpoolp256r1_sha256_513",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_513_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_513_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_513_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 89 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 514 for ECDSA, tcId is 90 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_514_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_514_msg[] = {
	0x35, 0x31, 0x37, 0x34, 0x34, 0x34, 0x38, 0x31, 0x39, 0x37, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_514_sig[] = {
	0x39, 0xc8, 0xf8, 0x70, 0x18, 0x5f, 0x87, 0x95, 0x7e, 0x00, 0x9d, 0x01, 0xe5, 0x2f, 0xbf, 0x6c, 0x7a, 0xe5, 0x0d, 0x73, 0x4d, 0x39, 0xec, 0x41, 0x13, 0xb3, 0x7b, 0x7b, 0xd1, 0xb6, 0x80, 0x66, 0x73, 0xd6, 0xda, 0x2b, 0x77, 0x7c, 0xe0, 0xc4, 0x3d, 0x49, 0x08, 0x08, 0x57, 0xc6, 0xec, 0x58, 0x54, 0x6f, 0xdd, 0xf1, 0x7d, 0x26, 0x76, 0xf1, 0x0f, 0x88, 0xdd, 0xc9, 0x00, 0xca, 0x18, 0x91, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_514 = {
	.name = "ecdsa_brainpoolp256r1_sha256_514",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_514_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_514_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_514_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 90 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 515 for ECDSA, tcId is 91 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_515_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_515_msg[] = {
	0x31, 0x39, 0x36, 0x37, 0x35, 0x36, 0x31, 0x32, 0x35, 0x31, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_515_sig[] = {
	0x2e, 0x95, 0xb7, 0x02, 0xed, 0x13, 0x8f, 0x42, 0x61, 0x4f, 0x07, 0xa1, 0xb2, 0x15, 0x48, 0xea, 0x1d, 0x24, 0x7a, 0x4a, 0x7f, 0xd7, 0x65, 0x62, 0x8b, 0xab, 0x68, 0x55, 0x11, 0x29, 0xad, 0x38, 0x2e, 0x9a, 0x6a, 0xf0, 0x78, 0xb5, 0x18, 0x12, 0xed, 0x71, 0xb0, 0xea, 0xb6, 0x53, 0x50, 0xcd, 0x08, 0x1f, 0x79, 0x99, 0xa2, 0x4a, 0x56, 0xe9, 0x6a, 0xf9, 0xd5, 0xc5, 0xf6, 0xbd, 0xaf, 0x0f, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_515 = {
	.name = "ecdsa_brainpoolp256r1_sha256_515",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_515_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_515_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_515_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 91 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 516 for ECDSA, tcId is 92 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_516_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_516_msg[] = {
	0x33, 0x34, 0x34, 0x37, 0x32, 0x35, 0x33, 0x33, 0x34, 0x33, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_516_sig[] = {
	0x58, 0x37, 0xb6, 0x87, 0xf2, 0x12, 0x80, 0x63, 0xdc, 0x67, 0xf5, 0x12, 0xcb, 0x66, 0x70, 0xf1, 0x22, 0xb6, 0x11, 0x25, 0x7f, 0x53, 0x6d, 0x45, 0xe3, 0x98, 0x4f, 0x5e, 0xbb, 0xc3, 0xcd, 0x4d, 0x6a, 0x6c, 0x0c, 0x41, 0xb9, 0xcc, 0x37, 0xae, 0x02, 0xc2, 0x21, 0x8d, 0x3b, 0x8c, 0xd8, 0x0c, 0xd3, 0xc4, 0xfc, 0x25, 0x77, 0x1c, 0x0c, 0xaa, 0xb3, 0xb8, 0xed, 0x2c, 0x61, 0x1c, 0xf7, 0xcb, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_516 = {
	.name = "ecdsa_brainpoolp256r1_sha256_516",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_516_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_516_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_516_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 92 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 517 for ECDSA, tcId is 93 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_517_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_517_msg[] = {
	0x33, 0x36, 0x38, 0x32, 0x36, 0x34, 0x33, 0x31, 0x38, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_517_sig[] = {
	0x5a, 0x73, 0xc7, 0x5d, 0x2b, 0x5c, 0x48, 0xaf, 0x17, 0xb7, 0x84, 0x72, 0x44, 0x26, 0x2b, 0xb9, 0xb2, 0xc3, 0xf2, 0x69, 0x7a, 0x9d, 0x8c, 0x60, 0x57, 0x58, 0xa2, 0xd3, 0x3c, 0xcc, 0xd1, 0x8f, 0x97, 0xf1, 0x2a, 0xa0, 0x4b, 0x25, 0x82, 0x37, 0x3f, 0x9b, 0xea, 0x64, 0x6b, 0xce, 0x1b, 0x12, 0x90, 0x30, 0xea, 0x5f, 0x35, 0xc9, 0xdc, 0x2a, 0x14, 0x9e, 0x90, 0xaa, 0x3b, 0x56, 0x34, 0x5c, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_517 = {
	.name = "ecdsa_brainpoolp256r1_sha256_517",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_517_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_517_msg,
	.msglen = 9,
	.sig = ecdsa_brainpoolp256r1_sha256_517_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 93 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 518 for ECDSA, tcId is 94 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_518_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_518_msg[] = {
	0x33, 0x32, 0x36, 0x31, 0x31, 0x39, 0x38, 0x36, 0x30, 0x38, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_518_sig[] = {
	0x32, 0xb6, 0x03, 0x13, 0x2a, 0x96, 0xc5, 0xb9, 0x57, 0xb0, 0x8c, 0x88, 0x53, 0x2e, 0x49, 0xfc, 0xb7, 0x3c, 0xd7, 0xc5, 0xf7, 0x1a, 0x1e, 0x6e, 0xd1, 0x4a, 0x5c, 0xc1, 0x77, 0x6d, 0x2d, 0xa7, 0x93, 0xbe, 0x0e, 0x4c, 0x98, 0x44, 0xbe, 0xc9, 0xd2, 0xb6, 0x2b, 0x42, 0x4e, 0x61, 0x8a, 0x84, 0x5a, 0x98, 0x53, 0x7b, 0x23, 0x56, 0xc1, 0xf4, 0x73, 0xbb, 0xa1, 0x3b, 0x08, 0x45, 0x8e, 0xea, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_518 = {
	.name = "ecdsa_brainpoolp256r1_sha256_518",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_518_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_518_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_518_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 94 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 519 for ECDSA, tcId is 95 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_519_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_519_msg[] = {
	0x39, 0x36, 0x37, 0x38, 0x37, 0x38, 0x31, 0x30, 0x39, 0x34, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_519_sig[] = {
	0x9b, 0x76, 0xb7, 0xaa, 0xc0, 0xa1, 0x3b, 0xf2, 0x17, 0xf2, 0x4d, 0x33, 0x5b, 0xc0, 0x46, 0x94, 0xec, 0xdb, 0xd5, 0xac, 0xfe, 0x4e, 0xc2, 0x3c, 0x06, 0x5e, 0xfe, 0xb7, 0x93, 0x6a, 0x1c, 0x62, 0x43, 0x2c, 0xde, 0x74, 0xfd, 0xbb, 0x4f, 0x54, 0x37, 0xcd, 0xec, 0xa5, 0x3c, 0xb7, 0xab, 0x79, 0xf6, 0x92, 0x69, 0x4f, 0x91, 0xed, 0x37, 0x35, 0xfb, 0xc4, 0xe0, 0x8a, 0x3f, 0x52, 0x78, 0x81, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_519 = {
	.name = "ecdsa_brainpoolp256r1_sha256_519",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_519_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_519_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_519_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 95 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 520 for ECDSA, tcId is 96 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_520_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_520_msg[] = {
	0x34, 0x39, 0x35, 0x38, 0x38, 0x32, 0x33, 0x38, 0x32, 0x33, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_520_sig[] = {
	0x8f, 0x25, 0x65, 0xb5, 0x17, 0xf6, 0x2a, 0x3b, 0x1e, 0x19, 0xb0, 0x91, 0x7a, 0xb2, 0xb2, 0x23, 0xfc, 0x81, 0x93, 0xcc, 0x0f, 0xdf, 0x3a, 0xb9, 0x69, 0x2b, 0xc4, 0x2c, 0xf4, 0x09, 0x10, 0xe8, 0x1d, 0xcc, 0xfb, 0xed, 0x8b, 0x90, 0xee, 0x53, 0x91, 0xea, 0x74, 0x3e, 0x35, 0xb6, 0x0e, 0xd3, 0x1d, 0x19, 0xed, 0xfb, 0xd9, 0x45, 0x04, 0xba, 0xdc, 0xa4, 0xaa, 0x4c, 0xf2, 0xa7, 0xbb, 0x31, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_520 = {
	.name = "ecdsa_brainpoolp256r1_sha256_520",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_520_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_520_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_520_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 96 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 521 for ECDSA, tcId is 97 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_521_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_521_msg[] = {
	0x38, 0x32, 0x34, 0x36, 0x33, 0x37, 0x38, 0x33, 0x37, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_521_sig[] = {
	0x31, 0xc6, 0x27, 0xfd, 0x79, 0x1f, 0x73, 0x44, 0x21, 0xe5, 0x50, 0x26, 0x18, 0xae, 0xc4, 0x47, 0xc6, 0x70, 0x29, 0xb2, 0x79, 0x4e, 0xe1, 0x2b, 0x08, 0xee, 0xb6, 0xc5, 0x9a, 0xed, 0xb3, 0xee, 0x08, 0xf9, 0x1f, 0x37, 0x89, 0xbd, 0x01, 0xe5, 0xb9, 0xd9, 0x39, 0x41, 0xcf, 0x46, 0x69, 0x8d, 0x5e, 0x1a, 0x27, 0x08, 0xe7, 0x0e, 0xe9, 0xa2, 0x26, 0xe8, 0x1e, 0x7f, 0x4a, 0x41, 0x4e, 0x9e, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_521 = {
	.name = "ecdsa_brainpoolp256r1_sha256_521",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_521_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_521_msg,
	.msglen = 9,
	.sig = ecdsa_brainpoolp256r1_sha256_521_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 97 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 522 for ECDSA, tcId is 98 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_522_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_522_msg[] = {
	0x31, 0x31, 0x30, 0x32, 0x30, 0x38, 0x33, 0x33, 0x37, 0x37, 0x36, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_522_sig[] = {
	0x60, 0x05, 0x29, 0x31, 0x32, 0xd7, 0xea, 0xc0, 0xe7, 0x2b, 0x9b, 0x21, 0x8d, 0x03, 0x21, 0x26, 0x75, 0xd5, 0xaa, 0xe0, 0xda, 0x97, 0xbc, 0xcd, 0xf1, 0xa5, 0xff, 0x78, 0x4d, 0xe5, 0xcd, 0xe6, 0x13, 0xa1, 0x55, 0xc7, 0x4a, 0x9a, 0xb2, 0x7c, 0xbd, 0xf6, 0xca, 0xe1, 0x8d, 0x4d, 0x1f, 0x18, 0xb8, 0x21, 0x2d, 0x80, 0x18, 0x55, 0x1e, 0x2b, 0xae, 0xc9, 0x19, 0x79, 0xea, 0x5b, 0x4c, 0x49, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_522 = {
	.name = "ecdsa_brainpoolp256r1_sha256_522",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_522_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_522_msg,
	.msglen = 11,
	.sig = ecdsa_brainpoolp256r1_sha256_522_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 98 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 523 for ECDSA, tcId is 99 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_523_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_523_msg[] = {
	0x31, 0x33, 0x33, 0x38, 0x37, 0x31, 0x36, 0x34, 0x38, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_523_sig[] = {
	0x3a, 0x6d, 0xab, 0x51, 0xed, 0x90, 0x27, 0xf5, 0xca, 0xe1, 0x92, 0xe0, 0x58, 0x6a, 0x32, 0xc8, 0xef, 0x22, 0x76, 0xce, 0xba, 0x3b, 0x79, 0x60, 0x59, 0xdc, 0xa1, 0x35, 0xe3, 0x61, 0x79, 0x5d, 0x4b, 0xf1, 0x6b, 0x0e, 0x62, 0xe3, 0x2a, 0x94, 0x50, 0x88, 0xf5, 0x5f, 0xb4, 0x28, 0x15, 0x9a, 0xf7, 0x82, 0x96, 0xdd, 0x4f, 0x8d, 0xfd, 0x97, 0x13, 0xbd, 0xb2, 0xf6, 0x77, 0xcb, 0xcd, 0x12, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_523 = {
	.name = "ecdsa_brainpoolp256r1_sha256_523",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_523_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_523_msg,
	.msglen = 9,
	.sig = ecdsa_brainpoolp256r1_sha256_523_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 99 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 524 for ECDSA, tcId is 100 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_524_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_524_msg[] = {
	0x33, 0x32, 0x32, 0x31, 0x34, 0x34, 0x31, 0x36, 0x32, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_524_sig[] = {
	0x96, 0x1d, 0xe7, 0x7e, 0xd9, 0xcf, 0x61, 0x70, 0xd9, 0x25, 0xc2, 0x33, 0xbd, 0x3e, 0x20, 0xee, 0xf9, 0xbb, 0xe6, 0xd6, 0xc8, 0xda, 0xc2, 0x8a, 0xcd, 0xe4, 0x60, 0x11, 0xf9, 0x9f, 0x8b, 0xff, 0x97, 0x7d, 0xe0, 0x47, 0x79, 0xff, 0xe3, 0xaf, 0xe7, 0x08, 0xd8, 0x1c, 0xe8, 0xa1, 0xed, 0x6c, 0x7d, 0x2a, 0x9a, 0x25, 0xef, 0x99, 0x59, 0xc7, 0xa9, 0x51, 0xa0, 0x55, 0x5a, 0x6d, 0x37, 0x92, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_524 = {
	.name = "ecdsa_brainpoolp256r1_sha256_524",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_524_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_524_msg,
	.msglen = 9,
	.sig = ecdsa_brainpoolp256r1_sha256_524_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 100 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 525 for ECDSA, tcId is 101 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_525_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_525_msg[] = {
	0x31, 0x30, 0x36, 0x38, 0x36, 0x36, 0x35, 0x35, 0x35, 0x34, 0x36, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_525_sig[] = {
	0x77, 0x85, 0x81, 0xb3, 0xd4, 0x03, 0x00, 0x31, 0x14, 0x1e, 0x55, 0x5f, 0xa1, 0xdb, 0xeb, 0xae, 0xf0, 0xee, 0xd0, 0x19, 0xe0, 0xb8, 0x97, 0xb5, 0x07, 0x65, 0x44, 0xab, 0x80, 0x49, 0x8b, 0x9c, 0x71, 0x32, 0xc8, 0xd1, 0x09, 0xc1, 0xf1, 0xa6, 0xc1, 0x0f, 0x81, 0xe9, 0xfc, 0x11, 0xad, 0xea, 0x4b, 0x9c, 0xff, 0x59, 0x92, 0x08, 0xb6, 0xd9, 0xcb, 0x4e, 0x4b, 0x27, 0xf1, 0x97, 0x28, 0x46, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_525 = {
	.name = "ecdsa_brainpoolp256r1_sha256_525",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_525_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_525_msg,
	.msglen = 11,
	.sig = ecdsa_brainpoolp256r1_sha256_525_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 101 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 526 for ECDSA, tcId is 102 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_526_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_526_msg[] = {
	0x36, 0x32, 0x31, 0x35, 0x35, 0x32, 0x34, 0x36, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_526_sig[] = {
	0x9e, 0xea, 0xc8, 0xf0, 0x7c, 0x40, 0xcc, 0x8e, 0xe3, 0xcb, 0xa1, 0x07, 0xaf, 0x49, 0xd5, 0x26, 0x73, 0x1d, 0x8b, 0x7c, 0x70, 0x13, 0x0c, 0xbb, 0x6e, 0xfa, 0x3c, 0x61, 0x50, 0x5d, 0x63, 0x37, 0x62, 0xdb, 0x38, 0x22, 0x6b, 0x71, 0xf6, 0x4a, 0x5b, 0x59, 0x8a, 0xb7, 0xc4, 0xe3, 0xf8, 0x98, 0x80, 0xfe, 0x0d, 0x07, 0x49, 0xdf, 0xd5, 0xc7, 0xa3, 0x8a, 0x3e, 0xec, 0x3c, 0x79, 0x38, 0x76, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_526 = {
	.name = "ecdsa_brainpoolp256r1_sha256_526",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_526_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_526_msg,
	.msglen = 8,
	.sig = ecdsa_brainpoolp256r1_sha256_526_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 102 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 527 for ECDSA, tcId is 103 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_527_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_527_msg[] = {
	0x37, 0x30, 0x33, 0x30, 0x38, 0x31, 0x38, 0x37, 0x37, 0x34, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_527_sig[] = {
	0x67, 0x3d, 0x41, 0xc1, 0x7e, 0x72, 0x7f, 0x01, 0x25, 0x17, 0x5b, 0x2a, 0x9f, 0x05, 0x61, 0xec, 0xc5, 0xcf, 0x9c, 0xd4, 0x90, 0x35, 0x82, 0x8b, 0xa7, 0xc4, 0x75, 0x45, 0xa0, 0xb3, 0x38, 0xf4, 0x00, 0x45, 0x9e, 0xf9, 0x78, 0xe7, 0xb0, 0x34, 0x68, 0xc8, 0x0f, 0xd4, 0x53, 0x3a, 0x33, 0x47, 0x55, 0xa0, 0x82, 0x6b, 0xf5, 0xa3, 0x0d, 0xf9, 0x19, 0x12, 0x9e, 0x35, 0x2d, 0x34, 0x75, 0x62, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_527 = {
	.name = "ecdsa_brainpoolp256r1_sha256_527",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_527_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_527_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_527_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 103 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 528 for ECDSA, tcId is 104 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_528_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_528_msg[] = {
	0x35, 0x39, 0x32, 0x34, 0x35, 0x32, 0x33, 0x37, 0x34, 0x34, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_528_sig[] = {
	0x8a, 0x97, 0xf1, 0x9b, 0x08, 0x09, 0x04, 0x2c, 0xda, 0xfe, 0x9c, 0x32, 0xbc, 0x0b, 0x0b, 0x01, 0x21, 0x8a, 0x49, 0x86, 0x7a, 0x68, 0x82, 0xd6, 0x4d, 0x5b, 0x7b, 0xc2, 0x55, 0xeb, 0x77, 0x3d, 0x90, 0x46, 0x62, 0xb5, 0xdf, 0xd8, 0xcd, 0x94, 0xea, 0xef, 0xd5, 0x7e, 0x5d, 0x4f, 0x2d, 0x14, 0x26, 0x8e, 0x1b, 0x8c, 0x4f, 0xbd, 0x4a, 0xc4, 0xe5, 0x08, 0x0f, 0x79, 0xd5, 0x3f, 0xd2, 0x4c, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_528 = {
	.name = "ecdsa_brainpoolp256r1_sha256_528",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_528_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_528_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_528_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 104 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 529 for ECDSA, tcId is 105 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_529_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_529_msg[] = {
	0x31, 0x34, 0x39, 0x35, 0x35, 0x38, 0x36, 0x36, 0x32, 0x31, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_529_sig[] = {
	0x28, 0x7a, 0x88, 0xbd, 0xb5, 0x61, 0xfa, 0x27, 0x85, 0xca, 0x25, 0x86, 0x63, 0xf8, 0x6d, 0x3b, 0x07, 0xaa, 0xc9, 0x49, 0xf6, 0x47, 0xee, 0x57, 0x26, 0x21, 0xb0, 0xb7, 0x0e, 0xb3, 0xe9, 0xca, 0x4a, 0x6d, 0x79, 0x16, 0x41, 0x84, 0x43, 0xde, 0xb4, 0xc4, 0x3f, 0x5c, 0x69, 0xf6, 0x49, 0x09, 0x52, 0xcf, 0x53, 0xee, 0x69, 0xee, 0xc1, 0xac, 0x69, 0xe1, 0x44, 0xb8, 0xf9, 0xe2, 0x63, 0x07, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_529 = {
	.name = "ecdsa_brainpoolp256r1_sha256_529",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_529_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_529_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_529_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 105 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 530 for ECDSA, tcId is 106 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_530_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_530_msg[] = {
	0x34, 0x30, 0x30, 0x35, 0x33, 0x31, 0x34, 0x34, 0x30, 0x36, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_530_sig[] = {
	0x25, 0x0d, 0xb6, 0xa8, 0xb3, 0x81, 0x3b, 0x13, 0xb6, 0xfb, 0x7b, 0xf1, 0x98, 0x96, 0xf1, 0x3a, 0x50, 0x2b, 0xe4, 0x53, 0xc2, 0x04, 0xe6, 0xa8, 0x13, 0xa1, 0x64, 0xdb, 0xdd, 0x9c, 0x66, 0xca, 0x1d, 0x96, 0x68, 0x3a, 0xc9, 0x7f, 0x58, 0x74, 0xac, 0x95, 0x38, 0xb5, 0x7b, 0xf1, 0xea, 0xa5, 0x0a, 0x11, 0xa3, 0x3e, 0x9a, 0xbb, 0x82, 0x5d, 0x6b, 0x7a, 0x75, 0x46, 0xa6, 0x98, 0x60, 0x6e, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_530 = {
	.name = "ecdsa_brainpoolp256r1_sha256_530",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_530_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_530_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_530_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 106 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 531 for ECDSA, tcId is 107 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_531_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_531_msg[] = {
	0x33, 0x30, 0x39, 0x36, 0x34, 0x35, 0x37, 0x35, 0x31, 0x32, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_531_sig[] = {
	0xa2, 0x9b, 0x2c, 0x4b, 0xe5, 0x0f, 0x17, 0x24, 0xa1, 0xce, 0x9a, 0xcd, 0x4c, 0x51, 0x29, 0xb3, 0x91, 0xb4, 0xb9, 0x00, 0x9a, 0xbb, 0x58, 0x23, 0x97, 0xa5, 0x22, 0xc7, 0x71, 0xd5, 0x4a, 0xbd, 0x0e, 0xc1, 0xd7, 0xae, 0xdb, 0xfe, 0x4e, 0x74, 0x3d, 0x76, 0x27, 0xea, 0x8d, 0x20, 0x7c, 0x24, 0x60, 0xae, 0x4c, 0x9f, 0x21, 0x34, 0xb0, 0xf8, 0x4a, 0x02, 0x55, 0x20, 0x5a, 0xc2, 0x34, 0x82, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_531 = {
	.name = "ecdsa_brainpoolp256r1_sha256_531",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_531_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_531_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_531_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 107 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 532 for ECDSA, tcId is 108 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_532_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_532_msg[] = {
	0x32, 0x37, 0x38, 0x34, 0x30, 0x32, 0x35, 0x36, 0x32, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_532_sig[] = {
	0x14, 0x9f, 0x05, 0x08, 0xae, 0xf9, 0xfb, 0xcc, 0xf3, 0x2e, 0x1b, 0xd3, 0x19, 0x9d, 0x63, 0x02, 0x40, 0xbb, 0x65, 0x77, 0x59, 0x3e, 0x87, 0x56, 0x6b, 0x0a, 0x14, 0xa5, 0xb6, 0xf2, 0x09, 0x99, 0x5d, 0x37, 0xb4, 0x09, 0xc0, 0x1f, 0xb9, 0xb6, 0xcf, 0x4e, 0xa1, 0x44, 0x32, 0xc3, 0x56, 0x31, 0x69, 0x44, 0x02, 0xd2, 0x87, 0x5a, 0x30, 0x1d, 0x76, 0x1d, 0x81, 0x81, 0x14, 0x69, 0x62, 0x8d, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_532 = {
	.name = "ecdsa_brainpoolp256r1_sha256_532",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_532_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_532_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_532_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 108 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 533 for ECDSA, tcId is 109 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_533_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_533_msg[] = {
	0x32, 0x36, 0x31, 0x38, 0x37, 0x38, 0x37, 0x34, 0x31, 0x38, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_533_sig[] = {
	0x6c, 0x9b, 0x11, 0x0d, 0x8e, 0x44, 0x53, 0xd8, 0x2e, 0xc5, 0x1a, 0x5a, 0x69, 0x1b, 0x15, 0x2e, 0xdf, 0x9f, 0xb1, 0xa9, 0x94, 0x7b, 0xd0, 0x01, 0xbe, 0xb2, 0x4d, 0x56, 0xf3, 0xbf, 0x27, 0xaf, 0x2a, 0x80, 0xbb, 0xd2, 0xf8, 0x27, 0xcc, 0x23, 0x15, 0x75, 0x26, 0xdf, 0x6e, 0xa4, 0xe0, 0xe3, 0x24, 0xb7, 0x65, 0xa5, 0x0b, 0xe7, 0x7f, 0x7e, 0x96, 0x67, 0x55, 0x8a, 0x16, 0x5e, 0xb6, 0x92, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_533 = {
	.name = "ecdsa_brainpoolp256r1_sha256_533",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_533_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_533_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_533_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 109 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 534 for ECDSA, tcId is 110 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_534_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_534_msg[] = {
	0x31, 0x36, 0x34, 0x32, 0x36, 0x32, 0x35, 0x32, 0x36, 0x32, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_534_sig[] = {
	0x90, 0x86, 0xa5, 0xc9, 0x38, 0x23, 0xb1, 0xdf, 0x21, 0xf6, 0x39, 0x51, 0xed, 0x6e, 0x70, 0x7f, 0xba, 0x0d, 0x89, 0x9e, 0xef, 0x71, 0x11, 0x00, 0xe3, 0x2f, 0x2d, 0x60, 0x17, 0xda, 0x65, 0x90, 0x1f, 0x83, 0x1e, 0xd3, 0x0c, 0x12, 0x9d, 0xab, 0x42, 0x66, 0x27, 0x2e, 0x01, 0x28, 0x32, 0x10, 0xed, 0x82, 0x3c, 0x55, 0x90, 0x7a, 0xc5, 0xec, 0xda, 0x85, 0xd7, 0x0b, 0xd8, 0x02, 0x79, 0xc3, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_534 = {
	.name = "ecdsa_brainpoolp256r1_sha256_534",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_534_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_534_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_534_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 110 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 535 for ECDSA, tcId is 111 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_535_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_535_msg[] = {
	0x36, 0x38, 0x32, 0x34, 0x31, 0x38, 0x39, 0x34, 0x33, 0x36, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_535_sig[] = {
	0x2a, 0xf6, 0x35, 0x47, 0xdc, 0x5f, 0xfc, 0x8b, 0xa4, 0xd1, 0x68, 0xd3, 0x68, 0xd9, 0x22, 0x81, 0x32, 0xa0, 0xef, 0xa2, 0x0e, 0x32, 0x55, 0xc3, 0x32, 0x21, 0x9f, 0xec, 0xed, 0x80, 0x03, 0x95, 0x36, 0x42, 0xf5, 0x3c, 0xe9, 0x52, 0x1f, 0xab, 0x75, 0x4b, 0xe7, 0x71, 0x1f, 0x00, 0xaf, 0x78, 0x88, 0x22, 0x2b, 0xf2, 0xbb, 0xf1, 0xed, 0x89, 0x95, 0xe0, 0x3b, 0x55, 0xc9, 0x8a, 0x60, 0x22, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_535 = {
	.name = "ecdsa_brainpoolp256r1_sha256_535",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_535_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_535_msg,
	.msglen = 10,
	.sig = ecdsa_brainpoolp256r1_sha256_535_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 111 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 536 for ECDSA, tcId is 112 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_536_pubkey[] = {
	0x01, 0x9a, 0x2d, 0x96, 0x37, 0x74, 0x3a, 0x63, 0xdd, 0xae, 0xfd, 0xbc, 0xa0, 0xee, 0x22, 0x9a, 0x16, 0x3b, 0x80, 0x9b, 0x9b, 0x14, 0x5e, 0x53, 0x13, 0xbb, 0xeb, 0x8d, 0xef, 0xea, 0xb9, 0xd6, 0x54, 0x8c, 0xaf, 0x89, 0xbf, 0x5b, 0xa4, 0x94, 0x99, 0x40, 0x41, 0x45, 0x65, 0x12, 0x34, 0x33, 0x64, 0x01, 0xb9, 0xb2, 0x84, 0x3a, 0x57, 0x9e, 0xd1, 0x52, 0xe0, 0x90, 0xf1, 0x1b, 0x9e, 0x59, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_536_msg[] = {
	0x34, 0x38, 0x34, 0x32, 0x34, 0x35, 0x34, 0x32, 0x35, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_536_sig[] = {
	0x91, 0xe9, 0xac, 0xef, 0x9b, 0xc2, 0x8c, 0x91, 0x08, 0x91, 0xb8, 0x03, 0x20, 0xaf, 0x36, 0x03, 0xc4, 0x30, 0x61, 0x74, 0xf1, 0x7e, 0x97, 0x05, 0x92, 0x67, 0xfc, 0x81, 0x78, 0x14, 0xff, 0x1f, 0x7a, 0x9c, 0x83, 0x3b, 0xeb, 0x73, 0xbd, 0xd6, 0x2d, 0xf6, 0x49, 0x52, 0xb4, 0xc8, 0x48, 0xd2, 0x18, 0x0f, 0xae, 0x38, 0x5f, 0x80, 0x84, 0xf1, 0xfc, 0x5b, 0x1b, 0x1c, 0x64, 0x57, 0x50, 0x07, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_536 = {
	.name = "ecdsa_brainpoolp256r1_sha256_536",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_536_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_536_msg,
	.msglen = 9,
	.sig = ecdsa_brainpoolp256r1_sha256_536_sig,
	.siglen = 64,
	.result = 1,
	.comment = "special case hash, tcId is 112 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 537 for ECDSA, tcId is 113 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_537_pubkey[] = {
	0x4b, 0x40, 0x2a, 0x9a, 0xe1, 0x8f, 0xc1, 0xa8, 0x7c, 0xda, 0x33, 0x74, 0x83, 0x90, 0x04, 0x99, 0xfe, 0x72, 0x9e, 0x47, 0x16, 0x07, 0x67, 0x16, 0x51, 0xa2, 0x63, 0xfb, 0xf0, 0xd9, 0x3f, 0x78, 0x1e, 0xf9, 0xb0, 0xf9, 0x8f, 0xb7, 0x3b, 0xcb, 0x60, 0x5a, 0x78, 0x23, 0xa4, 0x27, 0xea, 0x5f, 0x0d, 0x98, 0x78, 0x8c, 0x7d, 0xae, 0x42, 0xa0, 0x45, 0x36, 0x20, 0x20, 0x22, 0xc0, 0x21, 0xcd, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_537_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_537_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe2, 0x02, 0x7b, 0x80, 0x1f, 0xc4, 0x79, 0x30, 0x8f, 0xf5, 0x39, 0x9a, 0x88, 0x25, 0xfc, 0xcf, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa4, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_537 = {
	.name = "ecdsa_brainpoolp256r1_sha256_537",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_537_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_537_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_537_sig,
	.siglen = 64,
	.result = 1,
	.comment = "k*G has a large x-coordinate, tcId is 113 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 538 for ECDSA, tcId is 114 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_538_pubkey[] = {
	0x4b, 0x40, 0x2a, 0x9a, 0xe1, 0x8f, 0xc1, 0xa8, 0x7c, 0xda, 0x33, 0x74, 0x83, 0x90, 0x04, 0x99, 0xfe, 0x72, 0x9e, 0x47, 0x16, 0x07, 0x67, 0x16, 0x51, 0xa2, 0x63, 0xfb, 0xf0, 0xd9, 0x3f, 0x78, 0x1e, 0xf9, 0xb0, 0xf9, 0x8f, 0xb7, 0x3b, 0xcb, 0x60, 0x5a, 0x78, 0x23, 0xa4, 0x27, 0xea, 0x5f, 0x0d, 0x98, 0x78, 0x8c, 0x7d, 0xae, 0x42, 0xa0, 0x45, 0x36, 0x20, 0x20, 0x22, 0xc0, 0x21, 0xcd, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_538_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_538_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23, 0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e, 0x53, 0x76, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa4, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_538 = {
	.name = "ecdsa_brainpoolp256r1_sha256_538",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_538_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_538_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_538_sig,
	.siglen = 64,
	.result = -1,
	.comment = "r too large, tcId is 114 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 539 for ECDSA, tcId is 115 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_539_pubkey[] = {
	0x40, 0xa2, 0xdf, 0x0f, 0x17, 0xc7, 0x87, 0x34, 0x59, 0xd5, 0xe9, 0xac, 0x11, 0xff, 0xf8, 0x4d, 0xeb, 0x5f, 0x40, 0xff, 0x9a, 0x52, 0xdf, 0x87, 0x45, 0xbb, 0x47, 0x70, 0xf6, 0xdb, 0xf5, 0x81, 0x99, 0xc2, 0xbf, 0x49, 0x20, 0xe9, 0xc8, 0xf7, 0x58, 0xc2, 0xde, 0x69, 0xe4, 0x2c, 0x1c, 0xb7, 0x7c, 0x58, 0x42, 0x5a, 0x9d, 0xaf, 0xa4, 0x1d, 0x7b, 0x08, 0x73, 0xef, 0xa8, 0x94, 0xce, 0xdc, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_539_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_539_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa3, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa2, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_539 = {
	.name = "ecdsa_brainpoolp256r1_sha256_539",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_539_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_539_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_539_sig,
	.siglen = 64,
	.result = 1,
	.comment = "r,s are large, tcId is 115 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 540 for ECDSA, tcId is 116 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_540_pubkey[] = {
	0x9d, 0xe6, 0x69, 0xf9, 0x44, 0x4d, 0xa8, 0x2e, 0x42, 0x9f, 0x84, 0x2f, 0x31, 0xc6, 0x44, 0x18, 0xd4, 0xd7, 0xb0, 0x5e, 0x93, 0xf4, 0x1d, 0xad, 0xdd, 0x09, 0xfc, 0x18, 0x1a, 0xc2, 0x27, 0xc6, 0x1c, 0x86, 0x21, 0x0e, 0x82, 0x91, 0xfc, 0x5a, 0xe3, 0x0c, 0x72, 0xe2, 0x01, 0x3e, 0xc2, 0x2b, 0xb9, 0x7d, 0x88, 0xbf, 0x37, 0x6d, 0x4a, 0x85, 0xdd, 0x1b, 0xb7, 0x1b, 0x22, 0x52, 0x6d, 0x1f, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_540_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_540_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4a, 0xb8, 0xde, 0x0a, 0x51, 0x48, 0x1b, 0xc4, 0x57, 0x94, 0xb9, 0x24, 0x51, 0x8f, 0x2d, 0xd6, 0xac, 0x5c, 0xce, 0x31, 0xf3, 0x22, 0x8d, 0x62, 0x4c, 0x5a, 0x89, 0x6f, 0x79, 0xa2, 0xd6, 0xa2, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_540 = {
	.name = "ecdsa_brainpoolp256r1_sha256_540",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_540_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_540_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_540_sig,
	.siglen = 64,
	.result = 1,
	.comment = "r and s^-1 have a large Hamming weight, tcId is 116 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 541 for ECDSA, tcId is 117 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_541_pubkey[] = {
	0x30, 0x34, 0x5b, 0x64, 0x51, 0x37, 0x7b, 0x78, 0xa5, 0x4a, 0xc6, 0xe1, 0x10, 0xf5, 0x0c, 0x7d, 0xe7, 0x1c, 0x2c, 0x76, 0x02, 0x78, 0x37, 0x36, 0x07, 0x72, 0x2c, 0x53, 0xf5, 0x86, 0x79, 0x07, 0x59, 0xac, 0xc4, 0x00, 0x14, 0xc9, 0x3d, 0x4a, 0xd4, 0x47, 0x78, 0xbc, 0x1a, 0x44, 0xeb, 0xae, 0xbe, 0x1a, 0x97, 0xc8, 0x8a, 0xd1, 0x1c, 0x10, 0x25, 0x05, 0x7b, 0x6b, 0xc4, 0x37, 0x7f, 0x2d, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_541_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_541_sig[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8b, 0x1b, 0x5f, 0x89, 0xf5, 0xbb, 0x74, 0xca, 0xa4, 0x2d, 0x36, 0xe6, 0x01, 0xa9, 0xf3, 0xc2, 0x0b, 0x4e, 0x6c, 0x91, 0xce, 0xb9, 0x8a, 0x52, 0xfb, 0xfa, 0x9f, 0x81, 0x78, 0x1b, 0x8a, 0x17, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_541 = {
	.name = "ecdsa_brainpoolp256r1_sha256_541",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_541_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_541_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_541_sig,
	.siglen = 64,
	.result = 1,
	.comment = "r and s^-1 have a large Hamming weight, tcId is 117 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 542 for ECDSA, tcId is 118 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_542_pubkey[] = {
	0x14, 0x9d, 0x89, 0x3f, 0x13, 0x06, 0xfb, 0x25, 0x3b, 0xbf, 0x3a, 0x86, 0x91, 0xab, 0xa8, 0xa5, 0x00, 0x02, 0xb0, 0xa2, 0x76, 0x93, 0xaa, 0x97, 0x43, 0x5a, 0x7b, 0x5c, 0xb3, 0x3a, 0x55, 0xee, 0x24, 0xb0, 0x75, 0xfc, 0xdb, 0xc1, 0xa7, 0x39, 0xf2, 0xf4, 0x92, 0xdb, 0xe4, 0x79, 0x94, 0x74, 0xee, 0x3a, 0xd3, 0x80, 0x44, 0x47, 0xe7, 0xd5, 0x84, 0xe3, 0x43, 0x0c, 0xe1, 0x5a, 0x96, 0x8a, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_542_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_542_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_542 = {
	.name = "ecdsa_brainpoolp256r1_sha256_542",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_542_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_542_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_542_sig,
	.siglen = 64,
	.result = 1,
	.comment = "small r and s, tcId is 118 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 543 for ECDSA, tcId is 119 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_543_pubkey[] = {
	0x14, 0x9d, 0x89, 0x3f, 0x13, 0x06, 0xfb, 0x25, 0x3b, 0xbf, 0x3a, 0x86, 0x91, 0xab, 0xa8, 0xa5, 0x00, 0x02, 0xb0, 0xa2, 0x76, 0x93, 0xaa, 0x97, 0x43, 0x5a, 0x7b, 0x5c, 0xb3, 0x3a, 0x55, 0xee, 0x24, 0xb0, 0x75, 0xfc, 0xdb, 0xc1, 0xa7, 0x39, 0xf2, 0xf4, 0x92, 0xdb, 0xe4, 0x79, 0x94, 0x74, 0xee, 0x3a, 0xd3, 0x80, 0x44, 0x47, 0xe7, 0xd5, 0x84, 0xe3, 0x43, 0x0c, 0xe1, 0x5a, 0x96, 0x8a, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_543_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_543_sig[] = {
	0x01, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_543 = {
	.name = "ecdsa_brainpoolp256r1_sha256_543",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_543_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_543_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_543_sig,
	.siglen = 2,
	.result = 0,
	.comment = "incorrect size of signature, tcId is 119 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 544 for ECDSA, tcId is 120 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_544_pubkey[] = {
	0x15, 0x6e, 0x62, 0x66, 0x49, 0xce, 0x82, 0x36, 0x98, 0x22, 0x01, 0xa2, 0x49, 0x35, 0xfb, 0x3d, 0x36, 0xb0, 0xd7, 0x30, 0x41, 0xb6, 0xfd, 0xca, 0x97, 0x99, 0x0a, 0x8d, 0x15, 0x2e, 0xfb, 0x8b, 0x32, 0x6f, 0x4b, 0x20, 0xa0, 0xcc, 0x46, 0x23, 0xb0, 0x2a, 0x6b, 0xb1, 0x71, 0x14, 0x90, 0x1a, 0x01, 0xde, 0x0d, 0xf1, 0x71, 0x6d, 0x66, 0x9d, 0x25, 0x3d, 0xe4, 0x40, 0xcc, 0x8f, 0x9c, 0xdd, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_544_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_544_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_544 = {
	.name = "ecdsa_brainpoolp256r1_sha256_544",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_544_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_544_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_544_sig,
	.siglen = 64,
	.result = 1,
	.comment = "small r and s, tcId is 120 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 545 for ECDSA, tcId is 121 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_545_pubkey[] = {
	0x15, 0x6e, 0x62, 0x66, 0x49, 0xce, 0x82, 0x36, 0x98, 0x22, 0x01, 0xa2, 0x49, 0x35, 0xfb, 0x3d, 0x36, 0xb0, 0xd7, 0x30, 0x41, 0xb6, 0xfd, 0xca, 0x97, 0x99, 0x0a, 0x8d, 0x15, 0x2e, 0xfb, 0x8b, 0x32, 0x6f, 0x4b, 0x20, 0xa0, 0xcc, 0x46, 0x23, 0xb0, 0x2a, 0x6b, 0xb1, 0x71, 0x14, 0x90, 0x1a, 0x01, 0xde, 0x0d, 0xf1, 0x71, 0x6d, 0x66, 0x9d, 0x25, 0x3d, 0xe4, 0x40, 0xcc, 0x8f, 0x9c, 0xdd, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_545_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_545_sig[] = {
	0x01, 0x02, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_545 = {
	.name = "ecdsa_brainpoolp256r1_sha256_545",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_545_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_545_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_545_sig,
	.siglen = 2,
	.result = 0,
	.comment = "incorrect size of signature, tcId is 121 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 546 for ECDSA, tcId is 122 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_546_pubkey[] = {
	0x10, 0xcc, 0x79, 0x92, 0xed, 0xe2, 0x8c, 0x7b, 0x4d, 0xda, 0x5c, 0x35, 0xcb, 0xd7, 0x11, 0x74, 0x91, 0x8e, 0x83, 0xad, 0xab, 0x03, 0x42, 0xcc, 0x3d, 0x55, 0x6a, 0x41, 0x3b, 0x4c, 0xe9, 0x3b, 0x3f, 0x9c, 0x3b, 0x38, 0xae, 0xf0, 0xa0, 0xe6, 0x87, 0xd7, 0xee, 0x6a, 0xfd, 0xe7, 0x0d, 0x47, 0xd6, 0x90, 0x0f, 0xf0, 0xce, 0x62, 0x15, 0x6e, 0x86, 0x45, 0xb8, 0x10, 0x3f, 0xc6, 0x6c, 0xad, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_546_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_546_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_546 = {
	.name = "ecdsa_brainpoolp256r1_sha256_546",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_546_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_546_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_546_sig,
	.siglen = 64,
	.result = 1,
	.comment = "small r and s, tcId is 122 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 547 for ECDSA, tcId is 123 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_547_pubkey[] = {
	0x10, 0xcc, 0x79, 0x92, 0xed, 0xe2, 0x8c, 0x7b, 0x4d, 0xda, 0x5c, 0x35, 0xcb, 0xd7, 0x11, 0x74, 0x91, 0x8e, 0x83, 0xad, 0xab, 0x03, 0x42, 0xcc, 0x3d, 0x55, 0x6a, 0x41, 0x3b, 0x4c, 0xe9, 0x3b, 0x3f, 0x9c, 0x3b, 0x38, 0xae, 0xf0, 0xa0, 0xe6, 0x87, 0xd7, 0xee, 0x6a, 0xfd, 0xe7, 0x0d, 0x47, 0xd6, 0x90, 0x0f, 0xf0, 0xce, 0x62, 0x15, 0x6e, 0x86, 0x45, 0xb8, 0x10, 0x3f, 0xc6, 0x6c, 0xad, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_547_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_547_sig[] = {
	0x01, 0x03, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_547 = {
	.name = "ecdsa_brainpoolp256r1_sha256_547",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_547_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_547_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_547_sig,
	.siglen = 2,
	.result = 0,
	.comment = "incorrect size of signature, tcId is 123 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 548 for ECDSA, tcId is 124 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_548_pubkey[] = {
	0x10, 0xcc, 0x79, 0x92, 0xed, 0xe2, 0x8c, 0x7b, 0x4d, 0xda, 0x5c, 0x35, 0xcb, 0xd7, 0x11, 0x74, 0x91, 0x8e, 0x83, 0xad, 0xab, 0x03, 0x42, 0xcc, 0x3d, 0x55, 0x6a, 0x41, 0x3b, 0x4c, 0xe9, 0x3b, 0x3f, 0x9c, 0x3b, 0x38, 0xae, 0xf0, 0xa0, 0xe6, 0x87, 0xd7, 0xee, 0x6a, 0xfd, 0xe7, 0x0d, 0x47, 0xd6, 0x90, 0x0f, 0xf0, 0xce, 0x62, 0x15, 0x6e, 0x86, 0x45, 0xb8, 0x10, 0x3f, 0xc6, 0x6c, 0xad, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_548_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_548_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_548 = {
	.name = "ecdsa_brainpoolp256r1_sha256_548",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_548_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_548_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_548_sig,
	.siglen = 64,
	.result = -1,
	.comment = "r is larger than n, tcId is 124 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 549 for ECDSA, tcId is 125 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_549_pubkey[] = {
	0x2b, 0xa2, 0x8f, 0x62, 0x36, 0xc5, 0xa7, 0x74, 0xcd, 0x10, 0x4b, 0x03, 0x6d, 0x2e, 0x01, 0x67, 0x11, 0xcb, 0x4a, 0x83, 0xfa, 0x07, 0x8b, 0x51, 0x50, 0xf6, 0x9e, 0x50, 0x98, 0xde, 0x7b, 0x4c, 0xa7, 0xc1, 0x3e, 0xf8, 0xc5, 0x7f, 0xcb, 0xe6, 0x84, 0xce, 0xff, 0x31, 0x2e, 0xf5, 0x3a, 0xf1, 0xb1, 0x43, 0x97, 0xd4, 0x15, 0x4b, 0xa6, 0x10, 0x6a, 0x33, 0x83, 0xaa, 0xed, 0x16, 0xec, 0xb1, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_549_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_549_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x5b, 0x2d, 0x2e, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_549 = {
	.name = "ecdsa_brainpoolp256r1_sha256_549",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_549_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_549_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_549_sig,
	.siglen = 64,
	.result = -1,
	.comment = "s is larger than n, tcId is 125 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 550 for ECDSA, tcId is 126 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_550_pubkey[] = {
	0x11, 0x34, 0x89, 0x55, 0x5b, 0xdc, 0x11, 0x23, 0x52, 0xb0, 0x8b, 0x7f, 0xfe, 0xbc, 0xf0, 0x50, 0x90, 0xf9, 0x4d, 0xa6, 0x23, 0x67, 0x64, 0x6b, 0x2e, 0x03, 0xa3, 0x47, 0x88, 0x63, 0x91, 0x4b, 0x4b, 0x4a, 0x0a, 0x43, 0x54, 0x62, 0xa1, 0x22, 0xf6, 0xd9, 0xac, 0x80, 0x13, 0x19, 0xbb, 0xc6, 0xd2, 0xc5, 0x92, 0x28, 0x86, 0x1a, 0x34, 0x14, 0xb5, 0x00, 0xe5, 0xcf, 0x59, 0x43, 0xc9, 0x64, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_550_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_550_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x28, 0x27, 0x37, 0x05, 0x84, 0xfd, 0xeb, 0x9f, 0x5d, 0x5a, 0x9f, 0xb9, 0x57, 0x9a, 0x09, 0x39, 0x0e, 0xfb, 0x6f, 0x9d, 0x99, 0xb6, 0x4f, 0xc1, 0x88, 0xd8, 0xbc, 0xe0, 0x5c, 0x2d, 0x4e, 0xed, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_550 = {
	.name = "ecdsa_brainpoolp256r1_sha256_550",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_550_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_550_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_550_sig,
	.siglen = 64,
	.result = 1,
	.comment = "small r and s^-1, tcId is 126 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 551 for ECDSA, tcId is 127 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_551_pubkey[] = {
	0x34, 0x22, 0x47, 0x46, 0xef, 0xa8, 0xc5, 0xd4, 0xf4, 0xc6, 0xb8, 0x2d, 0xe4, 0xd7, 0x6d, 0x3e, 0x71, 0x50, 0xc1, 0xb6, 0x9e, 0x23, 0x33, 0x9f, 0x09, 0x8f, 0xf7, 0x69, 0xbc, 0xac, 0x94, 0xbf, 0x94, 0x61, 0x8e, 0x36, 0x24, 0xa5, 0x7d, 0x48, 0xd1, 0x9e, 0x72, 0x86, 0x7d, 0xbc, 0x19, 0x1a, 0x0f, 0xd0, 0x5c, 0xf6, 0xf4, 0xb5, 0xec, 0x49, 0x7b, 0x79, 0x76, 0x26, 0xa5, 0x7b, 0xaa, 0x22, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_551_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_551_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x9b, 0x4d, 0x34, 0x79, 0x52, 0xce, 0x49, 0x37, 0xa0, 0x87, 0x73, 0x1d, 0xf4, 0xfe, 0xbc, 0x2c, 0x3a, 0x81, 0xdd, 0xfb, 0xab, 0x5d, 0xc3, 0xaf, 0x95, 0x08, 0x17, 0xf4, 0x1b, 0x59, 0x0d, 0x15, 0x6e, 0xd4, 0x09, 0xad, 0x28, 0x69, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_551 = {
	.name = "ecdsa_brainpoolp256r1_sha256_551",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_551_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_551_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_551_sig,
	.siglen = 64,
	.result = 1,
	.comment = "smallish r and s^-1, tcId is 127 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 552 for ECDSA, tcId is 128 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_552_pubkey[] = {
	0x6f, 0xb0, 0xcd, 0xf3, 0xb0, 0x8d, 0xc5, 0xd8, 0xb7, 0xe5, 0x25, 0x9c, 0x7d, 0x1b, 0xbd, 0x31, 0xa2, 0x23, 0x53, 0x45, 0xb7, 0xb4, 0x45, 0x63, 0x1e, 0x89, 0x4b, 0x56, 0x7d, 0x23, 0xc0, 0x79, 0x53, 0x24, 0x32, 0x07, 0xdf, 0x5c, 0x44, 0x60, 0x11, 0xc1, 0xcf, 0xed, 0xde, 0x6e, 0x53, 0x51, 0x95, 0x8a, 0xff, 0xa8, 0xf2, 0x74, 0xfe, 0x5a, 0xf4, 0x35, 0x75, 0x9d, 0xe8, 0x7d, 0xb3, 0x43, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_552_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_552_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x33, 0xe6, 0x7e, 0x37, 0xb3, 0x2b, 0x44, 0x55, 0x80, 0xbf, 0x4e, 0xfb, 0x91, 0x82, 0x7d, 0x03, 0xbb, 0x6d, 0xac, 0x31, 0x94, 0x0b, 0xa5, 0x6e, 0xd8, 0x84, 0x89, 0x04, 0x8f, 0xf1, 0x73, 0xf0, 0xbf, 0x20, 0xca, 0xb2, 0x0d, 0xcc, 0x08, 0x6f, 0xca, 0x37, 0xf2, 0x85, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_552 = {
	.name = "ecdsa_brainpoolp256r1_sha256_552",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_552_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_552_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_552_sig,
	.siglen = 64,
	.result = 1,
	.comment = "100-bit r and small s^-1, tcId is 128 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 553 for ECDSA, tcId is 129 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_553_pubkey[] = {
	0x0b, 0x8d, 0x3b, 0xef, 0x12, 0xeb, 0xab, 0x43, 0xf2, 0xf6, 0xf6, 0x61, 0x8f, 0x08, 0x43, 0xd5, 0xf4, 0x5d, 0x97, 0x87, 0x4f, 0x26, 0xf9, 0xa3, 0x6b, 0x78, 0x8c, 0xb7, 0xa6, 0x9e, 0xcf, 0x5f, 0x85, 0x55, 0x88, 0xc9, 0x9b, 0x38, 0x39, 0xca, 0x93, 0x61, 0xdd, 0xc7, 0x76, 0x45, 0xf7, 0x59, 0x2a, 0xd3, 0x71, 0x43, 0x8e, 0xe3, 0xe1, 0x86, 0xc7, 0x40, 0x81, 0xc4, 0x81, 0xdd, 0x52, 0x95, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_553_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_553_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x3e, 0xb3, 0x5f, 0xe7, 0xe8, 0x33, 0x1f, 0x71, 0xe4, 0xc6, 0x3b, 0x45, 0xf3, 0x49, 0xa9, 0x9d, 0x47, 0xa5, 0xe7, 0x81, 0x79, 0x8e, 0x57, 0x9f, 0x23, 0x86, 0x19, 0x5d, 0x38, 0x27, 0xbb, 0x15, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_553 = {
	.name = "ecdsa_brainpoolp256r1_sha256_553",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_553_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_553_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_553_sig,
	.siglen = 64,
	.result = 1,
	.comment = "small r and 100 bit s^-1, tcId is 129 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 554 for ECDSA, tcId is 130 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_554_pubkey[] = {
	0x6d, 0x24, 0x98, 0x53, 0x42, 0xa4, 0x5a, 0x55, 0xfd, 0x99, 0xe4, 0x75, 0x21, 0xfe, 0x3e, 0x99, 0x1b, 0x8a, 0x1d, 0x37, 0x6f, 0xa7, 0x38, 0x99, 0xd3, 0xba, 0xcc, 0x06, 0x7c, 0x12, 0xee, 0x0d, 0x65, 0x42, 0xf1, 0x48, 0x59, 0x9f, 0xcc, 0xb9, 0x9b, 0x1b, 0xa2, 0x8d, 0x38, 0x05, 0x81, 0x42, 0x92, 0xa9, 0x9b, 0xff, 0xe3, 0x71, 0xdf, 0x27, 0x7b, 0x09, 0xe8, 0xad, 0xa1, 0x25, 0x3d, 0xcd, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_554_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_554_sig[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x25, 0x22, 0xbb, 0xd3, 0xec, 0xbe, 0x7c, 0x39, 0xe9, 0x3e, 0x7c, 0x25, 0x3e, 0xb3, 0x5f, 0xe7, 0xe8, 0x33, 0x1f, 0x71, 0xe4, 0xc6, 0x3b, 0x45, 0xf3, 0x49, 0xa9, 0x9d, 0x47, 0xa5, 0xe7, 0x81, 0x79, 0x8e, 0x57, 0x9f, 0x23, 0x86, 0x19, 0x5d, 0x38, 0x27, 0xbb, 0x15, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_554 = {
	.name = "ecdsa_brainpoolp256r1_sha256_554",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_554_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_554_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_554_sig,
	.siglen = 64,
	.result = 1,
	.comment = "100-bit r and s^-1, tcId is 130 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 555 for ECDSA, tcId is 131 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_555_pubkey[] = {
	0x41, 0x25, 0xe4, 0x68, 0x20, 0xf4, 0x12, 0x06, 0xb6, 0x70, 0x88, 0x2a, 0x9d, 0x8d, 0x51, 0xb6, 0xba, 0xc3, 0x90, 0x91, 0x15, 0x0c, 0x9c, 0xb3, 0x3b, 0x6d, 0x00, 0x9e, 0x0c, 0xff, 0x52, 0x23, 0x65, 0x74, 0x92, 0x40, 0x62, 0x2b, 0x40, 0xd7, 0x0a, 0x63, 0x40, 0x79, 0x52, 0xc1, 0xb8, 0x76, 0x1c, 0x9f, 0x8e, 0x85, 0xab, 0xa6, 0xf0, 0x3b, 0xbc, 0x72, 0x19, 0xe2, 0x4e, 0x6f, 0xb2, 0x76, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_555_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_555_sig[] = {
	0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66, 0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3, 0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48, 0x56, 0x28, 0x38, 0xa9, 0x1d, 0x49, 0x35, 0xfa, 0x38, 0x94, 0x14, 0xcc, 0xae, 0x30, 0x34, 0x81, 0x2f, 0x25, 0xd9, 0x68, 0x7e, 0x36, 0x91, 0xcb, 0x37, 0xa7, 0xda, 0xb4, 0xaf, 0x80, 0xdd, 0x18, 0x1c, 0xe2, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_555 = {
	.name = "ecdsa_brainpoolp256r1_sha256_555",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_555_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_555_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_555_sig,
	.siglen = 64,
	.result = 1,
	.comment = "r and s^-1 are close to n, tcId is 131 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 556 for ECDSA, tcId is 132 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_556_pubkey[] = {
	0x91, 0xba, 0x17, 0x06, 0xa1, 0x9c, 0xe5, 0x8f, 0xac, 0xa2, 0x63, 0x66, 0xdc, 0xed, 0x29, 0x33, 0x99, 0x45, 0x0e, 0xfa, 0x48, 0x8f, 0x2c, 0x4b, 0xaa, 0x95, 0x69, 0x3b, 0x97, 0x4d, 0x07, 0x5d, 0x5e, 0x84, 0x01, 0x56, 0x5a, 0x37, 0xb0, 0x5b, 0x93, 0x51, 0xe4, 0x08, 0xaf, 0x54, 0x2b, 0xf0, 0xf7, 0x95, 0x7e, 0x5e, 0xed, 0x18, 0x2a, 0xfe, 0xab, 0xea, 0xfa, 0x2b, 0xf7, 0xbb, 0xbb, 0x47, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_556_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_556_sig[] = {
	0x38, 0xa9, 0x1d, 0x49, 0x35, 0xfa, 0x38, 0x94, 0x14, 0xcc, 0xae, 0x30, 0x34, 0x81, 0x2f, 0x25, 0xd9, 0x68, 0x7e, 0x36, 0x91, 0xcb, 0x37, 0xa7, 0xda, 0xb4, 0xaf, 0x80, 0xdd, 0x18, 0x1c, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_556 = {
	.name = "ecdsa_brainpoolp256r1_sha256_556",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_556_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_556_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_556_sig,
	.siglen = 64,
	.result = 1,
	.comment = "s == 1, tcId is 132 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 557 for ECDSA, tcId is 133 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_557_pubkey[] = {
	0x91, 0xba, 0x17, 0x06, 0xa1, 0x9c, 0xe5, 0x8f, 0xac, 0xa2, 0x63, 0x66, 0xdc, 0xed, 0x29, 0x33, 0x99, 0x45, 0x0e, 0xfa, 0x48, 0x8f, 0x2c, 0x4b, 0xaa, 0x95, 0x69, 0x3b, 0x97, 0x4d, 0x07, 0x5d, 0x5e, 0x84, 0x01, 0x56, 0x5a, 0x37, 0xb0, 0x5b, 0x93, 0x51, 0xe4, 0x08, 0xaf, 0x54, 0x2b, 0xf0, 0xf7, 0x95, 0x7e, 0x5e, 0xed, 0x18, 0x2a, 0xfe, 0xab, 0xea, 0xfa, 0x2b, 0xf7, 0xbb, 0xbb, 0x47, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_557_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_557_sig[] = {
	0x38, 0xa9, 0x1d, 0x49, 0x35, 0xfa, 0x38, 0x94, 0x14, 0xcc, 0xae, 0x30, 0x34, 0x81, 0x2f, 0x25, 0xd9, 0x68, 0x7e, 0x36, 0x91, 0xcb, 0x37, 0xa7, 0xda, 0xb4, 0xaf, 0x80, 0xdd, 0x18, 0x1c, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_557 = {
	.name = "ecdsa_brainpoolp256r1_sha256_557",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_557_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_557_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_557_sig,
	.siglen = 64,
	.result = -1,
	.comment = "s == 0, tcId is 133 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 558 for ECDSA, tcId is 134 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_558_pubkey[] = {
	0x25, 0xd1, 0x75, 0x70, 0xe4, 0xba, 0xe1, 0xe4, 0x68, 0xe6, 0xdd, 0x09, 0x75, 0xb3, 0x82, 0x36, 0x80, 0x61, 0xe0, 0xc7, 0x04, 0x24, 0x1c, 0x1d, 0x18, 0xfd, 0x5b, 0xaa, 0x8c, 0xa8, 0xdc, 0x13, 0x5a, 0xca, 0xdc, 0xd1, 0x39, 0x92, 0xf6, 0x66, 0x5b, 0x46, 0x9c, 0x9f, 0x9a, 0xb7, 0x79, 0x7e, 0x3c, 0x4b, 0x88, 0x1c, 0x6d, 0x7f, 0x4d, 0x26, 0x01, 0xc9, 0x6a, 0x15, 0x36, 0xf7, 0x6d, 0x05, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_558_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_558_sig[] = {
	0x54, 0xfd, 0xab, 0xed, 0xd0, 0xf7, 0x54, 0xde, 0x1f, 0x33, 0x05, 0x48, 0x4e, 0xc1, 0xc6, 0xb8, 0xc6, 0x1c, 0xbd, 0x51, 0xda, 0xb0, 0xd3, 0x7b, 0xc8, 0x0f, 0x07, 0x41, 0x4b, 0xa4, 0x2b, 0x53, 0x38, 0xa9, 0x1d, 0x49, 0x35, 0xfa, 0x38, 0x94, 0x14, 0xcc, 0xae, 0x30, 0x34, 0x81, 0x2f, 0x25, 0xd9, 0x68, 0x7e, 0x36, 0x91, 0xcb, 0x37, 0xa7, 0xda, 0xb4, 0xaf, 0x80, 0xdd, 0x18, 0x1c, 0xe2, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_558 = {
	.name = "ecdsa_brainpoolp256r1_sha256_558",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_558_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_558_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_558_sig,
	.siglen = 64,
	.result = -1,
	.comment = "point at infinity during verify, tcId is 134 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 559 for ECDSA, tcId is 135 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_559_pubkey[] = {
	0x1d, 0xc3, 0x32, 0x5f, 0xfa, 0x55, 0xe1, 0x79, 0xe2, 0x17, 0x1a, 0x66, 0xb2, 0xe7, 0x53, 0x4a, 0xe1, 0x2c, 0xfc, 0x29, 0x2a, 0xf2, 0xe0, 0xfb, 0xf1, 0xc3, 0xfc, 0xce, 0x55, 0x58, 0xfc, 0x6a, 0x24, 0x20, 0xab, 0xcd, 0xb7, 0xdf, 0x8c, 0xf3, 0x86, 0x34, 0x64, 0x82, 0x64, 0xa6, 0x81, 0xd5, 0xed, 0x19, 0x5b, 0xf1, 0x6a, 0x97, 0x0f, 0xfa, 0x68, 0xab, 0x25, 0x0b, 0x34, 0xa9, 0x35, 0x14, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_559_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_559_sig[] = {
	0x54, 0xfd, 0xab, 0xed, 0xd0, 0xf7, 0x54, 0xde, 0x1f, 0x33, 0x05, 0x48, 0x4e, 0xc1, 0xc6, 0xb8, 0xc6, 0x1c, 0xbd, 0x51, 0xda, 0xb0, 0xd3, 0x7b, 0xc8, 0x0f, 0x07, 0x41, 0x4b, 0xa4, 0x2b, 0x53, 0x54, 0xfd, 0xab, 0xed, 0xd0, 0xf7, 0x54, 0xde, 0x1f, 0x33, 0x05, 0x48, 0x4e, 0xc1, 0xc6, 0xb8, 0xc6, 0x1c, 0xbd, 0x51, 0xda, 0xb0, 0xd3, 0x7b, 0xc8, 0x0f, 0x07, 0x41, 0x4b, 0xa4, 0x2b, 0x53, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_559 = {
	.name = "ecdsa_brainpoolp256r1_sha256_559",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_559_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_559_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_559_sig,
	.siglen = 64,
	.result = 1,
	.comment = "edge case for signature malleability, tcId is 135 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 560 for ECDSA, tcId is 136 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_560_pubkey[] = {
	0x3f, 0xff, 0xa6, 0xdb, 0xaf, 0x66, 0x7b, 0x0a, 0x94, 0xe5, 0xf8, 0x6b, 0x37, 0x74, 0xb9, 0x75, 0x97, 0x1a, 0x4d, 0x24, 0x39, 0x60, 0x7d, 0xef, 0x4e, 0x5d, 0xe1, 0xd1, 0x78, 0x20, 0xa3, 0xb2, 0x1b, 0xf3, 0x66, 0x13, 0xb5, 0x0b, 0x92, 0x52, 0x64, 0x55, 0x18, 0x15, 0xc5, 0xda, 0x78, 0x3b, 0xd1, 0x58, 0xaa, 0xa1, 0xc6, 0x24, 0x4b, 0x40, 0xa9, 0xfa, 0x31, 0xa2, 0xa4, 0x33, 0xf8, 0xe8, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_560_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_560_sig[] = {
	0x54, 0xfd, 0xab, 0xed, 0xd0, 0xf7, 0x54, 0xde, 0x1f, 0x33, 0x05, 0x48, 0x4e, 0xc1, 0xc6, 0xb8, 0xc6, 0x1c, 0xbd, 0x51, 0xda, 0xb0, 0xd3, 0x7b, 0xc8, 0x0f, 0x07, 0x41, 0x4b, 0xa4, 0x2b, 0x53, 0x54, 0xfd, 0xab, 0xed, 0xd0, 0xf7, 0x54, 0xde, 0x1f, 0x33, 0x05, 0x48, 0x4e, 0xc1, 0xc6, 0xb8, 0xc6, 0x1c, 0xbd, 0x51, 0xda, 0xb0, 0xd3, 0x7b, 0xc8, 0x0f, 0x07, 0x41, 0x4b, 0xa4, 0x2b, 0x54, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_560 = {
	.name = "ecdsa_brainpoolp256r1_sha256_560",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_560_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_560_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_560_sig,
	.siglen = 64,
	.result = 1,
	.comment = "edge case for signature malleability, tcId is 136 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 561 for ECDSA, tcId is 137 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_561_pubkey[] = {
	0x8a, 0xfd, 0x47, 0xeb, 0x06, 0x67, 0x86, 0x0b, 0xec, 0x98, 0xd5, 0xdc, 0xd2, 0xf6, 0x0d, 0xa9, 0xea, 0xc1, 0xae, 0x99, 0x62, 0x05, 0x69, 0x89, 0x2f, 0x14, 0xe0, 0x94, 0xd6, 0x35, 0x87, 0x2a, 0x5e, 0x8f, 0x0b, 0xc6, 0x7b, 0x98, 0xa2, 0x33, 0xad, 0xe7, 0x15, 0xc0, 0x4d, 0x9d, 0xaa, 0xb1, 0x1a, 0x27, 0x51, 0x7a, 0x92, 0xcf, 0x26, 0x51, 0xc9, 0xe5, 0xf2, 0xfd, 0xe4, 0xe2, 0xdb, 0x98, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_561_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_561_sig[] = {
	0x38, 0xa9, 0x1d, 0x49, 0x35, 0xfa, 0x38, 0x94, 0x14, 0xcc, 0xae, 0x30, 0x34, 0x81, 0x2f, 0x25, 0xd9, 0x68, 0x7e, 0x36, 0x91, 0xcb, 0x37, 0xa7, 0xda, 0xb4, 0xaf, 0x80, 0xdd, 0x18, 0x1c, 0xe2, 0xbb, 0x5a, 0x52, 0xf4, 0x2f, 0x9c, 0x92, 0x61, 0xed, 0x43, 0x61, 0xf5, 0x94, 0x22, 0xa1, 0xe3, 0x00, 0x36, 0xe7, 0xc3, 0x2b, 0x27, 0x0c, 0x88, 0x07, 0xa4, 0x19, 0xfe, 0xca, 0x60, 0x50, 0x23, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_561 = {
	.name = "ecdsa_brainpoolp256r1_sha256_561",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_561_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_561_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_561_sig,
	.siglen = 64,
	.result = -1,
	.comment = "u1 == 1, tcId is 137 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 562 for ECDSA, tcId is 138 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_562_pubkey[] = {
	0x08, 0x76, 0x61, 0x66, 0x36, 0xa8, 0xdb, 0xc8, 0x21, 0x60, 0xac, 0x01, 0xaf, 0x29, 0x41, 0x35, 0x3b, 0xa0, 0xee, 0xa4, 0xa3, 0xb8, 0xfe, 0x31, 0x69, 0x6b, 0x47, 0x31, 0x7d, 0x49, 0x72, 0xc9, 0x23, 0x18, 0x00, 0x73, 0x06, 0x1d, 0x27, 0x98, 0x4e, 0xcf, 0x49, 0x1f, 0x39, 0x40, 0x04, 0xc3, 0xa4, 0x84, 0x6d, 0x77, 0x3f, 0x58, 0xdc, 0x2a, 0xb5, 0xe4, 0x3d, 0xcb, 0xf9, 0x68, 0xd0, 0x27, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_562_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_562_sig[] = {
	0x38, 0xa9, 0x1d, 0x49, 0x35, 0xfa, 0x38, 0x94, 0x14, 0xcc, 0xae, 0x30, 0x34, 0x81, 0x2f, 0x25, 0xd9, 0x68, 0x7e, 0x36, 0x91, 0xcb, 0x37, 0xa7, 0xda, 0xb4, 0xaf, 0x80, 0xdd, 0x18, 0x1c, 0xe2, 0x98, 0x9c, 0x5c, 0xc3, 0x14, 0x40, 0xc1, 0x16, 0x8f, 0x88, 0xb3, 0x2b, 0xa6, 0xe4, 0x79, 0x00, 0x18, 0x3c, 0x0d, 0x84, 0x3f, 0x9c, 0x41, 0x67, 0x18, 0x98, 0x03, 0x06, 0x64, 0x30, 0x5d, 0x2b, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_562 = {
	.name = "ecdsa_brainpoolp256r1_sha256_562",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_562_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_562_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_562_sig,
	.siglen = 64,
	.result = 1,
	.comment = "u1 == n - 1, tcId is 138 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 563 for ECDSA, tcId is 139 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_563_pubkey[] = {
	0x0f, 0xab, 0xb0, 0x52, 0x21, 0x7e, 0xae, 0x8e, 0x63, 0xfe, 0xa4, 0xee, 0xa0, 0x99, 0x53, 0xd5, 0x18, 0x62, 0x42, 0x7f, 0x34, 0x13, 0x07, 0xd8, 0x19, 0xff, 0x6e, 0x93, 0x3b, 0xf7, 0x2b, 0xa9, 0x4b, 0x89, 0x7f, 0x2c, 0x4a, 0x4c, 0xf5, 0x70, 0x54, 0xc3, 0x63, 0xc7, 0x20, 0xda, 0x3d, 0x24, 0x24, 0x71, 0xcc, 0x8e, 0x49, 0x3b, 0xec, 0xb0, 0xde, 0x02, 0x22, 0x51, 0xd2, 0xee, 0x4c, 0x8c, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_563_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_563_sig[] = {
	0x38, 0xa9, 0x1d, 0x49, 0x35, 0xfa, 0x38, 0x94, 0x14, 0xcc, 0xae, 0x30, 0x34, 0x81, 0x2f, 0x25, 0xd9, 0x68, 0x7e, 0x36, 0x91, 0xcb, 0x37, 0xa7, 0xda, 0xb4, 0xaf, 0x80, 0xdd, 0x18, 0x1c, 0xe2, 0x38, 0xa9, 0x1d, 0x49, 0x35, 0xfa, 0x38, 0x94, 0x14, 0xcc, 0xae, 0x30, 0x34, 0x81, 0x2f, 0x25, 0xd9, 0x68, 0x7e, 0x36, 0x91, 0xcb, 0x37, 0xa7, 0xda, 0xb4, 0xaf, 0x80, 0xdd, 0x18, 0x1c, 0xe2, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_563 = {
	.name = "ecdsa_brainpoolp256r1_sha256_563",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_563_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_563_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_563_sig,
	.siglen = 64,
	.result = 1,
	.comment = "u2 == 1, tcId is 139 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 564 for ECDSA, tcId is 140 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_564_pubkey[] = {
	0x72, 0xeb, 0xad, 0x74, 0x9b, 0x50, 0x4c, 0x87, 0x4d, 0x21, 0xbc, 0x5e, 0x4b, 0xba, 0x54, 0x5d, 0xd4, 0x2e, 0xb5, 0xfb, 0xf7, 0x8a, 0xf4, 0x20, 0x43, 0xf5, 0xce, 0xf1, 0x0a, 0xeb, 0x3a, 0xd7, 0x45, 0x22, 0x74, 0x64, 0xe1, 0xe9, 0xce, 0xf6, 0x62, 0xf4, 0x3f, 0xc8, 0x0d, 0x4c, 0xe7, 0xeb, 0x7e, 0xb6, 0x15, 0xa2, 0x36, 0x99, 0xd4, 0x8e, 0x89, 0xb2, 0x78, 0xab, 0xd4, 0x6c, 0xcc, 0x46, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_564_msg[] = {
	0x31, 0x32, 0x33, 0x34, 0x30, 0x30, 
};
static const unsigned char ecdsa_brainpoolp256r1_sha256_564_sig[] = {
	0x38, 0xa9, 0x1d, 0x49, 0x35, 0xfa, 0x38, 0x94, 0x14, 0xcc, 0xae, 0x30, 0x34, 0x81, 0x2f, 0x25, 0xd9, 0x68, 0x7e, 0x36, 0x91, 0xcb, 0x37, 0xa7, 0xda, 0xb4, 0xaf, 0x80, 0xdd, 0x18, 0x1c, 0xe2, 0x71, 0x52, 0x3a, 0x92, 0x6b, 0xf4, 0x71, 0x28, 0x29, 0x99, 0x5c, 0x60, 0x69, 0x02, 0x5e, 0x4b, 0xb2, 0xd0, 0xfc, 0x6d, 0x23, 0x96, 0x6f, 0x4f, 0xb5, 0x69, 0x5f, 0x01, 0xba, 0x30, 0x39, 0xc5, 
};
static const wycheproof_ecdsa_test ecdsa_brainpoolp256r1_sha256_564 = {
	.name = "ecdsa_brainpoolp256r1_sha256_564",
	.sig_alg = ECDSA,
	.hash = SHA256,
	.curve =  &brainpoolp256r1_str_params,
	.pubkey = ecdsa_brainpoolp256r1_sha256_564_pubkey,
	.pubkeylen = 64,
	.msg = ecdsa_brainpoolp256r1_sha256_564_msg,
	.msglen = 6,
	.sig = ecdsa_brainpoolp256r1_sha256_564_sig,
	.siglen = 64,
	.result = 1,
	.comment = "u2 == n - 1, tcId is 140 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json",
};
#endif /* defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256) */
/* Test 565 for ECDSA, tcId is 141 in file ecdsa_brainpoolP256r1_sha256_p1363_test.json  */
#if defined(WITH_SIG_ECDSA) && defined(WITH_CURVE_BRAINPOOLP256R1) && defined(WITH_HASH_SHA256)
static const unsigned char ecdsa_brainpoolp256r1_sha256_565_pubkey[] = {
	0x74, 0x4e, 0x21, 0x8a, 0x04, 0xb3, 0x14, 0x71, 0xb0, 0x5e, 0x67, 0x9c, 0x94, 0x81, 0x44, 0x6b, 0xcd, 0x72, 0xa4, 0xd0, 0xfc, 0xa7, 0xa7, 0xaf, 0x1a, 0x1f, 0xe2, 0xf5, 0x74, 0xd9, 0x36, 0x2f, 0x60, 0xc0, 0xc5, 0x28, 0x43, 0xd8, 0xd7, 0x2c, 0xd6, 0x36, 0x15, 0x3f, 0x0f, 0x51, 0x0a, 0x09, 0x08, 0x9f, 0xc4, 0x47, 0x83, 0x72, 0xdf, 0xc5, 0x0