https://bugs.gentoo.org/886575
https://github.com/wesnoth/wesnoth/issues/7215

From d71e90ee50a89673cf9b6748bcb2975071d15445 Mon Sep 17 00:00:00 2001
From: =?UTF-8?q?=C4=90o=C3=A0n=20Tr=E1=BA=A7n=20C=C3=B4ng=20Danh?=
 <congdanhqx@gmail.com>
Date: Mon, 28 Nov 2022 23:21:38 +0700
Subject: [PATCH] gettext: fix build with Boost.Locale 1.81

See https://github.com/boostorg/locale/pull/128/

(cherry picked from commit fd96415bdf0a2e3a05e1a587a1c3853847e2c2bc)
--- src/gettext.cpp
+++ src/gettext.cpp
@@ -26,6 +26,7 @@
 #include <mutex>
 #include <boost/locale.hpp>
 #include <set>
+#include <type_traits>
 
 #if defined(__GNUC__)
 #pragma GCC diagnostic push
@@ -224,8 +225,13 @@ namespace
 			}
 
 			generator_.use_ansi_encoding(false);
+#if BOOST_VERSION < 108100
 			generator_.categories(bl::message_facet | bl::information_facet | bl::collation_facet | bl::formatting_facet | bl::convert_facet);
 			generator_.characters(bl::char_facet);
+#else
+			generator_.categories(bl::category_t::message | bl::category_t::information | bl::category_t::collation | bl::category_t::formatting | bl::category_t::convert);
+			generator_.characters(bl::char_facet_t::char_f);
+#endif
 			// We cannot have current_locale_ be a non boost-generated locale since it might not supply
 			// the bl::info facet. As soon as we add message paths, update_locale_internal might fail,
 			// for example because of invalid .mo files. So make sure we call it at least once before adding paths/domains
@@ -368,7 +374,12 @@ namespace
 			if(std::has_facet<bl::collator<char>>(current_locale_)) {
 				res << "has bl::collator<char> facet, ";
 			}
+#if BOOST_VERSION < 108100
 			res << "generator categories='" << generator_.categories() << "'";
+#else
+			res << "generator categories='" <<
+				static_cast<std::underlying_type<bl::category_t>::type>(generator_.categories()) << "'";
+#endif
 			return res.str();
 		}
 
