/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: DOMXPathImplementation.java,v $
 * Version:       $Name:  $ $Revision: 1.3 $
 * Last Modified: $Date: 2004/06/21 10:24:23 $
 *****************************************************************************/
package org.ten60.netkernel.xml.xda;

import org.ten60.netkernel.xml.util.XMLUtils;

import javax.xml.transform.TransformerException;

import org.w3c.dom.Node;
import org.w3c.dom.Document;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.NodeList;

import org.apache.xpath.XPathContext;
import org.apache.xpath.XPath;
import org.apache.xpath.NodeSet;
import org.apache.xpath.compiler.XPathParser;
import org.apache.xpath.XPathContext;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XNodeSetForDOM;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.ref.DTMNodeIterator;
import org.apache.xml.dtm.ref.DTMNodeList;
import org.apache.xml.dtm.ref.DTMManagerDefault;

import java.util.*;
import javax.xml.transform.ErrorListener;

/**
 * Wrapper around evaluation of xpaths using xalan.
 * An attempt is made to minimise memory usage by reusing contexts and caching last node id and
 * parsed xpath.
 * @author  tab
 */
public class DOMXPathImplementation implements IXPathImplementation
{
	private ErrorListener mErrorListener = new org.apache.xml.utils.DefaultErrorHandler();
	
	private PrefixResolver mResolver;
	private Document mDocument;
	private XPathContext mXPathContext;
	private int mLastNodeId;
	private Node mLastNodeRef;
	
	private String mLastXPathExpr;
	private XPath mXPath;
	
	/** Creates a new instance of XPathAPIWrapper */
	public DOMXPathImplementation()
	{	//mResolver = aResolver;
	}
	
	/** Evaluates an xpath expression on the given context node
	 */
	public final IXPathResult eval(Object aContextNode, String aXPath) throws XPathImplementationException
	{	if(aContextNode !=null && !(aContextNode instanceof org.w3c.dom.Node)) throw new XPathImplementationException("Context must be a Node");

		mDocument = XMLUtils.getDocumentFor((Node)aContextNode);
		if (aXPath.indexOf(':')>=0 && !(mResolver instanceof DOMPrefixResolver))
		{   mResolver = new DOMPrefixResolver(mDocument);
			reset();
		} else if (mResolver==null)
		{   mResolver = new PrefixResolverDefault(mDocument);
		}
		
		try
		{
		if (!aXPath.equals(mLastXPathExpr))
		{   mLastXPathExpr = aXPath;
			mXPath = new XPath(mLastXPathExpr, null, mResolver, XPath.SELECT, mErrorListener);
		}
		if (mXPathContext==null)
		{	mXPathContext= new XPathContext();
		}
		if (mLastNodeRef!=(Node)aContextNode)
		{   mLastNodeId = mXPathContext.getDTMHandleFromNode((Node)aContextNode);
		}
		
		return new DOMXPathResult(mXPath.execute(mXPathContext, mLastNodeId, mResolver));
		}
		catch(TransformerException e)
		{	throw new XPathImplementationException(e.getMessageAndLocation());
		}
	}
	
	/** reset the evaluator after the document has changed
	 */
	public void reset()
	{	if (mXPathContext!=null)
		{	mXPathContext.reset();
		}
		mLastXPathExpr=null;
		mLastNodeRef=null;
	}
	public void resetPrefixResolver()
	{	mResolver=null;
	}
	
	public PrefixResolver getPrefixResolver()
	{	if (!(mResolver instanceof DOMPrefixResolver) && mDocument!=null)
		{   mResolver = new DOMPrefixResolver(mDocument);
		}
		return mResolver;
	}
}