/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: SAX2DOM.java,v $
  Version:       $Name:  $ $Revision: 1.4 $
  Last Modified: $Date: 2004/09/24 22:36:56 $
 *****************************************************************************/
package org.ten60.netkernel.xml.transrepresentation;

import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.util.XMLUtils;
import org.ten60.netkernel.xml.xda.*;

import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.transrepresentation.SimpleTransreptorImpl;
import org.ten60.netkernel.layer1.representation.MultiRepresentationImpl;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.representation.ITransrepresentor;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.util.NetKernelException;

import org.apache.xml.serializer.*;
import javax.xml.transform.*;
import javax.xml.transform.sax.*;
import javax.xml.transform.stream.*;

import org.xml.sax.*;
import org.xml.sax.helpers.*;
import java.io.*;
import java.util.*;
import org.w3c.dom.*;

/**
 * Creates a DOMXDA Aspect from a SAX Stream
 * - this transreptor is not optimal it does the conversion via serialization and reparsing
 * @author  tab
 */
public class SAX2DOM extends SimpleTransreptorImpl
{
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return ( aFrom.hasAspect(IAspectSAX.class) && ( aTo.isAssignableFrom(IXAspect.class)) );
	}
	
	public IURRepresentation transrepresent(IURRepresentation aFrom) throws NetKernelException
	{	try
		{	// serialize SAX to string
			IAspectSAX sax = (IAspectSAX)aFrom.getAspect(IAspectSAX.class);
			StringWriter sw = new StringWriter(1024);
			Properties p=OutputPropertiesFactory.getDefaultMethodProperties("xml");
			Serializer s=SerializerFactory.getSerializer(p);
			s.setWriter(sw);
			ContentHandler ch = s.asContentHandler();
			// this serializer has no way to receive lexical events that we can see- so this is lost
			List usageDependencies = new ArrayList(8);
			XMLReader xr=XMLReaderFactory.createXMLReader();
			xr.setContentHandler(ch);
			sax.handleContent(xr,usageDependencies);
			
			//parse DOM
			StringReader sr = new StringReader(sw.toString());
			Document d = XMLUtils.getInstance().parse(sr);
			DOMXDA domXDA = new DOMXDA(d,false);
			IURAspect aspect = new DOMXDAAspect(domXDA);
			
			// build resultant representation
			DependencyMeta meta = new DependencyMeta(aFrom, 32);
			for (Iterator i = usageDependencies.iterator(); i.hasNext(); )
			{	IURRepresentation dependency = (IURRepresentation)i.next();
				meta.addDependency(dependency);
			}
			MultiRepresentationImpl rep = new MultiRepresentationImpl(meta,2);
			rep.addAspect(aspect);
			rep.addAspectsOf(aFrom);
			return rep;
		} catch (Exception e)
		{	NetKernelException e2 = new NetKernelException("Unhandled Exception in SAX2DOM");
			e2.addCause(e);
			throw e2;
		}
	}
}