/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: DOMXDASerializer.java,v $
  Version:       $Name:  $ $Revision: 1.7 $
  Last Modified: $Date: 2004/10/06 10:38:46 $
 *****************************************************************************/

package org.ten60.netkernel.xml.transrepresentation;


import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.util.XMLUtils;

import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.representation.MonoRepresentationImpl;
import org.ten60.netkernel.layer1.transrepresentation.SimpleTransreptorImpl;
import org.ten60.netkernel.layer1.representation.ByteArrayAspect;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.representation.ITransrepresentor;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.util.NetKernelException;

import org.w3c.dom.*;
import java.io.*;

/**
 * Serialise DOM to a binary stream
 * @author  tab
 */
public class DOMXDASerializer extends SimpleTransreptorImpl
{
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return ( aFrom.hasAspect(IAspectDOM.class) && ( aTo.isAssignableFrom(StringAspect.class)) );
	}
	
	public IURRepresentation transrepresent(IURRepresentation aFrom) throws NetKernelException
	{	try
		{	IAspectDOM proxy = (IAspectDOM)aFrom.getAspect(IAspectDOM.class);
			Node n = proxy.getReadOnlyDocument().getDocumentElement();
			DependencyMeta meta = new DependencyMeta(aFrom, 32);
			boolean isHTML = aFrom.getMeta().getMimeType().equals("text/html");
			StringWriter sw = new StringWriter(2048);
			if (isHTML)
			{	sw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
			// this breaks mozilla- it won't load css links!
			//osw.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n");
			SerializedDOMAspect.serialize(n,sw);
			}
			else
			{	XMLUtils.getInstance().toXML(sw, n, false,false);
			}
			sw.flush();
			IURAspect aspect = new StringAspect(sw.toString());
			return new MonoRepresentationImpl(meta, aspect);
		}
		catch (Exception e)
		{	NetKernelException e2 = new NetKernelException("Failed to serialize xml");
			e2.addCause(e);
			throw e2;
		}
	}	
}