/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: XAHelperExtra.java,v $
  Version:       $Name:  $ $Revision: 1.3 $
  Last Modified: $Date: 2004/06/21 10:24:23 $
 *****************************************************************************/
package org.ten60.netkernel.xml.xahelper;

import com.ten60.netkernel.urrequest.URRequest;
import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.container.Container;
import com.ten60.netkernel.util.NetKernelException;
import java.util.Map;
import java.net.URI;
/**
 * A few extra methods for some advanced/system accessors
 * @author  tab
 */
public interface XAHelperExtra
{
	/** Return the raw request that invoked the accessor */
	URRequest getRequest();
	/** Return the container we are running in */
	Container getContainer();
	/** Request a resource with optional pass-by-value arguments
	  @param aURI the type component of the active uri
	  @param aAspectClass the result must have this aspect
	  @param aURIToValue a map of <code>URI</code> to <code>IURRepresentation</code>
	  @exception NetKernelException thrown if we fail to request the resource sucessfully
	 *@return A Representation of the requested resource
	 */
	IURRepresentation requestResourceWithValues(URI aURI, Class aAspectClass, Map aURIToValue) throws NetKernelException;
}