/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: SerializedDOMAspect.java,v $
  Version:       $Name:  $ $Revision: 1.4 $
  Last Modified: $Date: 2004/09/03 17:21:47 $
 *****************************************************************************/

package org.ten60.netkernel.xml.transrepresentation;


import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.util.XMLUtils;

import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.representation.ByteArrayAspect;
import org.ten60.netkernel.layer1.transrepresentation.SimpleTransreptorImpl;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.representation.ITransrepresentor;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.util.NetKernelException;

import org.w3c.dom.*;
import java.util.*;
import java.io.*;

/**
 * Serialise DOM to a binary stream
 * @author  tab
 */
public class SerializedDOMAspect implements IAspectBinaryStream
{
	Node mNode;
	boolean mIsHTML;
	
	private static Set sNonCoaleseElements = new HashSet();
	static 
	{	sNonCoaleseElements.add("textarea");
	};
	
	public SerializedDOMAspect(Node aNode, boolean aIsHTML)
	{	mNode = aNode;
		mIsHTML = aIsHTML;
	}
	
	public String getEncoding()
	{	return "UTF-8";
	}
	
	public void write(OutputStream aStream) throws IOException
	{	
		OutputStreamWriter osw = new OutputStreamWriter(aStream,"UTF-8");
		if (mIsHTML)
		{	osw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
			// this breaks mozilla- it won't load css links!
			//osw.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n");
			Element docEl = (Element)mNode;
			//docEl.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
			serialize(docEl,osw);
		}
		else
		{	XMLUtils.getInstance().toXML(osw, mNode, false,false);
		}
		osw.flush();
	}
	
	static void serialize(Node aNode, Writer aWriter) throws IOException
	{	switch (aNode.getNodeType())
		{	case Node.ELEMENT_NODE:
			{	aWriter.write('<');
				String name = aNode.getNodeName();
				aWriter.write(name);
				NamedNodeMap atts = ((Element)aNode).getAttributes();
				int length=atts.getLength();
				if (length>0)
				{	aWriter.write(' ');
					for (int i=0; i<length; i++)
					{	serialize(atts.item(i),aWriter);
						aWriter.write(' ');
					}
				}
				Node n=aNode.getFirstChild();
				if (n==null && !sNonCoaleseElements.contains(name.toLowerCase()))
				{	aWriter.write(" />");
				}
				else
				{	aWriter.write(" >");
					while (n!=null)
					{	serialize(n,aWriter);
						n=n.getNextSibling();
					}

					aWriter.write("</");
					aWriter.write(aNode.getNodeName());
					aWriter.write('>');
				}
				
			}
			break;	
			case Node.ATTRIBUTE_NODE:
				aWriter.write(aNode.getNodeName());
				aWriter.write("=\"");
				aWriter.write(escapeAttr(aNode.getNodeValue()));
				//aWriter.write(aNode.getNodeValue());
				aWriter.write('"');
				break;
			case Node.TEXT_NODE:
			case Node.CDATA_SECTION_NODE:
				aWriter.write(escape(aNode.getNodeValue()));
				break;
			case Node.COMMENT_NODE:
				aWriter.write("<!--");
				aWriter.write(aNode.getNodeValue());
				aWriter.write("-->");
				break;
		}
	}
	
	public static String escape(String aXML)
	{   int length = aXML.length();
		StringBuffer result = new StringBuffer(length*2);
		boolean changed = false;
		for (int i=0; i<length; i++)
		{   char c = aXML.charAt(i);
			switch(c)
			{   case '<':
					result.append("&#60;");
					changed = true;
					break;
				case '>':
					result.append("&#62;");
					changed = true;
					break;
				case '\'':
					result.append("&#39;");
					changed = true;
					break;
				case '"':
					result.append("&#34;");
					changed = true;
					break;
				case '&':
					result.append("&#38;");
					changed = true;
					break;
				default:
					result.append(c);
					break;
			}
		}
		return (changed)?new String(result):aXML;
	}
	public static String escapeAttr(String aXML)
	{   int length = aXML.length();
		StringBuffer result = new StringBuffer(length*2);
		boolean changed = false;
		for (int i=0; i<length; i++)
		{   char c = aXML.charAt(i);
			switch(c)
			{   case '"':
					result.append("&#34;");
					changed = true;
					break;
				default:
					result.append(c);
					break;
			}
		}
		return (changed)?new String(result):aXML;
	}
}