/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: NodeList2XML.java,v $
  Version:       $Name:  $ $Revision: 1.4 $
  Last Modified: $Date: 2004/11/01 14:48:53 $
 *****************************************************************************/
package org.ten60.netkernel.xml.transrepresentation;

import com.ten60.netkernel.urii.IURAspect;
import com.ten60.netkernel.urii.IURRepresentation;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.NKFTransreptorImpl;
import org.ten60.netkernel.xml.representation.DOMXDAAspect;
import org.ten60.netkernel.xml.representation.IAspectNodeList;
import org.ten60.netkernel.xml.util.XMLUtils;
import org.ten60.netkernel.xml.xda.DOMXDA;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import java.util.List;

/**
 * Attempts to map a node list to a primary XML type
 * @author tab
 */
public class NodeList2XML extends NKFTransreptorImpl
{
	public static final String ERROR_ID="Incompatible Node List";

	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return ( aFrom.hasAspect(IAspectNodeList.class));
	}
	
	protected void transrepresent(INKFConvenienceHelper context) throws Exception
	{	IAspectNodeList aspect = (IAspectNodeList)context.sourceAspect(INKFRequestReadOnly.URI_SYSTEM,IAspectNodeList.class);
		List nodes = aspect.getNodes();
		IURAspect resultAspect=null;
		if (nodes.size()==1)
		{	Node n=(Node)nodes.get(0);
			if (n.getNodeType()==Node.ELEMENT_NODE)
			{	Document d = XMLUtils.newDocument();
				d.appendChild(d.importNode(n,true));
				DOMXDA xda = new DOMXDA(d,false);
				resultAspect = new DOMXDAAspect(xda);
			}
			else if (n.getNodeType()==Node.DOCUMENT_NODE)
			{	DOMXDA xda = new DOMXDA((Document)n,false);
				resultAspect = new DOMXDAAspect(xda);
			}
		}
		
		if (resultAspect!=null)
		{	Class desiredAspect = context.getThisRequest().getAspectClass();
			if (!desiredAspect.isAssignableFrom(DOMXDAAspect.class))
			{	// must further transrept
				resultAspect = context.transrept(resultAspect, desiredAspect);
			}
			
			INKFResponse response = context.createResponseFrom(resultAspect);
			response.setMimeType(context.source(INKFRequestReadOnly.URI_SYSTEM).getMeta().getMimeType());
			response.setCreationCost(16);
			context.setResponse(response);
		}
		else
		{	String message="Document cannot be created from NodeList: ";
			if (nodes.size()!=1)
			{	message+="1 node expected, "+nodes.size()+" nodes received.";
			}
			else
			{	message+="Element node expected, "+nodes.get(0).getClass().toString()+" received";
			}
			throw new NKFException(ERROR_ID,message,null);
		}
	}
}