/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: CanonicalBooleanToBoolean.java,v $
  Version:       $Name:  $ $Revision: 1.5 $
  Last Modified: $Date: 2005/06/09 08:25:22 $
 *****************************************************************************/
package org.ten60.netkernel.xml.transrepresentation;

import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.xda.*;

import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;
import com.ten60.netkernel.urii.aspect.IAspectReadableBinaryStream;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.urii.representation.ITransrepresentor;
import com.ten60.netkernel.urii.aspect.IAspectBoolean;

import org.w3c.dom.*;

/**
 * transrepresent a canonical boolean document to a boolean
 * @author  pjr
 */
public class CanonicalBooleanToBoolean  extends NKFTransreptorImpl
{
	
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return ( aTo.isAssignableFrom(IAspectBoolean.class) );
	}
	
	protected void transrepresent(INKFConvenienceHelper context) throws Exception
	{	IAspectXDA xp=(IAspectXDA)context.sourceAspect(INKFRequestReadOnly.URI_SYSTEM, IAspectXDA.class);
		IXDAReadOnly dx=xp.getXDA();
		if(!dx.isTrue("/b")) throw new NetKernelException("Document is not a canonical boolean");
		String value=dx.getText("/b", true);
		boolean result;
		value=value.toUpperCase();
		if(value.equals("T") || value.equals("1") || value.equals("TRUE")) result=true;
		else if(value.equals("F") || value.equals("0") || value.equals("FALSE")) result=false;
		else throw new NetKernelException("Document element does not contain a valid boolean argument");
		IURRepresentation from=context.source(INKFRequestReadOnly.URI_SYSTEM);
		INKFResponse resp=context.createResponseFrom(from);
		resp.addAspect(new BooleanAspect(result));
		context.setResponse(resp);
	}	
}
