/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: JMSConnectionCreator.java,v $
 * Version:       $Name:  $ $Revision: 1.3 $
 * Last Modified: $Date: 2004/12/07 13:50:20 $
 *****************************************************************************/
package org.ten60.netkernel.jms;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.urrequest.*;

import org.ten60.netkernel.layer1.nkf.impl.NKFTransreptorImpl;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.util.SuperStackClassLoader;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;
/**
 * Transreptor to take an XML JMS configuration and change it into a JMSConnectionAspect
 * @author  tab
 */
public class JMSConnectionCreator extends NKFTransreptorImpl
{
	/** will work with pre-parsed or serialized XML */
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return (aFrom.hasAspect(IAspectXDA.class) || aFrom.hasAspect(IAspectBinaryStream.class)) 
			&& JMSConnectionAspect.class.isAssignableFrom(aTo);
	}

	/** Construct a JMSConnectionAspect based on the passed configuration */
	protected void transrepresent(INKFConvenienceHelper context) throws Exception
	{	IAspectXDA configuration = (IAspectXDA)context.sourceAspect(INKFRequestReadOnly.URI_SYSTEM,IAspectXDA.class);
		// load connection aspect using superstack classloader to ensure we find it in
		// our callers context.
		URRequest request = context.getKernelHelper().getThisKernelRequest();
		SuperStackClassLoader cl = new SuperStackClassLoader(request);
		Class c = cl.loadClass("org.ten60.netkernel.jms.JMSConnectionAspect");
		java.lang.reflect.Constructor cons=c.getConstructor(new Class[] {IXDAReadOnly.class});
		Thread.currentThread().setContextClassLoader(cl);
		IURAspect aspect = (IURAspect)cons.newInstance(new Object[]{configuration.getXDA()});
		INKFResponse response = context.createResponseFrom(aspect);
		response.setCreationCost(256);
		context.setResponse(response);
	}
}