/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: CookieAccessor.java,v $
 * Version:       $Name:  $ $Revision: 1.6 $
 * Last Modified: $Date: 2005/12/20 13:36:41 $
 *****************************************************************************/
package org.ten60.transport.http.cookie.accessor;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.transport.http.cookie.representation.*;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.IAspectBinaryStream;
import org.ten60.netkernel.xml.xda.*;

import org.ten60.netkernel.layer1.representation.MultiPartAspect;
import org.ten60.netkernel.layer1.representation.BooleanAspect;
import org.ten60.netkernel.layer1.representation.MonoRepresentationImpl;
import org.ten60.netkernel.layer1.meta.*;
import java.util.*;

/**
 *
 * @author  pjr
 */
public class CookieAccessor extends XAccessor
{
	
	/** Creates a new instance of CookieAccessor */
	public CookieAccessor()
	{	declareArgument(OPERAND, true, false);
		declareArgument(OPERATOR, true, false);
		declareArgument(PARAMETER, false, false);
		declareThreadSafe();
	}
	
	protected com.ten60.netkernel.urii.IURRepresentation source(XAHelper aHelper) throws Exception
	{	IXDAReadOnly opt=aHelper.getOperator().getXDA();
		IURRepresentation result=null;
		if(opt.isTrue("/cookie/set"))
		{	HashMap parts=new HashMap(1);
			IURRepresentation operand = aHelper.getOperand(IAspectBinaryStream.class);
			parts.put("cookie1", aHelper.getParameter(IAspectCookie.class));
			result=MultiPartAspect.create(operand,parts);
		}
		else if(opt.isTrue("/cookie/get"))
		{	String name=opt.getText("/cookie/get", false);
			IURRepresentation operand = aHelper.getOperand(MultiPartAspect.class);
			MultiPartAspect multipart=(MultiPartAspect)operand.getAspect(MultiPartAspect.class);
			DependencyMeta dm = new DependencyMeta(operand,4);
			IAspectCookie cookie=getCookie(name, multipart);
			result = new MonoRepresentationImpl(dm, cookie);
		}
		else if(opt.isTrue("/cookie/exists"))
		{	String name=opt.getText("/cookie/exists", false);
			IURRepresentation operand = aHelper.getOperand(MultiPartAspect.class);
			MultiPartAspect multipart=(MultiPartAspect)operand.getAspect(MultiPartAspect.class);
			DependencyMeta dm = new DependencyMeta(operand,4);
			IAspectCookie cookie=getCookie(name, multipart);
			result = new MonoRepresentationImpl(dm, new BooleanAspect(cookie!=null));
		}
		return result;
	}
	
	public static IAspectCookie getCookie(String name, MultiPartAspect multipart)
	{		IURRepresentation[] parts = multipart.getParts();
			IAspectCookie result=null;
			for (int i=0; i<parts.length;  i++)
			{	if (parts[i].hasAspect(IAspectCookie.class))
				{	IAspectCookie ck = (IAspectCookie)parts[i].getAspect(IAspectCookie.class);
					if (ck.getCookie().getName().equals(name))
					{	result=ck;
						break;
					}
				}
			}
			return result;
	}
	
}
