/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: HTTPBridgeZone.java,v $
  Version:       $Name:  $ $Revision: 1.6 $
  Last Modified: $Date: 2008/03/23 13:28:29 $
 *****************************************************************************/
package org.ten60.transport.http.bridge;

import java.util.*;
import java.util.regex.*;

/**
 *
 * @author  pjr
 */
public class HTTPBridgeZone
{	
	private Pattern mMatch;
	private boolean mProcessQueries=false;
	private boolean mPassMethod=false;
	private boolean mPassByURI=false;
	private boolean mPassCookies=false;
	private boolean mPassRequestURL=false;
	private List mPassHeaders=Collections.EMPTY_LIST;
	private String mExceptionURI;
	private int mMaximumEntitySize=-1;  //Defaults to unlimited
	private boolean mSOAPMode=false;
	private String mSOAPConfig;
	private boolean mPassRemoteHost=false;
	
	public void setMatch(String aMatch)
	{	mMatch=Pattern.compile(aMatch);
	}

	/** Test the URI against the match pattern */
	public boolean matches(String aURI)
	{	return mMatch.matcher(aURI).matches();
	}
	
	public void setProcessQueries(boolean aProcessQueries)
	{	mProcessQueries=aProcessQueries;
	}
	
	public boolean shouldProcessQueries()
	{	return mProcessQueries;
	}
	
	public void setPassMethod(boolean aPassMethod)
	{	mPassMethod=aPassMethod;
	}
	
	public boolean shouldPassMethod()
	{	return mPassMethod;
	}
	
	public void setPassByURI(boolean aPassByURI)
	{	mPassByURI=aPassByURI;
	}
	
	public boolean shouldPassByURI()
	{	return mPassByURI;
	}
	
	public void setPassCookies(boolean aPassCookies)
	{	mPassCookies=aPassCookies;
	}
	
	public boolean shouldPassCookies()
	{	return mPassCookies;
	}
	
	public void setHeaders(String aHeaders)
	{	StringTokenizer st=new StringTokenizer(aHeaders, " ");
		mPassHeaders=new ArrayList(st.countTokens());
		while(st.hasMoreElements())
		{	mPassHeaders.add(st.nextToken());
		}
	}
	
	public List getHeaders()
	{	return mPassHeaders;
	}
	
	public void setExceptionURI(String aExceptionURI)
	{	mExceptionURI=aExceptionURI;
	}
	
	public String getExceptionURI()
	{	return mExceptionURI;
	}
	
	public void setMaximumEntitySize(int aSize)
	{	mMaximumEntitySize=aSize;
	}
	
	public int getMaximumEntitySize()
	{	return mMaximumEntitySize;
	}
	
	public void setPassRequestURL(boolean aPassRequestURL)
	{	mPassRequestURL=aPassRequestURL;
	}
	
	public boolean shouldPassRequestURL()
	{	return mPassRequestURL;
	}
	
	public void setSOAPMode(boolean aSOAPMode)
	{	mSOAPMode=aSOAPMode;
	}
	
	public boolean isSOAPMode()
	{	return mSOAPMode;
	}
	
	public void setSOAPConfig(String aSOAPConfig)
	{	mSOAPConfig=aSOAPConfig;
	}
	
	public String getSOAPConfig()
	{	return mSOAPConfig;
	}
	
	public void setPassRemoteHost(boolean b)
	{	mPassRemoteHost=b;		
	}
	
	public boolean shouldPassRemoteHost()
	{	return mPassRemoteHost;
	}

/**
 * Returns an XML document with this zone's configuration
 *
 * @return
 */
  public String toStringXML()
  { StringBuffer sb = new StringBuffer(1024);
    sb.append("<zone>\n\r");
    sb.append("  <match>");
    sb.append(mMatch.pattern());
    sb.append("</match>\n\r");
    if(isSOAPMode())
    { sb.append("  <SOAPMode/>\n\r");
    }
    if(shouldProcessQueries())
    { sb.append("  <processQueries/>\n\r");
    }
    if(shouldPassCookies())
    { sb.append("  <passCookies/>\n\r");
    }
    if(shouldPassRemoteHost())
    { sb.append("  <passRemoteHost/>\n\r");
    }
    if(shouldPassMethod())
    { sb.append("  <passMethod/>\n\r");
    }
    if(shouldPassByURI())
    { sb.append("  <passByURI/>\n\r");
    }
    if(null != this.mExceptionURI)
    { sb.append("  <exceptionURI>");
      sb.append(this.mExceptionURI);
      sb.append("</exceptionURI>\n\r");
    }
    if(this.shouldPassRequestURL())
    { sb.append("  <passRequestURL/>\n\r");
    }
    if(-1 != this.mMaximumEntitySize)
    { sb.append("  <maxEntitySize>");
      sb.append(this.mMaximumEntitySize);
      sb.append("</maxEntitySize>\n\r");
    }

    sb.append("</zone>");
    return sb.toString();
  }
	
}
