/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.util;

import com.ten60.netkernel.util.SysLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtils {
    private static Map sSingletons = new WeakHashMap();
    private static DocumentBuilderFactory sFactory = DocumentBuilderFactory.newInstance();
    private static DocumentBuilder sBuilder;
    private Transformer mSerializer;

    private XMLUtils() {
    }

    public static XMLUtils getInstance() {
        XMLUtils singleton = (XMLUtils)sSingletons.get(Thread.currentThread());
        if (singleton == null) {
            try {
                singleton = new XMLUtils();
                sSingletons.put(Thread.currentThread(), singleton);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return singleton;
    }

    public static void destroyInstances() {
        sSingletons.clear();
        sFactory = null;
        sBuilder = null;
    }

    public static void destroyInstance() {
        sSingletons.remove(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document newDocument() {
        DocumentBuilder documentBuilder = sBuilder;
        synchronized (documentBuilder) {
            return sBuilder.newDocument();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toXML(Writer aWriter, Node aNode, boolean aIndent, boolean aOmitDeclaration, String aEncoding, int aIndentChars) throws IOException {
        Transformer t = this.getSerializer();
        t.setOutputProperty("method", "xml");
        t.setOutputProperty("encoding", aEncoding);
        t.setOutputProperty("omit-xml-declaration", aOmitDeclaration ? "yes" : "no");
        t.setOutputProperty("indent", aIndent ? "yes" : "no");
        t.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", Integer.toString(aIndentChars));
        Document d = XMLUtils.getDocumentFor(aNode);
        DOMSource s = new DOMSource(aNode);
        StreamResult r = new StreamResult(aWriter);
        Document document = d;
        synchronized (document) {
            try {
                t.transform(s, r);
            }
            catch (TransformerException e) {
                throw new IOException(e.getMessageAndLocation());
            }
        }
    }

    public String toXML(Node aNode, boolean aIndent, boolean aOmitDeclaration) {
        try {
            StringWriter sw = new StringWriter(1024);
            this.toXML(sw, aNode, aIndent, aOmitDeclaration, "UTF-8", 4);
            return new String(sw.getBuffer());
        }
        catch (IOException e) {
            return "";
        }
    }

    private Transformer getSerializer() {
        if (this.mSerializer == null) {
            try {
                Transformer t;
                System.getProperties().remove("javax.xml.transform.TransformerFactory");
                TransformerFactory tf = TransformerFactory.newInstance();
                this.mSerializer = t = tf.newTransformer();
            }
            catch (TransformerConfigurationException e) {
                e.printStackTrace();
                System.out.println("cause:");
                e.getCause().printStackTrace();
            }
            catch (TransformerFactoryConfigurationError e) {
                e.printStackTrace();
            }
        }
        return this.mSerializer;
    }

    public static String escape(String aXML) {
        int length = aXML.length();
        StringBuffer result = new StringBuffer(length * 2);
        boolean changed = false;
        block7: for (int i = 0; i < length; ++i) {
            char c = aXML.charAt(i);
            switch (c) {
                case '<': {
                    result.append("&lt;");
                    changed = true;
                    continue block7;
                }
                case '>': {
                    result.append("&gt;");
                    changed = true;
                    continue block7;
                }
                case '\'': {
                    result.append("&apos;");
                    changed = true;
                    continue block7;
                }
                case '\"': {
                    result.append("&quot;");
                    changed = true;
                    continue block7;
                }
                case '&': {
                    result.append("&amp;");
                    changed = true;
                    continue block7;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return changed ? new String(result) : aXML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parse(Reader aReader) throws IOException, SAXException {
        InputSource is = new InputSource(aReader);
        DocumentBuilder documentBuilder = sBuilder;
        synchronized (documentBuilder) {
            return sBuilder.parse(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parse(InputStream aStream) throws IOException, SAXException {
        InputSource is = new InputSource(aStream);
        DocumentBuilder documentBuilder = sBuilder;
        synchronized (documentBuilder) {
            return sBuilder.parse(is);
        }
    }

    public static String getPathFor(Node aNode) {
        StringBuffer result = new StringBuffer(128);
        Node node = aNode;
        block4: while (node != null) {
            switch (node.getNodeType()) {
                case 2: {
                    result.insert(0, aNode.getNodeName());
                    result.insert(0, "/@");
                    Attr a = (Attr)node;
                    node = a.getOwnerElement();
                    continue block4;
                }
                case 1: {
                    int countInParent = 0;
                    int indexInParent = -1;
                    Node parent = node.getParentNode();
                    String name = node.getNodeName();
                    for (Node n = parent.getFirstChild(); n != null; n = n.getNextSibling()) {
                        if (!(n instanceof Element)) continue;
                        if (n == node) {
                            indexInParent = countInParent++;
                            continue;
                        }
                        if (!n.getNodeName().equals(name)) continue;
                        ++countInParent;
                        if (indexInParent >= 0) break;
                    }
                    if (countInParent > 1) {
                        result.insert(0, ']');
                        result.insert(0, indexInParent + 1);
                        result.insert(0, '[');
                    }
                    result.insert(0, name);
                    result.insert(0, '/');
                    node = parent;
                    continue block4;
                }
            }
            node = node.getParentNode();
        }
        return new String(result);
    }

    public static String getText(Node aNode) {
        StringBuffer result = null;
        String result2 = null;
        for (Node n = aNode.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 3 && n.getNodeType() != 4) continue;
            String s = n.getNodeValue();
            if (result2 == null) {
                result2 = s;
                continue;
            }
            if (result == null) {
                result = new StringBuffer(result2.length() + s.length());
                result.append(result2);
                result.append(s);
                continue;
            }
            result.append(s);
        }
        if (result == null) {
            if (result2 == null) {
                result2 = "";
            }
        } else {
            result2 = new String(result);
        }
        return result2;
    }

    public static void setText(Element aElement, String aText) {
        Node n = aElement.getFirstChild();
        while (n != null) {
            if (n.getNodeType() == 3 || n.getNodeType() == 4) {
                Node oldn = n;
                n = n.getNextSibling();
                aElement.removeChild(oldn);
                continue;
            }
            n = n.getNextSibling();
        }
        Text t = aElement.getOwnerDocument().createTextNode(aText);
        aElement.appendChild(t);
    }

    public static Element getNextSiblingElement(Node aNode) {
        Element result = null;
        for (Node n = aNode.getNextSibling(); n != null; n = n.getNextSibling()) {
            if (!(n instanceof Element)) continue;
            result = (Element)n;
            break;
        }
        return result;
    }

    public static Element getFirstChildElement(Node aNode) {
        Element result = null;
        for (Node n = aNode.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!(n instanceof Element)) continue;
            result = (Element)n;
            break;
        }
        return result;
    }

    public static Element depthFirstTraversalNextElement(Node aNode) {
        Element result = XMLUtils.getFirstChildElement(aNode);
        if (result == null) {
            result = XMLUtils.getNextSiblingElement(aNode);
        }
        return result;
    }

    public static Element inOrderTraversalNext(Node aNode, Node aRoot) {
        Node parent;
        Element result = XMLUtils.getFirstChildElement(aNode);
        if (result == null) {
            if (aNode != aRoot) {
                result = XMLUtils.getNextSiblingElement(aNode);
            } else {
                return null;
            }
        }
        if (result == null && (parent = aNode.getParentNode()) != aRoot && parent instanceof Element) {
            result = XMLUtils.getNextSiblingElement(parent);
        }
        return result;
    }

    public static Document getDocumentFor(Node aNode) {
        Document result = aNode instanceof Document ? (Document)aNode : aNode.getOwnerDocument();
        return result;
    }

    public static void appendTextedElement(Node aParent, String aName, String aValue) {
        Document d = aParent.getOwnerDocument();
        Element e = d.createElement(aName);
        Text t = d.createTextNode(aValue);
        e.appendChild(t);
        aParent.appendChild(e);
    }

    public static void write(Writer osw, String aName, String aValue) throws IOException {
        osw.write(60);
        osw.write(aName);
        osw.write(62);
        osw.write(aValue);
        osw.write("</");
        osw.write(aName);
        osw.write(62);
    }

    static {
        sFactory.setNamespaceAware(true);
        try {
            sFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", new Boolean(false));
        }
        catch (IllegalArgumentException iae) {
            SysLogger.log(2, sFactory, "JAXP Config Warning, be careful with external references:" + iae.getMessage());
        }
        try {
            sBuilder = sFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            SysLogger.log(3, sFactory, "ParserConfigurationException:" + e.getMessage());
        }
    }
}

