/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FastXPath {
    private static Map mCachedEvals = new HashMap(128);

    public static List eval(Node aContextNode, String aXPath) throws TransformerException {
        SimpleEvalStruct levels;
        ArrayList<Node> ns = new ArrayList<Node>();
        Object found = null;
        if (aXPath.charAt(0) == '/' && !(aContextNode instanceof Document)) {
            aContextNode = aContextNode.getOwnerDocument();
        }
        if ((levels = (SimpleEvalStruct)mCachedEvals.get(aXPath)) == null) {
            levels = new SimpleEvalStruct(aXPath);
            mCachedEvals.put(aXPath, levels);
        }
        try {
            if (levels.size() > 0) {
                FastXPath.evalDescend(ns, aContextNode, levels, 0);
            } else {
                ns.add(aContextNode);
            }
            return ns;
        }
        catch (Exception e) {
            throw new TransformerException(aXPath + " is malformed");
        }
    }

    public static Node getSingleNode(Node aContextNode, String aXPath) throws TransformerException {
        List ns = FastXPath.eval(aContextNode, aXPath);
        if (ns.size() == 0) {
            return null;
        }
        return (Node)ns.get(0);
    }

    private static void evalDescend(List aResult, Node aCurrent, SimpleEvalStruct aLevels, int aDepth) {
        List ns = aLevels.findMatch(aCurrent, aDepth);
        if (ns != null) {
            if (aDepth != aLevels.size() - 1) {
                for (int i = ns.size() - 1; i >= 0; --i) {
                    Node n = (Node)ns.get(i);
                    FastXPath.evalDescend(aResult, n, aLevels, aDepth + 1);
                }
            } else {
                aResult.addAll(ns);
            }
        }
    }

    public static boolean isSuitable(String aXPath) {
        int length = aXPath.length();
        boolean simple = length > 0;
        int c1 = 0;
        for (int i = length - 1; i >= 0; --i) {
            boolean doubleSlash;
            char c = aXPath.charAt(i);
            boolean validChar = c >= 'a' && c <= 'z' || c >= 'A' && c <= '[' || c >= '/' && c <= '9' || c == ']' || c == '*';
            boolean bl = doubleSlash = c == '/' && c1 == 47;
            if (!validChar || doubleSlash) {
                simple = false;
                break;
            }
            c1 = c;
        }
        return simple;
    }

    private static class SimpleEvalStruct {
        String[] mNames;
        int[] mIndices;

        public SimpleEvalStruct(String aXPath) {
            StringTokenizer stz = new StringTokenizer(aXPath, "/");
            int length = stz.countTokens();
            this.mNames = new String[length];
            this.mIndices = new int[length];
            for (int i = 0; i < length; ++i) {
                String token = stz.nextToken();
                int i1 = token.indexOf(91);
                if (i1 >= 0) {
                    int i2 = token.indexOf(93);
                    String indexString = token.substring(i1 + 1, i2);
                    this.mIndices[i] = Integer.parseInt(indexString);
                    this.mNames[i] = token.substring(0, i1);
                } else {
                    this.mIndices[i] = -1;
                    this.mNames[i] = token;
                }
                if (!this.mNames[i].equals("*")) continue;
                this.mNames[i] = null;
            }
        }

        public final List findMatch(Node aNode, int aDepth) {
            ArrayList<Node> result = null;
            int foundIndex = 0;
            String name = this.mNames[aDepth];
            int index = this.mIndices[aDepth];
            for (Node n = aNode.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (!(n instanceof Element) || name != null && !n.getNodeName().equals(name) || index != -1 && ++foundIndex != index) continue;
                if (result == null) {
                    result = new ArrayList<Node>(16);
                }
                result.add(n);
            }
            return result;
        }

        public final int size() {
            return this.mNames.length;
        }
    }
}

