/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.urii.aspect;

import com.ten60.netkernel.urii.IURMeta;
import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.urii.aspect.IAspectReadableBinaryStream;
import com.ten60.netkernel.urii.aspect.IAspectString;
import com.ten60.netkernel.urii.representation.MonoRepresentationImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;

public class StringAspect
implements IAspectReadableBinaryStream,
IAspectString {
    private String mString;
    private String mEncoding;
    private byte[] mBytes;

    public StringAspect(String aString) {
        this(aString, "UTF-8");
    }

    public StringAspect(String aString, String aEncoding) {
        this.mString = aString;
        this.mEncoding = aEncoding;
    }

    public String getString() {
        return this.mString;
    }

    public void write(OutputStream aStream) throws IOException {
        this.ensureBytes();
        aStream.write(this.mBytes);
        aStream.flush();
    }

    public int getContentLength() {
        this.ensureBytes();
        return this.mBytes.length;
    }

    public InputStream getInputStream() throws IOException {
        this.ensureBytes();
        return new ByteArrayInputStream(this.mBytes);
    }

    private void ensureBytes() {
        if (this.mBytes == null) {
            try {
                this.mBytes = this.mString.getBytes(this.mEncoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("unsupported encoding " + this.mEncoding);
            }
        }
    }

    public static IURRepresentation create(IURMeta aMeta, String aString) {
        return new MonoRepresentationImpl(aMeta, new StringAspect(aString));
    }

    public String getEncoding() {
        return this.mEncoding;
    }

    public Reader getReader() {
        return new StringReader(this.mString);
    }
}

