/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.urii;

public final class URIdentifier {
    private String mString;
    private static long sTag;
    private static Object sSynchDummy;

    public URIdentifier(String aString) {
        this.mString = aString;
    }

    public String toString() {
        return this.mString;
    }

    public boolean equals(Object aOther) {
        boolean result = false;
        if (aOther instanceof URIdentifier) {
            URIdentifier other = (URIdentifier)aOther;
            result = other.mString.equals(this.mString);
        }
        return result;
    }

    public int hashCode() {
        return this.mString.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URIdentifier getUnique(String aPrefix) {
        long tag;
        Object object = sSynchDummy;
        synchronized (object) {
            tag = sTag++;
        }
        return new URIdentifier(aPrefix + Long.toString(tag));
    }

    public static URIdentifier fromEscaped(String aURI) {
        return new URIdentifier(URIdentifier.decode(aURI));
    }

    private static String decode(String aInput) {
        StringBuffer sb = new StringBuffer(aInput.length());
        int length = aInput.length();
        for (int i = 0; i < length; ++i) {
            char c;
            char r = c = aInput.charAt(i);
            if (c == '%') {
                int c1 = URIdentifier.toHex(aInput.charAt(++i));
                int c2 = URIdentifier.toHex(aInput.charAt(++i));
                r = (char)((c1 << 4) + c2);
            }
            sb.append(r);
        }
        return new String(sb);
    }

    private static int toHex(char aChar) {
        int result = 0;
        if (aChar <= '9' && aChar >= '0') {
            result = aChar - 48;
        } else if (aChar <= 'Z' && aChar >= 'A') {
            result = aChar - 55;
        }
        return result;
    }

    public String getScheme() {
        String result = null;
        int i1 = this.mString.indexOf(58);
        if (i1 > 0) {
            result = this.mString.substring(0, i1);
        }
        return result;
    }

    public String getFragment() {
        String result = null;
        int i1 = this.mString.indexOf(35);
        if (i1 >= 0 && i1 < this.mString.length() - 1) {
            result = this.mString.substring(i1 + 1);
        }
        return result;
    }

    public URIdentifier withoutFragment() {
        URIdentifier result = this;
        int i1 = this.mString.indexOf(35);
        if (i1 >= 0) {
            result = new URIdentifier(this.mString.substring(0, i1));
        }
        return result;
    }

    public URIdentifier withFragment(String aFragment) {
        URIdentifier result = new URIdentifier(this.withoutFragment().toString() + "#" + aFragment);
        return result;
    }

    public String getSchemeSpecificPart() {
        int i1 = this.mString.indexOf(58);
        i1 = i1 < 0 ? 0 : ++i1;
        int i2 = this.mString.indexOf(35);
        if (i2 < 0) {
            i2 = this.mString.length();
        }
        String result = this.mString.substring(i1, i2);
        return result;
    }

    static {
        sSynchDummy = new Boolean(true);
    }
}

