/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.transport;

import com.ten60.netkernel.module.ModuleDefinition;
import com.ten60.netkernel.transport.ITransport;

public class TransportDeploymentRecord {
    private final ITransport mTransport;
    private final ModuleDefinition mModule;
    private int mIndex;
    private long[] mStats;
    private long mWork;

    public TransportDeploymentRecord(ITransport aTransport, ModuleDefinition aModule, int aStatBufferSize) {
        this.mTransport = aTransport;
        this.mModule = aModule;
        this.mStats = new long[aStatBufferSize];
    }

    public ITransport getTransport() {
        return this.mTransport;
    }

    public String getTransportClass() {
        return this.mTransport.getClass().getName();
    }

    public ModuleDefinition getModule() {
        return this.mModule;
    }

    public void accumulateWork(int aWork, int aIndex) {
        if (aIndex != this.mIndex) {
            this.mStats[aIndex] = this.mWork * 2L / 3L;
            this.mIndex = aIndex;
            this.mWork /= 3L;
        }
        this.mWork += (long)aWork;
    }

    public long[] getWork() {
        return this.mStats;
    }
}

