/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.transport;

import com.ten60.netkernel.transport.ThrottleOverloadException;

public class Throttle {
    private int mMaxCount;
    private int mQueueMax;
    private int mCount;
    private int mQueue;

    public Throttle() {
        this.setMaxCount(5);
        this.setMaxQueue(10);
    }

    public void setMaxCount(int aCount) {
        this.mMaxCount = aCount;
    }

    public void setMaxQueue(int aCount) {
        this.mQueueMax = aCount;
    }

    public synchronized void throttle() throws InterruptedException, ThrottleOverloadException {
        if (this.mCount < this.mMaxCount) {
            ++this.mCount;
        } else if (this.mQueue < this.mQueueMax) {
            ++this.mQueue;
            while (this.mCount >= this.mMaxCount) {
                this.wait();
            }
            ++this.mCount;
            --this.mQueue;
        } else {
            throw new ThrottleOverloadException();
        }
    }

    public synchronized void notifyOfReturn() {
        if (this.mQueue > 0) {
            this.notify();
        }
        --this.mCount;
    }

    public synchronized boolean isBusy() {
        return this.mCount > 0 || this.mQueue > 0;
    }

    public int getConcurrentCount() {
        return this.mCount;
    }

    public int getQueueSize() {
        return this.mQueue;
    }
}

