/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.module.rewrite;

import com.ten60.netkernel.urii.URIdentifier;
import com.ten60.netkernel.util.SysLogger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RegexRewriterRule {
    private Matcher mMatcher;
    private Matcher mToMatcher;
    private String mTo;

    public RegexRewriterRule(String aPattern, String aTo) {
        Pattern pattern = Pattern.compile(aPattern);
        this.mMatcher = pattern.matcher("");
        Pattern groupPattern = Pattern.compile("\\$(e?\\d+)");
        this.mTo = aTo;
        this.mToMatcher = groupPattern.matcher(aTo);
    }

    public synchronized URIdentifier map(URIdentifier aURI) {
        URIdentifier result = aURI;
        this.mMatcher = this.mMatcher.reset(aURI.toString());
        String replace = this.mTo;
        if (this.mMatcher.matches()) {
            this.mToMatcher.reset(replace);
            StringBuffer sb = new StringBuffer(replace.length() * 2);
            while (this.mToMatcher.find()) {
                String toMatch = this.mToMatcher.group(1);
                int action = 32;
                if (!Character.isDigit(toMatch.charAt(0))) {
                    action = toMatch.charAt(0);
                    toMatch = toMatch.substring(1);
                }
                int j = Integer.parseInt(toMatch);
                String replacement = this.mMatcher.group(j);
                switch (action) {
                    case 101: {
                        replacement = RegexRewriterRule.encode(replacement);
                    }
                }
                this.mToMatcher.appendReplacement(sb, replacement);
            }
            this.mToMatcher.appendTail(sb);
            result = new URIdentifier(sb.toString());
            if (SysLogger.shouldLog(0, this)) {
                SysLogger.log(0, this, "Rewrote: " + aURI.toString() + " to " + result + " using " + this.mMatcher.pattern().pattern());
            }
        }
        return result;
    }

    public synchronized boolean matches(CharSequence aString) {
        this.mMatcher.reset(aString);
        return this.mMatcher.matches();
    }

    public static String encode(String aInput) {
        StringBuffer sb = new StringBuffer(aInput.length() * 3 / 2);
        int length = aInput.length();
        block9: for (int i = 0; i < length; ++i) {
            char c = aInput.charAt(i);
            switch (c) {
                case ' ': {
                    sb.append("%20");
                    continue block9;
                }
                case '%': {
                    sb.append("%25");
                    continue block9;
                }
                case ':': {
                    sb.append("%3A");
                    continue block9;
                }
                case '#': {
                    sb.append("%23");
                    continue block9;
                }
                case '+': {
                    sb.append("%2B");
                    continue block9;
                }
                case '@': {
                    sb.append("%40");
                    continue block9;
                }
                case '=': {
                    sb.append("%3D");
                    continue block9;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return new String(sb);
    }
}

