/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.cache;

import com.ten60.netkernel.cache.ICachelet;
import com.ten60.netkernel.container.ComponentImpl;
import com.ten60.netkernel.container.Container;
import com.ten60.netkernel.module.ModuleDefinition;
import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.urii.URIdentifier;
import com.ten60.netkernel.urii.aspect.VoidAspect;
import com.ten60.netkernel.urrequest.URRequest;
import com.ten60.netkernel.urrequest.URResult;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.util.XMLUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Cache
extends ComponentImpl {
    public static final URIdentifier URI = new URIdentifier("netkernel:cache");
    public static final IURRepresentation EXPIRED_RESOURCE = VoidAspect.create();
    private Set mCacheModules = new HashSet();
    private ICachelet mDefaultCache;

    public Cache() {
        super(URI);
    }

    public void registerCacheletModule(ModuleDefinition aModule) {
        this.mCacheModules.add(aModule);
    }

    public void registerDefaultCacheletModule(ModuleDefinition aModule) {
        this.mDefaultCache = aModule.getCache();
    }

    private ICachelet getCacheForRequest(URRequest aRequest) {
        ModuleDefinition module = (ModuleDefinition)aRequest.getContext();
        ICachelet result = module.getCache();
        if (result == null) {
            List superStack = aRequest.getSuperStack();
            for (int i = superStack.size() - 1; i >= 0 && (result = (module = (ModuleDefinition)superStack.get(i)).getCache()) == null; --i) {
            }
        }
        if (result == null) {
            result = this.mDefaultCache;
        }
        return result;
    }

    public void start(Container aContainer) throws NetKernelException {
    }

    public void stop() throws NetKernelException {
        this.mDefaultCache = null;
        this.mCacheModules.clear();
    }

    public IURRepresentation get(URRequest aRequest) throws NetKernelException {
        IURRepresentation result = null;
        ICachelet cache = this.getCacheForRequest(aRequest);
        if (cache != null) {
            try {
                result = cache.get(aRequest);
            }
            catch (Exception ex) {
                NetKernelException e = new NetKernelException("Unhandled exception in Cache.get()", null, aRequest.toString());
                e.addCause(ex);
                throw e;
            }
        }
        return result;
    }

    public void put(URResult aResult) throws NetKernelException {
        ICachelet cache = this.getCacheForRequest(aResult.getRequest());
        if (cache != null) {
            try {
                cache.put(aResult);
            }
            catch (Exception ex) {
                NetKernelException e = new NetKernelException("Unhandled exception in Cache.put()", null, aResult.getRequest().toString());
                e.addCause(ex);
                throw e;
            }
        }
    }

    public void write(OutputStream aStream) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(aStream);
        osw.write("<cache>");
        Iterator i = this.mCacheModules.iterator();
        while (i.hasNext()) {
            ModuleDefinition md = (ModuleDefinition)i.next();
            ICachelet cache = md.getCache();
            this.writeCachelet(osw, md, cache);
            for (cache = cache.getBackingCache(); cache != null; cache = cache.getBackingCache()) {
                this.writeCachelet(osw, md, cache);
            }
        }
        osw.write("</cache>");
        osw.flush();
    }

    private void writeCachelet(OutputStreamWriter aStream, ModuleDefinition aModule, ICachelet aCachelet) throws IOException {
        aStream.write("<cachelet>");
        aStream.write("<module>");
        aStream.write(XMLUtils.escape(aModule.getURI().toString()));
        aStream.write("</module>");
        aStream.write("<class>");
        aStream.write(aCachelet.getClass().getName());
        aStream.write("</class>");
        aStream.write("<data>");
        aCachelet.write(aStream);
        aStream.write("</data>");
        aStream.write("</cachelet>");
    }
}

