<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
    <xsl:output method="xml"/>

    <xsl:template match="/">
        <div>
			<form>
				<input id="search" type="text" value="" onchange="searchImpl()"/>
				<span style="font-size: 9px; margin-top: 2px;" class="titlebar" >
				<a href="xrl:admin" xrl:resolve="href" onclick="searchImpl()"><span class="aa">&#160;</span><span class="bb">search</span><span class="cc">&#160;</span></a>
				</span>
			</form>	
			<span style="font-size: 9px; margin-top: 2px;" class="titlebar" >
				<a href="javascript:LFV('[[xrl:selector]]/0','selector')" xrl:resolve="href"><span class="aa">&#160;</span><span class="bb">selector</span><span class="cc">&#160;</span></a>
			</span>
			<span style="font-size: 9px; margin-top: 2px;" class="titlebar" >
				<a href="javascript:LFV('[[xrl:history]]','selector')" xrl:resolve="href"><span class="aa">&#160;</span><span class="bb">history</span><span class="cc">&#160;</span></a>
			</span>
			<br/>
			
            <xsl:apply-templates/>
        </div>
    </xsl:template>
	
	<xsl:template match="songlist">
		<xsl:for-each select="parent">
			<a href="javascript:LFV('[[xrl:selector]]/{id}','selector')" xrl:resolve="href"><xsl:value-of select="name"/></a>
			<xsl:if test="position()!=last()"> / </xsl:if>
		</xsl:for-each>		
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="history">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="parent"/>
	
	<xsl:template match="searchlist">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="search">
		search: 
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="dir">
		<div>
		<a href="javascript:LFV('[[xrl:selector]]/{id}','selector')" xrl:resolve="href" title="Directory"><img src="xrl:img_dir" border="0" width="17" height="17" xrl:resolve="src" /></a>
		<xsl:value-of select="name"/>
		</div>
	</xsl:template>
	
	<xsl:template match="item">
		<div>
		<a href="javascript:LFV('[[xrl:add-song]]?id={id}','status')" xrl:resolve="href" title="Add to Queue"><img src="xrl:img_queue" width="17" height="17" border="0" xrl:resolve="src"/></a>
		<xsl:value-of select="name"/>
		</div>
	</xsl:template>
	
</xsl:stylesheet>
