/******************************************************************************
  (c) Copyright 2002-2006, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: PingPongTransport.java,v $
  Version:       $Name:  $ $Revision: 1.4 $
  Last Modified: $Date: 2006/03/02 15:12:02 $
 *****************************************************************************/
package org.ten60.netkernel.pingpong.transport;

import org.ten60.netkernel.pingpong.model.*;

import com.ten60.netkernel.urii.aspect.IAspectReadableBinaryStream;
import com.ten60.netkernel.urii.aspect.IAspectBoolean;
import com.ten60.netkernel.urii.aspect.BooleanAspect;
import com.ten60.netkernel.util.NetKernelException;

import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.NKFTransportImpl;
import org.ten60.netkernel.layer1.representation.ByteArrayAspect;
import org.ten60.netkernel.layer1.util.Utils;
import org.ten60.netkernel.xml.representation.IAspectXDA;
import org.ten60.netkernel.xml.xda.IXDAReadOnly;

import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.io.ByteArrayOutputStream;

/**
 * NetKernel transport that initialised and destroys frame and sends timed requests into kernel
 * @author  tab
 */
public class PingPongTransport extends NKFTransportImpl
{	
	/** thread to poll for visibility/audibility state */
	private PingPongPollThread mThread;
	/** true if we should make noise */
	private boolean mAudible=false;
	/** contains the frame reference if we are visible */
	private PingPongFrame mVisible;
	/** last position **/
	private Point mLastLocation;
	
	/** part of the transport interface is to give a description */
	public String getDescription()
	{	return "PingPong";
	}
	
	/** startTransport is called by the kernel when the transport is started
	 */
	protected void startTransport() throws Exception
	{	mThread = new PingPongPollThread();
		mThread.start();
	}
	
	/** stopTransport is called by the kernel to shutdown the transport
	 */
	protected void stopTransport()
	{	mThread.setStopped();
		try
		{	mThread.join();
		} catch (InterruptedException e) {;}
	}
	
	boolean isAudible()
	{	return mAudible;
	}
	
	/** expose request context to module
	 */
	INKFConvenienceHelper getRequestContext()
	{	return getContext();
	}
	
	class PingPongPollThread extends Thread
	{
		private boolean mStopRequested=false;
		
		public void setStopped()
		{	mStopRequested=true;
		}
		
		public void run()
		{	while (!mStopRequested)
			{	//check visibility and audibiliy
				boolean isVisible=false;
				
				try
				{	isVisible=((IAspectBoolean)getRequestContext().sourceAspect("ffcpl:/pingpong/isVisible", IAspectBoolean.class)).isTrue();
					mAudible=((IAspectBoolean)getRequestContext().sourceAspect("ffcpl:/pingpong/isAudible", IAspectBoolean.class)).isTrue();
				}
				catch (NKFException e)
				{	System.out.println(e.toString());
				}
			
				//create frame if necessary
				if (isVisible && mVisible==null)
				{	try
					{	mVisible = new PingPongFrame(PingPongTransport.this,mLastLocation);
					}
					catch (Exception e)
					{	e.printStackTrace();
					}
				}
				//close frame if necessary
				if (mVisible!=null && !isVisible)
				{	mLastLocation=mVisible.getLocation();
					mVisible.stop();
					mVisible=null;
				}
				
				// sleep for a bit
				try
				{	Thread.currentThread().sleep(1000);
				} catch (InterruptedException e)
				{
				}
			}
		}
		
	}
	
}