/******************************************************************************
  (c) Copyright 2002-2006, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: BallsAspect.java,v $
  Version:       $Name:  $ $Revision: 1.1 $
  Last Modified: $Date: 2006/02/20 16:56:30 $
 *****************************************************************************/
package org.ten60.netkernel.pingpong.representation;

import com.ten60.netkernel.urii.IURAspect;
import java.util.*;
/**
 *
 * @author  tab
 */
public class BallsAspect implements IURAspect
{
	ArrayList mBalls;

	
	public BallsAspect(int aCount, int aX, int aY, float aSpread, float aVelocity, float aMomentumOffset)
	{	mBalls = new ArrayList(aCount);
		for (int i=0; i<aCount; i++)
		{	float direction=(float)(2.0*Math.PI*Math.random());
			float distance=(float)(aSpread*Math.random());
			float x = aX+(float)Math.sin(direction)*distance;
			float y = aY+(float)Math.cos(direction)*distance;
			float velocity=(float)(aVelocity*Math.random());
			direction+=(float)2.0*Math.PI*aMomentumOffset;
			float xv = (float)Math.sin(direction)*velocity;
			float yv = (float)Math.cos(direction)*velocity;
			
			Ball b = new Ball(x,y,xv,yv);
			mBalls.add(b);
		}
	}
	
	public List getBalls()
	{	return mBalls;
	}
	
	public static class Ball
	{
		public float mX, mY, mDX, mDY;
		
		public Ball(float aX, float aY, float aDX, float aDY)
		{	mX=aX;
			mY=aY;
			mDX=aDX;
			mDY=aDY;
		}
	}
}