/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: TransientDataAccessor.java,v $
  Version:       $Name:  $ $Revision: 1.1 $
  Last Modified: $Date: 2006/02/20 16:55:35 $
 *****************************************************************************/
package org.ten60.netkernel.pingpong.model;

import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.NKFAccessorImpl;
import com.ten60.netkernel.urii.*;
import java.util.*;

/**
 * Stores state between invocations
 * @author  tab
 */
public class TransientDataAccessor extends NKFAccessorImpl
{
    private final static Map mDocuments = new HashMap();
    
    public TransientDataAccessor()
    {   super(4,false,INKFRequestReadOnly.RQT_SOURCE|INKFRequestReadOnly.RQT_SINK|INKFRequestReadOnly.RQT_DELETE);
    }
	
 public void processRequest(INKFConvenienceHelper context) throws Exception
    {   switch (context.getThisRequest().getRequestType())
        {   case INKFRequestReadOnly.RQT_SOURCE:
                source(context);
                break;
            case INKFRequestReadOnly.RQT_SINK:
                sink(context);
                break;
            case INKFRequestReadOnly.RQT_DELETE:
                delete(context);
                break;
        }       
    }
    
    public void source(INKFConvenienceHelper context) throws Exception
    {   // use the URI as the key into the map
        String path = context.getThisRequest().getURIWithoutFragment();
        Holder h = (Holder)mDocuments.get(path);
        if (h==null)
        {  throw new Exception("Resource not found");
        }
        else
        {   INKFResponse resp = context.createResponseFrom(h);
	        context.setResponse(resp);
        }
    }
    public void delete(INKFConvenienceHelper context) throws Exception
    {
        String path = context.getThisRequest().getURIWithoutFragment();
        Object o = mDocuments.remove(path);
        INKFResponse resp = context.createResponseFrom(new BooleanAspect(o!=null));
	    context.setResponse(resp);
    }
    
    public void sink(INKFConvenienceHelper context) throws Exception
    {
        // sink requests pass representation to sink with the URI_SYSTEM uri
        IURRepresentation rep = context.source(INKFRequestReadOnly.URI_SYSTEM);
        // get the first aspect (assume it is the one and only)
        IURAspect aspect = (IURAspect)rep.getAspects().iterator().next();
        String path = context.getThisRequest().getURIWithoutFragment();
		Holder h = new Holder(aspect);
		
        Holder old = (Holder)mDocuments.put(path,h);
		if (old!=null)
		{	old.setExpired();
		}
        // if we set no response then a void result is assumed
    }	
	
	
	private class Holder implements IURRepresentation
	{
		private boolean mExpired;
		private IURAspect mAspect;
		private IURMeta mMeta;
	
		public Holder(IURAspect aAspect)
		{	mAspect = aAspect;
			mMeta = createMeta();
			mExpired=false;
		}
		
		private IURMeta createMeta()
		{	return new MetaImpl("context/unknown", 0, 0)
			{	public boolean isExpired()
				{	return mExpired;
				}
				public String toString() { return "Holder meta!";};
			};
		}
		
		public void setExpired()
		{	mExpired=true;
		}
		
		public IURAspect getAspect(Class aAspectClass)
		{	if (mAspect.getClass().isAssignableFrom(aAspectClass))
			{	return mAspect;
			}
			return null;
		}
		
		public Collection getAspects()
		{	return Collections.singletonList(mAspect);
		}
		
		public IURMeta getMeta()
		{	return mMeta;
		}
		
		public boolean hasAspect(Class aAspectClass)
		{	return mAspect.getClass().isAssignableFrom(aAspectClass);
		}
	}		
}