/*
 * NKDummySubmissionDriver.java
 *
 * Created on 03 November 2003, 12:04
 */

package org.ten60.netkernel.xforms.connector;

import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.util.*;
import org.chiba.xml.xforms.connector.*;
import org.chiba.xml.xforms.exception.*;
import org.chiba.xml.xforms.*;
import org.chiba.xml.util.*;
import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.stream.*;

import java.util.*;
import java.io.*;
import org.w3c.dom.*;
/**
 *	A dummy submission driver that wraps the submission data and URI so that the
 *	controller layer can decided how it wants to handle it.
 * @author  pjr
 */
public class NKDummySubmissionDriver implements SubmissionHandler
{	
	public static final String NK_FORWARD_PAYLOAD="NK_FORWARD_PAYLOAD";
	String mURI;
	
	
	/** Creates a new instance of NKDummySubmissionDriver */
	public NKDummySubmissionDriver()
	{
	}
	
	public void setURI(String uri)
	{	mURI=uri;
	}
	
	public java.util.Map submit(org.chiba.xml.xforms.Submission submission, org.w3c.dom.Node instance) throws org.chiba.xml.xforms.exception.XFormsException
	{	HashMap response=new HashMap(1);
		try
		{	StringBuffer sb=new StringBuffer(2048);
			sb.append("<forward><action>");
			sb.append(mURI);
			sb.append("</action><data>");
			sb.append(toXML(instance));
			sb.append("</data></forward>");
			response.put(NK_FORWARD_PAYLOAD, sb.toString()  );
		}
		catch(Throwable e)
		{	e.printStackTrace();
			throw new XFormsException(e.getMessage());	
		}
		return response;
	}
	
	private String toXML (Node instance) throws Exception {
        
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DOMSerializer serializer = new DOMSerializer();
		serializer.setDeclarationOmitting(true);
        serializer.setEncoding("UTF-8");
        serializer.setIndentation("\t");
        serializer.setLineBreaking(true);
        serializer.setOutputStream(stream);
        serializer.setWhitespaceIgnoring(true);
        serializer.serialize(instance);

        return stream.toString();
    }

	public String getURI()
	{	/*Return null for the moment*/
		return null;
	}	
	
	/*
	public void toXML(Writer aWriter, Node aNode, boolean aIndent, boolean aOmitDeclaration, String aEncoding, int aIndentChars) throws  Throwable
	{	Transformer t=null;
		try
		{	TransformerFactory tf=TransformerFactory.newInstance();
			t=tf.newTransformer();
		}
		catch(TransformerConfigurationException e)
		{	e.printStackTrace();
			throw e;
		}
		t.setOutputProperty( OutputKeys.METHOD,"xml");
		t.setOutputProperty( OutputKeys.ENCODING,aEncoding);
		t.setOutputProperty( OutputKeys.OMIT_XML_DECLARATION, aOmitDeclaration ? "yes" : "no");
		t.setOutputProperty( OutputKeys.INDENT, aIndent ? "yes" : "no");
		t.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", Integer.toString(aIndentChars));
		Source s=new DOMSource(aNode);
		Result r =new StreamResult(aWriter);
		try
		{	t.transform(s, r);
		}
		catch(TransformerException e)
		{	throw new IOException(e.getMessageAndLocation());
		}
	}
	 */
}
