/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: ForwardAccessor.java,v $
  Version:       $Name:  $ $Revision: 1.2 $
  Last Modified: $Date: 2003/11/06 14:38:27 $
 *****************************************************************************/

package org.ten60.netkernel.xforms.accessor;


import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urrequest.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.util.*;
import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.util.*;

import com.ten60.netkernel.scheduler.*;

import org.w3c.dom.*;
import java.util.*;
import java.io.*;
import java.net.*;

/**
 *	Forward accessor to execute the forwarded target of an XFormResult
 * @author  pjr
 */
public class ForwardAccessor extends XAccessor
{
	/** Creates a new instance of XFormsAccessor */
	public ForwardAccessor()
	{	declareArgument(OPERAND, true, false);
		declareArgument("session",false, false);
	}

	/** Abstract method to be implemented in subclass.
	 * @return Either the result as a Document or a Reader.
	 * @param aHelper The helper class that provides access to the operator,
	 * operand, and parameters.
	 * @throws AccessViolationException Thrown if we fail to access any of the beans
	 * @throws Exception Thrown if we fail for any reason.
	 *
	 */
	public IURRepresentation source(XAHelper aHelper) throws Throwable
	{	DOMXDA xda=new DOMXDA(aHelper.getOperand().getReadOnlyDocument(),true);
		URI uri=URI.create(xda.getText("/XFormResult/forward/action", true));
		uri=aHelper.getCurrentWorkingURI().resolve(uri);
		Document data=xda.getFragment("/XFormResult/forward/data/*[1]");
		XAHelperExtra extra=(XAHelperExtra)aHelper;
		
		CompoundURIdentifier curi=new CompoundURIdentifier(new URIdentifier(uri.toString()));
		URIdentifier prmURI=URIdentifier.getUnique("literal");
		curi.addArg(aHelper.PARAMETER, prmURI.toString());
		URI sessionURI=aHelper.getURI("session");
		if(sessionURI!=null)
		{	curi.addArg("session", sessionURI.toString());
		}	
		
		
		URRequest req=new URRequest(new URIdentifier(curi.toString()), this, extra.getRequest().getSession(), extra.getRequest().getContext(), URRequest.RQT_SOURCE, new URIdentifier(aHelper.getCurrentWorkingURI().toString()), extra.getRequest(), IURAspect.class);
		req.addArg(prmURI, DOMXDAAspect.create(new MetaImpl("text/xml", 0, 0), new DOMXDA(data,false)));
		Scheduler s=(Scheduler)extra.getContainer().getComponent(Scheduler.URI);
		URResult res=s.requestSynch(req);
		return res.getResource();
	}
	
}
