<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xforms="http://www.w3.org/2002/xforms"
    xmlns:chiba="http://chiba.sourceforge.net/2003/08/xforms"
    xmlns:xlink="http://www.w3.org/1999/xlink"
    exclude-result-prefixes="chiba xforms xlink xsl">

    <!-- This stylesheet contains a collection of templates which map XForms controls to HTML controls. -->
    <xsl:output method="html" indent="yes" omit-xml-declaration="yes"/>

    <!-- build input control -->
    <xsl:template name="input">
        <xsl:param name="size"/>
        <xsl:param name="maxlength"/>


        <xsl:element name="input">
            <xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
            <xsl:attribute name="type">text</xsl:attribute>
            <xsl:attribute name="class">input-control</xsl:attribute>
            <xsl:attribute name="name"><xsl:value-of select="chiba:data/@chiba:name" /></xsl:attribute>
            <xsl:attribute name="value"><xsl:value-of select="chiba:data/text()" /></xsl:attribute>
            <!--<xsl:attribute name="style">background-color:transparent;</xsl:attribute>-->
            <!--<xsl:attribute name="class">input-control</xsl:attribute>-->
            <xsl:attribute name="title"><xsl:value-of select="xforms:hint"/></xsl:attribute>

            <xsl:if test="chiba:data/@chiba:type='date'">
                <xsl:attribute name="type">button</xsl:attribute>
                <xsl:attribute name="onclick">
                    javascript:popUpCalendar(this, this, 'dd.mm.yyyy');return true;
                </xsl:attribute>
                <xsl:attribute name="onSelect">
                    javascript:popUpCalendar(this, this, 'dd.mm.yyyy');return true;
                </xsl:attribute>
                <xsl:attribute name="style">background-color:transparent;</xsl:attribute>
            </xsl:if>
            <xsl:if test="$size">
                <xsl:attribute name="size">
                    <xsl:value-of select="$size"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:if test="$maxlength">
                <xsl:attribute name="maxlength">
                    <xsl:value-of select="$maxlength"/>
                </xsl:attribute>
            </xsl:if>
        </xsl:element>

        <xsl:if test="chiba:data/@chiba:required='true'">
            <font color="red">*</font>
        </xsl:if>
    </xsl:template>

    <!-- build secret control -->
    <xsl:template name="secret">
        <xsl:param name="name"/>
        <xsl:param name="value"/>
        <xsl:param name="maxlength"/>
        <xsl:param name="size"/>

        <xsl:element name="input">
            <xsl:attribute name="name">
                <xsl:value-of select="$name"/>
            </xsl:attribute>
            <xsl:attribute name="value">
                <xsl:value-of select="$value"/>
            </xsl:attribute>
            <xsl:attribute name="type">password</xsl:attribute>
            <xsl:attribute name="class">secret</xsl:attribute>
            <xsl:attribute name="title">
                <xsl:value-of select="xforms:hint"/>
            </xsl:attribute>
            <xsl:if test="$size">
                <xsl:attribute name="size">
                    <xsl:value-of select="$size"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:if test="$maxlength">
                <xsl:attribute name="maxlength">
                    <xsl:value-of select="$maxlength"/>
                </xsl:attribute>
            </xsl:if>
        </xsl:element>

        <xsl:if test="chiba:data/@chiba:required='true'">
            <font color="red">*</font>
        </xsl:if>
    </xsl:template>

    <!-- build textarea control -->
    <xsl:template name="textarea">
        <xsl:param name="name"/>
        <xsl:param name="value"/>
        <xsl:param name="rows"/>
        <xsl:param name="cols"/>

        <xsl:element name="textarea">
            <xsl:attribute name="name">
                <xsl:value-of select="$name"/>
            </xsl:attribute>
            <xsl:attribute name="class">textarea</xsl:attribute>
            <xsl:attribute name="title">
                <xsl:value-of select="xforms:hint"/>
            </xsl:attribute>
            <xsl:if test="$rows">
                <xsl:attribute name="rows">
                    <xsl:value-of select="$rows"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:if test="$cols">
                <xsl:attribute name="cols">
                    <xsl:value-of select="$cols"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:value-of select="$value"/>
        </xsl:element>

        <xsl:if test="chiba:data/@chiba:required='true'">
            <font color="red">*</font>
        </xsl:if>
    </xsl:template>

    <!-- build output -->
    <xsl:template name="output">
        <xsl:param name="value"/>

        <span class="output"><xsl:value-of select="$value"/></span>
    </xsl:template>

    <!-- build upload control -->
    <!-- todo: fix upload -->
    <xsl:template name="upload">
        <xsl:param name="name"/>

        <!-- the stylesheet using this template has to take care, that form enctype is set to 'multipart/form-data' -->
        <xsl:message>WARN: upload not supported yet</xsl:message>
        <xsl:element name="input">
            <xsl:attribute name="type">file</xsl:attribute>
            <xsl:attribute name="class">upload</xsl:attribute>
            <xsl:attribute name="value">WARN: upload not supported yet</xsl:attribute>
            <xsl:attribute name="title">
                <xsl:value-of select="xforms:hint"/>
            </xsl:attribute>
        </xsl:element>

        <xsl:if test="chiba:data/@chiba:required='true'">
            <font color="red">*</font>
        </xsl:if>
    </xsl:template>

    <!-- build range -->
    <!-- todo: fix range -->
    <xsl:template name="range">
        <xsl:param name="name"/>

        <xsl:message>WARN: range not supported yet</xsl:message>
        <xsl:element name="input">
            <xsl:attribute name="type">text</xsl:attribute>
            <xsl:attribute name="class">range</xsl:attribute>
            <xsl:attribute name="value">WARN: range not supported yet</xsl:attribute>
            <xsl:attribute name="title">
                <xsl:value-of select="xforms:hint"/>
            </xsl:attribute>
        </xsl:element>

        <xsl:if test="chiba:data/@chiba:required='true'">
            <font color="red">*</font>
        </xsl:if>
    </xsl:template>

    <!-- build trigger / submit -->
    <xsl:template name="trigger">
        <xsl:param name="name"/>

        <input name="{$name}" type="submit" class="trigger" value="{xforms:label}" title="{xforms:hint}"/>
    </xsl:template>

    <!-- build image trigger / submit -->
    <xsl:template name="image-trigger">
        <xsl:param name="name"/>

        <input name="{$name}" type="image" class="trigger" value="{xforms:label}" title="{xforms:hint}" src="{xforms:label/@xlink:href}"/>
    </xsl:template>

    <xsl:template name="select1">
        <xsl:param name="name"/>
        <xsl:param name="value"/>
        <xsl:param name="appearance"/>

        <xsl:variable name="parent" select="."/>
        <!-- todo: provide default -->
        <xsl:choose>
            <xsl:when test="$appearance='compact'">
                <xsl:element name="select">
                    <xsl:attribute name="name">
                        <xsl:value-of select="$name"/>
                    </xsl:attribute>
                    <xsl:attribute name="size">5</xsl:attribute>
                    <xsl:attribute name="class">select1</xsl:attribute>
                    <xsl:attribute name="title">
                        <xsl:value-of select="./xforms:hint"/>
                    </xsl:attribute>
                    <xsl:call-template name="build-items">
                        <xsl:with-param name="parent" select="$parent"/>
                    </xsl:call-template>
                </xsl:element>
                <xsl:if test="./chiba:data/@chiba:required='true'">
                    <font color="red">*</font>
                </xsl:if>
            </xsl:when>
            <xsl:when test="$appearance='full'">
                <xsl:call-template name="build-radiobuttons">
                    <xsl:with-param name="name" select="$name"/>
                    <xsl:with-param name="value" select="$value"/>
                    <xsl:with-param name="parent" select="$parent"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:element name="select">
                    <xsl:attribute name="name">
                        <xsl:value-of select="$name"/>
                    </xsl:attribute>
                    <xsl:attribute name="size">1</xsl:attribute>
                    <xsl:attribute name="class">select1</xsl:attribute>
                    <xsl:attribute name="title">
                        <xsl:value-of select="./xforms:hint"/>
                    </xsl:attribute>
                    <xsl:call-template name="build-items">
                        <xsl:with-param name="parent" select="$parent"/>
                    </xsl:call-template>
                </xsl:element>
                <xsl:if test="./chiba:data/@chiba:required='true'">
                    <font color="red">*</font>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="select">
        <xsl:param name="name"/>
        <xsl:param name="value"/>
        <xsl:param name="appearance"/>

        <xsl:variable name="parent" select="."/>
        <xsl:choose>
            <xsl:when test="$appearance='compact'">
                <xsl:element name="select">
                    <xsl:attribute name="name">
                        <xsl:value-of select="$name"/>
                    </xsl:attribute>
                    <xsl:attribute name="size">5</xsl:attribute>
                    <xsl:attribute name="multiple">true</xsl:attribute>
                    <xsl:attribute name="class">select</xsl:attribute>
                    <xsl:attribute name="title">
                        <xsl:value-of select="./xforms:hint"/>
                    </xsl:attribute>
                    <xsl:call-template name="build-items">
                        <xsl:with-param name="value" select="$value"/>
                        <xsl:with-param name="parent" select="$parent"/>
                    </xsl:call-template>
                </xsl:element>
                <xsl:if test="./chiba:data/@chiba:required='true'">
                    <font color="red">*</font>
                </xsl:if>
            </xsl:when>
            <xsl:when test="$appearance='full'">
                <xsl:call-template name="build-checkboxes">
                    <xsl:with-param name="name" select="$name"/>
                    <xsl:with-param name="value" select="$value"/>
                    <xsl:with-param name="parent" select="$parent"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:element name="select">
                    <xsl:attribute name="name">
                        <xsl:value-of select="$name"/>
                    </xsl:attribute>
                    <xsl:attribute name="size">3</xsl:attribute>
                    <xsl:attribute name="multiple">true</xsl:attribute>
                    <xsl:attribute name="class">select</xsl:attribute>
                    <xsl:attribute name="title">
                        <xsl:value-of select="./xforms:hint"/>
                    </xsl:attribute>
                    <xsl:call-template name="build-items">
                        <xsl:with-param name="value" select="$value"/>
                        <xsl:with-param name="parent" select="$parent"/>
                    </xsl:call-template>
                </xsl:element>
                <xsl:if test="./chiba:data/@chiba:required='true'">
                    <font color="red">*</font>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>


    </xsl:template>

    <xsl:template name="build-items">
        <xsl:param name="parent"/>

        <!-- add an empty item, cause otherwise deselection is not possible -->
        <option value=""/>

        <xsl:variable name="items" select="$parent//xforms:item"/>
        <xsl:for-each select="$items">
            <xsl:choose>
                <xsl:when test="@xforms:selected='true'">
                    <option value="{./xforms:value}" selected="selected">
                        <xsl:apply-templates select="./xforms:label"/>
                    </option>
                </xsl:when>
                <xsl:otherwise>
                    <option value="{./xforms:value}">
                        <xsl:apply-templates select="./xforms:label"/>
                    </option>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>

    <!-- overwrite/change this template, if you don't like the
    way labels are rendered for checkboxes -->
    <xsl:template name="build-checkboxes">
        <xsl:param name="name"/>
        <xsl:param name="parent"/>

        <xsl:variable name="items" select="$parent//xforms:item"/>
        <xsl:for-each select="$items">
            <xsl:choose>
                <xsl:when test="@xforms:selected='true'">
                    <input class="input1" type="checkbox" name="{$name}" value="{./xforms:value}" checked="checked" title="{./xforms:label}"/>
                </xsl:when>
                <xsl:otherwise>
                    <input class="input1" type="checkbox" name="{$name}" value="{./xforms:value}" title="{./xforms:label}"/>
                    <input type="hidden" name="{$name}" value=""/>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:apply-templates select="./xforms:label"/>
        </xsl:for-each>
        <xsl:if test="./@chiba:required='true'">
            <font color="red">*</font>
        </xsl:if>
    </xsl:template>

    <!-- overwrite/change this template, if you don't the way labels are rendered for checkboxes -->
    <xsl:template name="build-radiobuttons">
        <xsl:param name="name"/>
        <xsl:param name="parent"/>

        <xsl:variable name="items" select="$parent//xforms:item"/>
        <xsl:for-each select="$items">
            <xsl:choose>
                <xsl:when test="@xforms:selected='true'">
                    <input class="input1" type="radio" name="{$name}" value="{./xforms:value}" checked="checked" title="{./xforms:label}"/>
                </xsl:when>
                <xsl:otherwise>
                    <input class="input1" type="radio" name="{$name}" value="{./xforms:value}" title="{./xforms:label}"/>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:apply-templates select="./xforms:label"/>
        </xsl:for-each>
        <xsl:if test="./chiba:data/@chiba:required='true'">
            <font color="red">*</font>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
