<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
    xmlns:xhtml="http://www.w3.org/2002/06/xhtml2"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xforms="http://www.w3.org/2002/xforms"
    xmlns:xlink="http://www.w3.org/1999/xlink"
    xmlns:chiba="http://chiba.sourceforge.net/2003/08/xforms"
    exclude-result-prefixes="xhtml xforms chiba xlink">

    <xsl:include href="html-form-controls.xsl"/>

    <!--    <xsl:include href="components.xsl"/>-->

    <!-- ####################################################################################################### -->
    <!-- This stylesheet transcodes a XTHML2/XForms input document to HTML 4.0.                                  -->
    <!-- It serves as a reference for customized stylesheets which may import it to overwrite specific templates -->
    <!-- or completely replace it.                                                                               -->
    <!-- This is the most basic transformator for HTML browser clients and assumes support for HTML 4 tagset     -->
    <!-- but does NOT rely on javascript.                                                                        -->
    <!-- author: joern turner                                                                                    -->
    <!-- ####################################################################################################### -->

    <!-- ####################################################################################################### -->
    <!-- This is a modified html4.xsl for use by NetKernel                                                       -->
    <!--     the change is to substitute all xsl:param's for xsl:variable - not sure why atm:-)                  -->
    <!-- ####################################################################################################### -->

    <!-- ### this url will be used to build the form action attribute ### -->
    <xsl:variable name="action-url" select="'http://@baseurl.host@:@baseurl.port@/chiba-@chiba-version@/XFormsServlet'"/>

    <!-- ### the CSS stylesheet to use ### -->
    <xsl:variable name="css" select="'styles/styles.css'"/>

    <!-- ### signals the phase of processing (init|submit) ### -->
    <xsl:variable name="phase" select="'false'"/>

    <xsl:variable name="form-id" select="'chiba-form'"/>
    <xsl:variable name="form-name" select="'Chiba XForms Processor'"/>
    <xsl:variable name="debug-enabled" select="'false'"/>

    <!-- ### specifies the parameter prefix for repeat selectors ### -->
    <xsl:variable name="selector-prefix" select="'s_'"/>

    <!-- ### checks, whether this form uses uploads. Used to set form enctype attribute ### -->
    <xsl:variable name="uses-upload" select="boolean(//*/xforms:upload)"/>

    <xsl:output method="html" version="4.0" encoding="ISO-8859-1" indent="yes"/>

    <!-- ### transcodes the XHMTL namespaced elements to HTML ### -->
    <xsl:namespace-alias stylesheet-prefix="xhtml" result-prefix="#default"/>

    <xsl:preserve-space elements="*"/>
    <xsl:strip-space elements="xforms:action"/>

    <!-- ####################################################################################################### -->
    <!-- ##################################### TEMPLATES ####################################################### -->
    <!-- ####################################################################################################### -->

    <xsl:template match="/">
        <xsl:if test="$debug-enabled='true'">
            <xsl:message>html-std: processing phase:
                <xsl:value-of select="$phase"/>
            </xsl:message>
        </xsl:if>

        <xsl:choose>
            <xsl:when test="$debug-enabled='true'">
                <xsl:message>html-std: ********** XSLT MESSAGES ARE ENABLED</xsl:message>
            </xsl:when>
            <xsl:otherwise>
                <xsl:message>html-std: ********** XSLT MESSAGES ARE DISABLED</xsl:message>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates/>
    </xsl:template>

    <xsl:template match="xhtml:head">
        <xsl:if test="$debug-enabled='true'">
            <xsl:message>html-std: head</xsl:message>
        </xsl:if>
        <head>
            <title>
                <xsl:value-of select="$form-name"/>
            </title>

            <xsl:choose>
                <xsl:when test="/xhtml:html/@chiba:css">
                    <link rel="stylesheet" type="text/css" href="{/xhtml:html/@chiba:css}"/>
                </xsl:when>
                <xsl:otherwise>
                    <link rel="stylesheet" type="text/css" href="{$css}"/>
                </xsl:otherwise>
            </xsl:choose>
        </head>
    </xsl:template>

    <!-- copy unmatched mixed markup, comments, whitespace, and text -->
    <!-- ### copy elements from the xhtml2 namespace to html (without any namespace) by re-creating the     ### -->
    <!-- ### elements. Other Elements are just copied.                                                      ### -->
    <xsl:template match="*|@*|text()">
        <xsl:choose>
            <xsl:when test="namespace-uri(.)='http://www.w3.org/2002/06/xhtml2'">
                <xsl:element name="{local-name(.)}">
                    <xsl:apply-templates select="*|@*|text()"/>
                </xsl:element>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy>
                    <xsl:apply-templates select="*|@*|text()"/>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="xhtml:html">
        <xsl:if test="$debug-enabled='true'">
            <xsl:message>html-std: html</xsl:message>
        </xsl:if>
        <html>
            <xsl:apply-templates/>
        </html>
    </xsl:template>

    <xsl:template match="xhtml:link">
        <xsl:copy-of select="."/>
    </xsl:template>

    <xsl:template match="xhtml:body">
        <xsl:if test="$debug-enabled='true'">
            <xsl:message>html-std: body</xsl:message>
        </xsl:if>
        <xsl:copy-of select="@*"/>
        <body>
            <a href="jsp/forms.jsp">
                <img src="images/chiba50t.gif" border="0" vspace="5" alt="Chiba Logo" width="113" height="39" id="chiba-logo"/>
            </a>
            <table border="0">
                <tr>
                    <td width="33"></td>
                    <td>
                        <xsl:element name="form">
                            <xsl:attribute name="name">
                                <xsl:value-of select="$form-id"/>
                            </xsl:attribute>
                            <xsl:attribute name="action">
                                <xsl:value-of select="$action-url"/>
                            </xsl:attribute>
                            <xsl:attribute name="method">POST</xsl:attribute>
                            <xsl:attribute name="enctype">application/x-www-form-urlencoded</xsl:attribute>
                            <xsl:if test="$uses-upload">
                                <xsl:attribute name="enctype">multipart/form-data</xsl:attribute>
                            </xsl:if>

                            <!-- provide a first submit which does not map to any xforms:trigger -->
                            <input type="image" name="dummy" style="width:0pt;height:0pt;" value="dummy"/>
                            <xsl:apply-templates/>
                        </xsl:element>
                    </td>
                </tr>
                <tr>
                    <td></td>
                    <td>
                        <table width="100%" border="0">
                            <tr>
                                <td>
                                    <span class="legend">
                                        <span style="color:red">*</span> - required |
                                        <b>?</b> - help
                                    </span>
                                </td>
                                <td align="right">
                                    &#169; Chiba 2003
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </body>
    </xsl:template>

    <xsl:template match="xhtml:span">
        <span>
            <xsl:copy-of select="@xhtml:class"/>
            <xsl:apply-templates/>
        </span>
    </xsl:template>

    <!-- ### skip explicitely disabled control ### -->
    <xsl:template match="*[chiba:data/@chiba:enabled='false']">
        <xsl:if test="$debug-enabled='true'">
            <xsl:message>html-std: skipping disabled control</xsl:message>
        </xsl:if>
    </xsl:template>

    <!-- ### skip chiba:data elements ### -->
    <xsl:template match="chiba:data"/>

    <!-- ### skip model section ### -->
    <xsl:template match="xforms:model"/>

    <!-- ####################################################################################################### -->
    <!-- #################################### GROUPS ########################################################### -->
    <!-- ####################################################################################################### -->

    <!--
    processing of groups and repeats is handled with a computational pattern (as mentioned in Michael Kay's XSLT
    Programmers Reference) in this stylesheet, that means that when a group or repeat is found its children will
    be processed with for-each. this top-down approach seems to be more adequate for transforming XForms markup
    than to follow a rule-based pattern. Also note that whenever nodesets of XForms controls are processed the
    call template 'buildControl' is used to handle the control. In contrast to apply-templates a call-template
    preserves the position() of the control inside its parent nodeset and this can be valuable information for
    annotating controls with CSS classes that refer to their parent.
    -->
    <!-- ###################################### MINIMAL GROUP ################################################## -->
    <!-- handle 'minimal' group - this is the default for groups and only annotates CSS to labels + controls and
    outputs them in a kind of flow-layout -->
    <xsl:template match="xforms:group[@xforms:appearance='minimal']">
        <xsl:if test="$debug-enabled='true'">
            <xsl:message>html-std: found minimal group</xsl:message>
        </xsl:if>

        <xsl:if test="not(chiba:data/@chiba:enabled='false')">

            <div class="minimal-group" id="{@id}">
                <xsl:copy-of select="@style"/>

                <xsl:for-each select="*">
                    <xsl:choose>
                        <xsl:when test="self::xforms:label" xmlns:xforms="http://www.w3.org/2002/xforms">
                            <xsl:if test="$debug-enabled='true'">
                                <xsl:message>html-std: handling outergroup label ...</xsl:message>
                            </xsl:if>
                            <span class="minimal-group-label">
                                <xsl:apply-templates select="."/>
                            </span>
                        </xsl:when>
                        <xsl:when test="self::xforms:group" xmlns:xforms="http://www.w3.org/2002/xforms">
                            <xsl:if test="$debug-enabled='true'">
                                <xsl:message>html-std: found inner group</xsl:message>
                            </xsl:if>
                            <xsl:apply-templates select="."/>
                        </xsl:when>
                        <xsl:when test="self::xforms:repeat" xmlns:xforms="http://www.w3.org/2002/xforms">
                            <xsl:if test="$debug-enabled='true'">
                                <xsl:message>html-std: found repeat</xsl:message>
                            </xsl:if>
                            <xsl:apply-templates select="."/>
                        </xsl:when>
                        <xsl:when test="self::xforms:switch" xmlns:xforms="http://www.w3.org/2002/xforms">
                            <xsl:if test="$debug-enabled='true'">
                                <xsl:message>html-std: found switch</xsl:message>
                            </xsl:if>
                            <xsl:apply-templates select="."/>
                        </xsl:when>

                        <!--                    <xsl:when test="name(.)='xforms:trigger' or name(.)='xforms:submit'" xmlns:xforms="http://www.w3.org/2002/xforms">-->
                        <!--                    <xsl:when test="(local-name(.)='trigger' or local-name(.)='submit') and (namespace-uri(.)='http://www.w3.org/2002/xforms')">-->
                        <xsl:when test="self::xforms:trigger or self::xforms:submit" xmlns:xforms="http://www.w3.org/2002/xforms">
                            <xsl:if test="$debug-enabled='true'">
                                <xsl:message>html-std: handling trigger:
                                    <xsl:value-of select="xforms:label"/>
                                </xsl:message>
                            </xsl:if>
                            <span class="xfcontrol" id="{@id}">
                                <xsl:apply-templates select="."/>
                            </span>
                        </xsl:when>
                        <xsl:when test="self::xforms:alert" xmlns:xforms="http://www.w3.org/2002/xforms">
                            <xsl:apply-templates select="xforms:alert"/>
                        </xsl:when>
                        <xsl:when test="self::xforms:*" xmlns:xforms="http://www.w3.org/2002/xforms">

                            <xsl:if test="chiba:data/@chiba:enabled='true'">
                                <xsl:if test="$debug-enabled='true'">
                                    <xsl:message>html-std: handling control label</xsl:message>
                                    <xsl:message>html-std: 
                                        <xsl:value-of select="name()"/>-
                                        <xsl:value-of select="xforms:label"/>
                                    </xsl:message>
                                </xsl:if>
                                <span class="xfcontrol" id="{@id}">
                                    <!--                                <span class="label">-->
                                    <xsl:apply-templates select="xforms:label"/>
                                    <!--                                </span>-->
                                    <xsl:if test="$debug-enabled='true'">
                                        <xsl:message>html-std: handling control</xsl:message>
                                        <xsl:message>html-std: 
                                            <xsl:value-of select="name()"/>
                                        </xsl:message>
                                    </xsl:if>
                                    <!--                                <span class="box">-->
                                    <xsl:call-template name="buildControl"/>
                                    <!--                                    <xsl:apply-templates select="."/>-->
                                    <!--                                </span>-->
                                </span>
                            </xsl:if>
                        </xsl:when>
                        <!--                    <xsl:when test="name(.)='chiba:data'">-->
                        <xsl:when test="self::chiba:data" xmlns:chiba="http://chiba.sourceforge.net/2003/08/xforms">
                            <xsl:if test="$debug-enabled='true'">
                                <xsl:message>html-std: ignoring chiba data element</xsl:message>
                            </xsl:if>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:if test="$debug-enabled='true'">
                                <xsl:message>html-std: handling element:
                                    <xsl:value-of select="name()"/>
                                </xsl:message>
                            </xsl:if>
                            <xsl:copy>
                                <xsl:copy-of select="@*"/>
                                <xsl:apply-templates/>
                            </xsl:copy>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            </div>
        </xsl:if>
    </xsl:template>


    <!-- ###################################### COMPACT GROUP ################################################## -->
    <xsl:template match="xforms:group[@xforms:appearance='compact']">
        <xsl:if test="$debug-enabled='yes'">
            <xsl:message>html-std: found compact group
                <xsl:value-of select="xforms:label"/>...
            </xsl:message>
        </xsl:if>

        <xsl:if test="not(chiba:data/@chiba:enabled='false')">

            <xsl:variable name="id" select="@id"/>
            <xsl:variable name="control-count" select="count(./*/xforms:label)"/>

            <table class="compact-group" id="{$id}">
                <tr>
                    <td colspan="{$control-count}" class="compact-group-label">
                        <xsl:apply-templates select="xforms:label"/>
                    </td>
                </tr>
                <tr>
                    <xsl:for-each select="./*/xforms:label">
                        <td class="label">
                            <xsl:apply-templates select="self::node()[not( name(..)='xforms:trigger' or name(..)='xforms:submit')]"/>
                        </td>
                    </xsl:for-each>
                </tr>
                <tr>
                    <xsl:for-each select="*">
                        <xsl:choose>
                            <xsl:when test="self::xforms:label" xmlns:xforms="http://www.w3.org/2002/xforms">
                                <xsl:if test="$debug-enabled='true'">
                                    <xsl:message>html-std: ignoring group label ...</xsl:message>
                                </xsl:if>
                            </xsl:when>
                            <xsl:when test="self::xforms:group" xmlns:xforms="http://www.w3.org/2002/xforms">
                                <td colspan="{$control-count}">
                                    <xsl:apply-templates select="."/>
                                </td>
                            </xsl:when>
                            <xsl:when test="self::xforms:repeat" xmlns:xforms="http://www.w3.org/2002/xforms">
                                <td colspan="{$control-count}">
                                    <xsl:apply-templates select="."/>
                                </td>
                            </xsl:when>
                            <xsl:when test="self::xforms:switch" xmlns:xforms="http://www.w3.org/2002/xforms">
                                <xsl:if test="$debug-enabled='true'">
                                    <xsl:message>html-std: found switch</xsl:message>
                                </xsl:if>
                                <td colspan="{$control-count}">
                                    <xsl:apply-templates select="."/>
                                </td>
                            </xsl:when>
                            <xsl:when test="self::xforms:trigger or self::xforms:submit" xmlns:xforms="http://www.w3.org/2002/xforms">
                                <xsl:if test="$debug-enabled='true'">
                                    <xsl:message>html-std: handling trigger:
                                        <xsl:value-of select="xforms:label"/>
                                    </xsl:message>
                                </xsl:if>
                                <td class="box" id="{@id}">
                                    <xsl:apply-templates select="."/>
                                </td>
                            </xsl:when>
                            <xsl:when test="self::xforms:alert" xmlns:xforms="http://www.w3.org/2002/xforms">
                                <xsl:apply-templates select="xforms:alert"/>
                            </xsl:when>
                            <xsl:when test="self::xforms:*" xmlns:xforms="http://www.w3.org/2002/xforms">
                                <xsl:if test="not(chiba:data/@chiba:enabled='false')">
                                    <td class="box">
                                        <xsl:if test="$debug-enabled='true'">
                                            <xsl:message>html-std: handling control</xsl:message>
                                            <xsl:message>html-std: 
                                                <xsl:value-of select="name()"/>
                                            </xsl:message>
                                        </xsl:if>
                                        <xsl:call-template name="buildControl"/>
                                    </td>
                                </xsl:if>
                            </xsl:when>
                            <xsl:when test="self::chiba:data" xmlns:xforms="http://chiba.sourceforge.net/2003/08/xforms">
                                <xsl:if test="$debug-enabled='true'">
                                    <xsl:message>html-std: ignoring chiba data element</xsl:message>
                                </xsl:if>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:if test="$debug-enabled='true'">
                                    <xsl:message>html-std: handling element:
                                        <xsl:value-of select="name()"/>
                                    </xsl:message>
                                </xsl:if>
                                <xsl:copy>
                                    <xsl:copy-of select="@*"/>
                                    <xsl:apply-templates/>
                                </xsl:copy>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:for-each>
                </tr>
            </table>
        </xsl:if>
    </xsl:template>

    <!-- ###################################### FULL GROUP ################################################## -->
    <!-- handle group with apprearance 'full' - will render controls in a two-column table with labels on
    the left side. -->
    <xsl:template match="xforms:group" name="full-group">
        <xsl:if test="$debug-enabled='true'">
            <xsl:message>html-std: found full group (the default)
                <xsl:value-of select="xforms:label"/>...
            </xsl:message>
        </xsl:if>

        <xsl:if test="not(chiba:data/@chiba:enabled='false')">

        <xsl:variable name="id" select="@id"/>

        <table class="full-group" id="{$id}" border="0">
            <!-- handling group children -->
            <xsl:for-each select="*">
                <xsl:choose>
                    <xsl:when test="self::xforms:label" xmlns:xforms="http://www.w3.org/2002/xforms">
                        <xsl:if test="$debug-enabled='true'">
                            <xsl:message>html-std: handling group label ...</xsl:message>
                        </xsl:if>
                        <tr>
                            <td colspan="2" id="{@id}" class="full-group-label">
                                <xsl:apply-templates select="."/>
                            </td>
                        </tr>
                    </xsl:when>
                    <xsl:when test="self::xforms:group" xmlns:xforms="http://www.w3.org/2002/xforms">
                        <tr>
                            <td colspan="2">
                                <xsl:apply-templates select="."/>
                            </td>
                        </tr>
                    </xsl:when>
                    <xsl:when test="self::xforms:repeat" xmlns:xforms="http://www.w3.org/2002/xforms">
                        <tr>
                            <td colspan="2">
                                <xsl:apply-templates select="."/>
                            </td>
                        </tr>
                    </xsl:when>
                    <xsl:when test="self::xforms:switch" xmlns:xforms="http://www.w3.org/2002/xforms">
                        <xsl:if test="$debug-enabled='true'">
                            <xsl:message>html-std: found switch</xsl:message>
                        </xsl:if>
                        <tr>
                            <td colspan="2">
                                <xsl:apply-templates select="."/>
                            </td>
                        </tr>
                    </xsl:when>
                    <xsl:when test="self::xforms:trigger or self::xforms:submit" xmlns:xforms="http://www.w3.org/2002/xforms">
                        <xsl:if test="$debug-enabled='true'">
                            <xsl:message>html-std: handling trigger:
                                <xsl:value-of select="xforms:label"/>
                            </xsl:message>
                        </xsl:if>
                        <tr>
                            <td class="xfcontrol" id="{@id}" colspan="2">
                                <xsl:call-template name="buildControl"/>
                            </td>
                        </tr>
                    </xsl:when>
                    <xsl:when test="self::xforms:alert" xmlns:xforms="http://www.w3.org/2002/xforms">
                        <xsl:apply-templates select="xforms:alert"/>
                    </xsl:when>
                    <xsl:when test="self::xforms:*" xmlns:xforms="http://www.w3.org/2002/xforms">
                        <xsl:if test="$debug-enabled='true'">
                            <xsl:message>html-std: element ->
                                <xsl:value-of select="name(.)"/>
                            </xsl:message>
                        </xsl:if>

                        <xsl:if test="not(chiba:data/@chiba:enabled='false')">
                            <tr>
                                <td class="{concat($id,'-label',' label')}">
                                    <xsl:if test="$debug-enabled='true'">
                                        <xsl:message>html-std: handling control label</xsl:message>
                                        <xsl:message>html-std: 
                                            <xsl:value-of select="name()"/>-
                                            <xsl:value-of select="xforms:label"/>
                                        </xsl:message>
                                    </xsl:if>
                                    <xsl:apply-templates select="xforms:label"/>
                                </td>
                                <td class="box">
                                    <xsl:if test="$debug-enabled='true'">
                                        <xsl:message>html-std: handling control</xsl:message>
                                        <xsl:message>html-std: 
                                            <xsl:value-of select="name()"/>
                                        </xsl:message>
                                    </xsl:if>
                                    <xsl:call-template name="buildControl"/>
                                </td>
                            </tr>
                        </xsl:if>
                    </xsl:when>
                    <xsl:when test="self::chiba:data" xmlns:xforms="http://chiba.sourceforge.net/2003/08/xforms">
                        <xsl:if test="$debug-enabled='true'">
                            <xsl:message>html-std: ignoring chiba data element</xsl:message>
                        </xsl:if>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:if test="$debug-enabled='true'">
                            <xsl:message>html-std: handling element:
                                <xsl:value-of select="name()"/>
                            </xsl:message>
                        </xsl:if>
                        <xsl:copy>
                            <xsl:copy-of select="@*"/>
                            <xsl:apply-templates/>
                        </xsl:copy>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </table>
        </xsl:if>
    </xsl:template>


    <!-- ######################################################################################################## -->
    <!-- ####################################### REPEAT ######################################################### -->
    <!-- ######################################################################################################## -->

    <!-- ### handle repeat with 'minimal' appearance ### -->
    <xsl:template match="xforms:repeat">
        <xsl:if test="$debug-enabled='true'">
            <xsl:message>html-std: found minimal repeat
                <xsl:value-of select="xforms:label"/>...
            </xsl:message>
        </xsl:if>

        <div class="minimal-repeat" id="{@id}">
            <!-- loop repeat entries -->
            <xsl:for-each select="*[@chiba:transient]">
                <xsl:if test="$debug-enabled='true'">
                    <xsl:message>html-std: found
                        <xsl:value-of select="name()"/>...
                    </xsl:message>
                    <xsl:message>html-std: found
                        <xsl:value-of select="xforms:label"/>...
                    </xsl:message>
                </xsl:if>
                <xsl:variable name="repeat-id" select="../@id"/>
                <xsl:variable name="repeat-index" select="../@chiba:index"/>
                <xsl:variable name="repeat-position" select="@chiba:position"/>
                <xsl:variable name="selected" select="boolean($repeat-index=$repeat-position)"/>

                <xsl:choose>
                    <xsl:when test="$repeat-index=$repeat-position">
                        <span class="minimal-repeat-selected">
                            <span class="minimal-repeat-selector">
                                <input type="radio" name="{$selector-prefix}{$repeat-id}" value="{$repeat-position}" checked="true"/>
                            </span>

                            <xsl:for-each select="*">
                                <span class="label" id="{@id}">
                                    <xsl:apply-templates select="./xforms:label"/>
                                </span>
                                <span class="box">
                                    <!--                                    <xsl:apply-templates select="."/>-->
                                    <xsl:call-template name="buildControl"/>

                                </span>
                            </xsl:for-each>
                        </span>
                    </xsl:when>
                    <xsl:otherwise>
                        <span class="minimal-repeat-deselected">
                            <span class="minimal-repeat-selector">
                                <input type="radio" name="{$selector-prefix}{$repeat-id}" value="{$repeat-position}"/>
                            </span>
                            <xsl:for-each select="*">
                                <span class="label" id="{@id}">
                                    <xsl:apply-templates select="./xforms:label"/>
                                </span>
                                <span class="box">
                                    <!--                                    <xsl:apply-templates select="."/>-->
                                    <xsl:call-template name="buildControl"/>
                                </span>
                            </xsl:for-each>
                        </span>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </div>
    </xsl:template>

    <!-- ### handle repeat with 'compact' appearance ### -->
    <xsl:template match="xforms:repeat[@xforms:appearance='compact']" priority="1">
        <xsl:if test="$debug-enabled='true'">
            <xsl:message>html-std: found compact repeat
                <xsl:value-of select="xforms:label"/>...
            </xsl:message>
        </xsl:if>

        <xsl:variable name="repeat" select="."/>
        <table class="compact-repeat">
            <tr class="compact-repeat-label">
                <!-- build empty selector cell -->
                <td class="repeat-selector-header">
                </td>
                <!-- build header -->
                <xsl:for-each select="./xforms:group[1]/*/xforms:label">
                    <td class="label">
                        <xsl:apply-templates select="self::node()[not(name(..)='xforms:trigger')]"/>
                    </td>
                </xsl:for-each>
            </tr>
            <xsl:for-each select="xforms:group[@chiba:transient]">

                <xsl:choose>
                    <xsl:when test="number(../@chiba:index)=number(@chiba:position)">
                        <tr class="repeat-selected">
                            <td class="selector-cell">
                                <input type="radio" name="{$selector-prefix}{$repeat/@id}" value="{@chiba:position}" checked="true"/>
                            </td>
                            <xsl:for-each select="*">
                                <td class="box">
                                    <span class="box">
                                        <xsl:call-template name="buildControl"/>
                                    </span>
                                </td>
                            </xsl:for-each>
                        </tr>
                    </xsl:when>
                    <xsl:otherwise>
                        <tr class="repeat-deselected">
                            <td class="selector-cell">
                                <input type="radio" name="{$selector-prefix}{$repeat/@id}" value="{@chiba:position}"/>
                            </td>
                            <xsl:for-each select="*">
                                <td class="box">
                                    <!--                                    <nobr>-->
                                    <span class="box">
                                        <xsl:call-template name="buildControl"/>
                                    </span>
                                    <!--                                    </nobr>-->
                                </td>
                            </xsl:for-each>
                        </tr>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </table>
    </xsl:template>

    <!-- ### handle repeat with 'full' appearance ### -->
    <xsl:template match="xforms:repeat[@xforms:appearance='full']">
        <xsl:if test="$debug-enabled='true'">
            <xsl:message>html-std: found full repeat
                <xsl:value-of select="xforms:label"/>...
            </xsl:message>
        </xsl:if>

        <xsl:variable name="repeat" select="."/>

        <table class="full-repeat" id="{@id}">
            <!-- loop repeat entries -->
            <xsl:for-each select="*[@chiba:transient]">
                <xsl:variable name="control-count" select="count(./*/xforms:label)"/>

                <xsl:variable name="repeat-id" select="$repeat/@id"/>
                <xsl:variable name="repeat-index" select="$repeat/@chiba:index"/>
                <xsl:variable name="repeat-position" select="./@chiba:position"/>
                <xsl:variable name="selected" select="boolean($repeat-index=$repeat-position)"/>


                <xsl:if test="$debug-enabled='true'">
                    <xsl:message>html-std: repeat-id:
                        <xsl:value-of select="$repeat-id"/>
                    </xsl:message>
                    <xsl:message>html-std: repeat-index:
                        <xsl:value-of select="$repeat-index"/>
                    </xsl:message>
                    <xsl:message>html-std: repeat-position:
                        <xsl:value-of select="$repeat-position"/>
                    </xsl:message>
                    <xsl:message>html-std: selected:
                        <xsl:value-of select="$selected"/>
                    </xsl:message>
                </xsl:if>

                <xsl:choose>
                    <xsl:when test="$repeat-index=$repeat-position">
                        <tr>
                            <td>
                                <table>
                                    <tr class="repeat-selected">
                                        <td class="selector-cell">
                                            <input type="radio" name="{$selector-prefix}{$repeat-id}" value="{$repeat-position}" checked="true"/>
                                        </td>
                                        <td>
                                            <xsl:call-template name="full-group"/>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </xsl:when>
                    <xsl:otherwise>
                        <tr>
                            <td>
                                <table>
                                    <tr class="repeat-deselected">
                                        <td class="selector-cell">
                                            <input type="radio" name="{$selector-prefix}{$repeat-id}" value="{$repeat-position}"/>
                                        </td>
                                        <td>
                                            <xsl:call-template name="full-group"/>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </table>
    </xsl:template>

    <!-- ### handle repeats attribute on foreign elements ### -->
    <xsl:template match="*[@xforms:repeat-bind]|*[@xforms:repeat-nodeset]">
        <xsl:apply-templates/>
    </xsl:template>

    <!-- ######################################################################################################## -->
    <!-- transient groups are created for clean handling of repeats; each each repeat entry will we wrapped into  -->
    <!-- a transient group. These can be used to detect the boundaries of a repeated item including its mixed     -->
    <!-- content. This template mainly handles the correct setting of the selected entry.                         -->
    <!-- ######################################################################################################## -->

    <xsl:template match="xforms:group[@chiba:transient='true']" priority="1">
        <xsl:if test="$debug-enabled='true'">
            <xsl:message>html-std: transient group</xsl:message>
        </xsl:if>

        <xsl:variable name="repeat-id" select="../@id"/>
        <xsl:variable name="repeat-index" select="../@chiba:index"/>
        <xsl:variable name="repeat-position" select="@chiba:position"/>
        <xsl:variable name="selected" select="boolean($repeat-index=$repeat-position)"/>

        <xsl:if test="$debug-enabled='true'">
            <xsl:message>html-std: repeat id:
                <xsl:value-of select="../@id"/>
            </xsl:message>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="$repeat-index=$repeat-position">
                <span class="repeat-selected">
                    <span class="repeat-selector">
                        <input type="radio" name="{$selector-prefix}{$repeat-id}" value="{$repeat-position}" checked="true"/>
                    </span>
                    <xsl:apply-templates/>
                </span>
            </xsl:when>
            <xsl:otherwise>
                <span class="repeat-deselected">
                    <span class="repeat-selector">
                        <input type="radio" name="{$selector-prefix}{$repeat-id}" value="{$repeat-position}"/>
                    </span>
                    <xsl:apply-templates/>
                </span>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <!-- ######################################################################################################## -->
    <!-- ####################################### SWITCH ######################################################### -->
    <!-- ######################################################################################################## -->

    <!-- ### handle xforms:switch ### -->
    <xsl:template match="xforms:switch">
        <xsl:if test="$debug-enabled='true'">
            <xsl:message>html-std: handling switch</xsl:message>
        </xsl:if>
        <xsl:apply-templates/>
    </xsl:template>

    <!-- ### handle selected xforms:case ### -->
    <xsl:template match="xforms:case[@xforms:selected='true']">
        <xsl:if test="$debug-enabled='true'">
            <xsl:message>html-std: handling selected case</xsl:message>
        </xsl:if>
        <xsl:apply-templates/>
    </xsl:template>

    <!-- ### skip unselected xforms:case ### -->
    <xsl:template match="xforms:case">
        <xsl:if test="$debug-enabled='true'">
            <xsl:message>html-std: handling unselected case</xsl:message>
        </xsl:if>
    </xsl:template>


    <!-- ######################################################################################################## -->
    <!-- #####################################  CONTROLS ######################################################## -->
    <!-- ######################################################################################################## -->

    <!-- handle non-standard image-trigger
    <xsl:template name="image-trigger">
        <input type="image"
            name="{@chiba:name}"
            value="{./xforms:label}"
            src="{xforms:label/@xlink:href}"
            title="{xforms:label}"/>
    </xsl:template>
     -->

    <!-- ### handle xforms:input ### -->
    <xsl:template match="xforms:input">
        <xsl:if test="$debug-enabled='true'">
            <xsl:message>html-std: input</xsl:message>
        </xsl:if>

        <xsl:call-template name="input"/>
        <xsl:apply-templates select="xforms:help"/>
        <xsl:apply-templates select="xforms:alert"/>
    </xsl:template>


    <!-- ### handle xforms:output ### -->
    <xsl:template match="xforms:output">
        <xsl:if test="$debug-enabled='true'">
            <xsl:message>html-std: output</xsl:message>
        </xsl:if>

        <xsl:choose>
            <xsl:when test="xforms:label">
                <xsl:value-of select="chiba:data/text()"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="chiba:data/text()"/>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>


    <!-- ### handle xforms:range ### -->
    <xsl:template match="xforms:range">
        <xsl:if test="$debug-enabled='true'">
            <xsl:message>html-std: range</xsl:message>
        </xsl:if>
        range is not supported yet
        <xsl:apply-templates select="xforms:help"/>
        <xsl:apply-templates select="xforms:alert"/>
    </xsl:template>

    <!-- ### handle xforms:secret ### -->
    <xsl:template match="xforms:secret">
        <xsl:if test="$debug-enabled='true'">
            <xsl:message>html-std: secret</xsl:message>
        </xsl:if>

        <xsl:variable name="ctrl" select="concat('xf-',@id,' ','xfcontrol')"/>
        <xsl:call-template name="secret"/>
        <xsl:apply-templates select="xforms:help"/>
        <xsl:apply-templates select="xforms:alert"/>
    </xsl:template>

    <!-- ### handle xforms:select ### -->
    <xsl:template match="xforms:select">
        <xsl:if test="$debug-enabled='true'">
            <xsl:message>html-std: select</xsl:message>
        </xsl:if>

        <xsl:variable name="ctrl" select="concat('xf-',@id,' ','xfcontrol')"/>

        <xsl:call-template name="select"/>
        <xsl:apply-templates select="xforms:help"/>
        <xsl:apply-templates select="xforms:alert"/>
    </xsl:template>


    <!-- ### handle xforms:select1 ### -->
    <xsl:template match="xforms:select1">
        <xsl:if test="$debug-enabled='true'">
            <xsl:message>html-std: select1</xsl:message>
        </xsl:if>

        <xsl:variable name="ctrl" select="concat('xf-',@id,' ','xfcontrol')"/>
        <xsl:call-template name="select1"/>
        <xsl:apply-templates select="xforms:help"/>
        <xsl:apply-templates select="xforms:alert"/>
    </xsl:template>

    <!-- ### handle xforms:submit ### -->
    <xsl:template match="xforms:submit">
        <xsl:if test="$debug-enabled='true'">
            <xsl:message>html-std: submit</xsl:message>
        </xsl:if>
        <xsl:call-template name="submit"/>
        <xsl:apply-templates select="xforms:help|xforms:alert"/>
    </xsl:template>

    <!-- ### handle xforms:trigger ### -->
    <xsl:template match="xforms:trigger">
        <xsl:if test="$debug-enabled='true'">
            <xsl:message>html-std: trigger</xsl:message>
        </xsl:if>

        <xsl:call-template name="trigger"/>
        <xsl:apply-templates select="xforms:help|xforms:alert"/>
    </xsl:template>

    <!-- ### handle image trigger ### -->
    <xsl:template match="xforms:trigger[starts-with(./xforms:label/@xlink:href,'images')]">
        <span class="box">
            <xsl:call-template name="trigger"/>
            <xsl:apply-templates select="xforms:help"/>
        </span>
    </xsl:template>

    <!-- ### handle xforms:textarea ### -->
    <xsl:template match="xforms:textarea">
        <xsl:if test="$debug-enabled='true'">
            <xsl:message>html-std: textarea</xsl:message>
        </xsl:if>

        <xsl:call-template name="textarea"/>
        <xsl:apply-templates select="xforms:help"/>
        <xsl:apply-templates select="xforms:alert"/>
    </xsl:template>

    <!-- ### handle xforms:upload ### -->
    <xsl:template match="xforms:upload">
        <xsl:if test="$debug-enabled='true'">
            <xsl:message>html-std: upload</xsl:message>
        </xsl:if>

        <xsl:variable name="ctrl" select="concat('xf-',@id,' ','xfcontrol')"/>
        <xsl:call-template name="upload"/>
        <xsl:apply-templates select="xforms:help"/>
        <xsl:apply-templates select="xforms:alert"/>
    </xsl:template>

    <!-- ### this template must be provided since its called from the imported html-form-controls.xsl ### -->
    <xsl:template name="eval-actions">
        <xsl:if test="xforms:insert|xforms:delete">
            <xsl:attribute name="onClick">javascript:
                <xsl:apply-templates select="xforms:insert|xforms:delete"/>return true;
            </xsl:attribute>
        </xsl:if>
    </xsl:template>

    <!-- ### handle label ### -->
    <xsl:template match="xforms:label">

        <xsl:variable name="group-id" select="ancestor::xforms:group[1]/@id"/>

        <xsl:choose>
            <xsl:when test="name(..)='xforms:group'">
                <xsl:apply-templates/>
            </xsl:when>
            <xsl:when test="name(..)='xforms:item'">
                <span id="{@id}" class="label">
                    <xsl:apply-templates/>
                </span>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- ### handle hint ### -->
    <xsl:template match="xforms:hint">
        <!--  already handled by individual controls -->
    </xsl:template>

    <!-- ### handle help ### -->
    <!-- ### only reacts on help elements with a 'src' attribute and interprets it as html href ### -->
    <xsl:template match="xforms:help">
        ?
        <!--
                <span style="font-color:blue;vertical-align:top;padding-left:2px;font-weight:bold">
                    <xsl:if test="@xforms:src">
                        <a href="{@xforms:src}">?</a>
                    </xsl:if>
                </span>
        -->
        <!--        <img src="images/kasten_blau.gif"/>-->
        <!-- this implementation renders a button to display a javascript message -->
        <!--        <img src="images/help.gif" onClick="javascript:xf_help('{normalize-space(.)}');return true;"/>-->
    </xsl:template>

    <!-- ### handle explicitely enabled alert ### -->
    <!--    <xsl:template match="xforms:alert[../chiba:data/@chiba:valid='false']">-->
    <xsl:template match="xforms:alert">

            <xsl:if test="../chiba:data/@chiba:valid='false'">
                <span class="alert">
                    <xsl:value-of select="."/>
                </span>
            </xsl:if>

<!--
        <xsl:if test="$phase!='init' and ../chiba:data/@chiba:valid='false'">
            <span class="alert">
                <xsl:value-of select="."/>
            </span>
        </xsl:if>
-->
    </xsl:template>

    <!-- ### skip alert ### -->
    <!--    <xsl:template match="xforms:alert">-->
    <!--    </xsl:template>-->

    <!-- ### handle extensions ### -->
    <xsl:template match="xforms:extension">
        <xsl:apply-templates/>
    </xsl:template>

    <xsl:template match="chiba:selector">
    </xsl:template>


    <!-- ########################## ACTIONS ####################################################### -->
    <!-- these templates serve no real purpose here but are shown for reference what may be over-   -->
    <!-- written by customized stylesheets importing this one. -->
    <!-- ########################## ACTIONS ####################################################### -->

    <!-- action nodes are simply copied to output without any modification -->
    <xsl:template match="xforms:action">
        <xsl:apply-templates/>
    </xsl:template>
    <xsl:template match="xforms:dispatch"/>
    <xsl:template match="xforms:rebuild"/>
    <xsl:template match="xforms:recalculate"/>
    <xsl:template match="xforms:revalidate"/>
    <xsl:template match="xforms:refresh"/>
    <xsl:template match="xforms:setfocus"/>
    <xsl:template match="xforms:load"/>
    <xsl:template match="xforms:setvalue"/>
    <xsl:template match="xforms:send"/>
    <xsl:template match="xforms:reset"/>
    <xsl:template match="xforms:message"/>
    <xsl:template match="xforms:toggle"/>
    <xsl:template match="xforms:insert"/>
    <xsl:template match="xforms:delete"/>
    <xsl:template match="xforms:setindex"/>


    <!-- ####################################################################################################### -->
    <!-- #####################################  HELPER TEMPLATES '############################################## -->
    <!-- ####################################################################################################### -->

    <!-- support for custom chiba:index param. Can be used in local scripts to change the value the server receives
    for update -->
    <!--
        <xsl:template name="setindex">
            <xsl:param name="repeat-node"/>
            <xsl:param name="index"/>

            <xsl:choose>
                <xsl:when test="$repeat-node/@chiba:index=$index">
                    <input type="radio" name="chiba:head/cursor/{$repeat-node/@id}" value="{$index}" checked="true"/>
                </xsl:when>
                <xsl:otherwise>
                    <input type="radio" name="chiba:head/cursor/{$repeat-node/@id}" value="{$index}"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:template>

    -->
    <xsl:template name="buildControl">
        <xsl:if test="$debug-enabled='true'">
            <xsl:message>html-std: buildControl:
                <xsl:value-of select="name(.)"/>
            </xsl:message>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="local-name()='input'">
                <xsl:call-template name="input"/>
                <xsl:apply-templates select="xforms:help"/>
                <xsl:apply-templates select="xforms:alert"/>
            </xsl:when>
            <xsl:when test="local-name()='output'">
                <xsl:call-template name="output"/>
                <xsl:apply-templates select="xforms:help"/>
                <xsl:apply-templates select="xforms:alert"/>
            </xsl:when>
            <xsl:when test="local-name()='range'">
                <xsl:apply-templates select="xforms:help"/>
                <xsl:apply-templates select="xforms:alert"/>
            </xsl:when>
            <xsl:when test="local-name()='secret'">
                <xsl:call-template name="secret"/>
                <xsl:apply-templates select="xforms:help"/>
                <xsl:apply-templates select="xforms:alert"/>
            </xsl:when>
            <xsl:when test="local-name()='select'">
                <xsl:call-template name="select"/>
                <xsl:apply-templates select="xforms:help"/>
                <xsl:apply-templates select="xforms:alert"/>
            </xsl:when>
            <xsl:when test="local-name()='select1'">
                <xsl:call-template name="select1"/>
                <xsl:apply-templates select="xforms:help"/>
                <xsl:apply-templates select="xforms:alert"/>
            </xsl:when>
            <xsl:when test="local-name()='submit'">
                <xsl:call-template name="submit"/>
                <xsl:apply-templates select="xforms:help"/>
                <xsl:apply-templates select="xforms:alert"/>
            </xsl:when>
            <xsl:when test="local-name()='trigger'">
                <xsl:call-template name="trigger"/>
                <xsl:apply-templates select="xforms:help"/>
                <xsl:apply-templates select="xforms:alert"/>
            </xsl:when>
            <xsl:when test="local-name()='textarea'">
                <xsl:call-template name="textarea"/>
                <xsl:apply-templates select="xforms:help"/>
                <xsl:apply-templates select="xforms:alert"/>
            </xsl:when>
            <xsl:when test="local-name()='upload'">
                <xsl:call-template name="upload"/>
                <xsl:apply-templates select="xforms:help"/>
                <xsl:apply-templates select="xforms:alert"/>
            </xsl:when>
            <xsl:when test="local-name()='repeat'">
                <xsl:apply-templates select="."/>
            </xsl:when>
            <xsl:when test="local-name()='group'">
                <xsl:apply-templates select="."/>
                <xsl:apply-templates select="xforms:help"/>
                <xsl:apply-templates select="xforms:alert"/>
            </xsl:when>
            <xsl:when test="local-name()='switch'">
                <xsl:apply-templates select="."/>
            </xsl:when>
        </xsl:choose>
    </xsl:template>


</xsl:stylesheet>




