<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xforms="http://www.w3.org/2002/xforms"
    xmlns:xlink="http://www.w3.org/1999/xlink"
    xmlns:chiba="http://chiba.sourceforge.net/2003/08/xforms"
    exclude-result-prefixes="chiba xforms xlink xsl">
    <!-- #############################################################################################################
        this stylesheet is generic for browsers that support the DOM more specifically IE5.5+ , Netscape6+ und Mozilla.
    ############################################################################################################## -->

    <!-- builds on html4.xsl and overwrites only templates that need to integrate javascript somehow -->
    <xsl:import href="html4.xsl"/>

    <!--    <xsl:param name="css" select="'styles/styles.css'"/>-->

    <!-- ### checks, wheter the 'date' datatype is used in this form. Used to conditionally include javascript ### -->
    <xsl:variable name="uses-dates" select="boolean(//*/@chiba:type='date')"/>

    <!--    <xsl:variable name="uses-upload" select="boolean(//*/xforms:upload)" />-->

    <xsl:output method="html" encoding="ISO-8859-1" omit-xml-declaration="yes"/>

    <!--<xsl:param name="action-path" select="''"/>-->
    <!--    <xsl:param name="action-path" select="''"/>-->
    <xsl:param name="base-url" select="''"/>
    <xsl:param name="form-id" select="'chiba-form'"/>
    <xsl:param name="form-name" select="'Chiba XForms Processor'"/>

    <xsl:preserve-space elements="*"/>
    <xsl:strip-space elements="xforms:action"/>

    <!-- match html or other surrounding markup -->
    <xsl:template match="/">
        <html>
            <head>
                <title>
                    <xsl:value-of select="$form-name"/>
                </title>
                <script language="javascript" src="scripts/actions.js"/>
                <script language="javascript" src="scripts/commons.js"/>

                <xsl:if test="$uses-dates">
                    <script language='javascript' src='scripts/popcalendar.js'/>
                </xsl:if>
                <link rel="stylesheet" type="text/css" href="{$css}"/>
            </head>
            <body>
                <xsl:element name="form">
                    <xsl:attribute name="name">
                        <xsl:value-of select="$form-id"/>
                    </xsl:attribute>
                    <!--                    <xsl:attribute name="action"><xsl:value-of select="$base-url"/>/<xsl:value-of select="$action-path"/></xsl:attribute>-->
                    <xsl:attribute name="action">
                        <xsl:value-of select="$base-url"/>/
                        <xsl:value-of select="$action-url"/>
                    </xsl:attribute>
                    <xsl:attribute name="method">post</xsl:attribute>
                    <xsl:attribute name="enctype">application/x-www-form-urlencoded</xsl:attribute>
                    <xsl:if test="$uses-upload">
                        <xsl:attribute name="enctype">multipart/form-data</xsl:attribute>
                    </xsl:if>
                    <!--                    <xsl:apply-templates select=".//body/*"/>-->
                    <xsl:apply-templates/>
                </xsl:element>
            </body>
        </html>
    </xsl:template>

    <!-- ### ignore following elements ### -->
    <xsl:template match="head"/>
    <xsl:template match="body"/>

    <!-- handle input -->
    <xsl:template name="input">
        <xsl:variable name="id" select="@id"/>
        <xsl:variable name="curr" select="."/>

        <xsl:variable name="repeat-id" select="ancestor::*[name(.)='xforms:repeat'][1]/@id"/>
        <xsl:variable name="pos" select="position()" />
        <xsl:element name="input">
            <xsl:attribute name="id">
                <xsl:value-of select="$id"/>
            </xsl:attribute>
            <xsl:attribute name="type">text</xsl:attribute>
            <xsl:attribute name="name">
                <xsl:value-of select="$id"/>
            </xsl:attribute>
            <xsl:attribute name="value">
                <xsl:value-of select="chiba:data"/>
            </xsl:attribute>
            <!--<xsl:attribute name="style">background-color:transparent;</xsl:attribute>-->
            <!--<xsl:attribute name="class">input-control</xsl:attribute>-->
            <xsl:attribute name="title">
                <xsl:value-of select="./xforms:hint"/>
            </xsl:attribute>

            <xsl:if test="chiba:data/@chiba:type='date'">
                <xsl:attribute name="type">button</xsl:attribute>
                <xsl:attribute name="onclick">
                    javascript:popUpCalendar(this, this, 'dd.mm.yyyy');return true;
                </xsl:attribute>
                <xsl:attribute name="onSelect">
                    javascript:popUpCalendar(this, this, 'dd.mm.yyyy');return true;
                </xsl:attribute>
                <xsl:attribute name="style">background-color:transparent;</xsl:attribute>
            </xsl:if>
            <xsl:choose>
                <xsl:when test="boolean(string-length($repeat-id) > 0)">
                    <xsl:attribute name="class"><xsl:value-of select="concat($repeat-id,'-',$pos,' input-widget')"/></xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="class">input-widget</xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>

        </xsl:element>

        <xsl:if test="./chiba:data/@chiba:required='true'">
            <font color="red">*</font>
        </xsl:if>

        <xsl:apply-templates select="xforms:help"/>
        <xsl:apply-templates select="xforms:alert"/>
    </xsl:template>

    <!-- handle trigger / submit -->
    <xsl:template match="xforms:trigger|xforms:submit">
        <span class="trigger-control">
            <xsl:element name="input">
                <xsl:attribute name="type">button</xsl:attribute>
                <xsl:attribute name="name">
                    <xsl:value-of select="chiba:data/@chiba:name"/>
                </xsl:attribute>
                <xsl:attribute name="value">
                    <xsl:value-of select="xforms:label"/>
                </xsl:attribute>
                <xsl:attribute name="title">
                    <xsl:value-of select="xforms:hint"/>
                </xsl:attribute>
                <xsl:call-template name="eval-actions"/>
            </xsl:element>
        </span>
        <xsl:apply-templates select="xforms:help|xforms:alert"/>
    </xsl:template>

    <xsl:template name="eval-actions">
        <xsl:if test="xforms:insert|xforms:delete">
            <xsl:attribute name="onClick">javascript:
                <xsl:apply-templates select="xforms:insert|xforms:delete"/>return true;
            </xsl:attribute>
        </xsl:if>
    </xsl:template>

    <!-- handle image trigger -->
    <xsl:template match="xforms:trigger[starts-with(./xforms:label/@xlink:href,'images')]">
        <span class="trigger-control">
            <xsl:element name="input">
                <xsl:attribute name="type">image</xsl:attribute>
                <xsl:attribute name="name">
                    <xsl:value-of select="chiba:data/@chiba:name"/>
                </xsl:attribute>
                <xsl:attribute name="value">
                    <xsl:value-of select="xforms:label"/>
                </xsl:attribute>
                <xsl:attribute name="src">
                    <xsl:value-of select="xforms:label/@xlink:href"/>
                </xsl:attribute>
                <xsl:attribute name="title">
                    <xsl:value-of select="xforms:hint"/>
                </xsl:attribute>
                <xsl:call-template name="eval-actions"/>
            </xsl:element>
        </span>
        <xsl:apply-templates select="xforms:help|xforms:alert"/>

    </xsl:template>

    <!-- handle help -->
    <xsl:template match="xforms:help">
        <!-- this implementation renders a button to display a javascript message -->
        <img src="images/help.gif" onClick="javascript:xf_help('{normalize-space(.)}');return true;"/>
    </xsl:template>


    <!-- ########################## ACTIONS ####################################################### -->
    <!-- ########################## ACTIONS ####################################################### -->
    <!-- ########################## ACTIONS ####################################################### -->

    <!-- this implementation always uses the current index position (chiba:index) as reference for inserting -->
    <xsl:template match="xforms:insert">
        <xsl:variable name="ref" select="@chiba:repeatref"/>
        <xsl:text>xf_insert('</xsl:text>
        <xsl:value-of select="$ref"/>
        <xsl:text>');</xsl:text>
    </xsl:template>

    <xsl:template match="xforms:delete">
        <xsl:variable name="ref" select="@chiba:repeatref"/>
        <xsl:text>xf_delete('</xsl:text>
        <xsl:value-of select="$ref"/>
        <xsl:text>');</xsl:text>
    </xsl:template>


</xsl:stylesheet>

