/*
 *
 *    Artistic License
 *
 *    Preamble
 *
 *    The intent of this document is to state the conditions under which a Package may be copied, such that
 *    the Copyright Holder maintains some semblance of artistic control over the development of the
 *    package, while giving the users of the package the right to use and distribute the Package in a
 *    more-or-less customary fashion, plus the right to make reasonable modifications.
 *
 *    Definitions:
 *
 *    "Package" refers to the collection of files distributed by the Copyright Holder, and derivatives
 *    of that collection of files created through textual modification.
 *
 *    "Standard Version" refers to such a Package if it has not been modified, or has been modified
 *    in accordance with the wishes of the Copyright Holder.
 *
 *    "Copyright Holder" is whoever is named in the copyright or copyrights for the package.
 *
 *    "You" is you, if you're thinking about copying or distributing this Package.
 *
 *    "Reasonable copying fee" is whatever you can justify on the basis of media cost, duplication
 *    charges, time of people involved, and so on. (You will not be required to justify it to the
 *    Copyright Holder, but only to the computing community at large as a market that must bear the
 *    fee.)
 *
 *    "Freely Available" means that no fee is charged for the item itself, though there may be fees
 *    involved in handling the item. It also means that recipients of the item may redistribute it under
 *    the same conditions they received it.
 *
 *    1. You may make and give away verbatim copies of the source form of the Standard Version of this
 *    Package without restriction, provided that you duplicate all of the original copyright notices and
 *    associated disclaimers.
 *
 *    2. You may apply bug fixes, portability fixes and other modifications derived from the Public Domain
 *    or from the Copyright Holder. A Package modified in such a way shall still be considered the
 *    Standard Version.
 *
 *    3. You may otherwise modify your copy of this Package in any way, provided that you insert a
 *    prominent notice in each changed file stating how and when you changed that file, and provided that
 *    you do at least ONE of the following:
 *
 *        a) place your modifications in the Public Domain or otherwise make them Freely
 *        Available, such as by posting said modifications to Usenet or an equivalent medium, or
 *        placing the modifications on a major archive site such as ftp.uu.net, or by allowing the
 *        Copyright Holder to include your modifications in the Standard Version of the Package.
 *
 *        b) use the modified Package only within your corporation or organization.
 *
 *        c) rename any non-standard executables so the names do not conflict with standard
 *        executables, which must also be provided, and provide a separate manual page for each
 *        non-standard executable that clearly documents how it differs from the Standard
 *        Version.
 *
 *        d) make other distribution arrangements with the Copyright Holder.
 *
 *    4. You may distribute the programs of this Package in object code or executable form, provided that
 *    you do at least ONE of the following:
 *
 *        a) distribute a Standard Version of the executables and library files, together with
 *        instructions (in the manual page or equivalent) on where to get the Standard Version.
 *
 *        b) accompany the distribution with the machine-readable source of the Package with
 *        your modifications.
 *
 *        c) accompany any non-standard executables with their corresponding Standard Version
 *        executables, giving the non-standard executables non-standard names, and clearly
 *        documenting the differences in manual pages (or equivalent), together with instructions
 *        on where to get the Standard Version.
 *
 *        d) make other distribution arrangements with the Copyright Holder.
 *
 *    5. You may charge a reasonable copying fee for any distribution of this Package. You may charge
 *    any fee you choose for support of this Package. You may not charge a fee for this Package itself.
 *    However, you may distribute this Package in aggregate with other (possibly commercial) programs as
 *    part of a larger (possibly commercial) software distribution provided that you do not advertise this
 *    Package as a product of your own.
 *
 *    6. The scripts and library files supplied as input to or produced as output from the programs of this
 *    Package do not automatically fall under the copyright of this Package, but belong to whomever
 *    generated them, and may be sold commercially, and may be aggregated with this Package.
 *
 *    7. C or perl subroutines supplied by you and linked into this Package shall not be considered part of
 *    this Package.
 *
 *    8. The name of the Copyright Holder may not be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 *    9. THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
 *    WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 *    MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 */
package org.chiba.xml.xforms.constraints;

import com.sun.msv.datatype.xsd.DatatypeFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.log4j.Category;
import org.chiba.xml.xforms.Instance;
import org.chiba.xml.xforms.LocalValue;
import org.chiba.xml.xforms.NamespaceCtx;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

import java.util.Iterator;

/**
 * Validates instance items.
 *
 * @version $Id: Validator.java,v 1.17 2004/01/27 09:59:49 joernt Exp $
 */
public class Validator implements ValidationContext {
	private static Category LOGGER = Category.getInstance(Validator.class);

	/**
	 * Creates a new Validator object.
	 */
	public Validator() {
	}

	// implementation of 'org.relaxng.datatype.ValidationContext'
	public String getBaseUri() {
        // todo: pass container base uri ???
        LOGGER.warn("NYI: getBaseUri");
		return null;
	}

	/**
	 * __UNDOCUMENTED__
	 *
	 * @param attr __UNDOCUMENTED__
	 *
	 * @return __UNDOCUMENTED__
	 */
	private static boolean isInstanceAttribute(Attr attr) {
		if (attr.getNamespaceURI() == null) {
			return true;
		}

		if (NamespaceCtx.XML_NS.equals(attr.getNamespaceURI())) {
			return false;
		}

		if (NamespaceCtx.XMLNS_NS.equals(attr.getNamespaceURI())) {
			return false;
		}

		return true;
	}

	/**
	 * __UNDOCUMENTED__
	 *
	 * @param s __UNDOCUMENTED__
	 *
	 * @return __UNDOCUMENTED__
	 */
	public boolean isNotation(String s) {
        LOGGER.warn("NYI: isNotation: " + s);
		return false;
	}

	/**
	 * __UNDOCUMENTED__
	 *
	 * @param s __UNDOCUMENTED__
	 *
	 * @return __UNDOCUMENTED__
	 */
	public boolean isUnparsedEntity(String s) {
        LOGGER.warn("NYI: isUnparsedEntity: " + s);
		return false;
	}

	/**
	 * __UNDOCUMENTED__
	 *
	 * @param s __UNDOCUMENTED__
	 *
	 * @return __UNDOCUMENTED__
	 */
	public String resolveNamespacePrefix(String s) {
        LOGGER.warn("NYI: resolveNamespacePrefix: " + s);
		return null;
	}

	// validator interface
	public boolean validate(Instance instance) {
		// validate all instance nodes
		return validate(instance, "/");
	}

	/**
	 * validates the part of the instance which is given through
	 * the path expression
	 *
	 * @param instance the Instance object
	 * @param path a xpath expression representing the subtree of the instance to be validated
	 *
	 * @return false, if any of the given constraints on the instance fail. true otherwise.
	 */
	public boolean validate(Instance instance, String path) {
		// initialize
		boolean result = true;
		String expressionPath = path;

		if (!path.endsWith("/")) {
			expressionPath = expressionPath + "/";
		}

        // set expression path to contain the specified path and its subtree
		expressionPath = expressionPath + "descendant-or-self::*";

		// evaluate expression path
		JXPathContext context = instance.getInstanceContext();
		Iterator iterator = context.iteratePointers(expressionPath);
		Pointer locationPointer;
		String locationPath;

		while (iterator.hasNext()) {
			locationPointer = (Pointer)iterator.next();
			locationPath = locationPointer.asPath();

			// validate element node
			result &= validateNode(instance, locationPath);

			// handle attributes explicitely since JXPath has
			// seriuos problems with namespaced attributes
			Element element = (Element)locationPointer.getNode();
			NamedNodeMap attributes = element.getAttributes();

			for (int index = 0; index < attributes.getLength(); index++) {
				Attr attr = (Attr)attributes.item(index);

				if (isInstanceAttribute(attr)) {
					// validate attribute node
					result &= validateNode(instance, locationPath + "/@" + attr.getNodeName());
				}
			}
		}

		return result;
	}

	private boolean checkDatatype(String type, String value) {
		try {
			return DatatypeFactory.getTypeByName(type).isValid(value, this);
		} catch (DatatypeException e) {
			LOGGER.error("datatype validation failed - assuming valid", e);

			return true;
		}
	}

	private boolean validateNode(Instance instance, String path) {
		// lookup model item
		LocalValue localValue = instance.getDataItem(path);

		// check only items that are *relevant* and *constraint-valid*
        if (!localValue.isEnabled()) {
			if (LOGGER.isDebugEnabled()) {
				LOGGER.debug("skipping non-relevant node " + path);
			}

			return true;
		}

		if (!localValue.isConstraintValid()) {
			if (LOGGER.isDebugEnabled()) {
				LOGGER.debug("ignoring constraint-invalid node " + path);
			}

			return false;
		}

		// get type and value
		String type = localValue.getDatatype();
		String value = localValue.getValue();

		// compute *type-valid*
		if (type != null) {
			localValue.setDatatypeValid(checkDatatype(type, value));
		} else {
            // default to string rule
            localValue.setDatatypeValid(checkDatatype("string", value));
//			localValue.setDatatypeValid(true);
		}

		// compute *required-valid*
		if (localValue.isLocalRequired()) {
			localValue.setRequiredValid(value.length() > 0);
		} else {
			localValue.setRequiredValid(true);
		}

        // propagate calculation/validation changes
        localValue.notifyListeners();

		// get validation result
		boolean result = localValue.isValid();

		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("computed " + (result
			                            ? "valid"
			                            : "invalid") + " node " + path);
		}

		return result;
	}
}
//end of class

