/*
 *
 *    Artistic License
 *
 *    Preamble
 *
 *    The intent of this document is to state the conditions under which a Package may be copied, such that
 *    the Copyright Holder maintains some semblance of artistic control over the development of the
 *    package, while giving the users of the package the right to use and distribute the Package in a
 *    more-or-less customary fashion, plus the right to make reasonable modifications.
 *
 *    Definitions:
 *
 *    "Package" refers to the collection of files distributed by the Copyright Holder, and derivatives
 *    of that collection of files created through textual modification.
 *
 *    "Standard Version" refers to such a Package if it has not been modified, or has been modified
 *    in accordance with the wishes of the Copyright Holder.
 *
 *    "Copyright Holder" is whoever is named in the copyright or copyrights for the package.
 *
 *    "You" is you, if you're thinking about copying or distributing this Package.
 *
 *    "Reasonable copying fee" is whatever you can justify on the basis of media cost, duplication
 *    charges, time of people involved, and so on. (You will not be required to justify it to the
 *    Copyright Holder, but only to the computing community at large as a market that must bear the
 *    fee.)
 *
 *    "Freely Available" means that no fee is charged for the item itself, though there may be fees
 *    involved in handling the item. It also means that recipients of the item may redistribute it under
 *    the same conditions they received it.
 *
 *    1. You may make and give away verbatim copies of the source form of the Standard Version of this
 *    Package without restriction, provided that you duplicate all of the original copyright notices and
 *    associated disclaimers.
 *
 *    2. You may apply bug fixes, portability fixes and other modifications derived from the Public Domain
 *    or from the Copyright Holder. A Package modified in such a way shall still be considered the
 *    Standard Version.
 *
 *    3. You may otherwise modify your copy of this Package in any way, provided that you insert a
 *    prominent notice in each changed file stating how and when you changed that file, and provided that
 *    you do at least ONE of the following:
 *
 *        a) place your modifications in the Public Domain or otherwise make them Freely
 *        Available, such as by posting said modifications to Usenet or an equivalent medium, or
 *        placing the modifications on a major archive site such as ftp.uu.net, or by allowing the
 *        Copyright Holder to include your modifications in the Standard Version of the Package.
 *
 *        b) use the modified Package only within your corporation or organization.
 *
 *        c) rename any non-standard executables so the names do not conflict with standard
 *        executables, which must also be provided, and provide a separate manual page for each
 *        non-standard executable that clearly documents how it differs from the Standard
 *        Version.
 *
 *        d) make other distribution arrangements with the Copyright Holder.
 *
 *    4. You may distribute the programs of this Package in object code or executable form, provided that
 *    you do at least ONE of the following:
 *
 *        a) distribute a Standard Version of the executables and library files, together with
 *        instructions (in the manual page or equivalent) on where to get the Standard Version.
 *
 *        b) accompany the distribution with the machine-readable source of the Package with
 *        your modifications.
 *
 *        c) accompany any non-standard executables with their corresponding Standard Version
 *        executables, giving the non-standard executables non-standard names, and clearly
 *        documenting the differences in manual pages (or equivalent), together with instructions
 *        on where to get the Standard Version.
 *
 *        d) make other distribution arrangements with the Copyright Holder.
 *
 *    5. You may charge a reasonable copying fee for any distribution of this Package. You may charge
 *    any fee you choose for support of this Package. You may not charge a fee for this Package itself.
 *    However, you may distribute this Package in aggregate with other (possibly commercial) programs as
 *    part of a larger (possibly commercial) software distribution provided that you do not advertise this
 *    Package as a product of your own.
 *
 *    6. The scripts and library files supplied as input to or produced as output from the programs of this
 *    Package do not automatically fall under the copyright of this Package, but belong to whomever
 *    generated them, and may be sold commercially, and may be aggregated with this Package.
 *
 *    7. C or perl subroutines supplied by you and linked into this Package shall not be considered part of
 *    this Package.
 *
 *    8. The name of the Copyright Holder may not be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 *    9. THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
 *    WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 *    MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 */
package org.chiba.tools.schemabuilder.test;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.chiba.tools.schemabuilder.BaseSchemaFormBuilder;
import org.chiba.tools.schemabuilder.FormBuilderException;
import org.chiba.tools.schemabuilder.SchemaFormBuilder;
import org.chiba.xml.util.DOMComparator;
import org.chiba.xml.util.DOMUtil;
import org.w3c.dom.Document;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;

/** Unit tests for BaseSchemaFormBuilder. Most functions are tested
 * through XML in- and output-files.
 *
 * TODO: Complete unit tests. Only basic testing performed right now.
 *
 * @author Brian Dueck
 * @version $Id: BaseSchemaFormBuilderTest.java,v 1.13 2004/03/05 08:53:29 soframel Exp $
 *
 */
public class BaseSchemaFormBuilderTest extends TestCase {
	private SchemaFormBuilder builder;

	/**
	 * Creates a new BaseSchemaFormBuilderTest object.
	 *
	 * @param name __UNDOCUMENTED__
	 */
	public BaseSchemaFormBuilderTest(String name) {
		super(name);
	}

	/**
	 * __UNDOCUMENTED__
	 *
	 * @param args __UNDOCUMENTED__
	 */
	public static void main(String[] args) {
		junit.textui.TestRunner.run(suite());

		//        junit.textui.TestRunner.run(runAll());
	}

	/**
	 * __UNDOCUMENTED__
	 *
	 * @return __UNDOCUMENTED__
	 */
	public static Test suite() {
		return new TestSuite(BaseSchemaFormBuilderTest.class);
	}

	/** Test failure scenario of invalid root element.
	 *
	 */
	public void testBuildForm_BadRootElementFailure() throws Exception {
		try {
			URL url=getClass().getResource("basicTest.xsd");

			builder = new BaseSchemaFormBuilder("invalidRootElement");

			Document form = builder.buildForm(url.getPath());

			// the previous line should cause an exception,
			// so we should never make it here
			//
			Assert.fail("Expected " + FormBuilderException.class.getName() + " to be thrown.");
		} catch (FormBuilderException eatMe) {
		}
	}

	/**
	 * todo: fake test - does include &apos; entities and still has namespace problems to be solved
     * with the new Xerces impl.
	 *
	 */
	/*public void testBuildForm_Basic() throws Exception {
		URL url=getClass().getResource("basicTest.xsd");

		builder = new BaseSchemaFormBuilder("basicSchemaTest");

		Document form = builder.buildForm(url.getPath());
		assertNotNull(form);

//        DOMUtil.prettyPrintDOM(form);

		Document expected = getXmlResource("basicTest-expected.xml");
		assertNotNull(expected);

		File f1 = new File("basicTest_expected.xml");
		FileOutputStream fout = new FileOutputStream(f1);
		File f2 = new File("basicTest_result.xml");
		FileOutputStream fout2 = new FileOutputStream(f2);
		DOMUtil.prettyPrintDOM(expected.getDocumentElement(), fout);
		DOMUtil.prettyPrintDOM(form.getDocumentElement(), fout2);

                //namespace problem when we test the documents
//		assertTrue(getComparator().compare(form.getDocumentElement(), expected.getDocumentElement()));
		assertTrue(getComparator().compare(f1, f2));
	}*/

	public void testBuildForm_Basic_noInheritence() throws Exception {
		URL url=getClass().getResource("basicTest-noInheritence.xsd");																		 

		builder = new BaseSchemaFormBuilder("basicSchemaTest");

		Document form = builder.buildForm(url.getPath());
		assertNotNull(form);

		Document expected = getXmlResource("basicTest-noInheritence-expected.xml");
		assertNotNull(expected);

		File f1 = new File("basicTest-noInheritence_expected.xml");
		FileOutputStream fout = new FileOutputStream(f1);
		File f2 = new File("basicTest-noInheritence_result.xml");
		FileOutputStream fout2 = new FileOutputStream(f2);
		DOMUtil.prettyPrintDOM(expected.getDocumentElement(), fout);
		DOMUtil.prettyPrintDOM(form.getDocumentElement(), fout2);

		//namespace problem when we test the documents
		//assertTrue(getComparator().compare(form.getDocumentElement(), expected.getDocumentElement()));
		assertTrue(getComparator().compare(f1, f2));
	}

	/**
	 * __UNDOCUMENTED__
	 *
	 * @throws Exception __UNDOCUMENTED__
	 */
	public void testBuildForm_PurchaseOrder() throws Exception {
		URL url=getClass().getResource("purchaseOrder.xsd");
		builder = new BaseSchemaFormBuilder("purchaseOrder");

		Document form = builder.buildForm(url.getPath());
		assertNotNull(form);

		Document expected = getXmlResource("purchaseOrder-expected.xml");
		assertNotNull(expected);

		File f1 = new File("purchaseOrder_expected.xml");
		FileOutputStream fout = new FileOutputStream(f1);
		File f2 = new File("purchaseOrder_result.xml");
		FileOutputStream fout2 = new FileOutputStream(f2);
		DOMUtil.prettyPrintDOM(expected.getDocumentElement(), fout);
		DOMUtil.prettyPrintDOM(form.getDocumentElement(), fout2);

                //namespace problem when we test the documents
		//assertTrue(getComparator().compare(form.getDocumentElement(),expected.getDocumentElement()));
		assertTrue(getComparator().compare(f1, f2));
	}

	/**
	 * __UNDOCUMENTED__
	 *
	 * @throws Exception __UNDOCUMENTED__
	 */
	public void testBuildForm_PurchaseOrderRepeats() throws Exception {
		URL url=getClass().getResource("purchaseOrderRepeats.xsd");

		builder = new BaseSchemaFormBuilder("purchaseOrder");

		Document form = builder.buildForm(url.getPath());
		assertNotNull(form);

//        DOMUtil.prettyPrintDOM(form);

		Document expected = getXmlResource("purchaseOrder-repeat-expected.xml");
		assertNotNull(expected);

		File f1 = new File("purchaseOrder-repeat_expected.xml");
		FileOutputStream fout = new FileOutputStream(f1);
		File f2 = new File("purchaseOrder-repeat_result.xml");
		FileOutputStream fout2 = new FileOutputStream(f2);
		DOMUtil.prettyPrintDOM(expected.getDocumentElement(), fout);
		DOMUtil.prettyPrintDOM(form.getDocumentElement(), fout2);

                //namespace problem when we test the documents
		//assertTrue(getComparator().compare(form.getDocumentElement(),expected.getDocumentElement()));
		assertTrue(getComparator().compare(f1, f2));
	}

	/**
	 * __UNDOCUMENTED__
	 *
	 * @throws Exception __UNDOCUMENTED__
	 */
	protected void setUp() throws Exception {
	}

	/**
	 * __UNDOCUMENTED__
	 */
	protected void tearDown() {
		this.builder = null;
	}

	private DOMComparator getComparator() {
		DOMComparator comparator = new DOMComparator();
		comparator.setIgnoreWhitespace(true);
		comparator.setIgnoreComments(true);
		comparator.setIgnoreNamespaceDeclarations(false);
		comparator.setPrintErrors(true);

		return comparator;
	}

	// TODO: getXMLResource() and getComparator() were copied from org.chiba.xml.xforms.test
	// This should be moved to a generic unit test helper class.
	//
	// ++++++++++++ oops, don't look at my private parts!  +++++++++++++++
	//helper - should be moved elsewhere...
	private Document getXmlResource(String fileName) throws Exception {
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		factory.setNamespaceAware(true);
		factory.setValidating(false);

		// Create builder.
		DocumentBuilder builder = factory.newDocumentBuilder();

		// Parse files.
		return builder.parse(getClass().getResourceAsStream(fileName));
	}
}
// end of class
