package org.chiba.connectors.xmlrpc;

import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;

public class DocTransformer {

	private Document doc;

	public DocTransformer() {};
	
	public DocTransformer(Document doc) {
		this.doc = doc;
	}
	
	public DocTransformer(byte[] bytes) throws SAXException, IOException {
		DocumentBuilder builder = getDocumentBuilder();
		doc = builder.parse(new ByteArrayInputStream(bytes));
	}
	
	public DocTransformer(String string) throws SAXException, IOException {
		DocumentBuilder builder = getDocumentBuilder();
		doc = builder.parse(string);
	}
	
	public DocTransformer(File file) throws SAXException, IOException {
		DocumentBuilder builder = getDocumentBuilder();
		doc = builder.parse(file);
	}
	
	public Document getDoc() {
		return doc;
	}

	private DocumentBuilder getDocumentBuilder() {
		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			factory.setNamespaceAware(true);
			factory.setValidating(false);
			factory.setAttribute("http://apache.org/xml/properties/dom/document-class-name",
                                 "org.chiba.xml.xforms.XFormsDocument");
			
			return factory.newDocumentBuilder();
		} catch (Exception e) {
			System.out.println("Unable to create document factory: " + e.toString());
		}
		return null;
	}
}

