<?xml version="1.0" encoding="UTF-8" ?>

<!--
   <comment>
		****************
		(C) 2003-2004, 1060 Research Limited. All rights reserved.
		Licensed under the 1060 Blogxter Non-commerical-Use License v1.0 -
		You are permitted to use this software only for non-commercial applications.
		For commercial licenses visit: http://www.1060research.com/license
		1060 is a registered trademark of 1060 Research Ltd.
		**********
		</comment>
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

	<xsl:param name="param"/>
	
    <xsl:template match="/nvp">
			<xsl:variable name="id" select="translate(id, ' #:@','_---')"/>
			<sql>
				UPDATE resources SET 
					resource=?,
					created=NOW(),
					URI='/resources/<xsl:value-of select="blogid"/>/<xsl:value-of select="$id"/>.<xsl:value-of select="substring-after(file, '.')"/>',
					descr='<xsl:value-of select="descr"/>',
					title='<xsl:value-of select="$id"/>.<xsl:value-of select="substring-after(file, '.')"/>',
					mimetype='<xsl:value-of select="$param/mimetype"/>'
					where id='<xsl:value-of select="$id"/>' AND blogid=<xsl:value-of select="blogid"/>
					;
			</sql>
    </xsl:template>

</xsl:stylesheet> 
