/******************************************************************************
  (c) Copyright 2002-2004, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: NKURIResolver.java,v $
  Version:       $Name:  $ $Revision: 1.7 $
  Last Modified: $Date: 2005/07/06 15:19:28 $
 *****************************************************************************/

package org.ten60.netkernel.xforms.connector;

//import org.ten60.netkernel.xforms.accessor.XFormsAccessor;
import org.chiba.xml.xforms.connector.*;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.util.*;
import org.ten60.netkernel.xforms.adapter.*;

import javax.xml.parsers.*;
import org.w3c.dom.*;
import java.net.*;
import java.io.*;
import java.util.*;
/**
 *
 * @author  pjr
 */
public class NKURIResolver implements URIResolver
{
	private String mURI;
	
	private Map mContext;
	
	/** Creates a new instance of NKURIResolver */
	public NKURIResolver()
	{
	}
	
	public Object resolve() throws org.chiba.xml.xforms.exception.XFormsLinkException
	{	try {
            INKFConvenienceHelper context=(INKFConvenienceHelper)mContext.get(NetKernelAdapter2.NKF_REQUEST_HELPER);			
			IXAspect xaa=(IXAspect)context.sourceAspect(mURI, IXAspect.class);
			Document document = (Document)XMLUtils.getInstance().safeDeepClone(xaa.getReadOnlyDocument());
            return document;
        }
        catch (Exception e) {
            throw new org.chiba.xml.xforms.exception.XFormsLinkException(mURI, e, null, null);
        }
    }
	
	public void setURI(String uri)
	{	mURI=uri;
	}
	
	public String getURI()
	{	return mURI;
	}
	
	public java.util.Map getContext()
	{	return mContext;
	}	
	
	public void setContext(java.util.Map context)
	{	mContext=context;
	}
	
}
