/*
	PiNKY Project : Execute Yahoo Pipelines on 1060 NetKernel!
    Copyright (C) 2007  Peter Rodgers

	GPL License Notice:
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
	
	1060 Public License Notice:
	 * This Software is licensed to You, the licensee, for use under the terms of
	 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
	 * License v1.0 [www.1060research.com/license] before using or redistributing
	 * this software.
	 *
	 * In summary the 1060 Public license has the following conditions.
	 * A. You may use the Software free of charge provided you agree to the terms
	 * laid out in the 1060 Public License v1.0
	 * B. You are only permitted to use the Software with components or applications
	 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
	 * for which licensing has been approved by 1060 Research Limited.
	 * You may write your own software for execution by this Software provided any
	 * distribution of your software with this Software complies with terms set out
	 * in section 2 of the 1060 Public License v1.0
	 * C. You may redistribute the Software provided you comply with the terms of
	 * the 1060 Public License v1.0 and that no warranty is implied or given.
	 * D. If you find you are unable to comply with this license you may seek to
	 * obtain an alternative license from 1060 Research Limited by contacting
	 * license@1060research.com or by visiting www.1060research.com
	 *
	 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
	 * LICENSE V1.0 FOR DETAILS
	 *
	 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
	 * THE DISTRIBUTED license.txt OR www.1060research.com/license

 
Created on 13 February 2007, 11:31
*/

package org.pinkypipes.accessor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import org.pinkypipes.aspect.FeedAspect;
import org.pinkypipes.aspect.IAspectFeed;
import org.ten60.netkernel.layer1.nkf.INKFConvenienceHelper;
import org.ten60.netkernel.layer1.nkf.INKFRequestReadOnly;
import org.ten60.netkernel.layer1.nkf.impl.NKFAccessorImpl;
import org.ten60.netkernel.xml.representation.IXAspect;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.ten60.netkernel.util.NetKernelException;



/**
 * UniqueAccessor - Filters feed based on a parmameter to provide a feed with unique entries.
 * @author  pjr
 */
public class UniqueAccessor extends NKFAccessorImpl
{	
	private static HashMap mode=new HashMap();
	private static final int MODE_UNKNOWN=0;
	private static final int MODE_TITLE=1;
	private static final int MODE_DATE=2;
	private static final int MODE_LINK=3;
	private static final int MODE_AUTHOR=4;
	private static final int MODE_CATEGORY=5;
	private static final int MODE_PERMALINK=6;

	{
		mode.put("title", new Integer(MODE_TITLE));
		mode.put("date", new Integer(MODE_DATE));
		mode.put("link", new Integer(MODE_LINK));
		mode.put("author", new Integer(MODE_AUTHOR));
		mode.put("category", new Integer(MODE_CATEGORY));
		mode.put("permalink", new Integer(MODE_PERMALINK));
	}

	
	/** Creates a new instance of UniqueAccessor */
	public UniqueAccessor()
	{	super(SAFE_FOR_CONCURRENT_USE, INKFRequestReadOnly.RQT_SOURCE);
	}
	
	public void processRequest(INKFConvenienceHelper context) throws Exception
	{	IAspectFeed fa=(IAspectFeed)context.sourceAspect("this:param:feed", IAspectFeed.class);
		IXAspect pa=(IXAspect)context.sourceAspect("this:param:operator", IXAspect.class);
		String filter=pa.getXDA().getText("/filter",true);
		int select;
		try
		{	select=((Integer)mode.get(filter)).intValue();
		}
		catch(Exception ex)
		{	throw new NetKernelException("Unique:Filter-Unknown-Error","The specified filter: "+filter+" is not supported.", null );
		}
		SyndFeed f=fa.getFeed();
		List es=f.getEntries();
		HashMap testedSet=new HashMap(es.size());
		ArrayList trash=new ArrayList(es.size()-1);
		Iterator it=es.iterator();
		while(it.hasNext())
		{	SyndEntry e=(SyndEntry)it.next();
			Object test=null;
			switch(select)
			{	case MODE_TITLE:
				{	test=e.getTitle();
				}
				break;
				case MODE_DATE:
				{	test=e.getPublishedDate();
				}
				break;
				case MODE_LINK:
				{	test=e.getLink();
				}
				break;
				case MODE_AUTHOR:
				{	test=e.getAuthor();
				}
				break;
				case MODE_CATEGORY:
				{	test=e.getCategories();
				}
				break;
				case MODE_PERMALINK:
				{	test=e.getUri();
				}
				break;
			}
			if(test!=null)
			{	if(testedSet.get(test)==null)
				{	testedSet.put(test, new Boolean(true));
				}
				else
				{	trash.add(e);
				}
			}
			else break;  //Return unfiltered if the feed doesn't support this element.
		}
		//Emtpy the trash
		it=trash.iterator();
		while(it.hasNext())
		{	es.remove(it.next());			
		}
		FeedAspect ufa=new FeedAspect(f);
		context.createResponseFrom(ufa);
	}
	
}
