/*
	PiNKY Project : Execute Yahoo Pipelines on 1060 NetKernel!
    Copyright (C) 2007  Peter Rodgers

	GPL License Notice:
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
	
	1060 Public License Notice:
	 * This Software is licensed to You, the licensee, for use under the terms of
	 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
	 * License v1.0 [www.1060research.com/license] before using or redistributing
	 * this software.
	 *
	 * In summary the 1060 Public license has the following conditions.
	 * A. You may use the Software free of charge provided you agree to the terms
	 * laid out in the 1060 Public License v1.0
	 * B. You are only permitted to use the Software with components or applications
	 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
	 * for which licensing has been approved by 1060 Research Limited.
	 * You may write your own software for execution by this Software provided any
	 * distribution of your software with this Software complies with terms set out
	 * in section 2 of the 1060 Public License v1.0
	 * C. You may redistribute the Software provided you comply with the terms of
	 * the 1060 Public License v1.0 and that no warranty is implied or given.
	 * D. If you find you are unable to comply with this license you may seek to
	 * obtain an alternative license from 1060 Research Limited by contacting
	 * license@1060research.com or by visiting www.1060research.com
	 *
	 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
	 * LICENSE V1.0 FOR DETAILS
	 *
	 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
	 * THE DISTRIBUTED license.txt OR www.1060research.com/license

Created on 15 February 2007, 7:38
*/

package org.pinkypipes.accessor;

import com.sun.syndication.feed.synd.SyndFeed;
import org.pinkypipes.aspect.IAspectFeed;
import org.pinkypipes.aspect.NumberAspect;
import org.ten60.netkernel.layer1.nkf.INKFConvenienceHelper;
import org.ten60.netkernel.layer1.nkf.INKFRequestReadOnly;
import org.ten60.netkernel.layer1.nkf.impl.NKFAccessorImpl;

/**
 * CountAccessor - Count the elements in a feed
 *
 * @author brian
 */
public class CountAccessor extends NKFAccessorImpl
  {
  public CountAccessor()
    {
    super(SAFE_FOR_CONCURRENT_USE, INKFRequestReadOnly.RQT_SOURCE);
    }

  public void processRequest(INKFConvenienceHelper context) throws Exception
    {
    IAspectFeed fa = (IAspectFeed) context.sourceAspect("this:param:feed", IAspectFeed.class);
    SyndFeed f = fa.getFeed();
    int count = f.getEntries().size();
    NumberAspect na = new NumberAspect(new Integer(count));
    context.createResponseFrom(na);

//		StringAspect sa=new StringAspect("<count>" + String.valueOf(count) + "</count>");
//		context.createResponseFrom(sa);
    }
  }
