/*
 * LDAPConnectionPoolTransreptor.java
 *
 * Created on 10 August 2005, 21:44
 */

package org.ten60.netkernel.ldap.transreptor;

import org.ten60.netkernel.layer1.nkf.impl.*;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.ldap.aspect.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.ldap.aspect.LDAPConnectionPoolAspect;


/**
 *
 * @author  pjr
 */
public class LDAPUserTransreptor extends NKFTransreptorImpl
{	
	/** Creates a new instance of LDAPConnectionPoolTransreptor */
	public LDAPUserTransreptor()
	{
	}
	
	public boolean supports(com.ten60.netkernel.urii.IURRepresentation aFrom, Class aTo)
	{	return aTo.isAssignableFrom(LDAPUserAspect.class);
	}
	
	protected void transrepresent(INKFConvenienceHelper context) throws Exception
	{	IXAspect xa=(IXAspect)context.sourceAspect(INKFRequestReadOnly.URI_SYSTEM, IXAspect.class);
		IXDAReadOnly xda=xa.getXDA();
		String userDN=xda.getText("/LDAPUserConfig/loginDN", true);
		String password=xda.getText("/LDAPUserConfig/password",true);
		LDAPUserAspect ua=new LDAPUserAspect(userDN, password);
		
		context.createResponseFrom(ua);
	}
	
}
