/*
 * LDAPConnectionAspect.java
 *
 * Created on 10 August 2005, 21:36
 */

package org.ten60.netkernel.ldap.aspect;

import com.ten60.netkernel.urii.*;
import com.novell.ldap.connectionpool.*;
import com.novell.ldap.*;

/**
 *
 * @author  pjr
 */
public class LDAPConnectionPoolAspect implements IURAspect
{	
	private PoolManager mPool;
	
	/** Creates a new instance of LDAPConnectionAspect */
	public LDAPConnectionPoolAspect(
		String aHost,
		int aPort,
		int aPoolSize,
		int aShareSize,
		boolean aSecure
	) throws LDAPException
	{	mPool=new PoolManager(
			aHost,
			aPort,
			aPoolSize,
			aShareSize,
			aSecure ? new LDAPJSSESecureSocketFactory() : null
		);
	}
	
	public LDAPConnection getConnection(LDAPUserAspect aUser) throws Exception
	{	return mPool.getBoundConnection(aUser.getUser(), aUser.getPassword().getBytes("UTF-8"));
	}
	
	public void releaseConnection(LDAPConnection aConnection)
	{	mPool.makeConnectionAvailable(aConnection);
	}
	
}
