/*
 * JSONSerializer.java
 *
 * Created on 16 June 2006, 11:11
 */

package org.ten60.json.transrept;

import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;
import com.ten60.netkernel.urii.aspect.*;
import org.ten60.json.representation.*;
import java.io.*;
import org.json.*;
/**
 *
 * @author  pjr
 */
public class JSONParser extends NKFTransreptorImpl
{
	
	public boolean supports(com.ten60.netkernel.urii.IURRepresentation aFrom, Class aTo)
	{ return aTo.isAssignableFrom(IAspectJSON.class);
	}
	
	protected void transrepresent(INKFConvenienceHelper context) throws Exception
	{	IAspectBinaryStream rbsa=(IAspectBinaryStream)context.sourceAspect(INKFRequestReadOnly.URI_SYSTEM, IAspectBinaryStream.class);
		ByteArrayOutputStream baos=new ByteArrayOutputStream(1024);
		rbsa.write(baos);
		JSONObject json=new JSONObject(baos.toString());
		JSONAspect sa=new JSONAspect(json);
		INKFResponse resp=context.createResponseFrom(sa);
		resp.setMimeType("application/json");
		context.setResponse(resp);
	}
	
}
