/******************************************************************************
  (c) Copyright 2002-2006, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: XRLMapper.java,v $
  Version:       $Name:  $ $Revision: 1.4 $
  Last Modified: $Date: 2006/03/30 11:34:38 $
 *****************************************************************************/
package org.ten60.docxter2;

import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.NKFAccessorImpl;
import org.ten60.netkernel.layer1.representation.StringAspect;
import org.ten60.netkernel.xml.util.XMLUtils;

import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.urii.IURAspect;
import java.net.URI;
import java.util.*;
import java.io.StringWriter;
import java.io.IOException;
/**
 * XRL Mapper accessor
 * @author  Tony Butterfield
 */
public class XRLMapper extends NKFAccessorImpl
{
	public static final String XRL_SCHEME="xrl:";
	
	/** Creates a new instance of XRLMapper */
	public XRLMapper()
	{	super(0,true,INKFRequestReadOnly.RQT_SOURCE|INKFRequestReadOnly.RQT_SINK|INKFRequestReadOnly.RQT_NEW|INKFRequestReadOnly.RQT_EXISTS|INKFRequestReadOnly.RQT_DELETE);
	}
	
	public void processRequest(INKFConvenienceHelper aContext) throws Exception
	{
		//resolve link table resource
		ILinkTableAspect linkTable;
		if (aContext.getThisRequest().getArgument("operator")!=null)
		{	linkTable = (ILinkTableAspect)aContext.sourceAspect("this:param:operator",ILinkTableAspect.class);
		}
		else
		{	linkTable = (ILinkTableAspect)aContext.sourceAspect(GTPUtils.DEFAULT_LINKS.toString(),ILinkTableAspect.class);
		}
		
		// determine path
		String operand = aContext.getThisRequest().getArgument("operand");
		if (operand==null)
		{	throw new NKFException("no path on operand");
		}
		URI operandURI = URI.create(operand);
		String path = operandURI.getPath();
		int type=aContext.getThisRequest().getRequestType();
		Class aspectClass = aContext.getThisRequest().getAspectClass();
		
		IURRepresentation result;
		try
		{	Link link = lookupPath(path,linkTable);		
			if (link!=null)
			{	result = GTPUtils.resolveLink(link, true, null,aContext,aspectClass,type);
			}
			else
			{	if (type==INKFRequestReadOnly.RQT_SOURCE)
				{	// find missing page
					result = notFoundContent(path,aContext,linkTable);
				}
				else
				{	throw new NKFException("Path not found");
				}
			}
		}
		catch(NKFException e)
		{	if (type==INKFRequestReadOnly.RQT_SOURCE)
			{	// error loading page
				result = errorContent(e,path,aContext,linkTable);
			}
			else throw e;
		}
		
		INKFResponse response = aContext.createResponseFrom(result);
		response.setCacheable();
		response.setCreationCost(8);
	}
	
	private Link lookupPath(String aPath,ILinkTableAspect aTable)
	{	Link result=null;
		Link link = aTable.getLinkWithExternalPath(aPath);
		List traversedLinkNames=null;
		while (result==null && link!=null && link.getInternal()!=null)
		{	if (link.getInternal().startsWith(XRL_SCHEME))
			{	String name = link.getInternal().substring(XRL_SCHEME.length());
				if (traversedLinkNames==null)
				{	traversedLinkNames = new ArrayList(2);
				}
				else
				{	if (traversedLinkNames.contains(name)) break; // circularity
				}
				traversedLinkNames.add(name);
				link = aTable.getLinkWithName(name);
			}
			else
			{	result=link;
			}
		}
		return result;
	}
	
	private IURRepresentation notFoundContent(String aPage, INKFConvenienceHelper aContext, ILinkTableAspect aTable) throws NKFException
	{
		IURRepresentation result;
		Link link = aTable.getLinkWithName("404");
		if (link==null)
		{	throw new NKFException("Link Not found","external path of "+aPage+" not matched" , aPage);
		}
		else
		{	String param = "<error><id>404</id><page>"+XMLUtils.escape(aPage)+"</page></error>";
			result = GTPUtils.resolveLink(link, true, new StringAspect(param), aContext, IURAspect.class);
		}
		return result;
	}

	private IURRepresentation errorContent(NKFException e, String aPage, INKFConvenienceHelper aContext, ILinkTableAspect aTable) throws NKFException, IOException
	{
		IURRepresentation result;
		Link link = aTable.getLinkWithName("500");
		if (link==null)
		{	throw e;
		}
		else
		{	StringWriter sw = new StringWriter(1024);
			sw.write("<error><id>500</id><page>");
			sw.write(XMLUtils.escape(aPage));
			sw.write("</page>");
			e.appendXML(sw);
			sw.write("</error>");
			sw.flush();
			result = GTPUtils.resolveLink(link, true, new StringAspect(sw.toString()), aContext, IURAspect.class);
		}
		return result;
	}
}