/******************************************************************************
 * (c) Copyright 2002-2006, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: GTPUtils.java,v $
 * Version:       $Name:  $ $Revision: 1.11 $
 * Last Modified: $Date: 2006/02/14 12:36:25 $
 *****************************************************************************/
package org.ten60.docxter2;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.urrequest.URRequest;
import java.net.URI;
import java.util.*;
import org.ten60.netkernel.layer1.util.CompoundURIdentifier;
import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.TimedExpiryMeta;
import org.ten60.netkernel.layer1.nkf.*;

import org.ten60.netkernel.xml.representation.IXAspect;
import org.ten60.netkernel.xml.xahelper.*;


/**
 * GTPUtils
 * @author  tab
 */
public class GTPUtils
{
	private static final URIdentifier URI_PARAM=new URIdentifier("literal:param");
	public static final URI DEFAULT_LINKS=URI.create("ffcpl:/etc/XRLLinks.xml");
	
	public static IURRepresentation resolveLink(Link aLink, boolean aInternal, IURAspect aParam, INKFConvenienceHelper aContext, Class aAspectClass) throws NKFException
	{	return resolveLink(aLink,aInternal,aParam,aContext,aAspectClass,URRequest.RQT_SOURCE);
	}

	public static IURRepresentation resolveLink(Link aLink, boolean aInternal, IURAspect aParam, INKFConvenienceHelper aContext, Class aAspectClass, int aType) throws NKFException
	{	String uri = aInternal?aLink.getInternal():aLink.getExternal();
		INKFRequest req=aContext.createSubRequest(uri);
		req.setRequestType(aType);
		if (aParam!=null)
		{	req.addArgument("param",aParam);
		}
		req.setAspectClass(aAspectClass);
		
		//do arguments
		Iterator argumentIterator=null;
		if(aLink.getArgs().size()==1 && ((String)aLink.getArgs().get(0)).equals("all"))
		{	argumentIterator=aContext.getThisRequest().getArguments();
		}
		else
		{	argumentIterator=aLink.getArgs().iterator();
		}
		
		for (Iterator i = argumentIterator; i.hasNext(); )
		{	String arg = (String)i.next();
			if (aParam!=null && (arg.equals(XRLLinker.ARG_CONTENT) || arg.equals(CompoundURIdentifier.PARAM))) // embedded content case
			{	req.addArgument(arg,aParam);
			}
			else if (arg.equals("this-name"))
			{	String name = aLink.getName();
				String uriString = "xrl:"+name;
				req.addArgument("name",uriString);
			}
			else
			{	if (arg.equals("links")) arg=XAccessor.OPERATOR;
				if (arg.equals(XRLLinker.ARG_CONTENT) && aParam==null)
				{	throw new NKFException("link required content","link "+aLink.getName()+" required content",null);
				}
				String argURI = aContext.getThisRequest().getArgument(arg);
				if (argURI!=null)
				{	IURRepresentation argValue = aContext.getThisRequest().getArgumentValue(argURI);
					if (argValue!=null)
					{	req.addArgument(arg,argValue);
					}
					else
					{	req.addArgument(arg,argURI);
					}
				}					
			}
		}
		
		//system argument if attached
		IURRepresentation system=aContext.getThisRequest().getArgumentValue(INKFRequestReadOnly.URI_SYSTEM);
		if (system!=null)
		{	req.addSystemArgument(system);
		}
		
		IURRepresentation result=aContext.issueSubRequest(req);
		return result;
	}		
}
