/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: XQueryCompiler.java,v $
 * Version:       $Name:  $ $Revision: 1.6 $
 * Last Modified: $Date: 2008/03/25 11:04:19 $
 *****************************************************************************/
package org.ten60.ura.xquery;

import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.urii.aspect.IAspectBinaryStream;
import com.ten60.netkernel.urii.aspect.IAspectReadableBinaryStream;
import com.ten60.netkernel.urii.representation.ITransrepresentor;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.scheduler.*;
import com.ten60.netkernel.module.ModuleDefinition;

import org.ten60.netkernel.layer1.transrepresentation.ComplexTransreptorImpl;
import org.ten60.netkernel.layer1.meta.DependencyMeta;
import org.ten60.netkernel.layer1.representation.*;

import org.ten60.netkernel.layer1.util.SuperStackClassLoader;

import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;
import com.ten60.netkernel.urii.aspect.*;

import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.xda.*;
import com.ten60.netkernel.util.SysLogger;

import javax.xml.transform.*;
import java.net.*;
import org.w3c.dom.*;
import java.io.*;

/**
 * XMLToXSLTransformer
 * @author  tab
 */
public class XQueryCompiler extends NKFTransreptorImpl
{
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return aTo.isAssignableFrom(XQueryAspect.class);
	}
	
	protected void transrepresent(INKFConvenienceHelper context) throws Exception
	{	IURRepresentation aFrom=context.source(INKFRequestReadOnly.URI_SYSTEM);
		String mime=aFrom.getMeta().getMimeType();
		String query=null;
		if (mime.equals("text/xml") || mime.equals("application/xml") || aFrom.hasAspect(IAspectXDA.class) || aFrom.hasAspect(IAspectXmlObject.class) || aFrom.hasAspect(IAspectJDOM.class))
		{	// must be a wrapped script
			IAspectXDA xa=(IAspectXDA)context.sourceAspect(INKFRequestReadOnly.URI_SYSTEM,IAspectXDA.class);
			try
			{	query=xa.getXDA().getText("/xquery", false);
			}
			catch(XPathLocationException e)
			{	SysLogger.log(SysLogger.WARNING, this, "XML source found but no <xquery> element - attempting to use document as plain text query");
				query=xa.getXDA().toString();
			}
		}
		else
		{	IAspectString sa=(IAspectString)context.sourceAspect(INKFRequestReadOnly.URI_SYSTEM,IAspectString.class);
			query=sa.getString();
		}
		INKFResponse resp=context.createResponseFrom(aFrom);
		resp.addAspect(new XQueryAspect(query, getResolver(context), getClassLoader(context)));
		context.setResponse(resp);
	}

	private ClassLoader getClassLoader(INKFConvenienceHelper aContext) throws Exception
	{	return new SuperStackClassLoader(aContext.getKernelHelper().getThisKernelRequest());

	}

	private URIResolver getResolver(INKFConvenienceHelper aContext)
	{	final INKFConvenienceHelper context = aContext;
		return new URIResolver()
		{	public Source resolve(String href, String base) throws TransformerException
			{	URI resource=URI.create(href);
				if(!resource.isAbsolute() && context.getCWU()!=null)
				{	resource=URI.create(context.getCWU().toString()).resolve(resource);
				}
				try
				{	URIdentifier uri = new URIdentifier(resource.toString());
					Document d = ((IAspectDOM)context.sourceAspect(resource.toString(), IAspectDOM.class)).getReadOnlyDocument();
					return new javax.xml.transform.dom.DOMSource(d);
				}
				catch(NetKernelException e)
				{	throw new TransformerException("Resource "+base+" "+href+" could not be accessed");
				}
			}
		};
	}	
}
