/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: XQueryAspect.java,v $
 * Version:       $Name:  $ $Revision: 1.13 $
 * Last Modified: $Date: 2008/03/25 11:04:19 $
 *****************************************************************************/
package org.ten60.ura.xquery;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.util.PairList;

import org.ten60.netkernel.layer1.nkf.INKFConvenienceHelper;

import org.ten60.netkernel.xml.representation.IXAspect;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.ura.util.LocalErrorListener;

import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import java.util.*;

import net.sf.saxon.query.*;
import com.ten60.netkernel.util.NetKernelException;

/**
 * XSLTTransformerAspect
 * @author  tab
 */
public class XQueryAspect implements IURAspect
{
	private XQueryExpression mXQueryExpression;
	//private QueryProcessor mQP;
	private StaticQueryContext mSQC;
	private NKCollectionURIResolver mResolver;
	private List mParameters;
	private String mMime;
	private static String SYNCH_LOCK="";
	private static Properties mProperties=new Properties();
	
	{
		mProperties.setProperty(javax.xml.transform.OutputKeys.ENCODING, "UTF-8");
		mProperties.setProperty(javax.xml.transform.OutputKeys.METHOD, "xml");
	}
		
	/** Creates a new instance of XQueryAspect */
	protected XQueryAspect(String aQuery, URIResolver aResolver, ClassLoader aLoader) throws Exception
	{	
		// get mime
		mMime ="text/xml";
		
		//build the transformer
		synchronized(SYNCH_LOCK)
		{	net.sf.saxon.Configuration config=new net.sf.saxon.Configuration();
			config.setURIResolver(aResolver);
			config.setClassLoader(aLoader);
			mResolver =new NKCollectionURIResolver();
			config.setCollectionURIResolver(mResolver);
			LocalErrorListener lol=new LocalErrorListener();
			config.setErrorListener(lol);
			mSQC=new StaticQueryContext(config);
			mSQC.setConfiguration(config);
			mXQueryExpression=mSQC.compileQuery(aQuery);
		}		
	}
	
	public synchronized void evaluateQuery(Result aResult, INKFConvenienceHelper aContext, URIResolver aResolver, PairList aParams) throws Exception
	{	net.sf.saxon.Configuration config=new net.sf.saxon.Configuration();
		DynamicQueryContext dqc=new DynamicQueryContext(config);
		dqc.setErrorListener(new LocalErrorListener());
		dqc.setURIResolver(aResolver);
		mResolver.setContext(aContext);
		for(int i=0; i<aParams.size(); i++)
		{	dqc.setParameter((String)aParams.getValue1(i), mSQC.buildDocument((Source)aParams.getValue2(i)) );
		}
		try
		{	net.sf.saxon.om.DocumentInfo di=QueryResult.wrap(mXQueryExpression.iterator(dqc), mSQC.getConfiguration());
			QueryResult.serialize( di.getRoot(), aResult, mProperties, mSQC.getConfiguration());
		}
		catch(TransformerException e)
		{	LocalErrorListener lel=(LocalErrorListener)dqc.getErrorListener();
			NetKernelException nke=new NetKernelException("Saxon XQuery Exception", lel.getErrorMessage()+" at "+mXQueryExpression.getLineNumber()+":"+mXQueryExpression.getColumnNumber(), null);
			nke.addCause(e);
			throw nke;
		}
	}
	
	public String getMimeType()
	{	return mMime;
	}

	class NKCollectionURIResolver extends net.sf.saxon.functions.StandardCollectionURIResolver {

		private String base = null;

		public NKCollectionURIResolver() {
			super();
		}

		public void setContext(INKFConvenienceHelper aContext) throws NetKernelException {
			if (aContext.getCWU()!=null)
				base = aContext.getCWU().toString();
			else {
				try {
					base = aContext.getThisRequest().getArgument("operator");
				} catch(Exception e) {
					NetKernelException nke=new NetKernelException("Saxon XQuery NKCollectionURIResolver Exception");
					nke.addCause(e);
					throw nke;
				}
			}
		}

		public net.sf.saxon.om.SequenceIterator resolve(String href,String base,net.sf.saxon.expr.XPathContext context) throws net.sf.saxon.trans.XPathException {
			return super.resolve(href,(base!=null?base:this.base),context);
		}
	}
}
